/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger;

import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import jakarta.annotation.PostConstruct;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public class IdGenerator {
    private final ReferenceDateTask referenceDateTask;
    private final MessengerConfig _messengerConfig;
    private final AtomicLong _messageIdFragment = new AtomicLong();
    private final AtomicLong _conversationIdFragment = new AtomicLong();

    public IdGenerator(ReferenceDateTask referenceDateTask, MessengerConfig messengerConfig) {
        this.referenceDateTask = referenceDateTask;
        this._messengerConfig = messengerConfig;
    }

    @PostConstruct
    public void init() {
        this._messageIdFragment.set(this.referenceDateTask.getReferenceCurrentTimeMillis());
        this._conversationIdFragment.set(this.referenceDateTask.getReferenceCurrentTimeMillis());
    }

    public String generateMessageId() {
        return "MID-" + this._messageIdFragment.incrementAndGet() + this.getDomain();
    }

    public String getStandardMessageId(String messageId) {
        if (messageId == null || messageId.trim().length() == 0) {
            return this.generateMessageId();
        }
        Object formatedMessageId = messageId.trim();
        int index = ((String)formatedMessageId).lastIndexOf("@");
        if (index == -1) {
            formatedMessageId = (String)formatedMessageId + this.getDomain();
        } else if (index + 1 == ((String)formatedMessageId).length()) {
            formatedMessageId = ((String)formatedMessageId).substring(0, index) + this.getDomain();
        }
        return formatedMessageId;
    }

    public String getSoapId() {
        return "id-" + UUID.randomUUID().toString();
    }

    public String generateConversationId() {
        return "CID-" + this._conversationIdFragment.incrementAndGet() + this.getDomain();
    }

    private String getDomain() {
        Object domain = null;
        try {
            domain = this._messengerConfig.getMessageIdDomain();
            if (domain == null) {
                domain = "@ponton.xp";
                this._messengerConfig.setMessageIdDomain((String)domain);
            }
            if (!((String)domain).startsWith("@")) {
                domain = "@" + (String)domain;
            }
            if (1 != this._messengerConfig.getMessengerId()) {
                domain = (String)domain + "-" + this._messengerConfig.getMessengerId();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return domain;
    }
}

