/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.message;

import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.message.ack.ObjectFactory;
import de.pontonconsulting.xmlpipe.message.ack.XpAcknowledgment;
import de.pontonconsulting.xmlpipe.soap.ebxml.DateTime;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.ParseException;
import java.util.Date;
import java.util.List;

public class XpAcknowledgment {
    private static final String XP_ACK_CLASSES = "de.pontonconsulting.xmlpipe.message.ack";
    public static final String SUCCESS = "Success";
    public static final String WARNING = "Warning";
    public static final String ERROR = "Error";
    public static final String PONG = "Pong";
    public static final String STATUS_RESPONSE = "StatusResponse";
    public static final String CERT_UPDATE_RESPONSE = "CertUpdateResponse";
    private static ObjectFactory _factory = new ObjectFactory();
    private final de.pontonconsulting.xmlpipe.message.ack.XpAcknowledgment _ack;
    private static final JAXBContext _jc;

    public XpAcknowledgment(byte[] ackBytes) throws JAXBException {
        Unmarshaller u = this.getUnmarshaller();
        ByteArrayInputStream ackStream = new ByteArrayInputStream(ackBytes);
        this._ack = (de.pontonconsulting.xmlpipe.message.ack.XpAcknowledgment)u.unmarshal((InputStream)ackStream);
    }

    public XpAcknowledgment(File ackFile) throws JAXBException {
        Unmarshaller u = this.getUnmarshaller();
        this._ack = (de.pontonconsulting.xmlpipe.message.ack.XpAcknowledgment)u.unmarshal(ackFile);
    }

    public XpAcknowledgment(XpMessage message, String ackReference, Date ackRegistrationTime, Date ackTime) throws JAXBException {
        this(message.getMessageId(), message.getMessageTimestamp(), ackReference);
        this.setMessageTime(ackRegistrationTime);
        this.setAckTime(ackTime);
    }

    public XpAcknowledgment(String messageId, Date ackTimestamp, String messageReference) throws JAXBException {
        this._ack = _factory.createXpAcknowledgment();
        this.setMessageReferenceId(messageReference);
        this.setMessageId(messageId);
        this.setAckTime(ackTimestamp);
    }

    public File saveToDisk(File destinationFolder, String name) throws JAXBException {
        destinationFolder.mkdirs();
        File destination = new File(destinationFolder, name);
        Marshaller m = this.getMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.setProperty("jaxb.encoding", (Object)"UTF-8");
        FilterOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(Files.newOutputStream(destination.toPath(), new OpenOption[0]));
            m.marshal((Object)this._ack, (OutputStream)bos);
        }
        catch (IOException e) {
            throw new JAXBException("Acknowledgment file '" + String.valueOf(destination) + "' could not be opened for writing: " + e.getMessage());
        }
        finally {
            try {
                bos.close();
            }
            catch (Exception exception) {}
        }
        return destination;
    }

    private Marshaller getMarshaller() throws JAXBException {
        return _jc.createMarshaller();
    }

    private Unmarshaller getUnmarshaller() throws JAXBException {
        return _jc.createUnmarshaller();
    }

    public File saveToDisk(File destinationFolder) throws JAXBException {
        destinationFolder.mkdirs();
        return this.saveToDisk(destinationFolder, "xpAck.xml");
    }

    public void addError(String code, String description) {
        List errorList = this._ack.getResults();
        XpAcknowledgment.Results newResult = _factory.createXpAcknowledgmentResults();
        newResult.setCode(code);
        newResult.setDescription(this.removeNonPrintableCharacters(description));
        errorList.add(newResult);
    }

    private String removeNonPrintableCharacters(String string) {
        char[] chars = string.toCharArray();
        for (int i = 0; i < string.length(); ++i) {
            char ch = chars[i];
            if (ch == '\r' || ch == '\n' || ch == '\t' || ch >= ' ') continue;
            chars[i] = 46;
        }
        return new String(chars);
    }

    public String getMessageId() {
        return this._ack.getMessageId();
    }

    public String getMessageReferenceId() {
        return this._ack.getReferenceId();
    }

    public Date getMessageTime() {
        String time = this._ack.getMessageTime();
        return this.toDate(time);
    }

    private Date toDate(String time) {
        Date result = null;
        if (time != null) {
            try {
                result = DateTime.parseDate(time);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return result;
    }

    public Date getRemoteReceptionTime() {
        String remote = this._ack.getRemoteReceptionTime();
        return this.toDate(remote);
    }

    public List<XpAcknowledgment.Results> getResults() {
        return this._ack.getResults();
    }

    public String getOverallResult() {
        return this._ack.getOverallResultCode();
    }

    public void setMessageId(String messageId) {
        this._ack.setMessageId(messageId);
    }

    public void setMessageReferenceId(String messageReferenceId) {
        this._ack.setReferenceId(messageReferenceId);
    }

    public void setMessageTime(Date messageTime) {
        String time = null;
        if (messageTime != null) {
            time = DateTime.formatDate(messageTime);
        }
        this._ack.setMessageTime(time);
    }

    public void setAckTime(Date ackTime) {
        String time = null;
        if (ackTime != null) {
            time = DateTime.formatDate(ackTime);
        }
        this._ack.setRemoteReceptionTime(time);
    }

    public void setOverallResult(String overallResult) {
        this._ack.setOverallResultCode(overallResult);
    }

    static {
        JAXBContext context = null;
        try {
            context = JAXBContext.newInstance((String)XP_ACK_CLASSES);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        _jc = context;
    }
}

