/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.message;

import de.pontonconsulting.common.xml.DtdFilterStream;
import de.pontonconsulting.xmlpipe.config.SchemaData;
import de.pontonconsulting.xmlpipe.config.SchemataConfig;
import de.pontonconsulting.xmlpipe.message.MessageException;
import de.pontonconsulting.xmlpipe.message.ZipXslTransformer;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.MessageInfo;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TVFS;
import de.schlichtherle.truezip.fs.FsSyncException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Messages {
    private static Log _log = LogFactory.getFactory().getInstance("Messenger.Messages");
    private final SchemataConfig _schemataConfig;
    private final MessageDAO _messageDAO;
    private final ZipXslTransformer _transformer;

    public Messages(SchemataConfig schemataConfig, MessageDAO messageDAO, ZipXslTransformer zipXslTransformer) {
        this._schemataConfig = schemataConfig;
        this._messageDAO = messageDAO;
        this._transformer = zipXslTransformer;
    }

    public void writeXmlDocumentTo(String messageId, OutputStream out) throws MessageException, IOException {
        MessageInfo msg;
        try {
            msg = this._messageDAO.getMessageInfo(this._messageDAO.getMessageDataID(messageId));
        }
        catch (DbException e) {
            throw new MessageException(48001, "Could not get message information from the database.", e);
        }
        if (msg == null) {
            throw new MessageException(48001, "Couldn't find message '" + messageId + "'");
        }
        this.writeXmlDocumentTo(msg, out);
    }

    private void writeXmlDocumentTo(MessageInfo msg, OutputStream out) throws MessageException, IOException {
        File usedPayloadFile = this.findFile(msg.getPayloadFile().getParentFile(), msg.getPayloadFile().getName());
        if (usedPayloadFile == null || !usedPayloadFile.exists()) {
            _log.warn((Object)("Couldn't find file " + String.valueOf(msg.getPayloadFile().getParentFile()) + "/" + msg.getPayloadFile().getName()));
            throw new FileNotFoundException("Couldn't find file " + String.valueOf(msg.getPayloadFile().getParentFile()) + "/" + msg.getPayloadFile().getName());
        }
        try (DtdFilterStream dfs = new DtdFilterStream((InputStream)new TFileInputStream(usedPayloadFile));){
            byte[] buffer = new byte[16384];
            int length = 0;
            while ((length = dfs.read(buffer)) != -1) {
                out.write(buffer, 0, length);
            }
            out.flush();
        }
        catch (IOException ioe) {
            throw new MessageException(48001, "Couldn't find file " + String.valueOf(msg.getPayloadFile().getParentFile()) + "/" + msg.getPayloadFile().getName());
        }
        finally {
            if (usedPayloadFile instanceof TFile) {
                this.unmountFile((TFile)usedPayloadFile.getParentFile());
            }
        }
    }

    private void unmountFile(TFile sourceFile) throws FsSyncException {
        if (sourceFile.isArchive()) {
            TVFS.umount((TFile)sourceFile);
        } else if (sourceFile.isDirectory()) {
            TFile[] files;
            for (TFile file : files = sourceFile.listFiles()) {
                if (!file.isArchive()) continue;
                TVFS.umount((TFile)file);
            }
        }
    }

    public void writeHtmlDocumentTo(String messageId, OutputStream out) throws MessageException, FileNotFoundException {
        MessageInfo msg = null;
        try {
            msg = this._messageDAO.getMessageInfo(this._messageDAO.getMessageDataID(messageId));
        }
        catch (DbException e) {
            throw new MessageException(48002, "Could not get message information from the database.", e);
        }
        if (msg == null) {
            throw new MessageException(48002, "Couldn't find message '" + messageId + "'");
        }
        if (!msg.getPayloadFile().getName().toLowerCase().endsWith(".xml")) {
            throw new MessageException(48002, "payload is no xml. no html output available");
        }
        this.transform(msg, out);
    }

    public void transform(MessageInfo msg, OutputStream out) throws FileNotFoundException, MessageException {
        File usedPayloadFile = this.findFile(msg.getPayloadFile().getParentFile(), msg.getPayloadFile().getName());
        if (usedPayloadFile == null || !usedPayloadFile.exists()) {
            _log.warn((Object)("Couldn't find file " + String.valueOf(msg.getPayloadFile().getParentFile()) + "/" + msg.getPayloadFile().getName()));
            throw new FileNotFoundException("Couldn't find file " + String.valueOf(msg.getPayloadFile().getParentFile()) + "/" + msg.getPayloadFile().getName());
        }
        this.transform(null, msg, usedPayloadFile, out);
    }

    public void transform(InputStream in, MessageInfo msg, File usedPayloadFile, OutputStream out) throws MessageException {
        try {
            SchemaData schemaData = this._schemataConfig.getSchemaBySetTypeVersion(msg.getSchemaSet(), msg.getMessageType(), msg.getSchemaVersion());
            File xslFile = schemaData == null || schemaData.getXslFile() == null ? this.retrieveDefaultXSL() : schemaData.getXslFile();
            if (Objects.nonNull(in)) {
                this._transformer.transform(in, usedPayloadFile.getName(), xslFile, out);
            } else {
                this._transformer.transform(usedPayloadFile, xslFile, out);
            }
        }
        catch (Exception e) {
            throw new MessageException(48002, "Could not transform message.", e);
        }
    }

    private File retrieveDefaultXSL() {
        return new File(this._schemataConfig.getXslFolder(), "genericHtmlOutput.xsl");
    }

    public File[] findFiles(File folder, FileFilter fileFilter) throws FileNotFoundException {
        File newFolder = folder;
        if (folder.getName().endsWith(".zip")) {
            int length = folder.getName().length();
            newFolder = new File(folder.getParentFile(), folder.getName().substring(0, length - 4));
        }
        if (newFolder.exists() && newFolder.isDirectory()) {
            return newFolder.listFiles(fileFilter);
        }
        TFile folder2 = new TFile(newFolder.getParentFile(), newFolder.getName());
        TFile file = this.substituteZip(folder2, ".", 0);
        return file.listFiles(fileFilter, TArchiveDetector.ALL);
    }

    public File findFile(File folder, String filename) throws FileNotFoundException {
        File realFolder;
        if (folder.getName().endsWith(".zip")) {
            int length = folder.getName().length();
            realFolder = new TFile(folder.getParentFile(), folder.getName().substring(0, length - 4));
        } else {
            realFolder = folder;
        }
        if (realFolder.exists() && realFolder.isDirectory()) {
            TFile result = new TFile(realFolder, filename);
            if (!result.exists()) {
                throw new FileNotFoundException(filename);
            }
            return result.getNormalizedFile();
        }
        TFile folder2 = new TFile(realFolder.getParentFile(), realFolder.getName());
        TFile file = this.substituteZip(folder2, filename, 0);
        if (!file.exists()) {
            throw new FileNotFoundException(filename);
        }
        return file.getNormalizedFile();
    }

    private TFile substituteZip(TFile folder, String filename, int depth) throws FileNotFoundException {
        TFile zipFile = new TFile((File)folder.getParentFile(), folder.getName() + ".zip");
        if (zipFile.exists()) {
            return new TFile((File)zipFile, filename).getNormalizedFile();
        }
        if (depth == 3) {
            throw new FileNotFoundException(filename);
        }
        String fileWithPath = folder.getName() + File.separatorChar + filename;
        TFile foundFile = this.substituteZip(folder.getParentFile(), fileWithPath, ++depth);
        return foundFile.getNormalizedFile();
    }
}

