/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.message;

import de.pontonconsulting.common.io.UTF8BOMSkippingInputStream;
import de.pontonconsulting.xmlpipe.message.EdiMessage;
import de.pontonconsulting.xmlpipe.message.EdifactMessageException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;

public class EdifactMessage
implements EdiMessage {
    private static final String SEGMENT_UNA = "UNA";
    private static final String SEGMENT_UNB = "UNB";
    private static final String SEGMENT_UNH = "UNH";
    private final File _ediFile;
    private char _compositeSeparator = (char)58;
    private char _elementSeparator = (char)43;
    private char _releaseChar = (char)63;
    private char _segmentSeparator = (char)39;
    private String _senderId;
    private String _receiverId;
    private String _messageId;
    private String _messageType;
    private String _messageVersion;
    private boolean _currentSegmentFinished;

    public EdifactMessage(File ediFile) throws IOException, EdifactMessageException {
        this._ediFile = ediFile;
        this.parse();
    }

    private void parse() throws IOException, EdifactMessageException {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(new UTF8BOMSkippingInputStream(Files.newInputStream(this._ediFile.toPath(), new OpenOption[0]))));
            String segmentIdentifier = this.getSegmentIdentifier(in);
            if (SEGMENT_UNA.equals(segmentIdentifier)) {
                this.parseUNA(in);
                segmentIdentifier = this.getSegmentIdentifier(in);
            }
            if (SEGMENT_UNB.equals(segmentIdentifier)) {
                this.parseUNB(in);
                segmentIdentifier = this.getSegmentIdentifier(in);
            } else {
                throw new EdifactMessageException(46000, "UNB segment not found.");
            }
            while (!SEGMENT_UNH.equals(segmentIdentifier)) {
                this.skipSegment(in);
                segmentIdentifier = this.getSegmentIdentifier(in);
            }
            this.parseUNH(in);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    private void parseUNA(BufferedReader in) throws IOException {
        this._compositeSeparator = (char)in.read();
        this._elementSeparator = (char)in.read();
        in.read();
        this._releaseChar = (char)in.read();
        in.read();
        this._segmentSeparator = (char)in.read();
    }

    private void parseUNB(BufferedReader in) throws IOException, EdifactMessageException {
        in.read();
        this.getNextElement(in);
        String[] data = this.getNextElement(in);
        if (data.length <= 0) {
            throw new EdifactMessageException(46001, "SenderId is missing");
        }
        this._senderId = data[0];
        data = this.getNextElement(in);
        if (data.length <= 0) {
            throw new EdifactMessageException(46002, "ReceiverId is missing");
        }
        this._receiverId = data[0];
        this.getNextElement(in);
        data = this.getNextElement(in);
        if (data.length != 1) {
            throw new EdifactMessageException(46003, "MessageId is missing");
        }
        this._messageId = data[0];
        if (!this._currentSegmentFinished) {
            this.skipSegment(in);
        }
    }

    private void parseUNH(BufferedReader in) throws IOException, EdifactMessageException {
        in.read();
        this.getNextElement(in);
        String[] data = this.getNextElement(in);
        if (data.length < 1) {
            throw new EdifactMessageException(46004, "MessageType is missing");
        }
        this._messageType = data[0];
        if (data.length <= 2) {
            throw new EdifactMessageException(46005, "MessageVersion is missing");
        }
        this._messageVersion = data[1] + data[2];
    }

    private String[] getNextElement(BufferedReader in) throws IOException {
        ArrayList<String> elements = new ArrayList<String>();
        StringBuilder element = new StringBuilder();
        while (!this._currentSegmentFinished) {
            char current = this.getNextChar(in, false);
            if (current == this._releaseChar) {
                current = this.getNextChar(in, false);
                element.append(current);
                continue;
            }
            if (current == this._compositeSeparator) {
                elements.add(element.toString().trim());
                element.setLength(0);
                continue;
            }
            if (current == this._elementSeparator) {
                elements.add(element.toString().trim());
                element.setLength(0);
                break;
            }
            if (current == this._segmentSeparator) {
                this._currentSegmentFinished = true;
                elements.add(element.toString().trim());
                element.setLength(0);
                break;
            }
            element.append(current);
        }
        return elements.toArray(new String[0]);
    }

    private String getSegmentIdentifier(BufferedReader in) throws IOException {
        StringBuilder segmentIdentifier = new StringBuilder();
        while (segmentIdentifier.length() < 3) {
            segmentIdentifier.append(this.getNextChar(in, true));
        }
        this._currentSegmentFinished = false;
        return segmentIdentifier.toString();
    }

    private void skipSegment(BufferedReader in) throws IOException {
        while (true) {
            char current;
            if ((current = this.getNextChar(in, true)) == this._releaseChar) {
                current = this.getNextChar(in, true);
                continue;
            }
            if (current == this._segmentSeparator) break;
        }
    }

    private char getNextChar(BufferedReader in, boolean skipSpace) throws IOException {
        int r = in.read();
        if (r == -1) {
            throw new IOException("end of file");
        }
        char current = (char)r;
        while (current == '\r' || current == '\n') {
            current = this.getNextChar(in, skipSpace);
        }
        if (skipSpace && current == ' ') {
            current = this.getNextChar(in, skipSpace);
        }
        return current;
    }

    @Override
    public String getSenderId() {
        return this._senderId;
    }

    @Override
    public String getReceiverId() {
        return this._receiverId;
    }

    @Override
    public String getMessageId() {
        return this._messageId + this._messageType + this._senderId + this._receiverId;
    }

    @Override
    public String getMessageType() {
        return this._messageType;
    }

    @Override
    public String getMessageVersion() {
        return this._messageVersion;
    }
}

