/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.listener.ebxml2;

import de.pontonconsulting.xmlpipe.listener.ErrorNotificationResult;
import de.pontonconsulting.xmlpipe.listener.ErrorNotificationService;
import de.pontonconsulting.xmlpipe.listener.ProcessingResultToErrorNotificationResultConverter;
import de.pontonconsulting.xmlpipe.listener.ebxml2.EbXml2Data;
import de.pontonconsulting.xmlpipe.listener.ebxml2.EbXml2Service;
import de.pontonconsulting.xmlpipe.listener.ebxml2.IEbXml2Service;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.ProcessingResult;
import de.pontonconsulting.xmlpipe.messenger.ReceiveFromListener;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.registry.RegistryProfileUpdater;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.soap.ebxml.EbXmlException;
import de.pontonconsulting.xmlpipe.soap.ebxml.EbXmlMessage;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessengerService
extends EbXml2Service
implements IEbXml2Service {
    private static final Log _log = LogFactory.getFactory().getInstance("Messenger.MessengerService");
    private final ErrorNotificationService _errorNotificationService;

    public MessengerService(ReferenceDateTask referenceDate, ReceiveFromListener receiveFromListener, MessageDAO messageDAO, MessengerLog messengerLog, RegistryProfileUpdater registryProfileUpdater, IdGenerator idGenerator, CertificateUtility certificateUtility, ErrorNotificationService errorNotificationService) {
        super(referenceDate, receiveFromListener, messageDAO, messengerLog, registryProfileUpdater, idGenerator, certificateUtility);
        this._errorNotificationService = errorNotificationService;
    }

    @Override
    public EbXmlMessage handleMessage(int messageStatus, EbXml2Data data) throws EbXmlException {
        this.checkSignature(data);
        EbXmlMessage resp = null;
        EbXmlMessage message = data.getInboundMessage();
        ProcessingResult[] result = null;
        result = this.processMessage(messageStatus == 0, data);
        if (result != null && result.length > 0) {
            if (result[result.length - 1].getResultCode() == 0) {
                if (message.getSequenceNumber() > -1) {
                    _log.debug((Object)"Received a message with a sequence. An asynchronous ACK will be created from the inbound queue.");
                } else if (message.isAckRequested()) {
                    resp = this.buildAcknowledgement(result, data);
                    _log.debug((Object)"Ack creation completed");
                }
            } else {
                resp = this.buildErrorMessage(result, data);
                _log.debug((Object)"ErrorMessage creation completed");
                this.notifyAdapter(result, data);
            }
        } else {
            _log.error((Object)("no processing result was returned for " + message.getMessageId()));
        }
        return resp;
    }

    private void notifyAdapter(ProcessingResult[] results, EbXml2Data data) {
        List<ErrorNotificationResult> notifications = ProcessingResultToErrorNotificationResultConverter.mapResultsToNotificationCodes(results);
        this._errorNotificationService.notifyAdapter(data.getXpMessage(), notifications);
    }

    private ProcessingResult[] processMessage(boolean newMessage, EbXml2Data data) throws EbXmlException {
        EbXmlMessage message = data.getInboundMessage();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"creating XpMessage from EbXML 2.0");
        }
        XpMessage xpMessage = data.getXpMessage();
        xpMessage.setMessageId(message.getMessageId());
        xpMessage.setConversationId(message.getConversationId());
        xpMessage.setReferenceId(message.getRefToMessageId());
        xpMessage.setSenderLocalId(data.getSender().getLocalId());
        xpMessage.setReceiverLocalId(data.getReceiver().getLocalId());
        xpMessage.setProcessingDirectives(message.getProcessingDirectives());
        xpMessage.setSyncReplyRequested(message.isSyncReplyRequested());
        xpMessage.setAckRequested(message.isAckRequested());
        xpMessage.setInboundMessage(true);
        xpMessage.setMessageTimestamp(message.getMessageTimestamp());
        try {
            this._messageDAO.updateMessage(xpMessage);
        }
        catch (DbException e) {
            _log.warn((Object)("Could not updating MessageType in database. " + e.getMessage()));
        }
        return this._receiveFromListener.handleMessage(xpMessage);
    }
}

