/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.listener.ebxml2;

import de.pontonconsulting.xmlpipe.config.DistributionConfigFinder;
import de.pontonconsulting.xmlpipe.config.EbXml20ServiceConfig;
import de.pontonconsulting.xmlpipe.listener.ebxml2.EbXml2Service;
import de.pontonconsulting.xmlpipe.listener.ebxml2.IEbXml2Service;
import de.pontonconsulting.xmlpipe.soap.ebxml.EbXmlException;
import de.pontonconsulting.xmlpipe.util.ApplicationContextBeanLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

public class EbXml2ServiceFactory
extends ApplicationContextBeanLoader {
    private static final String URI = "URI";
    private static Log _log = LogFactory.getFactory().getInstance("Messenger.EbXml2ServiceFactory");
    private final ArrayList<String> _services = new ArrayList();
    private final ArrayList<String> _serviceTypes = new ArrayList();
    private final ArrayList<String> _actions = new ArrayList();
    private final ArrayList<Class<EbXml2Service>> _implementations = new ArrayList();

    public EbXml2ServiceFactory(DistributionConfigFinder distributionConfigFinder, ApplicationContext applicationContext) throws ClassNotFoundException {
        super(applicationContext);
        List<EbXml20ServiceConfig> ebXml20ServiceConfigs = distributionConfigFinder.getEbXml20ServiceConfigs();
        for (EbXml20ServiceConfig ebXml20ServiceConfig : ebXml20ServiceConfigs) {
            if (_log.isTraceEnabled()) {
                _log.trace((Object)("Registering service '" + ebXml20ServiceConfig.getService() + "' - service type '" + ebXml20ServiceConfig.getServiceType() + "' - action '" + ebXml20ServiceConfig.getAction() + "' - handler '" + ebXml20ServiceConfig.getHandler() + "'"));
            }
            this.registerService(ebXml20ServiceConfig.getService(), ebXml20ServiceConfig.getServiceType(), ebXml20ServiceConfig.getAction(), Class.forName(ebXml20ServiceConfig.getHandler()));
        }
    }

    private void registerService(String service, String serviceType, String action, Class<EbXml2Service> serviceClass) {
        this._services.add(service);
        this._serviceTypes.add(serviceType);
        this._actions.add(action);
        this._implementations.add(serviceClass);
    }

    public IEbXml2Service findService(String service, String serviceType, String action) throws EbXmlException {
        Class<EbXml2Service> serviceClass = null;
        if (action == null || "null".equals(action)) {
            throw new EbXmlException(30008, new String[0], "Error", "ValueNotRecognized", "Action value is invalid.");
        }
        if (serviceType == null) {
            serviceType = URI;
        }
        for (int i = 0; i < this._services.size(); ++i) {
            String regAction;
            String regServiceType;
            String regService = this._services.get(i);
            if (!regService.equals("*") && !regService.equals(service) || !(regServiceType = this._serviceTypes.get(i)).equals("*") && !regServiceType.equals(serviceType) || !(regAction = this._actions.get(i)).equals("*") && !regAction.equals(action)) continue;
            serviceClass = this._implementations.get(i);
            break;
        }
        if (serviceClass != null) {
            return (IEbXml2Service)this.getBean(serviceClass);
        }
        throw new EbXmlException(30008, new String[0], "Error", "ValueNotRecognized", "Service and/or Action value is invalid.");
    }
}

