/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.listener.ebxml2;

import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.listener.ebxml2.EbXml2Data;
import de.pontonconsulting.xmlpipe.listener.ebxml2.EbXml2Service;
import de.pontonconsulting.xmlpipe.listener.ebxml2.IEbXml2Service;
import de.pontonconsulting.xmlpipe.message.XpAcknowledgment;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.message.XpStatusResponse;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.ProcessingResult;
import de.pontonconsulting.xmlpipe.messenger.ReceiveFromListener;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.archive.ArchiveProcessor;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.MessageInfo;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageWorkDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.registry.RegistryProfileUpdater;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.soap.ebxml.EbXmlException;
import de.pontonconsulting.xmlpipe.soap.ebxml.EbXmlMessage;
import de.pontonconsulting.xmlpipe.soap.ebxml.header.Error;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.util.Date;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.FileSystemUtils;

public class BaseEbXml2Service
extends EbXml2Service
implements IEbXml2Service {
    private static final String EBXML_ACKNOWLEDGMENT = "Acknowledgment";
    private static final String EBXML_MESSAGE_ERROR = "MessageError";
    private static final String EBXML_PING = "Ping";
    private static final String EBXML_PONG = "Pong";
    private static final String EBXML_STATUS_REQUEST = "StatusRequest";
    private static final String EBXML_STATUS_RESPONSE = "StatusResponse";
    public static final Logger _log = LogManager.getLogger((String)"Messenger.BasisEbXml2Service");
    private final IFolders _folders;
    private final ArchiveProcessor _archiveProcessor;
    private final MessageWorkDataDAO messageWorkDataDAO;

    public BaseEbXml2Service(ReferenceDateTask referenceDate, ReceiveFromListener receiveFromListener, MessageDAO messageDAO, MessengerLog messengerLog, RegistryProfileUpdater registryProfileUpdater, IdGenerator idGenerator, CertificateUtility certificateUtility, IFolders folders, ArchiveProcessor archiveProcessor, MessageWorkDataDAO messageWorkDataDAO) {
        super(referenceDate, receiveFromListener, messageDAO, messengerLog, registryProfileUpdater, idGenerator, certificateUtility);
        this._folders = folders;
        this._archiveProcessor = archiveProcessor;
        this.messageWorkDataDAO = messageWorkDataDAO;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public EbXmlMessage handleMessage(int messageStatus, EbXml2Data data) throws EbXmlException {
        if (messageStatus == 0) {
            XpMessage xpMessage = data.getXpMessage();
            xpMessage.setSenderLocalId(data.getSender().getLocalId());
            xpMessage.setReceiverLocalId(data.getReceiver().getLocalId());
            xpMessage.setMessageVersion("2.1");
            xpMessage.setSchemaSet("ponton");
            if (EBXML_PING.equalsIgnoreCase(data.getAction())) {
                xpMessage.setMessageType("PING");
                this.updateMessage(xpMessage);
                this.checkSignature(data);
                return this.handlePing(data);
            }
            if (EBXML_PONG.equalsIgnoreCase(data.getAction())) {
                xpMessage.setMessageType("PONG");
                this.updateMessage(xpMessage);
                this.checkSignature(data);
                this.handlePong(data);
                return null;
            }
            if (EBXML_MESSAGE_ERROR.equalsIgnoreCase(data.getAction())) {
                xpMessage.setMessageType("ACK");
                this.updateMessage(xpMessage);
                try {
                    try {
                        this.checkSignature(data);
                    }
                    catch (EbXmlException e) {
                        this._messengerLog.log2db(521, data.getXpMessage().getDatabaseId(), "MessageError is processed anyway");
                    }
                    this.handleMessageError(data);
                    return null;
                }
                catch (JAXBException e) {
                    _log.error("could not store Xp-ACK... stop further processing now:{}", (Object)e.getMessage());
                    if (xpMessage.getReferenceDatabaseId() <= -1L) return null;
                    this._messengerLog.log2dbWithHref(215, xpMessage.getReferenceDatabaseId(), xpMessage.getMessageId(), xpMessage.getMessageId(), xpMessage.getDatabaseId(), xpMessage.isInbound());
                    return null;
                }
                catch (Exception e) {
                    _log.error("Error occured while processing MessageError:{}", (Object)e.getMessage());
                    if (xpMessage.getReferenceDatabaseId() <= -1L) return null;
                    this._messengerLog.log2dbWithHref(215, xpMessage.getReferenceDatabaseId(), xpMessage.getMessageId(), xpMessage.getMessageId(), xpMessage.getDatabaseId(), xpMessage.isInbound());
                }
                return null;
            }
            if (EBXML_ACKNOWLEDGMENT.equalsIgnoreCase(data.getAction())) {
                xpMessage.setMessageType("ACK");
                xpMessage.setIsAck(true);
                this.updateMessage(xpMessage);
                try {
                    this.checkSignature(data);
                    this.handleAcknowledgment(data);
                    return null;
                }
                catch (JAXBException e) {
                    _log.debug("could not store Xp-ACK... stop further processing now:{}", (Object)e.getMessage());
                }
                catch (Exception e) {
                    _log.fatal("EbXmlAcknowledgment could not be processed: {}", (Object)e.getMessage());
                }
                if (xpMessage.getReferenceDatabaseId() > -1L) {
                    this._messengerLog.log2dbWithHref(215, xpMessage.getReferenceDatabaseId(), xpMessage.getMessageId(), xpMessage.getMessageId(), xpMessage.getDatabaseId(), xpMessage.isInbound());
                }
                this.finalizeFailedACK(xpMessage);
                return null;
            }
            if (EBXML_STATUS_REQUEST.equalsIgnoreCase(data.getAction())) {
                xpMessage.setMessageType(EBXML_STATUS_REQUEST);
                this.updateMessage(xpMessage);
                this.checkSignature(data);
                return this.handleStatusRequest(data);
            }
            if (!EBXML_STATUS_RESPONSE.equalsIgnoreCase(data.getAction())) throw new EbXmlException(30023, new String[]{data.getAction()}, "Error", "ValueNotRecognized", "Unknown Action:" + data.getAction());
            xpMessage.setMessageType(EBXML_STATUS_RESPONSE);
            this.updateMessage(xpMessage);
            try {
                this.checkSignature(data);
                this.handleStatusResponse(data);
                return null;
            }
            catch (Exception e) {
                _log.fatal("Error while processing Status Response... stop further processing now: {}", (Object)e.getMessage());
                if (xpMessage.getReferenceDatabaseId() <= -1L) return null;
                this._messengerLog.log2dbWithHref(215, xpMessage.getReferenceDatabaseId(), xpMessage.getMessageId(), xpMessage.getMessageId(), xpMessage.getDatabaseId(), xpMessage.isInbound());
            }
            return null;
        }
        _log.info("Duplicate EbXml Message Service Message received. it is ignored. MessageId={}", (Object)data.getInboundMessage().getMessageId());
        return null;
    }

    private void finalizeFailedACK(XpMessage xpMessage) {
        try {
            this.messageWorkDataDAO.uploadDirectoryToDB(xpMessage.getDatabaseId(), xpMessage.getCurrentContentReferenceFolder());
            FileSystemUtils.deleteRecursively((File)xpMessage.getCurrentContentReferenceFolder());
        }
        catch (DbException e) {
            _log.error("Couldn't upload message folder for {} to database: {}", (Object)xpMessage.getDatabaseId(), (Object)e.getMessage());
        }
        this._archiveProcessor.sendFilesToArchive(xpMessage.getDatabaseId(), true);
        this._messageDAO.updateMessageStatus(xpMessage.getDatabaseId(), xpMessage.getMessageId(), 4);
    }

    private void updateMessage(XpMessage xpMessage) {
        try {
            this._messageDAO.updateMessage(xpMessage);
        }
        catch (DbException e) {
            _log.error("could not update message type. {}", (Object)e.getMessage());
        }
    }

    public EbXmlMessage createOkAck(EbXml2Data org) {
        ProcessingResult[] result = new ProcessingResult[]{new ProcessingResult(0, null, null)};
        return this.buildAcknowledgement(result, org);
    }

    private EbXmlMessage handlePing(EbXml2Data data) {
        EbXmlMessage response = null;
        EbXmlMessage message = data.getInboundMessage();
        XpMessage xpMessagePing = data.getXpMessage();
        File messageFolder = new File(this._folders.getWorkInboundFolder(), String.valueOf(xpMessagePing.getDatabaseId()));
        xpMessagePing.setCurrentContentReferenceFolder(messageFolder);
        try {
            SOAPMessage msg = MessageFactory.newInstance().createMessage();
            response = new EbXmlMessage(msg, this._referenceDate);
            response.preparePongMessage(message.getMessageId());
            response.setCPAId(message.getCPAId());
            response.setConversationId(message.getConversationId());
            response.setFromIds(message.getToIds());
            response.setToIds(message.getFromIds());
            response.setMessageId(this._idGenerator.generateMessageId());
            response.setMessageTimestamp(this._referenceDate.getReferenceDate());
        }
        catch (SOAPException e) {
            _log.error("Could not create Pong Message:{}", (Object)e.getMessage());
        }
        return response;
    }

    private void handlePong(EbXml2Data data) {
        EbXmlMessage message = data.getInboundMessage();
        try {
            XpMessage xpMessage = data.getXpMessage();
            _log.debug("Create internal Pong message");
            xpMessage.setIsAck(true);
            XpAcknowledgment ack = new XpAcknowledgment(xpMessage, message.getRefToMessageId(), xpMessage.getRegistrationTimestamp(), message.getMessageTimestamp());
            ack.setOverallResult(EBXML_PONG);
            ack.addError("Success", "Pong Message");
            File ackRef = ack.saveToDisk(new File(this._folders.getWorkInboundFolder(), String.valueOf(xpMessage.getDatabaseId())));
            xpMessage.setCurrentContentReference(ackRef);
            this._messageDAO.updateMessage(xpMessage);
            this._receiveFromListener.handleMessage(xpMessage);
        }
        catch (Exception e) {
            _log.debug("Error while processing Pong... stop further processing now:{}", (Object)e.getMessage());
        }
    }

    private void handleMessageError(EbXml2Data data) throws JAXBException, DbException {
        EbXmlMessage message = data.getInboundMessage();
        _log.debug("creating XpAcknowledgment from EbXML 2.0 ErrorMessage");
        XpMessage xpMessage = data.getXpMessage();
        xpMessage.setIsAck(true);
        XpAcknowledgment ack = new XpAcknowledgment(xpMessage, xpMessage.getReferenceId(), xpMessage.getRegistrationTimestamp(), message.getMessageTimestamp());
        if (message.getErrors() != null) {
            ack.setOverallResult(message.getHighestSeverityOfError());
            for (Error element : message.getErrors()) {
                String errorCode = element.getErrorCode();
                String location = element.getLocation();
                String description = element.getDescription().getValue();
                if (location != null && location.trim().length() > 0) {
                    ack.addError("Error", "(" + location + ") " + description + " EbXml-ErrorCode:" + errorCode);
                    continue;
                }
                ack.addError("Error", description + " EbXml-ErrorCode:" + errorCode);
            }
        }
        File ackRef = ack.saveToDisk(new File(this._folders.getWorkInboundFolder(), String.valueOf(xpMessage.getDatabaseId())));
        xpMessage.setCurrentContentReference(ackRef);
        this._messageDAO.updateMessage(xpMessage);
        this._receiveFromListener.handleMessage(xpMessage);
    }

    private void handleAcknowledgment(EbXml2Data data) throws DbException, JAXBException {
        EbXmlMessage message = data.getInboundMessage();
        _log.debug("creating XpAcknowledgment from EbXML 2.0 Ack");
        XpMessage xpMessage = data.getXpMessage();
        xpMessage.setIsAck(true);
        Date receivedTime = message.getAcknowledgementTimestamp();
        XpAcknowledgment ack = new XpAcknowledgment(xpMessage, xpMessage.getReferenceId(), xpMessage.getRegistrationTimestamp(), receivedTime);
        if (message.getErrors() != null) {
            ack.setOverallResult(message.getHighestSeverityOfError());
            for (Error element : message.getErrors()) {
                String errorCode = element.getErrorCode();
                String description = element.getDescription().getValue();
                ack.addError("Error", description + " EbXml-ErrorCode:" + errorCode);
            }
        } else {
            ack.setOverallResult("Success");
            ack.addError("Success", "Message was successfully received");
        }
        try {
            String ackRequested = data.getCommunication(data.getReceiver().getLocalId(), data.getSender().getLocalId()).getPackagingOptionValue("/RequestAck");
            boolean signedAck = "signed".equalsIgnoreCase(ackRequested);
            if (signedAck && !message.isSigned()) {
                this._messengerLog.log2db(516, xpMessage.getReferenceDatabaseId(), "signed ACK expected but received unsigned ACK");
                this._messageDAO.updateMessageAndStatus(xpMessage, 4);
                ack.setOverallResult("Error");
                ack.addError("Error", "A signed Acknowledgment was requested but we received an unsigned one");
                _log.fatal("Signed Ack was requested but unsigned Ack was received");
                return;
            }
        }
        catch (OptionNotFoundException optionNotFoundException) {
            // empty catch block
        }
        File ackRef = ack.saveToDisk(new File(this._folders.getWorkInboundFolder(), String.valueOf(xpMessage.getDatabaseId())));
        xpMessage.setCurrentContentReference(ackRef);
        this._receiveFromListener.handleMessage(xpMessage);
    }

    private void handleStatusResponse(EbXml2Data data) throws JAXBException {
        EbXmlMessage message = data.getInboundMessage();
        XpMessage xpMessage = data.getXpMessage();
        _log.debug("creating XpStatusResponse from EbXML 2.0 Status Response");
        xpMessage.setIsStatusResponse(true);
        String refMessageId = message.getStatusResponseMSGReference();
        String status = message.getMessageStatus();
        xpMessage.setMessageTimestamp(this._referenceDate.getReferenceDate());
        _log.debug("handle StatusResponse responseId: {} status: {} for the MSG: {}", (Object)xpMessage.getMessageId(), (Object)status, (Object)refMessageId);
        XpStatusResponse statusResponse = new XpStatusResponse(xpMessage, xpMessage.getReferenceId(), message.getMessageTimestamp());
        statusResponse.setStatusResponse(refMessageId, status, message.getStatusResponseMSGTimestamp());
        File statusResponseRef = statusResponse.saveToDisk(new File(this._folders.getWorkInboundFolder(), String.valueOf(xpMessage.getDatabaseId())));
        xpMessage.setCurrentContentReference(statusResponseRef);
        xpMessage.setProcessingDirective("MSGStatus", status);
        xpMessage.setProcessingDirective("StatusResponseMSGId", refMessageId);
        xpMessage.setProcessingDirective("IsStatusResponse", String.valueOf(true));
        this._receiveFromListener.handleMessage(xpMessage);
    }

    private EbXmlMessage handleStatusRequest(EbXml2Data data) {
        EbXmlMessage response = null;
        EbXmlMessage message = data.getInboundMessage();
        XpMessage xpMessage = data.getXpMessage();
        String status = "NotRecognized";
        Date msgReceptionTime = null;
        String senderLocalId = xpMessage.getSenderLocalId();
        String refMessage = message.getStatusRequestReference();
        _log.debug("handle StatusRequest from: {} to: {} for the MSG: {} requestId: {}", (Object)senderLocalId, (Object)xpMessage.getReceiverLocalId(), (Object)refMessage, (Object)xpMessage.getMessageId());
        try {
            MessageInfo messageInfo = null;
            messageInfo = this._messageDAO.getMessageInfo(refMessage, 1);
            if (senderLocalId == null || !senderLocalId.equals(messageInfo.getSenderId())) {
                status = "UnAuthorized";
            } else {
                int dbStatus = messageInfo.getStatus();
                long refDataId = messageInfo.getDatabaseId();
                switch (dbStatus) {
                    case 0: {
                        status = "NotRecognized";
                        this._messengerLog.log2db(93, xpMessage.getDatabaseId(), refMessage);
                        break;
                    }
                    case 1: {
                        status = "Received";
                        msgReceptionTime = new Date(messageInfo.getTimestamp());
                        this._messengerLog.log2dbWithHref(93, xpMessage.getDatabaseId(), refMessage, refMessage, refDataId, false);
                        this._messengerLog.log2dbWithHref(96, refDataId, xpMessage.getMessageId(), xpMessage.getMessageId(), xpMessage.getDatabaseId(), true);
                        break;
                    }
                    case 2: {
                        status = "Received";
                        msgReceptionTime = new Date(messageInfo.getTimestamp());
                        this._messengerLog.log2dbWithHref(93, xpMessage.getDatabaseId(), refMessage, refMessage, refDataId, false);
                        this._messengerLog.log2dbWithHref(96, refDataId, xpMessage.getMessageId(), xpMessage.getMessageId(), xpMessage.getDatabaseId(), true);
                        break;
                    }
                    case 3: {
                        status = "Processed";
                        msgReceptionTime = new Date(messageInfo.getTimestamp());
                        this._messengerLog.log2dbWithHref(93, xpMessage.getDatabaseId(), refMessage, refMessage, refDataId, false);
                        this._messengerLog.log2dbWithHref(96, refDataId, xpMessage.getMessageId(), xpMessage.getMessageId(), xpMessage.getDatabaseId(), true);
                        break;
                    }
                    case 5: {
                        status = "Processed";
                        msgReceptionTime = new Date(messageInfo.getTimestamp());
                        this._messengerLog.log2dbWithHref(93, xpMessage.getDatabaseId(), refMessage, refMessage, refDataId, false);
                        this._messengerLog.log2dbWithHref(96, refDataId, xpMessage.getMessageId(), xpMessage.getMessageId(), xpMessage.getDatabaseId(), true);
                        break;
                    }
                    case 4: {
                        status = "Received";
                        msgReceptionTime = new Date(messageInfo.getTimestamp());
                        this._messengerLog.log2db(93, xpMessage.getDatabaseId(), refMessage);
                        break;
                    }
                    default: {
                        status = "NotRecognized";
                        this._messengerLog.log2db(93, xpMessage.getDatabaseId(), refMessage);
                    }
                }
                File messageFolder = new File(this._folders.getWorkInboundFolder(), String.valueOf(xpMessage.getDatabaseId()));
                xpMessage.setCurrentContentReferenceFolder(messageFolder);
            }
        }
        catch (DbException e) {
            status = "NotRecognized";
            this._messengerLog.log2db(93, xpMessage.getDatabaseId(), refMessage);
        }
        try {
            SOAPMessage msg = MessageFactory.newInstance().createMessage();
            response = new EbXmlMessage(msg, this._referenceDate);
            response.prepareStatusResponseMessage(message.getMessageId());
            response.setCPAId(message.getCPAId());
            response.setConversationId(message.getConversationId());
            response.setFromIds(message.getToIds());
            response.setToIds(message.getFromIds());
            response.setMessageId(this._idGenerator.generateMessageId());
            response.setMessageTimestamp(this._referenceDate.getReferenceDate());
            response.setStatusResponse(refMessage, status, msgReceptionTime);
            _log.debug("created StatusResponse responeId: {} status: {} for the MSG: {}", (Object)response.getMessageId(), (Object)status, (Object)refMessage);
        }
        catch (SOAPException e) {
            _log.error("Could not create Status Response Message:{}", (Object)e.getMessage());
        }
        return response;
    }
}

