/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.listener;

import de.pontonconsulting.common.file.FileLocker;
import de.pontonconsulting.common.log.LogPrintStream;
import de.pontonconsulting.xmlpipe.activation.ActivationControl;
import de.pontonconsulting.xmlpipe.activation.capability.AS4Capability;
import de.pontonconsulting.xmlpipe.activation.capability.ASxCapability;
import de.pontonconsulting.xmlpipe.activation.capability.EbXMLCapability;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.events.ServiceLevel;
import de.pontonconsulting.xmlpipe.events.StartupService;
import de.pontonconsulting.xmlpipe.listener.AS1Processor;
import de.pontonconsulting.xmlpipe.listener.ASProcessingResult;
import de.pontonconsulting.xmlpipe.listener.IASProcessorFactory;
import de.pontonconsulting.xmlpipe.listener.ListenerManager;
import de.pontonconsulting.xmlpipe.listener.SoapListener;
import de.pontonconsulting.xmlpipe.mail.DispositionNotification;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.IServiceProvider;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.MaintenanceManager;
import de.pontonconsulting.xmlpipe.messenger.Messenger;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.transport.BaseTransportProvider;
import de.pontonconsulting.xmlpipe.messenger.transport.SmtpSender;
import de.pontonconsulting.xmlpipe.messenger.transport.SmtpSenderFactory;
import de.pontonconsulting.xmlpipe.messenger.transport.TransportException;
import de.pontonconsulting.xmlpipe.messenger.transport.TransportProviderFactory;
import de.pontonconsulting.xmlpipe.util.EmailUtils;
import de.pontonconsulting.xmlpipe.util.MimeMultipartUtils;
import de.pontonconsulting.xmlpipe.util.SOAPMessageUtils;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Flags;
import jakarta.mail.Folder;
import jakarta.mail.Header;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Part;
import jakarta.mail.Session;
import jakarta.mail.Store;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimePart;
import jakarta.mail.util.SharedFileInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Date;
import java.util.Enumeration;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationEvent;

public class MailListener
implements IServiceProvider {
    private static final String MAIL_POP3S_SSL_TRUST = "mail.pop3s.ssl.trust";
    private static final String MAIL_IMAPS_SSL_TRUST = "mail.imaps.ssl.trust";
    private static final String MAIL_POP3_SSL_TRUST = "mail.pop3.ssl.trust";
    private static final String MAIL_IMAP_SSL_TRUST = "mail.imap.ssl.trust";
    private static final String MAIL_IMAPS_SSL_CHECK_SERVER_IDENTITY = "mail.imaps.ssl.checkserveridentity";
    private static final String MAIL_IMAP_SSL_CHECK_SERVER_IDENTITY = "mail.imap.ssl.checkserveridentity";
    private static final String MAIL_POP3_SSL_CHECK_SERVER_IDENTITY = "mail.pop3.ssl.checkserveridentity";
    private static final String MAIL_POP3S_SSL_CHECK_SERVER_IDENTITY = "mail.pop3s.ssl.checkserveridentity";
    private static final String MAIL_IMAP_STARTTLS_ENABLE = "mail.imap.starttls.enable";
    private static final String MAIL_IMAP_STARTTLS_REQUIRED = "mail.imap.starttls.required";
    private static final String MAIL_POP3_STARTTLS_ENABLE = "mail.pop3.starttls.enable";
    private static final String MAIL_POP3_STARTTLS_REQUIRED = "mail.pop3.starttls.required";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String TRUST_ALL_HOSTS = "*";
    private static final String SMTP = "MAILTO";
    private static final String MAIL_TEMP_HEADER_FILE = "mail-Ack-Header.dat";
    private static final String MAIL_TEMP_FILE = "mail-Ack.dat";
    private static final String APPLICATION = "application";
    private static final String REPORT = "report";
    private static final String MULTIPART = "multipart";
    private static final String TEXT = "text";
    private static final String XML = "xml";
    private static final String RELATED = "related";
    public static final String INBOX = "INBOX";
    private static final String BOUNDARY = "boundary";
    private static final String UA_PONTONXP_MAIL_LISTENER = "; PontonXP Mail-Listener";
    private static final String PROTOCOL_IMAP = "imap";
    private static final String PROTOCOL_IMAP_STARTTLS = "imap+starttls";
    private static final String PROTOCOL_POP3 = "pop3";
    private static final String PROTOCOL_POP3_STARTTLS = "pop3+starttls";
    private static final String PROTOCOL_POP3S = "pop3s";
    public static final String BASETYPE_MULTIPART_RELATED = "multipart/related";
    public static final String TYPE_APPLICATION_SOAP_XML = "application/soap+xml";
    public static final String PARAMETER_TYPE = "type";
    public static final Logger _log = LogManager.getLogger((String)"Messenger.MailListener");
    private boolean _keepRunning;
    private final MessengerConfig messengerConfig;
    private SoapListener _soapListener;
    private final IASProcessorFactory _asProcessorFactory;
    private final ReferenceDateTask referenceDateTask;
    private final ListenerManager _listenerManager;
    private final TransportProviderFactory _transportProviderFactory;
    private final MessageDAO _messageDAO;
    private final MessengerLog _messengerLog;
    private final SmtpSenderFactory _smtpSenderFactory;
    private final IFolders _folders;
    private final IdGenerator _idGenerator;
    private final MaintenanceManager _maintenanceManager;
    private final ActivationControl _activationControl;
    private final ASxCapability as1Capability;
    private final EbXMLCapability ebXmlCapability;
    private final AS4Capability as4Capability;
    private String _host;
    private String _protocol;
    private final File _mailLockFolder;
    private final AtomicLong _emailCount;

    public MailListener(MessengerConfig messengerConfig, IServerConfigBean serverConfig, IASProcessorFactory asProcessorFactory, ReferenceDateTask referenceDateTask, ListenerManager listenerManager, TransportProviderFactory transportProviderFactory, MessageDAO messageDAO, MessengerLog messengerLog, SmtpSenderFactory smtpSenderFactory, IFolders folders, IdGenerator idGenerator, MaintenanceManager maintenanceManager, ActivationControl activationControl, ASxCapability as1Capability, EbXMLCapability ebXmlCapability, AS4Capability as4Capability) {
        this._asProcessorFactory = asProcessorFactory;
        this.referenceDateTask = referenceDateTask;
        this._listenerManager = listenerManager;
        this._transportProviderFactory = transportProviderFactory;
        this._messageDAO = messageDAO;
        this._messengerLog = messengerLog;
        this._smtpSenderFactory = smtpSenderFactory;
        this._folders = folders;
        this._idGenerator = idGenerator;
        this._maintenanceManager = maintenanceManager;
        this._activationControl = activationControl;
        this.as1Capability = as1Capability;
        this.ebXmlCapability = ebXmlCapability;
        this.as4Capability = as4Capability;
        this._emailCount = new AtomicLong(0L);
        this._keepRunning = true;
        this.messengerConfig = messengerConfig;
        this._mailLockFolder = new File(serverConfig.getConfigFolder(), "MailLock");
        this._mailLockFolder.mkdirs();
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            this._host = localhost.getHostAddress();
        }
        catch (UnknownHostException uhe) {
            this._host = "unresolvable.hostname";
        }
    }

    public void run() {
        if (this._maintenanceManager.isRejectInboundMSGs()) {
            _log.warn("mail reception is disabled due to maintenance mode");
        }
        if (!this._activationControl.isActive()) {
            _log.warn("mail reception is disabled due to missing license activation");
        }
        this.receive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receive() {
        _log.debug("Start receiving");
        String port = null;
        String folderName = null;
        Object lockObject = new Object();
        try {
            this._maintenanceManager.putLock(lockObject);
            this._protocol = this.messengerConfig.getMailServerProtocol();
            String username = this.messengerConfig.getMailServerUser();
            String password = this.messengerConfig.getMailServerPassword();
            String mailServer = this.messengerConfig.getMailServerHost();
            folderName = this.messengerConfig.getMailInboxFolder();
            if (folderName == null) {
                folderName = INBOX;
                this.messengerConfig.setMailInboxFolder(INBOX);
            }
            if (_log.isTraceEnabled()) {
                _log.trace("checking email on server:{}", (Object)mailServer);
            }
            Properties props = new Properties();
            props.setProperty(MAIL_IMAP_SSL_TRUST, TRUST_ALL_HOSTS);
            props.setProperty(MAIL_POP3_SSL_TRUST, TRUST_ALL_HOSTS);
            props.setProperty(MAIL_IMAPS_SSL_TRUST, TRUST_ALL_HOSTS);
            props.setProperty(MAIL_POP3S_SSL_TRUST, TRUST_ALL_HOSTS);
            props.setProperty(MAIL_IMAPS_SSL_CHECK_SERVER_IDENTITY, this.messengerConfig.getProperty(MAIL_IMAPS_SSL_CHECK_SERVER_IDENTITY, FALSE));
            props.setProperty(MAIL_IMAP_SSL_CHECK_SERVER_IDENTITY, this.messengerConfig.getProperty(MAIL_IMAP_SSL_CHECK_SERVER_IDENTITY, FALSE));
            props.setProperty(MAIL_POP3_SSL_CHECK_SERVER_IDENTITY, this.messengerConfig.getProperty(MAIL_POP3_SSL_CHECK_SERVER_IDENTITY, FALSE));
            props.setProperty(MAIL_POP3S_SSL_CHECK_SERVER_IDENTITY, this.messengerConfig.getProperty(MAIL_POP3S_SSL_CHECK_SERVER_IDENTITY, FALSE));
            if (PROTOCOL_POP3_STARTTLS.equals(this._protocol)) {
                _log.debug("Using POP3+STARTTLS protocol");
                props.setProperty(MAIL_POP3_STARTTLS_ENABLE, TRUE);
                props.setProperty(MAIL_POP3_STARTTLS_REQUIRED, TRUE);
            } else {
                _log.debug("Using POP3/POP3S without STARTTLS protocol");
                props.setProperty(MAIL_POP3_STARTTLS_ENABLE, FALSE);
            }
            if (PROTOCOL_IMAP_STARTTLS.equals(this._protocol)) {
                _log.debug("Using IMAP+STARTTLS protocol");
                props.setProperty(MAIL_IMAP_STARTTLS_ENABLE, TRUE);
                props.setProperty(MAIL_IMAP_STARTTLS_REQUIRED, TRUE);
            } else {
                _log.debug("Using IMAP/IMAPS without STARTTLS protocol");
                props.setProperty(MAIL_IMAP_STARTTLS_ENABLE, FALSE);
            }
            Session session = Session.getInstance((Properties)props, null);
            if (_log.isTraceEnabled()) {
                session.setDebug(true);
                session.setDebugOut((PrintStream)new LogPrintStream(_log));
            } else {
                session.setDebug(false);
            }
            int index2 = mailServer.indexOf(58);
            if (index2 > 0) {
                port = mailServer.substring(index2 + 1);
                mailServer = mailServer.substring(0, index2);
            }
            Store store = PROTOCOL_POP3_STARTTLS.equals(this._protocol) ? session.getStore(PROTOCOL_POP3) : (PROTOCOL_IMAP_STARTTLS.equals(this._protocol) ? session.getStore(PROTOCOL_IMAP) : session.getStore(this._protocol));
            if (port == null) {
                store.connect(mailServer, username, password);
            } else {
                store.connect(mailServer, Integer.parseInt(port), username, password);
            }
            Folder folder = store.getFolder(folderName);
            if (!folder.exists()) {
                throw new Exception("Folder <" + folderName + "> does not exist in mail server <" + mailServer + ">!");
            }
            if ((folder.getType() & 1) == 0) {
                throw new Exception("Folder <" + folderName + "> cannot hold any message!");
            }
            folder.open(2);
            Message[] messages = folder.getMessages();
            if (_log.isTraceEnabled()) {
                _log.trace("found {} emails on server", (Object)messages.length);
            }
            int skipped = 0;
            for (Message value : messages) {
                int messageNumber = value.getMessageNumber();
                Flags flags = value.getFlags();
                if (flags.contains(Flags.Flag.SEEN) || flags.contains(Flags.Flag.FLAGGED)) {
                    ++skipped;
                    continue;
                }
                if (!(value instanceof MimeMessage)) {
                    _log.warn("Message number {} in Folder <{}> is not a MimeMessage!", (Object)messageNumber, (Object)folderName);
                    this.flagOrDelete(value, false);
                    continue;
                }
                FileLocker lock = null;
                boolean wasSuccess = false;
                MimeMessage message = (MimeMessage)value;
                File tempFile = null;
                SharedFileInputStream shardInputStream = null;
                try {
                    tempFile = MimeMultipartUtils.createMessageTempFile(message);
                    shardInputStream = new SharedFileInputStream(tempFile);
                    MimeMessage copyMessage = new MimeMessage(null, (InputStream)shardInputStream);
                    wasSuccess = this.processEmail(copyMessage, messageNumber, folderName);
                }
                catch (MessagingException | IOException ex) {
                    _log.error(ex.toString());
                    break;
                }
                finally {
                    this.flagOrDelete((Message)message, wasSuccess);
                    IOUtils.closeQuietly((InputStream)shardInputStream);
                    FileUtils.deleteQuietly((File)tempFile);
                }
                if (lock == null) continue;
                lock.unlockFile();
            }
            folder.close(true);
            store.close();
            if (_log.isTraceEnabled()) {
                _log.trace("skipped {} old emails.", (Object)skipped);
            }
        }
        catch (Exception e) {
            _log.fatal("Could not fetch new mails:{}", (Object)e.getMessage());
        }
        finally {
            this._maintenanceManager.removeLock(lockObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processEmail(MimeMessage message, int messageNumber, String folderName) throws MessagingException {
        SharedFileInputStream emailStream;
        File emailFile;
        boolean wasSuccess;
        block44: {
            String protocol = SMTP;
            wasSuccess = false;
            boolean as1Mail = false;
            boolean ebXmlMail = false;
            boolean as4Mail = false;
            boolean mdnMail = false;
            boolean as1Support = this.as1Capability.isCapable();
            boolean ebXML20Support = this.ebXmlCapability.isCapable();
            boolean as4Support = this.as4Capability.isCapable();
            String notificationAddress = null;
            emailFile = null;
            emailStream = null;
            String[] notificationAddresses = message.getHeader("Disposition-Notification-To");
            if (notificationAddresses != null) {
                notificationAddress = notificationAddresses[0];
            }
            MimeHeaders mimeHeaders = MimeMultipartUtils.createMimeHeader((Part)message);
            ASProcessingResult result = null;
            try {
                Address[] replyAdresses = message.getReplyTo();
                MimeMessage emailContent = message;
                ContentType contentType = null;
                boolean soapAction = false;
                Enumeration headerEnum = emailContent.getAllHeaders();
                if (headerEnum != null) {
                    if (_log.isTraceEnabled()) {
                        _log.trace("second header check ");
                    }
                    while (headerEnum.hasMoreElements()) {
                        Header header = (Header)headerEnum.nextElement();
                        if (_log.isTraceEnabled()) {
                            _log.trace("{}: {}", (Object)header.getName(), (Object)header.getValue());
                        }
                        if (header.getName().equalsIgnoreCase("Content-Type")) {
                            contentType = new ContentType(header.getValue());
                        }
                        if (!header.getName().equalsIgnoreCase("SOAPAction")) continue;
                        soapAction = true;
                    }
                }
                if (contentType == null) {
                    contentType = MimeMultipartUtils.getContentType((Part)emailContent);
                }
                if (soapAction) {
                    ebXmlMail = true;
                } else if (TYPE_APPLICATION_SOAP_XML.equalsIgnoreCase(contentType.getBaseType()) || BASETYPE_MULTIPART_RELATED.equalsIgnoreCase(contentType.getBaseType()) && TYPE_APPLICATION_SOAP_XML.equalsIgnoreCase(contentType.getParameter(PARAMETER_TYPE))) {
                    as4Mail = true;
                } else if (contentType.getPrimaryType().equalsIgnoreCase(APPLICATION)) {
                    as1Mail = true;
                } else if (contentType.getSubType().equalsIgnoreCase(REPORT)) {
                    mdnMail = true;
                }
                String type = contentType.toString();
                mimeHeaders.setHeader("Content-Type", type);
                emailFile = this.saveContent((MimePart)emailContent);
                if (Messenger.isDevelopmentMode()) {
                    File emailHeaderFile = new File(emailFile.getParentFile(), emailFile.getName() + ".headers");
                    MimeMultipartUtils.writeHeadersFile(emailHeaderFile, mimeHeaders);
                }
                emailStream = new SharedFileInputStream(emailFile);
                if (ebXmlMail) {
                    if (ebXML20Support) {
                        wasSuccess = this.handleSoapMail(message, replyAdresses, protocol);
                    } else {
                        _log.error("current license does not allow to exchange EbXML 2.0 messages. skipped");
                    }
                } else if (as4Mail) {
                    if (as4Support) {
                        wasSuccess = this.handleSoapMail(message, replyAdresses, protocol);
                    } else {
                        _log.error("current license does not allow to exchange AS4 messages. skipped");
                    }
                } else if (as1Support || mdnMail) {
                    if (_log.isDebugEnabled()) {
                        _log.debug("email is AS1 email: {}", (Object)as1Mail);
                    }
                    notificationAddress = null;
                    result = this.handleAS1Mail(message, protocol);
                    wasSuccess = result.isSuccess();
                    if (result.isSendMDN() && notificationAddresses != null) {
                        notificationAddress = notificationAddresses[0];
                    }
                } else {
                    _log.error("current license does not allow to exchange ASx messages. skipped");
                }
                if (notificationAddress == null) break block44;
                this.sendMDN((Message)message, notificationAddress, wasSuccess, result == null ? null : result.getIncomingXpMessage());
            }
            catch (Exception e) {
                block45: {
                    try {
                        _log.warn("Message number {} in Folder <{}>: {}", (Object)messageNumber, (Object)folderName, (Object)e);
                        if (notificationAddress == null) break block45;
                        this.sendMDN((Message)message, notificationAddress, wasSuccess, result == null ? null : result.getIncomingXpMessage());
                    }
                    catch (Throwable throwable) {
                        if (notificationAddress != null) {
                            this.sendMDN((Message)message, notificationAddress, wasSuccess, result == null ? null : result.getIncomingXpMessage());
                        }
                        IOUtils.closeQuietly(emailStream);
                        if (emailFile != null && emailFile.exists()) {
                            if (!Messenger.isDevelopmentMode()) {
                                if (!emailFile.delete()) {
                                    _log.warn("File {} could not be deleted !", (Object)emailFile);
                                }
                            } else {
                                _log.debug("File {} is not deleted because development mode is active", (Object)emailFile);
                            }
                        }
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly(emailStream);
                if (emailFile != null && emailFile.exists()) {
                    if (!Messenger.isDevelopmentMode()) {
                        if (!emailFile.delete()) {
                            _log.warn("File {} could not be deleted !", (Object)emailFile);
                        }
                    } else {
                        _log.debug("File {} is not deleted because development mode is active", (Object)emailFile);
                    }
                }
            }
        }
        IOUtils.closeQuietly((InputStream)emailStream);
        if (emailFile != null && emailFile.exists()) {
            if (!Messenger.isDevelopmentMode()) {
                if (!emailFile.delete()) {
                    _log.warn("File {} could not be deleted !", (Object)emailFile);
                }
            } else {
                _log.debug("File {} is not deleted because development mode is active", (Object)emailFile);
            }
        }
        return wasSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File saveContent(MimePart emailContent) throws IOException, MessagingException {
        long callNumber = this._emailCount.getAndIncrement();
        File tempStore = new File(this._folders.getWorkInboundFolder(), "email-" + callNumber);
        int receivedContentLength = -1;
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(tempStore.toPath(), new OpenOption[0]));
             BufferedInputStream in = new BufferedInputStream(emailContent.getInputStream());){
            ((InputStream)in).transferTo(out);
        }
        catch (IOException ex) {
            _log.warn((Object)-1, (Throwable)ex);
        }
        finally {
            receivedContentLength = emailContent.getSize();
        }
        String[] contentLengths = emailContent.getHeader("Content-Length");
        String contentLength = null;
        if (contentLengths != null && contentLengths.length > 0) {
            contentLength = contentLengths[0];
        } else {
            _log.warn("Missing Content-Length: integrity of incoming message is not ensured[{}]", (Object)callNumber);
        }
        if (contentLength != null && !contentLength.equals(String.valueOf(receivedContentLength))) {
            String errorMessage = "Error in receiving incoming message: Content-Length = " + contentLength + " while number of received bytes = " + tempStore.length() + "[" + callNumber + "]";
            throw new IOException(errorMessage);
        }
        return tempStore;
    }

    private void flagOrDelete(Message message, boolean success) {
        block9: {
            try {
                if (success || PROTOCOL_POP3.equalsIgnoreCase(this._protocol) || PROTOCOL_POP3S.equalsIgnoreCase(this._protocol)) {
                    message.setFlag(Flags.Flag.DELETED, true);
                    break block9;
                }
                try {
                    message.setFlag(Flags.Flag.SEEN, true);
                }
                catch (MessagingException me) {
                    try {
                        message.setFlag(Flags.Flag.FLAGGED, true);
                    }
                    catch (MessagingException me1) {
                        message.setFlag(Flags.Flag.DELETED, true);
                    }
                }
            }
            catch (MessagingException me) {
                try {
                    _log.error("could not set flag on email server for {}", (Object)((MimeMessage)message).getMessageID());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private ASProcessingResult handleAS1Mail(MimeMessage mimeMessage, String protocol) {
        AS1Processor as1Processor = this._asProcessorFactory.getAS1Processor();
        return as1Processor.processRequest(mimeMessage, protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleSoapMail(MimeMessage mimeMessage, Address[] replyAddresses, String protocol) throws TransportException, URISyntaxException, InterruptedException {
        boolean success = false;
        SOAPMessage reply = null;
        try {
            _log.debug("start to process SOAP email-message");
            reply = this._soapListener.handleSoapMessage(mimeMessage, protocol, Optional.empty());
            success = true;
        }
        catch (Exception e) {
            _log.fatal("Couldn't process email ", (Throwable)e);
        }
        if (reply != null) {
            File work = this._folders.getWorkFolder();
            File tempSoap = new File(work, MAIL_TEMP_FILE);
            File tempSoapHeader = new File(work, MAIL_TEMP_HEADER_FILE);
            try {
                SOAPMessageUtils.saveToFile(reply, tempSoapHeader, tempSoap);
                String mailTOURI = EmailUtils.getMailTO(replyAddresses);
                BaseTransportProvider transportProvider = this._transportProviderFactory.getTransportProvider(mailTOURI);
                _log.debug("Sending answer to: {}", (Object)mailTOURI);
                transportProvider.sendMessage(tempSoap, tempSoapHeader, mailTOURI, null, null, null, null, 0);
            }
            finally {
                SOAPMessageUtils.purgeAttachments(reply);
                FileUtils.deleteQuietly((File)tempSoap);
                FileUtils.deleteQuietly((File)tempSoapHeader);
            }
        }
        return success;
    }

    private void sendMDN(Message originalMessage, String destination, boolean success, XpMessage incomingXpMessage) {
        try {
            String senderId;
            String[] id = originalMessage.getHeader("Message-Id");
            InternetAddress to = EmailUtils.getInternetAdress(destination);
            InternetAddress from = null;
            Address[] fromAddresses = originalMessage.getRecipients(Message.RecipientType.TO);
            if (fromAddresses == null) {
                throw new AddressException("No receiver email defined");
            }
            from = new InternetAddress(fromAddresses[0].toString());
            _log.debug("destination:{}", (Object)to.getAddress());
            _log.debug("id:{}", (Object)id[0]);
            _log.debug("from:{}", (Object)from);
            SmtpSender smtpSender = this._smtpSenderFactory.getSmtpSender();
            de.pontonconsulting.common.mail.MimeMessage msg = new de.pontonconsulting.common.mail.MimeMessage(smtpSender.getSession());
            msg.setFrom((Address)from);
            InternetAddress[] address = new InternetAddress[]{to};
            msg.setRecipients(Message.RecipientType.TO, (Address[])address);
            msg.setSubject("Accepted mail");
            msg.setSentDate(this.referenceDateTask.getReferenceDate());
            msg.addHeader("In-Reply-To", id[0]);
            msg.setHeader("Message-Id", this._idGenerator.generateMessageId());
            msg.setText("This is a multipart MIME message");
            MimeBodyPart mbp1 = new MimeBodyPart();
            mbp1.setContent((Object)("Message " + id[0] + " has been received."), "text/plain");
            MimeBodyPart mbp2 = new MimeBodyPart();
            DispositionNotification dn = new DispositionNotification();
            dn.setReportingUA(this._host + UA_PONTONXP_MAIL_LISTENER);
            if (success) {
                dn.setDisposition("automatic-action/MDN-sent-automatically; processed");
            } else {
                dn.setDisposition("automatic-action/MDN-sent-automatically; processed/error, unexpected processing-error");
            }
            dn.setOriginalMessageID(originalMessage.getHeader("Message-Id")[0]);
            dn.setFinalRecipient("rfc822;" + originalMessage.getAllRecipients()[0].toString());
            dn.setOriginalRecipient("rfc822;" + originalMessage.getAllRecipients()[0].toString());
            mbp2.setContent((Object)dn, "message/disposition-notification");
            MimeMultipart mp = new MimeMultipart(REPORT);
            mp.addBodyPart((BodyPart)mbp1);
            mp.addBodyPart((BodyPart)mbp2);
            ContentType contenttype = new ContentType(mp.getContentType());
            StringBuilder mdnContent = new StringBuilder();
            mdnContent.append("--" + contenttype.getParameter(BOUNDARY) + "\nContent-Type: text/plain\nContent-Transfer-Encoding: 7bit\n\nMessage " + id[0] + " has been received");
            if (!success) {
                mdnContent.append(" and an Error occured while processing");
            }
            mdnContent.append(".\n--" + contenttype.getParameter(BOUNDARY) + "\nContent-Type: message/disposition-notification\nContent-Transfer-Encoding: 7bit\n\nReporting-UA: " + this._host + "; PontonXP Mail-Listener\nOriginal-Recipient: rfc822;" + originalMessage.getAllRecipients()[0].toString() + "\nFinal-Recipient: rfc822;" + originalMessage.getAllRecipients()[0].toString() + "\nOriginal-Message-ID: " + originalMessage.getHeader("Message-Id")[0] + "\nDisposition: automatic-action/MDN-sent-automatically; processed");
            if (!success) {
                mdnContent.append("/error, unexpected processing-error");
            }
            mdnContent.append("\n\n--" + contenttype.getParameter(BOUNDARY) + "--\n");
            msg.setText(mdnContent.toString());
            msg.setHeader("Content-Type", "multipart/report;\n\treport-type=disposition-notification;\n\tboundary=\"" + contenttype.getParameter(BOUNDARY) + "\"");
            _log.debug("sending MDN for message-id:{}", (Object)id[0]);
            smtpSender.sendMessage(msg);
            XpMessage xpMessage = new XpMessage();
            xpMessage.setIsAck(true);
            String messageId = msg.getMessageID().replace('<', ' ').replace('>', ' ').trim();
            xpMessage.setMessageId(messageId);
            if (incomingXpMessage != null) {
                xpMessage.setConversationId(incomingXpMessage.getConversationId());
                xpMessage.setReferenceDatabaseId(incomingXpMessage.getDatabaseId());
                xpMessage.setMessagePackaging(incomingXpMessage.getMessagePackaging());
            }
            if ((senderId = from.getAddress()).length() > 30) {
                senderId = senderId.substring(0, 29);
            }
            xpMessage.setSenderLocalId(senderId);
            String receiverId = to.getAddress();
            if (receiverId.length() > 30) {
                receiverId = receiverId.substring(0, 29);
            }
            xpMessage.setReceiverLocalId(receiverId);
            xpMessage.setMessageType("ACK");
            xpMessage.setMessageVersion("2.1");
            xpMessage.setSchemaSet("ponton");
            xpMessage.setInboundMessage(false);
            xpMessage.setProtocol(SMTP);
            xpMessage.setMessengerId(this.messengerConfig.getMessengerId());
            Date receivedTime = this.referenceDateTask.getReferenceDate();
            xpMessage.setMessageTimestamp(receivedTime);
            try {
                this._messageDAO.registerMessage(xpMessage);
                this._messengerLog.log2db(74, xpMessage.getDatabaseId(), " MDN (ACK) SMTP");
                this._messageDAO.updateMessageStatus(xpMessage.getDatabaseId(), xpMessage.getMessageId(), 3);
            }
            catch (DbException e) {
                _log.fatal("Ack could not be registered in DB: {}", (Object)e.getMessage());
            }
            _log.debug("successfully sent MDN with message-id:{}", (Object)msg.getMessageID());
        }
        catch (MessagingException me) {
            _log.fatal("Could not generate MDN:{}", (Object)me.getMessage());
        }
        catch (TransportException e) {
            _log.fatal("Could not send MDN because SMTP sender could not be created.{}", (Object)e.getMessage());
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof StartupService) {
            StartupService startupEvent = (StartupService)event;
            if (this.getServiceLevel() == startupEvent.getServiceLevel() && this._soapListener == null) {
                this._soapListener = (SoapListener)this._listenerManager.getListener("SoapListener");
                _log.debug("SoapListener initialized");
            }
        }
    }

    @Override
    public ServiceLevel getServiceLevel() {
        return ServiceLevel.getServiceLevel(this.getClass());
    }

    @Override
    public String getServiceName() {
        return "MailListener";
    }
}

