/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.listener;

import de.ponton.securelistener.administration.certs.Certificate;
import de.pontonconsulting.xmlpipe.admintool.InstallCertException;
import de.pontonconsulting.xmlpipe.config.ListenerConfig;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.config.listener.ListenerConfigException;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.ListenerCertificate;
import de.pontonconsulting.xmlpipe.messenger.database.tables.ListenerConfigDAO;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.RevocationVerifier;
import de.pontonconsulting.xmlpipe.security.RevocationVerifierFactory;
import java.io.IOException;
import java.security.NoSuchProviderException;
import java.security.cert.CRLReason;
import java.security.cert.CertificateException;
import java.security.cert.CertificateRevokedException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class ListenerCertificateRevocationTask {
    private final Logger logger = LogManager.getLogger((String)("messenger." + String.valueOf(this.getClass())));
    private final ListenerConfig listenerConfig;
    private final CertificateUtility certificateUtility;
    private final ReferenceDateTask referenceDateTask;
    private final RevocationVerifierFactory revocationVerifierFactory;
    private final MessengerConfig messengerConfig;
    private final ListenerConfigDAO listenerConfigDAO;

    public ListenerCertificateRevocationTask(ListenerConfig listenerConfig, CertificateUtility certificateUtility, ReferenceDateTask referenceDateTask, RevocationVerifierFactory revocationVerifierFactory, MessengerConfig messengerConfig, ListenerConfigDAO listenerConfigDAO) {
        this.listenerConfig = listenerConfig;
        this.certificateUtility = certificateUtility;
        this.referenceDateTask = referenceDateTask;
        this.revocationVerifierFactory = revocationVerifierFactory;
        this.messengerConfig = messengerConfig;
        this.listenerConfigDAO = listenerConfigDAO;
    }

    public void checkCertificates() {
        RevocationVerifier revocationVerifier = this.revocationVerifierFactory.createRevocationVerifier();
        try {
            if (this.messengerConfig.isPartnerCertificateRevocationCheckEnabled()) {
                this.listenerConfigDAO.loadListenerCertificatesByType(ListenerCertificate.Type.CLIENT).stream().map(this::convertToX509).filter(Objects::nonNull).filter(cert -> this.checkRevocationState((X509Certificate)cert, revocationVerifier).isTrusted()).forEach(this::restoreCertificate);
                this.listenerConfig.listClientCertificates().forEach(e -> this.checkCertificate((String)e, revocationVerifier));
            }
        }
        catch (ListenerConfigException e2) {
            this.logger.error(e2.getMessage());
        }
    }

    private X509Certificate convertToX509(ListenerCertificate listenerCertificate) {
        try {
            return this.certificateUtility.getX509Certificate(listenerCertificate.getCertificate());
        }
        catch (InstallCertException | NoSuchProviderException | CertificateException e) {
            this.logger.error("could not convert {} certificate {}  to x509 certificate: {}", (Object)listenerCertificate.getType(), (Object)listenerCertificate.getAlias(), (Object)e.toString());
            return null;
        }
    }

    private void restoreCertificate(X509Certificate revokedCertificate) {
        try {
            this.listenerConfig.installClientCertificate(new Certificate(revokedCertificate.getEncoded()), true);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }

    private RevocationResult checkRevocationState(X509Certificate certificate, RevocationVerifier revocationVerifier) {
        try {
            revocationVerifier.verifyCertificateCRLs(certificate);
        }
        catch (IOException e) {
            return new RevocationResult(ListenerCertificate.Status.TEMPORARILY_DISABLED);
        }
        catch (CertificateRevokedException e) {
            return new RevocationResult(ListenerCertificate.Status.REVOKED, e.getRevocationReason());
        }
        return new RevocationResult(ListenerCertificate.Status.TRUSTED);
    }

    private void checkCertificate(String alias, RevocationVerifier revocationVerifier) {
        try {
            Certificate clientCertificate = this.listenerConfig.getClientCertificate(alias);
            X509Certificate x509Certificate = this.certificateUtility.getX509Certificate(clientCertificate.getCertificate());
            RevocationResult revocationResult = this.checkRevocationState(x509Certificate, revocationVerifier);
            switch (revocationResult.status) {
                case TRUSTED: {
                    this.listenerConfigDAO.setListenerCertificateTRUSTED(alias, ListenerCertificate.Type.CLIENT);
                    break;
                }
                case REVOKED: {
                    this.listenerConfig.deleteClientCertificate(alias);
                    this.listenerConfigDAO.setListenerCertificateStatus(alias, ListenerCertificate.Type.CLIENT, ListenerCertificate.Status.REVOKED, revocationResult.reason);
                    break;
                }
                case TEMPORARILY_DISABLED: {
                    ListenerCertificate listenerCertificate = this.listenerConfigDAO.loadListenerCertificate(alias, ListenerCertificate.Type.CLIENT);
                    if (Duration.between(listenerCertificate.getLastSuccessfulCheck(), this.referenceDateTask.getReferenceOffsetDateTime()).toDays() >= 3L) {
                        this.logger.warn("Can't check RevocationState of CLIENT certificate {} since {} => remove it from Listener", (Object)alias, (Object)listenerCertificate.getLastSuccessfulCheck());
                        this.listenerConfig.deleteClientCertificate(alias);
                    }
                    this.listenerConfigDAO.setListenerCertificateStatus(alias, ListenerCertificate.Type.CLIENT, ListenerCertificate.Status.TEMPORARILY_DISABLED, CRLReason.UNSPECIFIED);
                }
            }
        }
        catch (InstallCertException | ListenerConfigException | NoSuchProviderException | CertificateException e) {
            this.logger.error(e.getMessage());
        }
    }

    private record RevocationResult(ListenerCertificate.Status status, CRLReason reason) {
        public RevocationResult(ListenerCertificate.Status status) {
            this(status, null);
        }

        public boolean isTrusted() {
            return this.status.equals((Object)ListenerCertificate.Status.TRUSTED);
        }
    }
}

