/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.listener;

import de.pontonconsulting.xmlpipe.adapter.activation.MimeTypeMapper;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.cpa.Agreement;
import de.pontonconsulting.xmlpipe.cpa.AgreementException;
import de.pontonconsulting.xmlpipe.cpa.AgreementNotFoundException;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.ProfileNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.listener.EbXmlData;
import de.pontonconsulting.xmlpipe.listener.EbXmlResponseException;
import de.pontonconsulting.xmlpipe.listener.ErrorNotificationResult;
import de.pontonconsulting.xmlpipe.listener.ErrorNotificationService;
import de.pontonconsulting.xmlpipe.listener.SoapProcessor;
import de.pontonconsulting.xmlpipe.listener.ebxml2.BaseEbXml2Service;
import de.pontonconsulting.xmlpipe.listener.ebxml2.EbXml2Data;
import de.pontonconsulting.xmlpipe.listener.ebxml2.EbXml2ServiceFactory;
import de.pontonconsulting.xmlpipe.listener.ebxml2.IEbXml2Service;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.message.XpMessageAttachment;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.archive.ArchiveProcessor;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.MessageExistsException;
import de.pontonconsulting.xmlpipe.messenger.database.tables.ConversationDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageWorkDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.packaging.AsyncSoapResponseSender;
import de.pontonconsulting.xmlpipe.messenger.packaging.EbXml20UIOptions;
import de.pontonconsulting.xmlpipe.soap.ebxml.AttachmentInfo;
import de.pontonconsulting.xmlpipe.soap.ebxml.EbXmlException;
import de.pontonconsulting.xmlpipe.soap.ebxml.EbXmlMessage;
import jakarta.mail.internet.ContentDisposition;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.MimeUtility;
import jakarta.mail.internet.ParseException;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Optional;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.FileSystemUtils;

public class EbXml2Processor
extends SoapProcessor {
    private static final String TRUE = "true";
    private static final String PAPINET_TEST_SERVICE = "Test";
    private static final String URI = "URI";
    private static final String EBXML_ACKNOWLEDGMENT = "Acknowledgment";
    private static final String EBXML_MESSAGE_ERROR = "MessageError";
    private static final String EBXML_PONG = "Pong";
    private static final String EBXML_STATUS_RESPONSE = "StatusResponse";
    private static final Logger _log = LogManager.getLogger((String)"Messenger.EbXml2Processor");
    private EbXmlMessage _incomingMessage;
    private CppPartner _sender;
    private CppPartner _receiver;
    private final EbXml2ServiceFactory _ebXml2ServiceFactory;
    private final MessageDAO _messageDAO;
    private final MessengerLog _messengerLog;
    private final ConversationDAO _conversationDAO;
    private final IFolders _folders;
    private final IdGenerator _idGenerator;
    private final ErrorNotificationService _errorNotificationService;
    private final AsyncSoapResponseSender asyncSoapResponseSender;
    private final EbXml20UIOptions _ebXml20UIOptions;
    private final MessengerConfig messengerConfig;
    private final MessageWorkDataDAO messageWorkDataDAO;

    public EbXml2Processor(Agreements agreements, Profiles profiles, ReferenceDateTask referenceDate, ArchiveProcessor archiveProcessor, EbXml2ServiceFactory ebXml2ServiceFactory, MessageDAO messageDAO, MessengerLog messengerLog, ConversationDAO conversationDAO, IFolders folders, IdGenerator idGenerator, ErrorNotificationService errorNotificationService, AsyncSoapResponseSender asyncSoapResponseSender, EbXml20UIOptions ebXml20UIOptions, MessengerConfig messengerConfig, MessageWorkDataDAO messageWorkDataDAO) {
        super(agreements, profiles, referenceDate, archiveProcessor);
        this._ebXml2ServiceFactory = ebXml2ServiceFactory;
        this._messageDAO = messageDAO;
        this._messengerLog = messengerLog;
        this._conversationDAO = conversationDAO;
        this._folders = folders;
        this._idGenerator = idGenerator;
        this._errorNotificationService = errorNotificationService;
        this.asyncSoapResponseSender = asyncSoapResponseSender;
        this._ebXml20UIOptions = ebXml20UIOptions;
        this.messengerConfig = messengerConfig;
        this.messageWorkDataDAO = messageWorkDataDAO;
    }

    @Override
    public SOAPMessage processMessage(SOAPMessage message, String protocol, Optional<Long> refDbId) throws SOAPException {
        EbXmlMessage ebXmlResponse = null;
        SOAPMessage response = null;
        try {
            this._incomingMessage = new EbXmlMessage(message, this._referenceDate);
        }
        catch (Exception e2) {
            _log.error((Object)e2);
            throw new SOAPException("Could not parse EbXml Message");
        }
        String action = this._incomingMessage.getAction();
        String service = this._incomingMessage.getService();
        String serviceType = this._incomingMessage.getServiceType();
        Date ttl = this._incomingMessage.getTimeToLive();
        _log.info("received EbXML2.0 Message (id:" + this._incomingMessage.getMessageId() + ")");
        _log.debug("request-action: " + action);
        _log.debug("request-service: " + service);
        _log.debug("request-servicetype: " + serviceType);
        _log.debug("ttl: " + String.valueOf(ttl));
        XpMessage xpMessage = this.createXpMessage(protocol);
        Optional.ofNullable(message.getMimeHeaders().getHeader("X-Remote-Address")).ifPresent(e -> {
            if (((String[])e).length > 0) {
                xpMessage.setProcessingDirective("X-RemoteAddress", message.getMimeHeaders().getHeader("X-Remote-Address")[0]);
            }
        });
        Optional.ofNullable(message.getMimeHeaders().getHeader("X-Forwarded-For")).ifPresent(e -> {
            if (((String[])e).length > 0) {
                xpMessage.setProcessingDirective("X-ForwardedFor", message.getMimeHeaders().getHeader("X-Forwarded-For")[0]);
            }
        });
        Optional.ofNullable(message.getMimeHeaders().getHeader("User-Agent")).ifPresent(e -> {
            if (((String[])e).length > 0) {
                xpMessage.setProcessingDirective("X-UserAgent", message.getMimeHeaders().getHeader("User-Agent")[0]);
            }
        });
        XpMessage xpResponse = new XpMessage();
        try {
            int messageStatus;
            MimeHeaders mimeHeaders = message.getMimeHeaders();
            String[] originalFilenames = mimeHeaders.getHeader("X-Original-Filename");
            if (originalFilenames != null && originalFilenames.length > 0) {
                String originalFilename = originalFilenames[0];
                String decoded = "";
                try {
                    decoded = MimeUtility.decodeText((String)originalFilename);
                }
                catch (UnsupportedEncodingException ex) {
                    _log.error("Problem while decoding: {}", (Object)ex.getMessage());
                    decoded = originalFilename;
                }
                xpMessage.setProcessingDirective("OriginalFilename", decoded);
            }
            this.setPartysFromUrls(this._incomingMessage, xpMessage);
            EbXml2Data data = new EbXml2Data(xpMessage);
            data.setInboundMessage(this._incomingMessage);
            data.setAction(action);
            data.setService(service);
            data.setServiceType(serviceType);
            boolean isNewMessage = this.registerMessage(xpMessage);
            if (isNewMessage) {
                messageStatus = 0;
            } else {
                messageStatus = this.getMessageStatus(this._incomingMessage.getMessageId());
                int direction = xpMessage.isInbound() ? 1 : 0;
                xpMessage.setDatabaseId(this._messageDAO.getMessageDataID(xpMessage.getMessageId(), direction));
                this.updateSequenceNumber(xpMessage);
                if (messageStatus == 4 || !this._incomingMessage.isDuplicateElmination() && (messageStatus == 3 || messageStatus == 2)) {
                    try {
                        boolean updated = this._messageDAO.updateMessageStatus(xpMessage.getDatabaseId(), messageStatus, 1);
                        if (!updated) {
                            messageStatus = this.getMessageStatus(this._incomingMessage.getMessageId());
                        }
                    }
                    catch (DbException e3) {
                        _log.fatal("Error while updating message status: {}", (Object)e3.getMessage());
                        throw new EbXmlException(30010, "Error", "DeliveryFailure", "Internal Database Problem.");
                    }
                }
            }
            if (messageStatus == 0 || messageStatus == 4) {
                int sequenceErrorCode = this.checkSequence(xpMessage);
                data.setSequenceErrorCode(sequenceErrorCode);
            }
            this.logReception(refDbId, xpMessage);
            this.checkToUri(this._incomingMessage.getToId(URI));
            this.checkFromUri(this._incomingMessage.getFromId(URI));
            if (messageStatus == 0 || messageStatus == 4) {
                ebXmlResponse = this.handleNewMessage(ebXmlResponse, action, service, serviceType, xpMessage, messageStatus, data);
            } else if (messageStatus == 2) {
                _log.warn("Ignored duplicate message. Message is currently in the inbound queue.");
                ebXmlResponse = this.handleDuplicateMessage(data);
            } else if (messageStatus == 3) {
                if (EBXML_ACKNOWLEDGMENT.equalsIgnoreCase(action)) {
                    _log.warn("Ignored duplicate Acknowledgment.");
                    this._messengerLog.log2db(106, xpMessage.getDatabaseId(), null);
                    this._messageDAO.updateMessageStatus(xpMessage.getDatabaseId(), xpMessage.getMessageId(), 3);
                } else if (this._incomingMessage.isDuplicateElmination()) {
                    _log.warn("Ignored duplicate message.");
                    this._messengerLog.log2db(106, xpMessage.getDatabaseId(), null);
                    ebXmlResponse = this.handleDuplicateMessage(data);
                } else {
                    ebXmlResponse = this.handleNewMessage(ebXmlResponse, action, service, serviceType, xpMessage, messageStatus, data);
                }
            } else {
                _log.info("Message received which is currently being processed:{} (status:{})", (Object)this._incomingMessage.getMessageId(), (Object)messageStatus);
            }
        }
        catch (EbXmlException ebXmlError) {
            ArrayList<ErrorNotificationResult> results = new ArrayList<ErrorNotificationResult>();
            results.add(new ErrorNotificationResult(ErrorNotificationResult.ErrorType.PACKAGING_ERROR, ebXmlError.getDescription()));
            this._errorNotificationService.notifyAdapter(xpMessage, results);
            this.recognizePayloadOnError(xpMessage);
            ebXmlResponse = this.createErrorResponseFromException(xpMessage, xpResponse, ebXmlError);
        }
        catch (Error r) {
            if (xpMessage.getDatabaseId() != -1L) {
                this.recognizePayloadOnError(xpMessage);
                try {
                    this._messageDAO.updateMessageAndStatus(xpMessage, 4);
                }
                catch (DbException dbException) {
                    // empty catch block
                }
            }
            throw r;
        }
        if (ebXmlResponse != null && (xpMessage.getSequenceNumber() == -1 || ebXmlResponse.getHighestSeverityOfError() != null)) {
            response = this.prepareResponse(ebXmlResponse, xpMessage, xpResponse);
        }
        return response;
    }

    private void recognizePayloadOnError(XpMessage xpMessage) {
        if (xpMessage.getAgreement() != null) {
            xpMessage.recognizePayload();
        }
    }

    private int checkSequence(XpMessage xpMessage) throws EbXmlException {
        int sequence = xpMessage.getSequenceNumber();
        try {
            if (sequence != -1) {
                boolean isDuplicated;
                long maxSequence;
                if (xpMessage.isSequenceReset() && sequence == 0 && !this._messageDAO.hasFirstMSG(xpMessage.getConversationDatabaseId(), xpMessage.getDatabaseId()) && (maxSequence = this._messageDAO.getMaxSequence(xpMessage.getConversationDatabaseId(), xpMessage.getDatabaseId())) >= 0L) {
                    long nextSequence = maxSequence + 1L;
                    long numberOfPredecessors = this._messageDAO.getNumberOfPredecessors(xpMessage.getConversationDatabaseId(), nextSequence);
                    if (nextSequence == numberOfPredecessors) {
                        this._conversationDAO.updateSequenceOffset(xpMessage.getConversationDatabaseId(), nextSequence);
                        this._messageDAO.updateSequenceNumber(xpMessage.getDatabaseId(), nextSequence);
                        xpMessage.setInternalSequenceNumber(nextSequence);
                    } else {
                        return 1;
                    }
                }
                if (isDuplicated = this._messageDAO.isSequenceDuplicated(xpMessage.getDatabaseId(), xpMessage.getInternalSequenceNumber(), xpMessage.getConversationDatabaseId(), 1)) {
                    return 2;
                }
            }
            return 0;
        }
        catch (DbException e) {
            _log.fatal("Error while checking sequence: {}", (Object)e.getMessage());
            throw new EbXmlException(30010, "Error", "DeliveryFailure", "Internal Database Problem.");
        }
    }

    private void setPartysFromUrls(EbXmlMessage incomingMessage, XpMessage xpMessage) {
        String toUrl = "unknown";
        String fromUrl = "unknown";
        String to = this._incomingMessage.getToId(URI);
        String from = this._incomingMessage.getFromId(URI);
        if (to != null && to.length() > 19) {
            toUrl = to.substring(0, 19);
        }
        if (from != null && from.length() > 19) {
            fromUrl = from.substring(0, 19);
        }
        xpMessage.setSenderLocalId(fromUrl);
        xpMessage.setReceiverLocalId(toUrl);
    }

    private void logReception(Optional<Long> refDbId, XpMessage xpMessage) {
        String logText = " ebXml 2.0 " + xpMessage.getProtocol();
        if (refDbId.isPresent()) {
            logText = logText + "(Sync Reply)";
        }
        this._messengerLog.log2db(60, xpMessage.getDatabaseId(), logText);
    }

    private EbXmlMessage handleNewMessage(EbXmlMessage ebXmlResponse, String action, String service, String serviceType, XpMessage xpMessage, int messageStatus, EbXml2Data data) throws EbXmlException {
        this.identifySender(data);
        this.identifyReceiver(data);
        this.identifyAgreement(data);
        this.checkService(service, serviceType);
        this.updateMessage(xpMessage);
        this._incomingMessage.validate();
        this.identifyAttachments(xpMessage);
        if (data.getSequenceErrorCode() == 1) {
            throw new EbXmlException(30047, "Error", "Unknown", "Sequence could not be reset.");
        }
        if (data.getSequenceErrorCode() == 2) {
            throw new EbXmlException(30048, "Error", "Unknown", "Using of duplicate sequence numbers is not allowed.");
        }
        IEbXml2Service serviceObject = this._ebXml2ServiceFactory.findService(service, serviceType, action);
        File workFolder = new File(this._folders.getWorkInboundFolder(), String.valueOf(xpMessage.getDatabaseId()));
        if (workFolder.exists()) {
            File[] oldFile = workFolder.listFiles();
            for (int i = 0; i < oldFile.length; ++i) {
                oldFile[i].delete();
            }
            oldFile = workFolder.listFiles();
            if (oldFile != null && oldFile.length != 0) {
                _log.error("one or more files could not be deleted from workfolder {}", (Object)workFolder);
                throw new EbXmlException(30008, new String[]{service}, "Error", "DeliveryFailure", "Could not store xml data");
            }
        }
        this.storeMessageParts(workFolder, data, xpMessage.getDatabaseId());
        this.addAttachmentsToXpMessage(data);
        if (serviceObject == null) {
            throw new EbXmlException(30008, new String[]{service}, "Error", "ValueNotRecognized", "Unknown Service:" + service);
        }
        ebXmlResponse = serviceObject.handleMessage(messageStatus, data);
        return ebXmlResponse;
    }

    private EbXmlMessage handleDuplicateMessage(EbXml2Data data) {
        EbXmlMessage ebXmlResponse = null;
        _log.info("Message received is a duplicate that was already successfully received:{}", (Object)this._incomingMessage.getMessageId());
        if (this._incomingMessage.isAckRequested()) {
            try {
                this.identifySender(data);
                this.identifyReceiver(data);
                this.identifyAgreement(data);
                BaseEbXml2Service base = (BaseEbXml2Service)this._ebXml2ServiceFactory.findService("urn:oasis:names:tc:ebxml-msg:service", "", "");
                ebXmlResponse = base.createOkAck(data);
            }
            catch (EbXmlException ebXmlError) {
                _log.error("Acknowledgement could not be created because EbXmlError was found: {}", (Object)ebXmlError.getDescription());
                this._messengerLog.log2db(527, data.getXpMessage().getDatabaseId(), "EbXML Error: " + ebXmlError.getDescription());
            }
        }
        return ebXmlResponse;
    }

    private EbXmlMessage createErrorResponseFromException(XpMessage xpMessage, XpMessage xpResponse, EbXmlException ebXmlError) throws SOAPException {
        if (xpMessage.getDatabaseId() != -1L) {
            this.updateMessage(xpMessage);
            this._messengerLog.log2db(527, xpMessage.getDatabaseId(), "EbXML Error: " + ebXmlError.getDescription());
            this._messageDAO.updateMessageStatus(xpMessage.getDatabaseId(), xpMessage.getMessageId(), 4);
        }
        _log.fatal("EbXmlError was found:{}", (Object)ebXmlError.getDescription());
        SOAPMessage msg = MessageFactory.newInstance().createMessage();
        msg.setProperty("javax.xml.soap.write-xml-declaration", (Object)TRUE);
        msg.setProperty("javax.xml.soap.character-set-encoding", (Object)"UTF-8");
        EbXmlMessage ebXmlResponse = new EbXmlMessage(msg, this._referenceDate);
        ebXmlResponse.prepareErrorMessage(this._incomingMessage.getMessageId());
        ebXmlResponse.setCPAId(this._incomingMessage.getCPAId());
        ebXmlResponse.setConversationId(this._incomingMessage.getConversationId());
        ebXmlResponse.setFromIds(this._incomingMessage.getToIds());
        ebXmlResponse.setToIds(this._incomingMessage.getFromIds());
        ebXmlResponse.setMessageId(this._idGenerator.generateMessageId());
        ebXmlResponse.setMessageTimestamp(this._referenceDate.getReferenceDate());
        ebXmlResponse.addError(ebXmlError.getSeverity(), ebXmlError.getCode(), null);
        ebXmlResponse.setDescriptionToCurrentError(ebXmlError.getDescription(), "en");
        xpResponse.setMessageId(ebXmlResponse.getMessageId());
        xpResponse.setInboundMessage(false);
        xpResponse.setConversationId(ebXmlResponse.getConversationId());
        if (this._sender != null) {
            xpResponse.setReceiverLocalId(this._sender.getLocalId());
        }
        if (this._receiver != null) {
            xpResponse.setSenderLocalId(this._receiver.getLocalId());
        }
        return ebXmlResponse;
    }

    private SOAPMessage prepareResponse(EbXmlMessage ebXmlResponse, XpMessage xpMessage, XpMessage xpResponse) throws SOAPException {
        SOAPMessage response = ebXmlResponse.getMessage();
        String destinationURL = null;
        xpResponse.setMessengerId(this.messengerConfig.getMessengerId());
        xpResponse.setMessageId(ebXmlResponse.getMessageId());
        xpResponse.setMessageTimestamp(ebXmlResponse.getMessageTimestamp());
        xpResponse.setPackaged(true);
        xpResponse.setMessagePackaging("EbXml20");
        xpResponse.setProtocol(xpMessage.getProtocol());
        xpResponse.setReferenceId(xpMessage.getMessageId());
        xpResponse.setInboundMessage(false);
        xpResponse.setConversationId(ebXmlResponse.getConversationId());
        xpResponse.setTimeToLive(ebXmlResponse.getTimeToLive());
        if (this._sender != null) {
            xpResponse.setReceiverLocalId(this._sender.getLocalId());
        }
        if (this._receiver != null) {
            xpResponse.setSenderLocalId(this._receiver.getLocalId());
        }
        if (EBXML_ACKNOWLEDGMENT.equalsIgnoreCase(ebXmlResponse.getAction()) || EBXML_MESSAGE_ERROR.equalsIgnoreCase(ebXmlResponse.getAction())) {
            xpResponse.setMessageType("ACK");
        } else if (EBXML_PONG.equalsIgnoreCase(ebXmlResponse.getAction())) {
            xpResponse.setMessageType("PONG");
        } else if (EBXML_STATUS_RESPONSE.equalsIgnoreCase(ebXmlResponse.getAction())) {
            xpResponse.setMessageType(EBXML_STATUS_RESPONSE);
        } else {
            xpResponse.setMessageType(ebXmlResponse.getAction());
        }
        xpResponse.setSchemaSet("ponton");
        xpResponse.setMessageVersion("2.1");
        try {
            boolean receivedViaFtp;
            this._messageDAO.registerMessage(xpResponse);
            if (EBXML_PONG.equalsIgnoreCase(ebXmlResponse.getAction())) {
                this.finalizePingHandling(xpMessage);
            }
            if (EBXML_STATUS_RESPONSE.equalsIgnoreCase(ebXmlResponse.getAction())) {
                this.finalizeStatusRequestHandling(xpMessage);
            }
            this.storeResponse(new File(this._folders.getWorkOutboundFolder(), String.valueOf(xpResponse.getDatabaseId())), ebXmlResponse, xpResponse.getDatabaseId());
            Communication responseSettings = null;
            try {
                responseSettings = xpMessage.getAgreement().getCommunication(xpMessage.getReceiverLocalId(), xpMessage.getSenderLocalId());
                xpResponse.setAgreement(xpMessage.getAgreement());
                xpResponse.setOwnPartner(xpMessage.getOwnPartner());
                xpResponse.setCommunicationPartner(xpMessage.getCommunicationPartner());
                xpResponse.setCommunication(responseSettings);
                destinationURL = responseSettings.getTransportURL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Date ttlDate = ebXmlResponse.getTimeToLive();
            int retryInterval = 10000;
            long ttl1 = 0L;
            if (ttlDate == null) {
                _log.debug("no ttl set in response, using current time as reference.");
                ttlDate = this._referenceDate.getReferenceDate();
                ttl1 = ttlDate.getTime() + 60000L;
            } else {
                ttl1 = ttlDate.getTime();
            }
            this.updateMessage(xpResponse);
            if (EBXML_MESSAGE_ERROR.equalsIgnoreCase(ebXmlResponse.getAction())) {
                this._messengerLog.log2dbWithHref(7, xpMessage.getDatabaseId(), xpResponse.getMessageId(), xpResponse.getMessageId(), xpResponse.getDatabaseId(), false);
            } else if (EBXML_ACKNOWLEDGMENT.equalsIgnoreCase(ebXmlResponse.getAction()) || EBXML_PONG.equalsIgnoreCase(ebXmlResponse.getAction())) {
                this._messengerLog.log2dbWithHref(2, xpMessage.getDatabaseId(), xpResponse.getMessageId(), xpResponse.getMessageId(), xpResponse.getDatabaseId(), false);
            } else if (EBXML_STATUS_RESPONSE.equalsIgnoreCase(ebXmlResponse.getAction())) {
                this._messengerLog.log2dbWithHref(97, xpResponse.getDatabaseId(), xpMessage.getMessageId(), xpMessage.getMessageId(), xpMessage.getDatabaseId(), true);
                this._messengerLog.log2dbWithHref(97, xpMessage.getDatabaseId(), xpResponse.getMessageId(), xpResponse.getMessageId(), xpResponse.getDatabaseId(), false);
                String status = ebXmlResponse.getMessageStatus();
                if ("Processed".equals(status) || "Received".equals(status)) {
                    String refMessageId = ebXmlResponse.getStatusResponseMSGReference();
                    long refMessageDataId = this._messageDAO.getReferenceMessageDataID(refMessageId, 1);
                    this._messengerLog.log2dbWithHref(97, refMessageDataId, xpResponse.getMessageId(), xpResponse.getMessageId(), xpResponse.getDatabaseId(), false);
                }
            }
            if (ebXmlResponse.isAckRequested()) {
                xpResponse.setAckRequested(true);
            } else {
                long timest = ebXmlResponse.getMessageTimestamp().getTime();
                long diff = ttl1 - timest;
                retryInterval = (int)(diff / 1000L);
                _log.debug("ttl {}", (Object)ttlDate);
                _log.debug("timestamp {}", (Object)ebXmlResponse.getMessageTimestamp());
                _log.debug("interval set to {} seconds", (Object)retryInterval);
            }
            File messageFolder = new File(this._folders.getWorkOutboundFolder(), String.valueOf(xpResponse.getDatabaseId()));
            xpResponse.setCurrentContentReferenceFolder(messageFolder);
            this._messengerLog.log2db(79, xpResponse.getDatabaseId(), "EbXml20");
            if (ebXmlResponse.isSigned()) {
                this._messengerLog.log2db(73, xpResponse.getDatabaseId(), null);
            }
            boolean bl = receivedViaFtp = xpMessage.getProtocol().equals("FTP") || xpMessage.getProtocol().equals("FTPS");
            if (!receivedViaFtp && this._incomingMessage.isSyncReplyRequested() || this._sender == null || this._receiver == null || responseSettings == null || destinationURL == null) {
                _log.debug("preparing Sync response");
                this._messengerLog.log2db(1, xpResponse.getDatabaseId(), "Sync Response");
                this.messageWorkDataDAO.uploadDirectoryToDB(xpResponse.getDatabaseId(), xpResponse.getCurrentContentReferenceFolder());
                FileSystemUtils.deleteRecursively((File)xpResponse.getCurrentContentReferenceFolder());
                this._archiveProcessor.sendFilesToArchive(xpResponse.getDatabaseId(), false);
                this._messengerLog.log2dbWithHref(104, xpResponse.getDatabaseId(), "For message: " + xpMessage.getMessageId(), xpMessage.getMessageId(), xpMessage.getDatabaseId(), true);
                this._messageDAO.updateMessageStatus(xpResponse.getDatabaseId(), xpResponse.getMessageId(), 3);
            } else {
                this.sendAsyncResponse(ebXmlResponse, destinationURL, xpResponse);
                response = null;
            }
        }
        catch (DbException e1) {
            _log.error("could not register ebxml response message {} in database: {}", (Object)xpResponse.getMessageId(), (Object)e1.getMessage());
            if (!this._incomingMessage.isSyncReplyRequested()) {
                response = null;
            }
        }
        catch (EbXmlResponseException e) {
            this._messengerLog.log2db(522, xpMessage.getDatabaseId(), "ACK could not be created: " + e.getMessage());
            this._messengerLog.log2db(522, xpResponse.getDatabaseId(), "ACK could not be created: " + e.getMessage());
            this._messageDAO.updateMessageStatus(xpResponse.getDatabaseId(), xpResponse.getMessageId(), 4);
            _log.error("Ebxml response for {} could not be created: {}", (Object)xpMessage.getMessageId(), (Object)e.getMessage());
            response = null;
        }
        return response;
    }

    private void finalizePingHandling(XpMessage xpMessage) {
        this._messengerLog.log2db(101, xpMessage.getDatabaseId(), null);
        this._messageDAO.updateMessageFolder(xpMessage.getDatabaseId(), xpMessage.getCurrentContentReferenceFolder());
        try {
            this.messageWorkDataDAO.uploadDirectoryToDB(xpMessage.getDatabaseId(), xpMessage.getCurrentContentReferenceFolder());
            FileSystemUtils.deleteRecursively((File)xpMessage.getCurrentContentReferenceFolder());
        }
        catch (DbException e) {
            _log.error("Couldn't upload message folder for {} to database: {}", (Object)xpMessage.getDatabaseId(), (Object)e.getMessage());
        }
        this._archiveProcessor.sendFilesToArchive(xpMessage.getDatabaseId(), false);
        try {
            this._messageDAO.updateMessageAndStatus(xpMessage, 3);
        }
        catch (DbException e) {
            _log.warn("Status of Ping message couldn't be updated. {}", (Object)e.getMessage());
        }
    }

    private void finalizeStatusRequestHandling(XpMessage xpMessage) {
        this._messengerLog.log2db(101, xpMessage.getDatabaseId(), null);
        this._messageDAO.updateMessageFolder(xpMessage.getDatabaseId(), xpMessage.getCurrentContentReferenceFolder());
        try {
            this.messageWorkDataDAO.uploadDirectoryToDB(xpMessage.getDatabaseId(), xpMessage.getCurrentContentReferenceFolder());
            FileSystemUtils.deleteRecursively((File)xpMessage.getCurrentContentReferenceFolder());
        }
        catch (DbException e) {
            _log.error("Couldn't upload message folder for {} to database: {}", (Object)xpMessage.getDatabaseId(), (Object)e.getMessage());
        }
        this._archiveProcessor.sendFilesToArchive(xpMessage.getDatabaseId(), false);
        try {
            this._messageDAO.updateMessageAndStatus(xpMessage, 3);
        }
        catch (DbException e) {
            _log.warn("Status of StatusRequest message couldn't be updated. {}", (Object)e.getMessage());
        }
    }

    private void identifyAttachments(XpMessage xpMessage) {
        String payloadRole = null;
        String signatureRole = null;
        try {
            payloadRole = xpMessage.getCommunication().getPackagingOptionValue("/AttachmentRolePayload");
        }
        catch (OptionNotFoundException e) {
            payloadRole = this._ebXml20UIOptions.getDefaultAttachmentRolePayload();
        }
        try {
            signatureRole = xpMessage.getCommunication().getPackagingOptionValue("/AttachmentRoleSignature");
        }
        catch (OptionNotFoundException e) {
            signatureRole = this._ebXml20UIOptions.getDefaultAttachmentRoleSignature();
        }
        this._incomingMessage.identifyAttachments(payloadRole, signatureRole);
    }

    private void addAttachmentsToXpMessage(EbXml2Data data) {
        XpMessage xpMessage = data.getXpMessage();
        AttachmentInfo[] validAttachments = data.getAttachments();
        if (validAttachments == null) {
            _log.debug("no attachments found");
            return;
        }
        for (int i = 0; i < validAttachments.length; ++i) {
            boolean schemaLocationsDefined;
            AttachmentInfo attachmentInfo = validAttachments[i];
            boolean bl = schemaLocationsDefined = attachmentInfo.getSchemaLocations().length > 0;
            if (attachmentInfo.isPayload()) {
                xpMessage.setCurrentContentReference(attachmentInfo.getLocalFile());
                String contentType = attachmentInfo.getContentType();
                if (contentType != null) {
                    try {
                        ContentType cType = new ContentType(contentType);
                        if (!cType.getPrimaryType().equalsIgnoreCase("multipart")) {
                            contentType = cType.getBaseType();
                        }
                    }
                    catch (ParseException cType) {
                        // empty catch block
                    }
                }
                if (contentType == null) {
                    contentType = MimeTypeMapper.getMimeType((String)attachmentInfo.getLocalFile().getName());
                }
                xpMessage.setCurrentContentType(contentType);
                if (schemaLocationsDefined) {
                    String schemaLocation = attachmentInfo.getSchemaLocations()[0];
                    _log.info("Found schema location in the SOAP Envelope: {}.", (Object)schemaLocation);
                    if ("BINARY".equals(schemaLocation)) {
                        _log.info("Ignored schemaLocation '{}'.", (Object)"BINARY");
                    } else {
                        xpMessage.setSchemaLocation(schemaLocation);
                    }
                }
                ContentDisposition contentDisposition = attachmentInfo.getContentDisposition();
                String processedOriginalFilename = null;
                if (contentDisposition == null) {
                    processedOriginalFilename = attachmentInfo.getContentId().replace("<", "").replace(">", "");
                } else {
                    processedOriginalFilename = contentDisposition.getParameter("filename");
                    if (StringUtils.isNotBlank((CharSequence)processedOriginalFilename)) {
                        try {
                            processedOriginalFilename = MimeUtility.decodeText((String)processedOriginalFilename.trim());
                        }
                        catch (UnsupportedEncodingException ex) {
                            _log.error(ex.getMessage());
                            processedOriginalFilename = processedOriginalFilename.trim();
                        }
                    }
                }
                xpMessage.setProcessingDirective("ProcessedOriginalFilename", processedOriginalFilename);
                if (!_log.isTraceEnabled()) continue;
                _log.trace("Set processing directive ProcessedOriginalFilename to {}", (Object)processedOriginalFilename);
                continue;
            }
            if (attachmentInfo.isSignature()) {
                xpMessage.setSignatureReference(attachmentInfo.getLocalFile());
                _log.debug("business document signature found:{}", (Object)attachmentInfo.getLocalFile().getName());
                continue;
            }
            xpMessage.addAttachment(new XpMessageAttachment(attachmentInfo.getLocalFile(), attachmentInfo.getContentType()));
            _log.debug("other attachment found:{}", (Object)attachmentInfo.getLocalFile().getName());
        }
    }

    private void sendAsyncResponse(EbXmlMessage ebXmlResponse, String destinationURL, XpMessage xpMessage1) throws SOAPException {
        _log.debug("preparing Async response");
        SOAPMessage response = ebXmlResponse.getMessage();
        File work = new File(this._folders.getWorkOutboundFolder(), String.valueOf(xpMessage1.getDatabaseId()));
        work.mkdirs();
        xpMessage1.setCurrentContentReferenceFolder(work);
        this.asyncSoapResponseSender.addToOutboundQueue(response, xpMessage1);
    }

    void identifyAgreement(EbXmlData data) throws EbXmlException {
        try {
            Agreement agreement = this._agreements.getAgreement(data.getReceiver().getLocalId(), data.getSender().getLocalId(), true);
            data.getXpMessage().setAgreement(agreement);
            data.getXpMessage().setOwnPartner(this._profiles.getProfileForLocalId(agreement.getOwnPartner().getId(), true));
            data.getXpMessage().setCommunicationPartner(this._profiles.getProfileForLocalId(agreement.getCommunicationPartner().getId(), true));
            Communication communication = agreement.getCommunication(data.getSender().getLocalId(), data.getReceiver().getLocalId());
            if (!"EbXml20".equals(communication.getPackagingId())) {
                _log.error("Agreement supports {} and not EbXml20.", (Object)communication.getPackagingId());
                throw new EbXmlException(30013, new String[0], "Error", "Inconsistent", "Agreement supports only " + communication.getPackagingId() + ".");
            }
            data.getXpMessage().setCommunication(communication);
            data.getXpMessage().setAdapterId(data.getXpMessage().getAgreement().getDefaultAdapterId());
        }
        catch (AgreementNotFoundException e) {
            _log.error("Agreement is not found on the System: {}", (Object)e.getMessage());
            throw new EbXmlException(30013, new String[0], "Error", "Inconsistent", "Agreement is not found.");
        }
        catch (AgreementException e) {
            _log.error("Communication is not defined in Agreement: {}", (Object)e.getMessage());
            throw new EbXmlException(30013, new String[0], "Error", "Inconsistent", "Agreement is incomplete.");
        }
        catch (ProfileException e) {
            _log.error("Profile is not found on the System: {}", (Object)e.getMessage());
            throw new EbXmlException(30013, new String[0], "Error", "Inconsistent", "Profile is not found.");
        }
    }

    private void checkToUri(String to) throws EbXmlException {
        if (to != null) {
            try {
                new URI(to);
            }
            catch (URISyntaxException e1) {
                throw new EbXmlException(30008, new String[]{to}, "Error", "Inconsistent", "To PartyId is not a valid URI");
            }
        }
    }

    private void checkFromUri(String from) throws EbXmlException {
        if (from != null) {
            try {
                new URI(from);
            }
            catch (URISyntaxException e1) {
                throw new EbXmlException(30008, new String[]{from}, "Error", "Inconsistent", "From PartyId is not a valid URI");
            }
        }
    }

    private void checkService(String service, String serviceType) throws EbXmlException {
        if (URI.equals(serviceType)) {
            try {
                new URI(service);
            }
            catch (URISyntaxException e1) {
                throw new EbXmlException(30008, new String[]{service}, "Error", "Inconsistent", "Service is not a valid URI");
            }
        }
    }

    private void updateMessage(XpMessage xpMessage) {
        try {
            this._messageDAO.updateMessage(xpMessage);
        }
        catch (DbException e) {
            _log.fatal("Error while updating Message: {}", (Object)e.getMessage());
        }
    }

    private boolean registerMessage(XpMessage xpMessage) throws EbXmlException {
        try {
            this._messageDAO.registerMessage(xpMessage);
            _log.info("registered new message {}", (Object)xpMessage.getMessageId());
            return true;
        }
        catch (MessageExistsException e) {
            return false;
        }
        catch (DbException e) {
            _log.fatal("Error while registering Message: {}", (Object)e.getMessage());
            throw new EbXmlException(30010, "Error", "DeliveryFailure", "Internal Database Problem.");
        }
    }

    private void updateSequenceNumber(XpMessage xpMessage) throws EbXmlException {
        try {
            this._messageDAO.updateSequenceInfo(xpMessage);
        }
        catch (DbException e) {
            _log.fatal("Error while registering Message: {}", (Object)e.getMessage());
            throw new EbXmlException(30010, "Error", "DeliveryFailure", "Internal Database Problem.");
        }
    }

    private void identifyReceiver(EbXmlData data) throws EbXmlException {
        try {
            this._receiver = this._profiles.getProfileForPartyIds(this._incomingMessage.getToIds(), true);
            data.setReceiver(this._receiver);
            if (this._receiver.isRemote()) {
                _log.fatal("Receiver is a remote partner. Reception denied. localId={}", (Object)this._receiver.getLocalId());
                throw new EbXmlException(30011, "Error", "DeliveryFailure", "Receiver is a remote partner by the System");
            }
            if (this._receiver.isDisabled()) {
                _log.fatal("Receiver is disabled. Reception denied. localId={}", (Object)this._receiver.getLocalId());
                throw new EbXmlException(30011, "Error", "DeliveryFailure", "Receiver is blocked by the System");
            }
        }
        catch (ProfileNotFoundException e) {
            _log.error("Receiver is not known to the System. {}{}", (Object)e.getMessage(), this._incomingMessage.getToIds());
            throw new EbXmlException(30013, new String[]{String.valueOf(this._incomingMessage.getToIds())}, "Error", "Inconsistent", "Receiver is not known to the System:" + String.valueOf(this._incomingMessage.getToIds()));
        }
        catch (ProfileException e) {
            _log.fatal("Could not access Receiver information from local data: {}", (Object)e.getMessage());
            throw new EbXmlException(30014, "Error", "DeliveryFailure", "Receiver Profile could not be accessed");
        }
    }

    private void identifySender(EbXmlData data) throws EbXmlException {
        try {
            this._sender = this._profiles.getProfileForPartyIds(this._incomingMessage.getFromIds(), true);
            data.setSender(this._sender);
            if (this._sender.isDisabled()) {
                _log.fatal("Sender is disabled. Reception denied. localId={}", (Object)this._sender.getLocalId());
                throw new EbXmlException(30015, "Error", "DeliveryFailure", "Sender is blocked by the System");
            }
        }
        catch (ProfileNotFoundException e) {
            _log.fatal("Sender is not known to the System. {}{}", (Object)e.getMessage(), this._incomingMessage.getFromIds());
            throw new EbXmlException(30016, new String[]{String.valueOf(this._incomingMessage.getFromIds())}, "Error", "Inconsistent", "Sender is not known to the System: " + String.valueOf(this._incomingMessage.getFromIds()));
        }
        catch (ProfileException e) {
            _log.fatal("Could not access Sender information from local data: {}", (Object)e.getMessage());
            throw new EbXmlException(30017, "Error", "DeliveryFailure", "Sender Profile could not be accessed");
        }
    }

    private int getMessageStatus(String messageId) throws EbXmlException {
        int messageStatus;
        try {
            messageStatus = this._messageDAO.getStatusOfMessage(messageId, 1);
        }
        catch (DbException e) {
            _log.error("Could not get status of existing message: {}", (Object)this._incomingMessage.getMessageId(), (Object)e);
            throw new EbXmlException(30018, new String[]{messageId}, "Error", "Unknown", "Internal Error: " + messageId);
        }
        return messageStatus;
    }

    private XpMessage createXpMessage(String protocol) {
        XpMessage xpMessage = new XpMessage();
        xpMessage.setMessageId(this._incomingMessage.getMessageId());
        xpMessage.setConversationId(this._incomingMessage.getConversationId());
        int seqNumber = this._incomingMessage.getSequenceNumber();
        if (seqNumber > -1) {
            xpMessage.setSequenceNumber(seqNumber);
            xpMessage.setSequenceReset(this._incomingMessage.isSequenceReset());
        }
        xpMessage.setReferenceId(this._incomingMessage.getRefToMessageId());
        xpMessage.setProcessingDirectives(this._incomingMessage.getProcessingDirectives());
        xpMessage.setTimeToLive(this._incomingMessage.getTimeToLive());
        xpMessage.setSignedAckRequested(this._incomingMessage.isSignedAckRequested());
        xpMessage.setMessagePackaging("EbXml20");
        xpMessage.setSyncReplyRequested(this._incomingMessage.isSyncReplyRequested());
        xpMessage.setAckRequested(this._incomingMessage.isAckRequested());
        xpMessage.setInboundMessage(true);
        xpMessage.setProtocol(protocol);
        xpMessage.setProcessingDirective("service", this._incomingMessage.getService());
        if (this._incomingMessage.getServiceType() != null) {
            xpMessage.setProcessingDirective("servicetype", this._incomingMessage.getServiceType());
        }
        xpMessage.setProcessingDirective("action", this._incomingMessage.getAction());
        xpMessage.setMessageTimestamp(this._incomingMessage.getMessageTimestamp());
        xpMessage.setMessengerId(this.messengerConfig.getMessengerId());
        String flag = xpMessage.getProcessingDirective("TestFlag");
        if (TRUE.equalsIgnoreCase(flag)) {
            xpMessage.setTestMessage(true);
        }
        if (flag == null && PAPINET_TEST_SERVICE.equalsIgnoreCase(this._incomingMessage.getService())) {
            xpMessage.setTestMessage(true);
        }
        return xpMessage;
    }

    private void storeResponse(File folder, EbXmlMessage message, long databaseId) throws EbXmlResponseException {
        try {
            folder.mkdirs();
            _log.debug("storing ebxml response");
            message.saveEbXmlToDisk(folder);
            this._messageDAO.updateMessageFolder(databaseId, folder);
        }
        catch (Exception e) {
            _log.error("problem while storing ebxml response to disk: " + String.valueOf(e));
            throw new EbXmlResponseException(e.toString());
        }
    }

    private void storeMessageParts(File folder, EbXml2Data data, long messageDataID) throws EbXmlException {
        this._messageDAO.updateMessageFolder(messageDataID, folder);
        try {
            if (this._incomingMessage.hasAttachments()) {
                _log.debug("storing attachments and payload");
                this._incomingMessage.saveAttachmentsToDisk(folder);
                AttachmentInfo[] validAttachments = this._incomingMessage.getAttachmentInfo();
                data.setAttachments(validAttachments);
            }
            _log.debug("storing ebxml header");
            this._incomingMessage.saveEbXmlToDisk(folder);
        }
        catch (Exception e) {
            _log.error("problem while storing xml to disk: {}", (Object)e.getMessage());
            this._messageDAO.updateMessageStatus(messageDataID, data.getXpMessage().getMessageId(), 4);
            this._messengerLog.log2db(527, messageDataID, "Could not store message in filesystem: " + String.valueOf(e));
            throw new EbXmlException(30019, "Error", "Unknown", "Internal Storage Problem.");
        }
    }
}

