/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.listener;

import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.cpa.Agreement;
import de.pontonconsulting.xmlpipe.cpa.AgreementException;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.jaxb.as4.Error;
import de.pontonconsulting.xmlpipe.jaxb.as4.MessageInfo;
import de.pontonconsulting.xmlpipe.jaxb.as4.SignalMessage;
import de.pontonconsulting.xmlpipe.listener.AS4Exception;
import de.pontonconsulting.xmlpipe.listener.AS4ProcessorHelper;
import de.pontonconsulting.xmlpipe.listener.IAS4SignalProcessorCallback;
import de.pontonconsulting.xmlpipe.message.XpAcknowledgment;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.packaging.AS4Error;
import jakarta.xml.bind.JAXBException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.Assert;

public class AS4SignalProcessor {
    private static final Logger _log = LogManager.getLogger((String)"Messenger.AS4SignalProcessor");
    private final Agreements _agreements;
    private final Profiles _profiles;
    private final IFolders _folders;
    private final MessageDAO _messageDAO;
    private final MessengerLog _messengerLog;
    private final MessengerConfig messengerConfig;

    public AS4SignalProcessor(Agreements agreements, Profiles profiles, IFolders folders, MessageDAO messageDAO, MessengerLog messengerLog, MessengerConfig messengerConfig) {
        this._agreements = agreements;
        this._folders = folders;
        this._messageDAO = messageDAO;
        this._messengerLog = messengerLog;
        this._profiles = profiles;
        this.messengerConfig = messengerConfig;
    }

    public SOAPMessage processSignals(SOAPMessage originalMessage, List<SignalMessage> signalMessages, IAS4SignalProcessorCallback callback, Optional<Long> refDbId) {
        SOAPMessage response = null;
        if (signalMessages == null) {
            return null;
        }
        if (signalMessages.isEmpty()) {
            return null;
        }
        XpMessage xpMessage = null;
        for (SignalMessage signal : signalMessages) {
            try {
                de.pontonconsulting.xmlpipe.messenger.database.MessageInfo referenceMessage;
                xpMessage = this.createXpMessage(signal, callback, refDbId);
                if (xpMessage == null) continue;
                try {
                    this._messageDAO.registerOrUpdateMessage(xpMessage);
                }
                catch (DbException ex) {
                    _log.error(xpMessage.getMessageId(), (Object)ex.getMessage(), (Object)ex);
                    throw new AS4Exception(AS4Error.EBMS_0003, "Could not register acknowledgment.", ex);
                }
                if (xpMessage.getReferenceDatabaseId() > -1L && (referenceMessage = this._messageDAO.getMessageInfo(xpMessage.getReferenceDatabaseId())) != null && "PING".equals(referenceMessage.getMessageType())) {
                    xpMessage.setSchemaSet("ponton");
                    xpMessage.setMessageType("PONG");
                    xpMessage.setMessageVersion("2.1");
                    this._messageDAO.updateMessage(xpMessage);
                }
                File contentFolder = new File(xpMessage.isInbound() ? this._folders.getWorkInboundFolder() : this._folders.getWorkOutboundFolder(), String.valueOf(xpMessage.getDatabaseId()));
                FileUtils.forceMkdir((File)contentFolder);
                xpMessage.setCurrentContentReferenceFolder(contentFolder);
                this._messageDAO.updateMessageFolder(xpMessage.getDatabaseId(), xpMessage.getCurrentContentReferenceFolder());
                callback.createXpAcknowledgment(signal, xpMessage);
                response = callback.signMessage(originalMessage, signal, xpMessage);
                response = callback.handleSignal(response, signal, xpMessage);
            }
            catch (Exception ex) {
                _log.error(ex.toString());
                if (xpMessage != null) {
                    this._messageDAO.updateMessageStatus(xpMessage.getDatabaseId(), xpMessage.getMessageId(), 4);
                    this._messengerLog.log2db(527, xpMessage.getDatabaseId(), ex.getMessage());
                    if (xpMessage.getReferenceDatabaseId() > -1L) {
                        this._messengerLog.log2dbWithHref(215, xpMessage.getReferenceDatabaseId(), xpMessage.getMessageId(), xpMessage.getMessageId(), xpMessage.getDatabaseId(), xpMessage.isInbound());
                    }
                    xpMessage = null;
                    continue;
                }
                try (ByteArrayOutputStream originalMessageStream = new ByteArrayOutputStream();){
                    originalMessage.writeTo((OutputStream)originalMessageStream);
                    _log.error(originalMessageStream.toString());
                }
                catch (IOException | SOAPException e) {
                    _log.error("could not log original message: {}", (Object)e.getMessage());
                }
            }
        }
        return response;
    }

    public XpAcknowledgment createXpAcknowledgment(SignalMessage signal, XpMessage xpMessage) {
        try {
            XpAcknowledgment ack = new XpAcknowledgment(xpMessage, xpMessage.getReferenceId(), xpMessage.getRegistrationTimestamp(), xpMessage.getMessageTimestamp());
            if (signal.getReceipt() != null) {
                if ("PONG".equals(xpMessage.getMessageType())) {
                    ack.setOverallResult("Pong");
                    ack.addError("Success", "Pong Message");
                } else {
                    ack.setOverallResult("Success");
                    ack.addError("Success", "Message was successfully received");
                }
            } else {
                List errorList = signal.getError();
                for (Error error : errorList) {
                    ack.setOverallResult("Error");
                    String description = this.getDescriptionFromError(error);
                    ack.addError("Error", error.getErrorCode() + ": " + description);
                }
            }
            return ack;
        }
        catch (JAXBException e) {
            _log.debug("could not store Xp-ACK... stop further processing now:{}", (Object)e.getMessage());
        }
        catch (Exception e) {
            _log.fatal("Acknowledgment could not be processed: {}", (Object)e.getMessage());
        }
        return null;
    }

    private String getDescriptionFromError(Error error) {
        if (error.getErrorDetail() != null) {
            return error.getErrorDetail();
        }
        if (error.getDescription() != null) {
            return error.getDescription().getValue();
        }
        if (error.getShortDescription() != null) {
            return error.getShortDescription();
        }
        return "no details provided";
    }

    public boolean isErrorSignal(SignalMessage signal) {
        if (signal.getError() == null) {
            return false;
        }
        return !signal.getError().isEmpty();
    }

    public XpMessage createXpMessage(SignalMessage signal, IAS4SignalProcessorCallback callback, Optional<Long> refDbId) throws DbException {
        MessageInfo messageInfo = signal.getMessageInfo();
        de.pontonconsulting.xmlpipe.messenger.database.MessageInfo reference = null;
        try {
            this.checkMessageInfo(messageInfo);
            reference = this._messageDAO.getMessageInfo(messageInfo.getRefToMessageId(), callback.isInbound() ? 0 : 1);
        }
        catch (IllegalArgumentException e) {
            if (refDbId.isPresent()) {
                long referenceId = refDbId.get();
                _log.warn("Message Info check failed: {}. Try to use reference DB ID: {}", (Object)e.getMessage(), (Object)referenceId);
                reference = this._messageDAO.getMessageInfo(referenceId);
            }
            _log.error("Message Info check failed: {}. No reference DB ID provided, cannot create XpMessage.", (Object)e.getMessage());
        }
        if (reference == null) {
            _log.warn("Reference not found for signal: {}", (Object)signal);
            return null;
        }
        XpMessage result = new XpMessage();
        result.setIsAck(true);
        result.setMessageType("ACK");
        result.setMessagePackaging(AS4ProcessorHelper.AS4_PACKAGE);
        result.setMessageVersion("2.1");
        result.setSchemaSet("ponton");
        result.setInboundMessage(callback.isInbound());
        result.setReferenceId(reference.getMessageId());
        result.setReferenceDatabaseId(reference.getDatabaseId());
        result.setMessageId(messageInfo.getMessageId());
        result.setConversationId(reference.getConversationId());
        result.setSenderLocalId(reference.getReceiverId());
        result.setReceiverLocalId(reference.getSenderId());
        result.setProtocol(reference.getProtocol());
        result.setMessengerId(this.messengerConfig.getMessengerId());
        result.setPackaged(true);
        Date receivedTime = messageInfo.getTimestamp();
        result.setMessageTimestamp(receivedTime);
        try {
            Agreement agreement = this.getAgreement(result, callback.isInbound());
            Communication communication = agreement.getCommunication(result.getSenderLocalId(), result.getReceiverLocalId());
            result.setCommunication(communication);
            result.setAgreement(agreement);
            result.setOwnPartner(this._profiles.getProfileForLocalId(agreement.getOwnPartner().getId(), true));
            result.setCommunicationPartner(this._profiles.getProfileForLocalId(agreement.getCommunicationPartner().getId(), true));
        }
        catch (AgreementException | ProfileException ex) {
            _log.error(ex.getMessage());
        }
        return result;
    }

    private Agreement getAgreement(XpMessage xpMessage, boolean isInbound) throws AgreementException {
        if (isInbound) {
            return this._agreements.getAgreement(xpMessage.getReceiverLocalId(), xpMessage.getSenderLocalId(), true);
        }
        return this._agreements.getAgreement(xpMessage.getSenderLocalId(), xpMessage.getReceiverLocalId(), true);
    }

    private void checkMessageInfo(MessageInfo messageInfo) {
        Assert.notNull((Object)messageInfo, (String)"Signal Message was not set correctly");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)messageInfo.getRefToMessageId()), (String)"Message Ref not set");
    }
}

