/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.listener;

import de.ponton.xmlpipe.metrics.MetricsService;
import de.ponton.xmlpipe.queue.OutboundQueue;
import de.pontonconsulting.activation.ActivationException;
import de.pontonconsulting.xmlpipe.activation.ActivationControl;
import de.pontonconsulting.xmlpipe.activation.MessengerActivation;
import de.pontonconsulting.xmlpipe.as.AS2ObjectFactory;
import de.pontonconsulting.xmlpipe.as.ASException;
import de.pontonconsulting.xmlpipe.as.ASMessage;
import de.pontonconsulting.xmlpipe.as.ASReport;
import de.pontonconsulting.xmlpipe.as.IAS2Object;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.listener.AS2Processor;
import de.pontonconsulting.xmlpipe.listener.AbstractMessageReceiver;
import de.pontonconsulting.xmlpipe.listener.IASProcessorFactory;
import de.pontonconsulting.xmlpipe.listener.IMessageReceiver;
import de.pontonconsulting.xmlpipe.listener.MessageRequest;
import de.pontonconsulting.xmlpipe.listener.MessageResponse;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.MaintenanceManager;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.archive.ArchiveProcessor;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageWorkDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import jakarta.mail.Header;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.mail.smime.util.SharedFileInputStream;
import org.springframework.util.FileSystemUtils;

public class AS2Listener
extends AbstractMessageReceiver<ASReport>
implements IMessageReceiver {
    private static final String AS2_MESSAGING_IS_DISABLED = "AS2 messaging is disabled.";
    public static final String SERVICE_NAME = "AS2Listener";
    private static final String CONTENT_LENGTH = "Content-Length";
    private static int _processCount = 1;
    private static final AtomicLong _callNumber = new AtomicLong(0L);
    private static final Log _log = LogFactory.getFactory().getInstance("Messenger.AS2Listener" + _processCount++);
    private static final String HEADER_TAB = "\t";
    private static final String HEADER_CR = "\r";
    private static final String HEADER_LF = "\n";
    private final IASProcessorFactory _asProcessorFactory;
    private final ArchiveProcessor _archiveProcessor;
    private final MessengerLog _messengerLog;
    private final MessageDAO _messageDAO;
    private final OutboundQueue _outboundMessageQueue;
    private final IFolders _folders;
    private final MessengerConfig _messengerConfig;
    private final AS2ObjectFactory _as2ObjectFactory;
    private final MessageWorkDataDAO messageWorkDataDAO;

    public AS2Listener(ActivationControl activationControl, MessengerActivation activationProvider, MaintenanceManager maintenanceManager, ReferenceDateTask referenceDateTask, IMessengerProperties messengerProperties, IASProcessorFactory asProcessorFactory, ArchiveProcessor archiveProcessor, MessengerLog messengerLog, MessageDAO messageDAO, OutboundQueue outboundMessageQueue, IFolders folders, MessengerConfig messengerConfig, AS2ObjectFactory as2ObjectFactory, MetricsService metricsService, MessageWorkDataDAO messageWorkDataDAO) {
        super(activationControl, activationProvider, maintenanceManager, referenceDateTask, messengerProperties, metricsService);
        this._asProcessorFactory = asProcessorFactory;
        this._archiveProcessor = archiveProcessor;
        this._messengerLog = messengerLog;
        this._messageDAO = messageDAO;
        this._outboundMessageQueue = outboundMessageQueue;
        this._folders = folders;
        this._messengerConfig = messengerConfig;
        this._as2ObjectFactory = as2ObjectFactory;
        this.messageWorkDataDAO = messageWorkDataDAO;
        this.initLog();
    }

    private synchronized void initLog() {
        _log.debug((Object)"new instance");
    }

    @Override
    protected Log getLogger() {
        return _log;
    }

    @Override
    protected ASReport processRequest(MessageRequest messageRequest) throws Exception {
        return this.processRequest(messageRequest, messageRequest.getRequestURL());
    }

    @Override
    protected void processResult(ASReport result, MessageResponse messageResponse) throws Exception {
        if (result.getMDNParameters().isSyncReplyRequested()) {
            this.sendSynchronousReply(result, messageResponse);
        } else {
            this.sendAsynchronousReply(result);
        }
    }

    @Override
    protected void handleException(Throwable exception, MessageResponse messageResponse) throws IOException {
        String result = "Error while receiving AS2 message: " + exception.toString();
        _log.error((Object)result);
        messageResponse.setResult(500, result);
        OutputStream os = messageResponse.getOutputStream();
        os.write(result.getBytes());
        os.flush();
    }

    @Override
    protected boolean isFeatureEnabled() throws ActivationException {
        return this.activationProvider.isASxMessagingEnabled();
    }

    @Override
    protected String getMessengerExceptionText() {
        return AS2_MESSAGING_IS_DISABLED;
    }

    protected ASReport processRequest(MessageRequest messageRequest, String uri) throws ASException, IOException, MessagingException, DbException {
        try (SharedFileInputStream sharedInputStream = new SharedFileInputStream(messageRequest.getRequestDataFile());){
            ASReport asReport;
            String protocol;
            MimeMessage mimeMessage = new MimeMessage(null, (InputStream)sharedInputStream);
            String realProtocol = messageRequest.getHeader("X-inbound-protocol");
            if (realProtocol != null) {
                protocol = realProtocol;
            } else {
                try {
                    protocol = new URI(uri).getScheme().toUpperCase();
                }
                catch (Exception e) {
                    protocol = "unknown";
                }
            }
            this.logUserInformation(mimeMessage);
            AS2Processor processor = this._asProcessorFactory.getAS2Processor();
            IAS2Object as2Object = this._as2ObjectFactory.createAS2Object(mimeMessage);
            if (as2Object instanceof ASReport) {
                processor.processReport((ASReport)((Object)as2Object), protocol);
                asReport = null;
            } else {
                asReport = processor.processMessage((ASMessage)((Object)as2Object), protocol);
            }
            sharedInputStream.dispose();
            ASReport aSReport = asReport;
            return aSReport;
        }
    }

    public void processSyncResponse(Map<String, String> headers, byte[] dataBytes, String protocol) throws Exception {
        Object lock = new Object();
        File tempStore = new File(this._folders.getWorkInboundFolder(), "as2call-" + this.getCallNumber());
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(tempStore.toPath(), new OpenOption[0]));){
            for (Map.Entry<String, String> header : headers.entrySet()) {
                ((OutputStream)out).write((header.getKey() + ": " + header.getValue() + "\r\n").getBytes());
            }
            ((OutputStream)out).write("\r\n".getBytes());
            ((OutputStream)out).write(dataBytes);
            ((OutputStream)out).close();
            this.putLock(lock);
            MessageRequest messageRequest = new MessageRequest(tempStore, new HashMap<String, String>(0));
            ASReport response = this.processRequest(messageRequest, protocol + "://dummy");
            if (response != null) {
                _log.warn((Object)"Processing of Sync-Response created another response. unable to deliver it !");
            }
        }
        catch (ASException e) {
            _log.fatal((Object)("SyncResponse could not be processed:" + e.getMessage()));
            throw e;
        }
        catch (IOException e) {
            _log.fatal((Object)("SyncResponse could not be processed:" + String.valueOf(e)));
            throw e;
        }
        catch (Exception e) {
            _log.error((Object)"error while processing sync response", (Throwable)e);
            throw e;
        }
        finally {
            this.removeLock(lock);
            FileUtils.deleteQuietly((File)tempStore);
        }
    }

    private void sendSynchronousReply(ASReport report, MessageResponse messageResponse) {
        _log.debug((Object)"Sending synchronous response");
        this._messengerLog.log2db(1, report.getXpMessage().getDatabaseId(), "Sync Response");
        try {
            MimeBodyPart reply = report.getMimePart();
            Enumeration headers = reply.getAllHeaders();
            while (headers.hasMoreElements()) {
                Header header = (Header)headers.nextElement();
                String name = header.getName();
                String headerValue = header.getValue();
                if (!this._messengerConfig.isHttpMultiLineUse()) {
                    StringBuilder value = new StringBuilder(headerValue);
                    int index = -1;
                    while ((index = value.indexOf(HEADER_CR)) != -1) {
                        value.deleteCharAt(index);
                    }
                    while ((index = value.indexOf(HEADER_LF)) != -1) {
                        value.deleteCharAt(index);
                    }
                    while ((index = value.indexOf(HEADER_TAB)) != -1) {
                        value.deleteCharAt(index);
                    }
                    headerValue = value.toString();
                }
                messageResponse.addHeader(name, headerValue);
            }
            try (InputStream in = reply.getInputStream();){
                int temp = -1;
                while ((temp = in.read()) != -1) {
                    messageResponse.write(temp);
                }
            }
            messageResponse.addHeader(CONTENT_LENGTH, String.valueOf(messageResponse.getDataSize()));
            this._messengerLog.log2dbWithHref(104, report.getXpMessage().getDatabaseId(), "For message: " + report.getMDN().getOriginalMessageID(), report.getMDN().getOriginalMessageID(), report.getXpMessage().getReferenceDatabaseId(), true);
            try {
                this.messageWorkDataDAO.uploadDirectoryToDB(report.getXpMessage().getDatabaseId(), report.getXpMessage().getCurrentContentReferenceFolder());
                FileSystemUtils.deleteRecursively((File)report.getXpMessage().getCurrentContentReferenceFolder());
            }
            catch (DbException e) {
                _log.error((Object)"Couldn't upload message folder for %s to database: %s".formatted(report.getXpMessage().getDatabaseId(), e.getMessage()));
            }
            this._archiveProcessor.sendFilesToArchive(report.getXpMessage().getDatabaseId(), false);
            this._messageDAO.updateMessageStatus(report.getXpMessage().getDatabaseId(), report.getXpMessage().getMessageId(), 3);
        }
        catch (Exception e) {
            _log.error((Object)"Error while creating sync reply. ", (Throwable)e);
            messageResponse.addHeader("X-Result-Code", String.valueOf(400));
        }
    }

    private void sendAsynchronousReply(ASReport report) {
        report.getXpMessage().setProtocol(report.getMDNParameters().getAsyncMDNRecipient().split(":")[0].toUpperCase());
        boolean overHTTP = report.getMDNParameters().getAsyncMDNRecipient().split(":")[0].toUpperCase().startsWith("HTTP");
        if (overHTTP) {
            report.getXpMessage().setMessagePackaging("AS2");
        } else {
            report.getXpMessage().setMessagePackaging("AS1");
        }
        File work = new File(this._folders.getWorkOutboundFolder(), String.valueOf(report.getXpMessage().getDatabaseId()));
        work.mkdirs();
        File messageFile = new File(work, "xp_message.dat");
        File messageHeaderFile = new File(work, "xp_message_header.dat");
        MimeBodyPart response = report.getMimePart();
        try (BufferedOutputStream messageOut = new BufferedOutputStream(Files.newOutputStream(messageFile.toPath(), new OpenOption[0]));
             BufferedOutputStream headersOut = new BufferedOutputStream(Files.newOutputStream(messageHeaderFile.toPath(), new OpenOption[0]));
             InputStream in = response.getInputStream();
             ObjectOutputStream oos = new ObjectOutputStream(headersOut);){
            in.transferTo(messageOut);
            ((OutputStream)messageOut).flush();
            response.addHeader(CONTENT_LENGTH, "" + messageFile.length());
            HashMap<String, String> header2 = this.convertInternetHeadersToHashMap(response.getAllHeaders());
            oos.writeObject(header2);
            _log.debug((Object)"Sending Async response");
            if (report.getXpMessage().getAdapterId() == null) {
                report.getXpMessage().setAdapterId("NullAdapter");
            }
            XpMessage xpMessage = report.getXpMessage();
            String destinationUri = report.getMDNParameters().getAsyncMDNRecipient();
            xpMessage.setDestinationUrl(destinationUri);
            this._outboundMessageQueue.deliverMessageToPartner(report.getXpMessage());
        }
        catch (Exception e) {
            _log.fatal((Object)"Unable send send asynchonous reply", (Throwable)e);
        }
    }

    private long getCallNumber() {
        return _callNumber.incrementAndGet();
    }

    protected HashMap<String, String> convertInternetHeadersToHashMap(Enumeration<?> headersEnum) {
        HashMap<String, String> result = new HashMap<String, String>();
        while (headersEnum.hasMoreElements()) {
            Header header = (Header)headersEnum.nextElement();
            String value = header.getValue();
            result.put(header.getName(), value);
        }
        return result;
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }
}

