/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.config.listener;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class ListenerResponse {
    private final int _responseCode;
    private String _responseMessage;
    private Map<String, String> _headers;
    private byte[] _content;

    public ListenerResponse(int responseCode, String responseMessage) {
        this._responseCode = responseCode;
        this._responseMessage = URLDecoder.decode(responseMessage, StandardCharsets.US_ASCII);
    }

    public ListenerResponse(int responseCode, String responseMessage, Map<String, String> headers) {
        this(responseCode, responseMessage);
        this._headers = headers;
    }

    public ListenerResponse(int responseCode, String responseMessage, Map<String, String> headers, byte[] content) {
        this(responseCode, responseMessage, headers);
        this._content = content;
    }

    public byte[] getContent() {
        return this._content;
    }

    public void setContent(byte[] content) {
        this._content = content;
    }

    public Map<String, String> getHeaders() {
        return this._headers;
    }

    public void setHeaders(HashMap<String, String> headers) {
        this._headers = headers;
    }

    public int getResponseCode() {
        return this._responseCode;
    }

    public String getResponseMessage() {
        return this._responseMessage;
    }
}

