/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.config.listener;

import de.ponton.securelistener.administration.certs.ServerCertificate;
import de.pontonconsulting.xmlpipe.config.listener.ListenerCommand;
import de.pontonconsulting.xmlpipe.config.listener.ListenerConfigException;
import de.pontonconsulting.xmlpipe.config.listener.ListenerResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Optional;

public class InstallServerCertificate
extends ListenerCommand {
    private String certificateId;

    public InstallServerCertificate(ServerCertificate cer) {
        super(null);
        try {
            this._command = "installServerCertificate";
            this._headers.put("X-Ponton-SecureListener-KeyPass", cer.getPassword());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(cer.getCertificate());
            if (cer.getPrivateKey() != null && cer.getPrivateKey().length > 0) {
                this._headers.put("X-Ponton-SecureListener-Privkey-Included", "true");
                out.write("\n".getBytes());
                out.write("---CERT SEPARATOR---".getBytes());
                out.write("\n".getBytes());
                out.write(cer.getPrivateKey());
                out.write("\n".getBytes());
            } else {
                this._headers.put("X-Ponton-SecureListener-Privkey-Included", "false");
            }
            this._content = out.toByteArray();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void handleResponse(ListenerResponse response) throws ListenerConfigException {
        Optional<String> certAlias = Optional.ofNullable(response.getHeaders().get("X-Ponton-SecureListener-CertAlias"));
        if (!certAlias.isPresent()) {
            throw new ListenerConfigException(-1, "No certificate alias returned.");
        }
        this.certificateId = certAlias.get();
    }

    public String getCertificateId() {
        return this.certificateId;
    }
}

