/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.config.listener;

import de.ponton.securelistener.administration.CommandRequest;
import de.ponton.securelistener.administration.CommandResponse;
import de.ponton.xmlpipe.websocket.ConfigEndpoint;
import de.ponton.xmlpipe.websocket.WebsocketClient;
import de.pontonconsulting.xmlpipe.config.listener.ListenerCommand;
import de.pontonconsulting.xmlpipe.config.listener.ListenerConfigException;
import de.pontonconsulting.xmlpipe.config.listener.ListenerResponse;
import java.util.HashMap;
import java.util.HashSet;

public class AdminConnection {
    private final WebsocketClient websocketClient;

    public AdminConnection(WebsocketClient websocketClient) {
        this.websocketClient = websocketClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCommand(ListenerCommand command) throws ListenerConfigException {
        WebsocketClient websocketClient = this.websocketClient;
        synchronized (websocketClient) {
            if (this.websocketClient.getConfigEndpoints().isEmpty()) {
                throw new ListenerConfigException(47001, "No Listener is connected");
            }
            ListenerConfigException exception = null;
            for (ConfigEndpoint configEndpoint : new HashSet<ConfigEndpoint>(this.websocketClient.getConfigEndpoints())) {
                try {
                    this.executeCommandSingle(command, configEndpoint);
                }
                catch (ListenerConfigException e) {
                    exception = e;
                }
                catch (Exception e) {
                    exception = new ListenerConfigException(0, e.getMessage(), e);
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
    }

    public void executeCommandSingle(ListenerCommand command, ConfigEndpoint configEndpoint) throws ListenerConfigException {
        HashMap<String, String> commandHeaders = command.getHeaders();
        commandHeaders.put("command", command.getCommand());
        CommandRequest commandRequest = new CommandRequest(commandHeaders, command.getContent());
        if (!configEndpoint.isAuthenticated()) {
            Throwable t = configEndpoint.getLastThrowable();
            if (t != null) {
                throw new ListenerConfigException(47001, t.getMessage());
            }
            throw new ListenerConfigException(47001, "Listener is not connected");
        }
        CommandResponse commandResponse = configEndpoint.sendCommand(commandRequest);
        String errorText = commandResponse.getHeader("X-Error");
        int statusCode = 500;
        if (errorText == null) {
            errorText = "OK";
            statusCode = 200;
        }
        ListenerResponse response = new ListenerResponse(statusCode, errorText, commandResponse.getHeaders(), commandResponse.getData());
        if (statusCode / 100 != 2) {
            throw new ListenerConfigException(47003, new String[]{response.getResponseMessage()}, response.getResponseMessage());
        }
        command.handleResponse(response);
    }
}

