/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class UnzipFile {
    private static final long MAX_SIZE = 10000000L;

    public List<String> listFiles(String filename) throws IOException {
        ArrayList<String> files = new ArrayList<String>();
        try (ZipFile zipFile = new ZipFile(filename);){
            Enumeration<? extends ZipEntry> zipEntryEnum = zipFile.entries();
            while (zipEntryEnum.hasMoreElements()) {
                ZipEntry zipEntry = zipEntryEnum.nextElement();
                if (!this.validateEntry(zipEntry) || zipEntry.isDirectory()) continue;
                files.add(zipEntry.getName());
            }
        }
        return files;
    }

    public void unzip(String filename, String destination) throws IOException {
        try (ZipFile zipFile = new ZipFile(filename);){
            Enumeration<? extends ZipEntry> zipEntryEnum = zipFile.entries();
            while (zipEntryEnum.hasMoreElements()) {
                ZipEntry zipEntry = zipEntryEnum.nextElement();
                if (!this.validateEntry(zipEntry)) continue;
                this.extractEntry(zipFile, zipEntry, destination);
            }
        }
    }

    private void extractEntry(ZipFile zf, ZipEntry entry, String destDir) throws IOException {
        File file = new File(destDir, entry.getName());
        if (entry.isDirectory()) {
            file.mkdirs();
        } else {
            new File(file.getParent()).mkdirs();
            byte[] buffer = new byte[10000];
            try (InputStream is = zf.getInputStream(entry);
                 OutputStream os = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
                int length;
                int totalLength = 0;
                while ((length = is.read(buffer)) > 0) {
                    os.write(buffer, 0, length);
                    if ((long)(totalLength += length) <= 10000000L) continue;
                    throw new IOException("extracted file size is too large");
                }
            }
        }
    }

    private boolean validateEntry(ZipEntry zipEntry) throws IOException {
        if (zipEntry.getName().contains("../") || zipEntry.getName().contains("..\\")) {
            throw new IOException("invalid name in ZIP archive");
        }
        if (zipEntry.getSize() > 10000000L) {
            throw new IOException("extracted file size is too large");
        }
        return true;
    }
}

