/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.config;

import java.util.HashMap;
import java.util.Map;

public enum SystemEvent {
    BRUTE_FORCE_LOGIN_ATTACK(1001, "Brute Force Login Attack"),
    REMOTE_PARTNER_CERTIFICATE_EXPIRATION_WARNING(1002, "Remote Partner Certificate will expire in 30 days"),
    LOCAL_PARTNER_CERTIFICATE_EXPIRATION_WARNING(1003, "Local Partner Certificate will expire in 30 days"),
    REMOTE_PARTNER_CERTIFICATE_EXPIRED_ERROR(1004, "Remote Partner Certificate has expired"),
    LOCAL_PARTNER_CERTIFICATE_EXPIRED_ERROR(1005, "Local Partner Certificate has expired"),
    ACTIVATION_SERVER_UNREACHABLE(1006, "Activation Server Unreachable");

    private static final Map<Integer, SystemEvent> EVENTS;
    private final int code;
    private final String description;

    private SystemEvent(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public static SystemEvent getSystemEvent(int code) {
        return EVENTS.get(code);
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFullDescription() {
        return this.code + ": " + this.description;
    }

    static {
        EVENTS = new HashMap<Integer, SystemEvent>();
        for (SystemEvent systemEvent : SystemEvent.values()) {
            EVENTS.put(systemEvent.code, systemEvent);
        }
    }
}

