/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.config;

import de.pontonconsulting.common.file.DBConfigChangeWatcher;
import de.pontonconsulting.xmlpipe.config.ConfigResourceService;
import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.config.InvalidSchemaSetException;
import de.pontonconsulting.xmlpipe.config.SchemataConfig;
import de.pontonconsulting.xmlpipe.config.UnzipFile;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.messenger.MaintenanceManager;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SchemaSetInstaller {
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.SchemaSetInstaller");
    private static final Pattern VALID_EXTENSIONS = Pattern.compile(".+\\.(?i)(dtd|xml|xsd)$");
    private final IServerConfigBean serverConfig;
    private final SchemataConfig schemataConfig;
    private final MaintenanceManager maintenanceManager;
    private final ConfigResourceService configResourceService;

    public SchemaSetInstaller(SchemataConfig schemataConfig, MaintenanceManager maintenanceManager, IServerConfigBean serverConfigBean, ConfigResourceService configResourceService, DBConfigChangeWatcher schemataChangeWatcher) {
        this.schemataConfig = schemataConfig;
        this.maintenanceManager = maintenanceManager;
        this.serverConfig = serverConfigBean;
        this.configResourceService = configResourceService;
        schemataChangeWatcher.addFileChangeListener(() -> {
            maintenanceManager.startMainMaintenanceMode();
            try {
                schemataConfig.reinit();
            }
            finally {
                maintenanceManager.stopMainMaintenanceMode();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installNewSchemaSet(File schemaSetPackage, String username) throws IOException, ProfileException, InvalidSchemaSetException {
        block4: {
            this.maintenanceManager.startMainMaintenanceMode();
            try {
                if (this.validateSchemaSetPackage(schemaSetPackage)) {
                    String schemaSetFolderPath = this.serverConfig.getRealPath(this.serverConfig.getSchemaSetFolder().getAbsolutePath());
                    new UnzipFile().unzip(schemaSetPackage.getAbsolutePath(), schemaSetFolderPath);
                    this.configResourceService.storeSchemataAndEnvelopes(username);
                    this.schemataConfig.reinit();
                    break block4;
                }
                throw new InvalidSchemaSetException();
            }
            finally {
                this.maintenanceManager.stopMainMaintenanceMode();
            }
        }
    }

    boolean validateSchemaSetPackage(File schemaSetPackage) throws IOException {
        AtomicBoolean valid = new AtomicBoolean(true);
        List<String> files = new UnzipFile().listFiles(schemaSetPackage.getAbsolutePath());
        files.forEach(file -> {
            if (!VALID_EXTENSIONS.matcher((CharSequence)file).matches()) {
                valid.set(false);
            }
        });
        return valid.get();
    }
}

