/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.config;

import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.config.ServerSettings;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerConfig;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerConfigDAO;
import de.pontonconsulting.xmlpipe.server.Startup;
import jakarta.annotation.PostConstruct;
import jakarta.xml.bind.JAXBException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class SSLKeystoreBean {
    private static final Log _log = LogFactory.getLog((String)"Messenger.SSLKeystoreBean");
    public static final String SSL_KEY_STORE_PASSWORD = "changeit";
    private KeyStore _sslKeyStore;
    private String _sslKeyStorePassword = "changeit";
    private KeyStore _sslTempKeyStore;
    private String _sslTempKeyStorePassword = "changeit";
    private KeyStore _trustKeyStore;
    private String _trustKeyStorePassword = "changeit";
    private final IServerConfigBean _config;
    boolean _initDone;
    private MessengerConfigDAO messengerConfigDAO;
    private long keystoreTempLastModified;
    private long keystoreLastModified;
    private long trustKeystoreLastModified;
    protected static final String XP_ROOT_CA = "XPRootCA-chain.pem";
    protected static final String XP_ROOT_CA_ALIAS = "cn=xp root ca,o=ponton gmbh,c=de";

    public SSLKeystoreBean(IServerConfigBean serverConfig, MessengerConfigDAO messengerConfigDAO) throws IOException, GeneralSecurityException, JAXBException {
        this._config = serverConfig;
        Path keystorePath = null;
        Path keystoreTempPath = null;
        Path trustKeystorePath = null;
        Map<String, ServerSettings> list = this._config.getConnectors();
        for (ServerSettings c : list.values()) {
            if (!c.isSsl()) continue;
            try {
                if (c.isNeedClientCert() || c.isWantClientCert()) {
                    trustKeystorePath = this._config.getRealFile(c.getTrustKeystore()).toPath();
                    if (!messengerConfigDAO.doesMessengerConfigExist("trust-keystore-ssl")) {
                        this._trustKeyStorePassword = SSL_KEY_STORE_PASSWORD;
                    }
                }
                keystorePath = this._config.getRealFile(c.getSslKeystore()).toPath();
                if (!messengerConfigDAO.doesMessengerConfigExist("keystore-ssl")) {
                    this._sslKeyStorePassword = SSL_KEY_STORE_PASSWORD;
                    this._sslTempKeyStorePassword = SSL_KEY_STORE_PASSWORD;
                }
                keystoreTempPath = this._config.getRealFile(c.getSslKeystore() + "-temp").toPath();
            }
            catch (Exception e) {
                _log.error((Object)("could not init SSL for server port " + c.getPort() + ": " + String.valueOf(e)));
            }
        }
        if (keystorePath == null) {
            keystorePath = this._config.getRealFile("$XP_CONFIG_FOLDER/keystore-ssl").toPath();
        }
        if (trustKeystorePath == null) {
            trustKeystorePath = this._config.getRealFile("$XP_CONFIG_FOLDER/keystore-ssl").toPath();
        }
        if (keystoreTempPath == null) {
            keystoreTempPath = this._config.getRealFile("$XP_CONFIG_FOLDER/keystore-ssl-temp").toPath();
        }
        this.messengerConfigDAO = messengerConfigDAO;
        if (Files.exists(keystorePath, new LinkOption[0]) && !messengerConfigDAO.doesMessengerConfigExist("keystore-ssl")) {
            this.keystoreLastModified = messengerConfigDAO.storeMessengerConfig(Files.readAllBytes(keystorePath), "keystore-ssl", "SYSTEM");
            Files.delete(keystorePath);
        }
        if (Files.exists(trustKeystorePath, new LinkOption[0]) && !messengerConfigDAO.doesMessengerConfigExist("trust-keystore-ssl")) {
            this.trustKeystoreLastModified = messengerConfigDAO.storeMessengerConfig(Files.readAllBytes(trustKeystorePath), "trust-keystore-ssl", "SYSTEM");
            Files.delete(trustKeystorePath);
        }
        if (Files.exists(keystoreTempPath, new LinkOption[0]) && !messengerConfigDAO.doesMessengerConfigExist("keystore-ssl-temp")) {
            this.keystoreTempLastModified = messengerConfigDAO.storeMessengerConfig(Files.readAllBytes(keystoreTempPath), "keystore-ssl-temp", "SYSTEM");
            Files.delete(keystoreTempPath);
        }
        if (!messengerConfigDAO.doesMessengerConfigExist("keystore-ssl")) {
            this._sslKeyStorePassword = SSL_KEY_STORE_PASSWORD;
        }
        if (!messengerConfigDAO.doesMessengerConfigExist("trust-keystore-ssl")) {
            this._trustKeyStorePassword = SSL_KEY_STORE_PASSWORD;
        }
        this._sslKeyStore = this.initKeyStore(this._sslKeyStore, this._sslKeyStorePassword, "keystore-ssl");
        this._trustKeyStore = this.initKeyStore(this._trustKeyStore, this._trustKeyStorePassword, "trust-keystore-ssl");
        this._sslTempKeyStore = this.initKeyStore(this._sslTempKeyStore, this._sslTempKeyStorePassword, "keystore-ssl-temp");
        this._sslKeyStorePassword = SSL_KEY_STORE_PASSWORD;
        this._trustKeyStorePassword = SSL_KEY_STORE_PASSWORD;
        this._sslTempKeyStorePassword = SSL_KEY_STORE_PASSWORD;
        this.storeKeyStore(this._sslKeyStore, this._sslKeyStorePassword, "keystore-ssl");
        this.storeKeyStore(this._trustKeyStore, this._trustKeyStorePassword, "trust-keystore-ssl");
        this.storeKeyStore(this._sslTempKeyStore, this._sslTempKeyStorePassword, "keystore-ssl-temp");
        try (InputStream inputStream = Objects.requireNonNull(Startup.class.getClassLoader().getResource(XP_ROOT_CA)).openStream();){
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate caCert = (X509Certificate)certificateFactory.generateCertificate(inputStream);
            if (this._sslKeyStore.getCertificate(XP_ROOT_CA_ALIAS) == null) {
                this.addSslCA(XP_ROOT_CA_ALIAS, caCert);
            }
        }
    }

    @PostConstruct
    public void initialize() throws IOException, GeneralSecurityException, JAXBException {
        this._initDone = true;
    }

    private KeyStore initKeyStore(KeyStore currentKeystore, String password, String type) throws GeneralSecurityException {
        KeyStore keyStore;
        KeyStore keyStore2 = keyStore = currentKeystore != null ? currentKeystore : KeyStore.getInstance("JKS", "SUN");
        if (password == null || password.length() == 0) {
            throw new KeyStoreException("Password for keystore required.");
        }
        if (this.messengerConfigDAO.doesMessengerConfigExist(type)) {
            MessengerConfig messengerConfig = this.messengerConfigDAO.loadMessengerConfig(type);
            if (type.equals("keystore-ssl")) {
                this.keystoreLastModified = messengerConfig.getTimestamp().toInstant().toEpochMilli();
            } else if (type.equals("keystore-ssl-temp")) {
                this.keystoreTempLastModified = messengerConfig.getTimestamp().toInstant().toEpochMilli();
            } else if (type.equals("trust-keystore-ssl")) {
                this.trustKeystoreLastModified = messengerConfig.getTimestamp().toInstant().toEpochMilli();
            }
            this.loadKeyStore(keyStore, messengerConfig.getData(), password);
        } else {
            try {
                keyStore.load(null, password.toCharArray());
                this.storeKeyStore(keyStore, password, type);
            }
            catch (Exception e) {
                KeyStoreException ke = new KeyStoreException(e.getMessage());
                ke.setStackTrace(e.getStackTrace());
                throw ke;
            }
        }
        return keyStore;
    }

    private void loadKeyStore(KeyStore keyStore, byte[] bytes, String password) throws KeyStoreException {
        if (keyStore == this._sslKeyStore) {
            this.keystoreLastModified = this.messengerConfigDAO.getTimestampAsLongByConfigType("keystore-ssl");
        } else if (keyStore == this._sslTempKeyStore) {
            this.keystoreTempLastModified = this.messengerConfigDAO.getTimestampAsLongByConfigType("keystore-ssl-temp");
        } else if (keyStore == this._trustKeyStore) {
            this.trustKeystoreLastModified = this.messengerConfigDAO.getTimestampAsLongByConfigType("trust-keystore-ssl");
        }
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);){
            keyStore.load(byteArrayInputStream, password.toCharArray());
        }
        catch (Exception e) {
            String msg = "Unable to load keystore ";
            throw new KeyStoreException("Unable to load keystore ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeKeyStore(KeyStore keyStore, String password, String type) throws KeyStoreException {
        SSLKeystoreBean sSLKeystoreBean = this;
        synchronized (sSLKeystoreBean) {
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Saving keystore to db.");
                }
                keyStore.store(byteArrayOutputStream, password.toCharArray());
                byteArrayOutputStream.flush();
                Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
                long timestamp = this.messengerConfigDAO.storeMessengerConfig(byteArrayOutputStream.toByteArray(), type, authentication != null ? authentication.getName() : "SYSTEM");
                if (type.equals("keystore-ssl")) {
                    this.keystoreLastModified = timestamp;
                } else if (type.equals("keystore-ssl-temp")) {
                    this.keystoreTempLastModified = timestamp;
                } else if (type.equals("trust-keystore-ssl")) {
                    this.trustKeystoreLastModified = timestamp;
                }
            }
            catch (Exception e) {
                String msg = "Unable to store keystore ";
                throw new KeyStoreException("Unable to store keystore ", e);
            }
        }
    }

    public KeyStore getSslTrustCertificateKeystore() throws KeyStoreException {
        if (this.messengerConfigDAO.getTimestampAsLongByConfigType("trust-keystore-ssl") != this.trustKeystoreLastModified) {
            this.loadKeyStore(this._trustKeyStore, this.messengerConfigDAO.loadMessengerConfig("trust-keystore-ssl").getData(), this._trustKeyStorePassword);
        }
        return this._trustKeyStore;
    }

    public KeyStore getSslCertificateKeystore() throws KeyStoreException {
        if (this.messengerConfigDAO.getTimestampAsLongByConfigType("keystore-ssl") != this.keystoreLastModified) {
            this.loadKeyStore(this._sslKeyStore, this.messengerConfigDAO.loadMessengerConfig("keystore-ssl").getData(), this._sslKeyStorePassword);
        }
        return this._sslKeyStore;
    }

    public X509Certificate getSslCertificate(String alias) throws KeyStoreException {
        if (this.messengerConfigDAO.getTimestampAsLongByConfigType("keystore-ssl") != this.keystoreLastModified) {
            this.loadKeyStore(this._sslKeyStore, this.messengerConfigDAO.loadMessengerConfig("keystore-ssl").getData(), this._sslKeyStorePassword);
        }
        return (X509Certificate)this._sslKeyStore.getCertificate(alias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTempPrivateKey(String localID, PrivateKey privateKey, char[] cs, X509Certificate selfCert) throws KeyStoreException {
        SSLKeystoreBean sSLKeystoreBean = this;
        synchronized (sSLKeystoreBean) {
            if (this.messengerConfigDAO.getTimestampAsLongByConfigType("keystore-ssl-temp") != this.keystoreTempLastModified) {
                this.loadKeyStore(this._sslTempKeyStore, this.messengerConfigDAO.loadMessengerConfig("keystore-ssl-temp").getData(), this._sslTempKeyStorePassword);
            }
            this._sslTempKeyStore.setKeyEntry(localID, privateKey, cs, new Certificate[]{selfCert});
            this.storeKeyStore(this._sslTempKeyStore, this._sslTempKeyStorePassword, "keystore-ssl-temp");
        }
    }

    public PrivateKey getTempPrivateKey(String alias, char[] cs) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (this.messengerConfigDAO.getTimestampAsLongByConfigType("keystore-ssl-temp") != this.keystoreTempLastModified) {
            this.loadKeyStore(this._sslTempKeyStore, this.messengerConfigDAO.loadMessengerConfig("keystore-ssl-temp").getData(), this._sslTempKeyStorePassword);
        }
        return (PrivateKey)this._sslTempKeyStore.getKey(alias, cs);
    }

    public PrivateKey getSslPrivateKey(String alias, char[] password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (this.messengerConfigDAO.getTimestampAsLongByConfigType("keystore-ssl") != this.keystoreLastModified) {
            this.loadKeyStore(this._sslKeyStore, this.messengerConfigDAO.loadMessengerConfig("keystore-ssl").getData(), this._sslKeyStorePassword);
        }
        return (PrivateKey)this._sslKeyStore.getKey(alias, password);
    }

    public Certificate[] getSslTempCertificateChain(String alias) throws KeyStoreException {
        if (this.messengerConfigDAO.getTimestampAsLongByConfigType("keystore-ssl-temp") != this.keystoreTempLastModified) {
            this.loadKeyStore(this._sslTempKeyStore, this.messengerConfigDAO.loadMessengerConfig("keystore-ssl-temp").getData(), this._sslTempKeyStorePassword);
        }
        return this._sslTempKeyStore.getCertificateChain(alias);
    }

    public void checkCertificate(X509Certificate certificate) throws CertificateException {
        this.checkCertificateChain(this.getSslCertificateChain(certificate));
    }

    private void checkCertificateChain(X509Certificate[] certChain) throws CertificateException {
        X509Certificate certificate = certChain[0];
        Date validationDate = new Date();
        this.checkValidity(certificate, validationDate);
        for (int i = 1; i < certChain.length; ++i) {
            certificate = certChain[i];
            this.checkValidity(certificate, validationDate);
            this.checkCertificateSignature(certChain[i - 1], certificate);
        }
    }

    private void checkCertificateSignature(X509Certificate certificate, X509Certificate caCertificate) throws CertificateException {
        try {
            certificate.verify(caCertificate.getPublicKey());
        }
        catch (SignatureException e) {
            String msg = "Signing CA '" + caCertificate.getSubjectX500Principal().getName() + "' is not issuer of certificate '" + certificate.getSubjectDN().getName() + "'";
            throw new CertificateException(msg, e);
        }
        catch (InvalidKeyException e) {
            _log.error((Object)"could not verify certificate signature.", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            _log.error((Object)"could not verify certificate signature.", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (NoSuchProviderException e) {
            _log.error((Object)"could not verify certificate signature.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void checkValidity(X509Certificate certificate, Date validationDate) throws CertificateException {
        try {
            _log.trace((Object)("checks validity of the certificate: " + certificate.getSubjectDN().getName()));
            if (validationDate == null) {
                certificate.checkValidity();
            } else {
                certificate.checkValidity(validationDate);
            }
        }
        catch (CertificateExpiredException e) {
            Object msg = e.getMessage();
            msg = msg == null || ((String)msg).length() == 0 ? "." : ": " + (String)msg;
            msg = "Certificate '" + certificate.getSubjectX500Principal().getName() + "' is out of date" + (String)msg;
            CertificateException ce = new CertificateException((String)msg);
            ce.setStackTrace(e.getStackTrace());
            throw ce;
        }
        catch (CertificateNotYetValidException e) {
            Object msg = e.getMessage();
            msg = msg == null || ((String)msg).length() == 0 ? "." : ": " + (String)msg;
            msg = "Certificate '" + certificate.getSubjectX500Principal().getName() + "' is not valid" + (String)msg;
            CertificateException ce = new CertificateException((String)msg);
            ce.setStackTrace(e.getStackTrace());
            throw ce;
        }
    }

    public X509Certificate[] getSslCertificateChain(X509Certificate cert) throws CertificateException {
        ArrayList<X509Certificate> v = new ArrayList<X509Certificate>();
        v.add(cert);
        X500Principal subject = cert.getSubjectX500Principal();
        X500Principal issuer = cert.getIssuerX500Principal();
        X509Certificate tempCert = cert;
        while (!issuer.equals(subject)) {
            X509Certificate issuerCert = this.getIssuerCertificate(tempCert, this._sslKeyStore);
            if (issuerCert == null) {
                throw new CertificateException("No certificate for CA '" + issuer.getName() + "' found.");
            }
            try {
                issuerCert.checkValidity();
            }
            catch (GeneralSecurityException e) {
                Object msg = e.getMessage();
                msg = msg == null || ((String)msg).length() == 0 ? "." : ": " + (String)msg;
                msg = "Certificate for '" + issuerCert.getIssuerX500Principal().getName() + "' is out of date" + (String)msg;
                CertificateException ce = new CertificateException((String)msg);
                ce.setStackTrace(e.getStackTrace());
                throw ce;
            }
            v.add(issuerCert);
            subject = issuerCert.getSubjectX500Principal();
            issuer = issuerCert.getIssuerX500Principal();
            tempCert = issuerCert;
        }
        X509Certificate[] certChain = new X509Certificate[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            certChain[i] = (X509Certificate)v.get(i);
        }
        return certChain;
    }

    private X509Certificate getIssuerCertificate(X509Certificate cert, KeyStore keyStore) {
        X500Principal issuer = cert.getIssuerX500Principal();
        for (X509Certificate aCert : this.certificates(keyStore)) {
            if (!aCert.getSubjectX500Principal().equals(issuer)) continue;
            return aCert;
        }
        return null;
    }

    private List<X509Certificate> certificates(KeyStore keyStore) {
        try {
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!keyStore.isCertificateEntry(alias)) continue;
                certs.add((X509Certificate)keyStore.getCertificate(alias));
            }
            return certs;
        }
        catch (KeyStoreException e) {
            return new ArrayList<X509Certificate>(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTempPrivateKey(String alias) throws KeyStoreException {
        SSLKeystoreBean sSLKeystoreBean = this;
        synchronized (sSLKeystoreBean) {
            if (this.messengerConfigDAO.getTimestampAsLongByConfigType("keystore-ssl-temp") != this.keystoreTempLastModified) {
                this.loadKeyStore(this._sslTempKeyStore, this.messengerConfigDAO.loadMessengerConfig("keystore-ssl-temp").getData(), this._sslTempKeyStorePassword);
            }
            this._sslTempKeyStore.deleteEntry(alias);
            this.storeKeyStore(this._sslTempKeyStore, this._sslTempKeyStorePassword, "keystore-ssl-temp");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSslPrivateKey(String alias, PrivateKey privateKey, char[] password, X509Certificate[] chain) throws KeyStoreException {
        SSLKeystoreBean sSLKeystoreBean = this;
        synchronized (sSLKeystoreBean) {
            if (this.messengerConfigDAO.getTimestampAsLongByConfigType("keystore-ssl") != this.keystoreLastModified) {
                this.loadKeyStore(this._sslKeyStore, this.messengerConfigDAO.loadMessengerConfig("keystore-ssl").getData(), this._sslKeyStorePassword);
            }
            this._sslKeyStore.setKeyEntry(alias, privateKey, password, chain);
            this.storeKeyStore(this._sslKeyStore, this._sslKeyStorePassword, "keystore-ssl");
        }
    }

    public X509Certificate getSslCA(String alias) throws KeyStoreException {
        if (this.messengerConfigDAO.getTimestampAsLongByConfigType("keystore-ssl") != this.keystoreLastModified) {
            this.loadKeyStore(this._sslKeyStore, this.messengerConfigDAO.loadMessengerConfig("keystore-ssl").getData(), this._sslKeyStorePassword);
        }
        return (X509Certificate)this._sslKeyStore.getCertificate(alias);
    }

    public X509Certificate getSSLTrustCertificate(String alias) throws KeyStoreException {
        if (this.messengerConfigDAO.getTimestampAsLongByConfigType("trust-keystore-ssl") != this.trustKeystoreLastModified) {
            this.loadKeyStore(this._trustKeyStore, this.messengerConfigDAO.loadMessengerConfig("trust-keystore-ssl").getData(), this._trustKeyStorePassword);
        }
        return (X509Certificate)this._trustKeyStore.getCertificate(alias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSslCA(String alias, X509Certificate cert) throws KeyStoreException {
        SSLKeystoreBean sSLKeystoreBean = this;
        synchronized (sSLKeystoreBean) {
            if (this.messengerConfigDAO.getTimestampAsLongByConfigType("keystore-ssl") != this.keystoreLastModified) {
                this.loadKeyStore(this._sslKeyStore, this.messengerConfigDAO.loadMessengerConfig("keystore-ssl").getData(), this._sslKeyStorePassword);
            }
            this._sslKeyStore.setCertificateEntry(alias, cert);
            this.storeKeyStore(this._sslKeyStore, this._sslKeyStorePassword, "keystore-ssl");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSSLTrustCertificate(String alias, X509Certificate cert) throws KeyStoreException {
        SSLKeystoreBean sSLKeystoreBean = this;
        synchronized (sSLKeystoreBean) {
            if (this.messengerConfigDAO.getTimestampAsLongByConfigType("trust-keystore-ssl") != this.trustKeystoreLastModified) {
                this.loadKeyStore(this._trustKeyStore, this.messengerConfigDAO.loadMessengerConfig("trust-keystore-ssl").getData(), this._trustKeyStorePassword);
            }
            this._trustKeyStore.setCertificateEntry(alias, cert);
            this.storeKeyStore(this._trustKeyStore, this._trustKeyStorePassword, "trust-keystore-ssl");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSslCA(String alias) throws KeyStoreException {
        SSLKeystoreBean sSLKeystoreBean = this;
        synchronized (sSLKeystoreBean) {
            if (this.messengerConfigDAO.getTimestampAsLongByConfigType("keystore-ssl") != this.keystoreLastModified) {
                this.loadKeyStore(this._sslKeyStore, this.messengerConfigDAO.loadMessengerConfig("keystore-ssl").getData(), this._sslKeyStorePassword);
            }
            this._sslKeyStore.deleteEntry(alias);
            this.storeKeyStore(this._sslKeyStore, this._sslKeyStorePassword, "keystore-ssl");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSSLTrustCertificate(String alias) throws KeyStoreException {
        SSLKeystoreBean sSLKeystoreBean = this;
        synchronized (sSLKeystoreBean) {
            if (this.messengerConfigDAO.getTimestampAsLongByConfigType("trust-keystore-ssl") != this.trustKeystoreLastModified) {
                this.loadKeyStore(this._trustKeyStore, this.messengerConfigDAO.loadMessengerConfig("trust-keystore-ssl").getData(), this._trustKeyStorePassword);
            }
            this._trustKeyStore.deleteEntry(alias);
            this.storeKeyStore(this._trustKeyStore, this._trustKeyStorePassword, "trust-keystore-ssl");
        }
    }

    public Enumeration<String> getSslAliases() throws KeyStoreException {
        if (this.messengerConfigDAO.getTimestampAsLongByConfigType("keystore-ssl") != this.keystoreLastModified) {
            this.loadKeyStore(this._sslKeyStore, this.messengerConfigDAO.loadMessengerConfig("keystore-ssl").getData(), this._sslKeyStorePassword);
        }
        ArrayList<String> caIds = new ArrayList<String>();
        Enumeration<String> allAliases = this._sslKeyStore.aliases();
        while (allAliases.hasMoreElements()) {
            String alias = allAliases.nextElement();
            if (!this._sslKeyStore.isCertificateEntry(alias)) continue;
            caIds.add(alias);
        }
        return Collections.enumeration(caIds);
    }

    public Enumeration<String> getTrustSSLAliases() throws KeyStoreException {
        if (this.messengerConfigDAO.getTimestampAsLongByConfigType("trust-keystore-ssl") != this.trustKeystoreLastModified) {
            this.loadKeyStore(this._trustKeyStore, this.messengerConfigDAO.loadMessengerConfig("trust-keystore-ssl").getData(), this._trustKeyStorePassword);
        }
        ArrayList<String> caIds = new ArrayList<String>();
        Enumeration<String> allAliases = this._trustKeyStore.aliases();
        while (allAliases.hasMoreElements()) {
            String alias = allAliases.nextElement();
            if (!this._trustKeyStore.isCertificateEntry(alias)) continue;
            caIds.add(alias);
        }
        return Collections.enumeration(caIds);
    }

    public void deletePrivateKey(String alias) throws KeyStoreException {
        if (this.messengerConfigDAO.getTimestampAsLongByConfigType("keystore-ssl") != this.keystoreLastModified) {
            this.loadKeyStore(this._sslKeyStore, this.messengerConfigDAO.loadMessengerConfig("keystore-ssl").getData(), this._sslKeyStorePassword);
        }
        this._sslKeyStore.deleteEntry(alias);
        this.storeKeyStore(this._sslKeyStore, this._sslKeyStorePassword, "keystore-ssl");
    }
}

