/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.config;

import de.pontonconsulting.xmlpipe.adapter.util.StringUtils;
import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.config.NtpServer;
import de.pontonconsulting.xmlpipe.config.SubjectElement;
import de.pontonconsulting.xmlpipe.config.SystemEvent;
import de.pontonconsulting.xmlpipe.config.model.common.authentication.XpAuthenticationDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.XpMessengerConfigurationDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.adapterapi.XpAdapterApiDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.archive.XpArchiveDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.archive.XpCleanupDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.archive.XpMessagePart;
import de.pontonconsulting.xmlpipe.config.model.messenger.authtoken.XpAuthenticationTokenDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.communication.XpCommunicationDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.communication.XpFtpProxyConfigDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.communication.XpHttpProxyConfigDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.communication.XpLdapProxyConfigDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.communication.XpPingAllDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.communication.XpRetransmissionDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.database.XpDatabaseDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.display.XpDisplayDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.email.XpEmailDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.email.XpEmailInboundDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.email.XpEmailInboundProtocol;
import de.pontonconsulting.xmlpipe.config.model.messenger.email.XpEmailOutboundDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.email.XpEmailOutboundProtocol;
import de.pontonconsulting.xmlpipe.config.model.messenger.email.notification.XpCronExpressionDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.email.notification.XpEmailNotificationDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.email.notification.message.IXpSubjectElement;
import de.pontonconsulting.xmlpipe.config.model.messenger.email.notification.message.XpMessageEventReceiverDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.email.notification.message.XpSubjectElementTextDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.email.notification.message.XpSubjectElementVariableDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.email.notification.message.XpSubjectElementXPathDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.email.notification.message.XpVariable;
import de.pontonconsulting.xmlpipe.config.model.messenger.email.notification.system.XpSystemEventReceiverDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.listener.XpListenerConnectionDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.logging.XpLogLevel;
import de.pontonconsulting.xmlpipe.config.model.messenger.logging.XpLoggingDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.maintenance.XpMaintenanceDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.maintenance.XpMaintenancePeriodDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.messagequeue.XpMessageQueueDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.partnerregistry.XpPartnerRegistryDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.partnerregistry.XpPartnerRegistryUpdateDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.server.XpConnectorDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.server.XpServerDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.server.XpServerProtocol;
import de.pontonconsulting.xmlpipe.config.model.messenger.server.XpService;
import de.pontonconsulting.xmlpipe.config.model.messenger.timeserver.XpTimeServerDto;
import de.pontonconsulting.xmlpipe.messenger.MaintenanceManager;
import jakarta.xml.bind.JAXBException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Instant;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.datatype.XMLGregorianCalendar;

public class MessengerConfigLoader {
    private final MessengerConfig messengerConfig;
    private final IServerConfigBean serverConfig;
    private final MaintenanceManager maintenanceManager;

    public MessengerConfigLoader(MessengerConfig messengerConfig, IServerConfigBean serverConfig, MaintenanceManager maintenanceManager) {
        this.messengerConfig = messengerConfig;
        this.serverConfig = serverConfig;
        this.maintenanceManager = maintenanceManager;
    }

    public XpMessengerConfigurationDto getConfigurationDto() throws URISyntaxException, JAXBException, MalformedURLException {
        return new XpMessengerConfigurationDto().setArchive(this.getXpArchiveDto()).setCommunication(this.getXpCommunicationDto()).setDatabase(this.getXpDatabaseDto()).setEmail(this.getXpEmailDto()).setEmailNotification(this.getXpEmailNotificationDto()).setLogging(this.getXpLoggingDto()).setMaintenance(this.getXpMaintenanceDto()).setMessageQueue(this.getXpMessageQueueDto()).setPartnerRegistry(this.getXpPartnerRegistryDto()).setServer(this.getXpServerDto()).setTimeServer(this.getXpTimeServerDto()).setListenerConnection(this.getListenerConnections()).setAdapterApi(this.getAdapterApiDto()).setAuthenticationToken(this.getXpAuthenticationTokenDto()).setDisplay(this.getDisplayDto());
    }

    private List<XpListenerConnectionDto> getListenerConnections() {
        return this.messengerConfig.getXpListeners().stream().map(e -> {
            XpListenerConnectionDto dto = new XpListenerConnectionDto();
            dto.setEnabled(e.isEnabled());
            dto.setHost(e.getHost());
            dto.setPort(e.getPort());
            dto.setUseSsl(e.isSsl());
            dto.setNumberOfDataConnections(e.getDataConnectionCount());
            return dto;
        }).toList();
    }

    private XpAdapterApiDto getAdapterApiDto() {
        return new XpAdapterApiDto().setAdapterApiEnabled(this.serverConfig.isAdapterInterfaceEnabled()).setAdapterApiAddress(this.serverConfig.getAdapterInterfaceAddress()).setAdapterApiPort(this.serverConfig.getAdapterInterfacePort()).setAdapterApiTimeout(this.serverConfig.getAdapterInterfaceTimeout());
    }

    public XpArchiveDto getXpArchiveDto() throws JAXBException {
        XpCleanupDto archiveCleanup = this.messengerConfig.isDeleteArchive() ? new XpCleanupDto().setMaxAge(this.messengerConfig.getArchiveMaxAge()).setCleanupTime(this.convert(this.messengerConfig.getArchiveCleanupTime())).setCleanupMaxRuntime(this.messengerConfig.getArchiveCleanupMaxRuntime()) : null;
        EnumSet<XpMessagePart> archiveParts = EnumSet.noneOf(XpMessagePart.class);
        if (this.messengerConfig.isArchivePayload()) {
            archiveParts.add(XpMessagePart.PAYLOAD);
        }
        if (this.messengerConfig.isArchiveAttachments()) {
            archiveParts.add(XpMessagePart.ATTACHMENT);
        }
        if (this.messengerConfig.isArchiveSignature()) {
            archiveParts.add(XpMessagePart.SIGNATURE);
        }
        if (this.messengerConfig.isArchiveEbXml()) {
            archiveParts.add(XpMessagePart.PACKAGING_ENVELOPE);
        }
        if (this.messengerConfig.isArchiveBackendEnvelope()) {
            archiveParts.add(XpMessagePart.BACKEND_ENVELOPE);
        }
        if (this.messengerConfig.isArchiveCertificate()) {
            archiveParts.add(XpMessagePart.CERTIFICATE);
        }
        return new XpArchiveDto().setArchiveFolder(this.messengerConfig.getArchiveFolder()).setArchiveFailedFolder(this.messengerConfig.getArchiveFailedFolder()).setUseZipCompression(this.messengerConfig.isArchiveCompression()).setMessageParts(archiveParts).setArchiveCleanup(archiveCleanup).setArchiverType(this.messengerConfig.getArchiverType()).setAdapterId(this.messengerConfig.getArchiveAdapterId());
    }

    public XpTimeServerDto getXpTimeServerDto() throws JAXBException {
        List<String> ntpServerList = this.messengerConfig.getNtpServers().stream().map(this::ntpServerToString).filter(Objects::nonNull).collect(Collectors.toList());
        return new XpTimeServerDto().setEnabled(this.messengerConfig.isNtpEnabled()).setSyncInterval(this.messengerConfig.getNtpServerSynchronizeIntervalHours()).setNtpServers(ntpServerList);
    }

    public XpAuthenticationTokenDto getXpAuthenticationTokenDto() {
        return new XpAuthenticationTokenDto().setExpiration(this.messengerConfig.getJwtExpiration()).setRandomSecretAtRestart(this.messengerConfig.isRandomSecret()).setIgnoreIpAddress(this.messengerConfig.isJwtIgnoreIpAddress());
    }

    public XpDisplayDto getDisplayDto() {
        XpDisplayDto dto = new XpDisplayDto();
        if (this.maintenanceManager.isConfigError()) {
            dto.setMessengerName("MAINTENANCE MODE (ConfigError)").setColorAdjustment(150).setEnvironment(this.messengerConfig.getEnvironment());
        } else {
            dto.setMessengerName(this.messengerConfig.getMessengerName()).setColorAdjustment(this.messengerConfig.getColorAdjustment()).setEnvironment(this.messengerConfig.getEnvironment());
        }
        return dto;
    }

    private String ntpServerToString(NtpServer ntpServer) {
        StringBuilder stringBuilder = new StringBuilder(ntpServer.getHostname());
        if (ntpServer.getPort() > 0 && ntpServer.getPort() != 123) {
            stringBuilder.append(":");
            stringBuilder.append(ntpServer.getPort());
        }
        return stringBuilder.toString();
    }

    public XpServerDto getXpServerDto() {
        List<XpConnectorDto> connectors = this.serverConfig.getConnectors().values().stream().map(serverSettings -> {
            XpConnectorDto connectorDto = new XpConnectorDto().setPort(serverSettings.getPort());
            if (serverSettings.isSsl()) {
                connectorDto.setProtocol(XpServerProtocol.HTTPS);
            } else {
                connectorDto.setProtocol(XpServerProtocol.HTTP);
            }
            connectorDto.setServices(serverSettings.getServices().stream().map(XpService::valueOf).collect(Collectors.toCollection(() -> EnumSet.noneOf(XpService.class))));
            return connectorDto;
        }).collect(Collectors.toList());
        return new XpServerDto().setConnectors(connectors);
    }

    public XpPartnerRegistryDto getXpPartnerRegistryDto() throws MalformedURLException, JAXBException {
        if (this.messengerConfig.isRegistryConfigured()) {
            XpAuthenticationDto authenticationDto = new XpAuthenticationDto().setUsername(this.messengerConfig.getRegistryUsername()).setPassword(this.messengerConfig.getRegistryPassword());
            XpPartnerRegistryUpdateDto partnerRegistryUpdateDto = null;
            if (this.messengerConfig.isRegistryDownloadEnabled()) {
                partnerRegistryUpdateDto = new XpPartnerRegistryUpdateDto().setAuthentication(authenticationDto).setAutomaticPartnerCleanup(this.messengerConfig.isRegistryCleanUpEnabled()).setAutomaticPartnerCreation(this.messengerConfig.isRegistryPartnerCreationEnabled()).setAutomaticAgreementUpdates(this.messengerConfig.isAutomaticAgreementUpdateEnabled()).setDownloadInterval(this.messengerConfig.getRegistryDownloadInterval());
            }
            return new XpPartnerRegistryDto().setRegistryUrl(new URL(this.messengerConfig.getRegistryURL())).setPartnerRegistryUpdate(partnerRegistryUpdateDto);
        }
        return new XpPartnerRegistryDto();
    }

    public XpMessageQueueDto getXpMessageQueueDto() {
        XpMessageQueueDto messageQueueDto = new XpMessageQueueDto().setInboundQueueDeliveryTimeout((int)this.messengerConfig.getInboundQueueDeliveryTimeout() / 1000).setInboundQueueRetryDelay((int)this.messengerConfig.getInboundQueueRetryDelay() / 1000).setInboundQueueScanInterval((int)this.messengerConfig.getInboundQueueScanTime()).setOutboundQueueScanInterval((int)this.messengerConfig.getOutboundQueueScanTime());
        return messageQueueDto;
    }

    public XpMaintenanceDto getXpMaintenanceDto() {
        List<XpMaintenancePeriodDto> periodDtos = this.messengerConfig.getMaintenanceServices().stream().map(maintenanceService -> {
            OffsetDateTime startTime = OffsetDateTime.ofInstant(Instant.ofEpochMilli(maintenanceService.getStartTime()), ZoneOffset.UTC);
            OffsetDateTime endTime = OffsetDateTime.ofInstant(Instant.ofEpochMilli(maintenanceService.getEndTime()), ZoneOffset.UTC);
            return new XpMaintenancePeriodDto().setStartDate(startTime).setStartDate(startTime).setEndDate(endTime).setRejectIncomingMessages(maintenanceService.isRejectInboundMSGs()).setRejectOutgoingMessages(maintenanceService.isRejectOutboundMSGs()).setStopDeliveryToAdapters(maintenanceService.isTurnOffToAdapters()).setStopDeliveryToPartners(maintenanceService.isTurnOffToPartners());
        }).collect(Collectors.toList());
        return new XpMaintenanceDto().setMaintenancePeriod(periodDtos);
    }

    public XpLoggingDto getXpLoggingDto() throws JAXBException {
        return new XpLoggingDto().setJdbcLogLevel(XpLogLevel.valueOf(this.serverConfig.getJDBCLogLevel())).setMessengerLogLevel(XpLogLevel.valueOf(this.serverConfig.getMessengerLogLevel())).setLogOnlyErrorsInDb(this.messengerConfig.isDetailLogOnlyErrors()).setOkEventAge(this.messengerConfig.getOkEventAge());
    }

    public XpEmailNotificationDto getXpEmailNotificationDto() throws JAXBException {
        List<XpSystemEventReceiverDto> systemEventReceiverDtoList = this.messengerConfig.getSystemEventReceivers().stream().map(r -> new XpSystemEventReceiverDto().setEmail(r.getEmail()).setSubject(r.getSubject()).setMessageEventIds(r.getEvents().stream().map(SystemEvent::getCode).collect(Collectors.toList()))).collect(Collectors.toList());
        List<XpMessageEventReceiverDto> messageEventReceiverDtoList = this.messengerConfig.getNotificationReceivers().stream().map(notificationReceiver -> {
            List<IXpSubjectElement> subjectElementList = notificationReceiver.getSubjectElements().stream().map(this::mapToXpSubjectElement).collect(Collectors.toList());
            List<Integer> eventIdList = Arrays.stream(notificationReceiver.getEvents()).boxed().collect(Collectors.toList());
            return new XpMessageEventReceiverDto().setEmail(notificationReceiver.getEmail()).setWithHtmlAttachment(notificationReceiver.isWithAttachement()).setSubjectElements(subjectElementList).setMessageEventIds(eventIdList);
        }).collect(Collectors.toList());
        List<XpCronExpressionDto> cronExpressionDtoList = this.messengerConfig.getEMailSendSettings().stream().map(eMailSendSetting -> new XpCronExpressionDto().setCronExpression(eMailSendSetting.getCronExpression()).setMaxNotificationPerMail(eMailSendSetting.getEmailMaxCount())).collect(Collectors.toList());
        return new XpEmailNotificationDto().setCronExpressions(cronExpressionDtoList).setMessageEventReceivers(messageEventReceiverDtoList).setSystemEventReceivers(systemEventReceiverDtoList);
    }

    private IXpSubjectElement mapToXpSubjectElement(SubjectElement subjectElement) {
        switch (subjectElement.getType()) {
            case 1: {
                return new XpSubjectElementVariableDto().setValue(XpVariable.valueOfXmlName(subjectElement.getVariable()));
            }
            case 3: {
                return new XpSubjectElementTextDto().setValue(subjectElement.getText());
            }
            case 2: {
                return new XpSubjectElementXPathDto().setValue(subjectElement.getXpath());
            }
        }
        throw new IllegalArgumentException("unknown subject element type");
    }

    public XpEmailDto getXpEmailDto() throws URISyntaxException, JAXBException {
        XpEmailDto emailDto = new XpEmailDto();
        if (StringUtils.isNotBlank((CharSequence)this.messengerConfig.getMailServerHost()) && this.messengerConfig.getMailPollInterval() > 0) {
            XpAuthenticationDto auth = new XpAuthenticationDto().setUsername(this.messengerConfig.getMailServerUser()).setPassword(this.messengerConfig.getMailServerPassword());
            XpEmailInboundDto emailInboundDto = new XpEmailInboundDto().setAuthentication(auth).setInterval(this.messengerConfig.getMailPollInterval()).setInboxFolderName(this.messengerConfig.getMailInboxFolder()).setProtocol(XpEmailInboundProtocol.valueOfXmlName(this.messengerConfig.getMailServerProtocolName())).setHost(new URI(this.messengerConfig.getMailServerHost()));
            emailDto.setInbound(emailInboundDto);
        }
        if (StringUtils.isNotBlank((CharSequence)this.messengerConfig.getSmtpServerHost())) {
            XpEmailOutboundDto emailOutboundDto = new XpEmailOutboundDto();
            if (StringUtils.isNotBlank((CharSequence)this.messengerConfig.getSmtpUser())) {
                emailOutboundDto.setAuthentication(new XpAuthenticationDto().setUsername(this.messengerConfig.getSmtpUser()).setPassword(this.messengerConfig.getSmtpPassword()));
            }
            emailOutboundDto.setProtocol(XpEmailOutboundProtocol.valueOfXmlName(this.messengerConfig.getSmtpServerProtocolName()));
            emailOutboundDto.setHost(new URI(this.messengerConfig.getSmtpServerHost()));
            emailOutboundDto.setFrom(this.messengerConfig.getSmtpFromAddress());
            emailDto.setOutbound(emailOutboundDto);
        }
        return emailDto;
    }

    public XpDatabaseDto getXpDatabaseDto() throws JAXBException {
        XpCleanupDto databaseCleanup = this.messengerConfig.isDeleteDatabase() ? new XpCleanupDto().setMaxAge(this.messengerConfig.getDatabaseMaxAge()).setCleanupTime(this.convert(this.messengerConfig.getDatabaseCleanupTime())).setCleanupMaxRuntime(this.messengerConfig.getDatabaseCleanupMaxRuntime()) : null;
        return new XpDatabaseDto().setDatabaseCleanup(databaseCleanup);
    }

    public XpCommunicationDto getXpCommunicationDto() throws JAXBException {
        XpRetransmissionDto retransmissionDto = new XpRetransmissionDto().setNumberOfRetries(this.messengerConfig.getDefaultRetransmissionRetries()).setRetryInterval(this.messengerConfig.getDefaultRetransmissionRetryInterval());
        XpPingAllDto pingAllDto = new XpPingAllDto().setPingAll(this.messengerConfig.isPingAllEnabled()).setPingAllInterval(this.messengerConfig.getPingAllInterval());
        XpCommunicationDto communicationDto = new XpCommunicationDto().setRetransmission(retransmissionDto).setAllowLoopback(this.messengerConfig.isLoopback()).setMessageIdDomain(this.messengerConfig.getMessageIdDomain()).setRequeueFailedMessages(this.messengerConfig.isRequeueFailedMessagesEnabled()).setPartnerCertificateRevocationCheck(this.messengerConfig.isPartnerCertificateRevocationCheckEnabled()).setCheckSslServerCert(this.messengerConfig.isSSLCertificateCheck()).setPingAll(pingAllDto).setDefaultAdapter(this.messengerConfig.getDefaultAdapterId());
        if (StringUtils.isNotBlank((CharSequence)this.messengerConfig.getLdapProxyHost())) {
            XpLdapProxyConfigDto ldapProxyConfigDto = new XpLdapProxyConfigDto().setHost(this.messengerConfig.getLdapProxyHost()).setPort(this.messengerConfig.getLdapProxyPort());
            communicationDto.setLdapProxyConfig(ldapProxyConfigDto);
        }
        if (StringUtils.isNotBlank((CharSequence)this.messengerConfig.getFtpProxyHost())) {
            XpFtpProxyConfigDto ftpProxyConfigDto = new XpFtpProxyConfigDto().setHost(this.messengerConfig.getFtpProxyHost()).setPort(this.messengerConfig.getFtpProxyPort());
            if (StringUtils.isNotBlank((CharSequence)this.messengerConfig.getFtpProxyUser())) {
                ftpProxyConfigDto.setAuthentication(new XpAuthenticationDto().setUsername(this.messengerConfig.getFtpProxyUser()).setPassword(this.messengerConfig.getFtpProxyPassword()));
            }
            communicationDto.setFtpProxyConfig(ftpProxyConfigDto);
        }
        if (StringUtils.isNotBlank((CharSequence)this.messengerConfig.getProxyHost())) {
            XpHttpProxyConfigDto httpProxyConfigDto = new XpHttpProxyConfigDto().setHost(this.messengerConfig.getProxyHost()).setPort(this.messengerConfig.getProxyPort());
            if (StringUtils.isNotBlank((CharSequence)this.messengerConfig.getProxyUser())) {
                httpProxyConfigDto.setAuthentication(new XpAuthenticationDto().setUsername(this.messengerConfig.getProxyUser()).setPassword(this.messengerConfig.getProxyPassword()));
            }
            httpProxyConfigDto.setNtDomain(this.messengerConfig.getProxyDomain());
            httpProxyConfigDto.setBypassProxyFor(this.messengerConfig.getProxyBypassList());
            communicationDto.setHttpProxyConfig(httpProxyConfigDto);
        }
        return communicationDto;
    }

    private LocalTime convert(XMLGregorianCalendar xmlTime) {
        return xmlTime == null ? null : LocalTime.of(xmlTime.getHour(), xmlTime.getMinute(), xmlTime.getSecond());
    }
}

