/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.config;

import de.pontonconsulting.common.encoding.Base64Decoder;
import de.pontonconsulting.common.encoding.Base64Encoder;
import de.pontonconsulting.common.security.IPasswordCrypt;
import de.pontonconsulting.xmlpipe.config.ConfigResourceService;
import de.pontonconsulting.xmlpipe.config.EMailSendSetting;
import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.config.NotificationReceiver;
import de.pontonconsulting.xmlpipe.config.SubjectElement;
import de.pontonconsulting.xmlpipe.config.SystemEvent;
import de.pontonconsulting.xmlpipe.config.SystemEventReceiver;
import de.pontonconsulting.xmlpipe.config.XpValidationEventHandler;
import de.pontonconsulting.xmlpipe.config.messenger.ArchiveSetting;
import de.pontonconsulting.xmlpipe.config.messenger.ArchiverType;
import de.pontonconsulting.xmlpipe.config.messenger.AuthenticationType;
import de.pontonconsulting.xmlpipe.config.messenger.DownloadIntervalType;
import de.pontonconsulting.xmlpipe.config.messenger.EnvironmentType;
import de.pontonconsulting.xmlpipe.config.messenger.MailServerType;
import de.pontonconsulting.xmlpipe.config.messenger.Messenger;
import de.pontonconsulting.xmlpipe.config.messenger.NotificationSubjectElementType;
import de.pontonconsulting.xmlpipe.config.messenger.NtpServer;
import de.pontonconsulting.xmlpipe.config.messenger.ObjectFactory;
import de.pontonconsulting.xmlpipe.config.messenger.PasswordEncryptionType;
import de.pontonconsulting.xmlpipe.config.messenger.SmtpServerType;
import de.pontonconsulting.xmlpipe.config.model.messenger.archive.XpArchiverType;
import de.pontonconsulting.xmlpipe.messenger.MaintenanceService;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerConfigDAO;
import de.pontonconsulting.xmlpipe.util.XMLGregorianCalendarConverter;
import jakarta.annotation.PostConstruct;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEventHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessengerConfig
implements IMessengerProperties {
    public static final String PROPERTY_AS4_CERTUPDATE_ACTIVATE_BY_IN_SECONDS = "ponton.messenger.cert_update_activate_by_in_seconds";
    public static final String PROPERTY_AS4_CERTUPDATE_SCHEDULER_INTERVAL_IN_SECONDS = "ponton.messenger.cert_update_scheduler_interval_in_seconds";
    private static final String PROPERTY_DEVELOPER_MODE = "ponton.messenger.developermode";
    private static final String DEFAULT_DEVELOPER_MODE = "false";
    private static final String FILE_NAME = "ponton-messenger.properties";
    private static final String CUSTOM_FILE_NAME = "ponton-messenger-custom.properties";
    private static final String PROPERTY_WEBSOCKET_EXECUTOR_CORE_POOL_SIZE = "ponton.messenger.websocket.executor.core_pool_size";
    private static final String DEFAULT_WEBSOCKET_EXECUTOR_CORE_POOL_SIZE = "2";
    private static final String PROPERTY_WEBSOCKET_EXECUTOR_MAX_POOL_SIZE = "ponton.messenger.websocket.executor.max_pool_size";
    private static final String DEFAULT_WEBSOCKET_EXECUTOR_MAX_POOL_SIZE = "100";
    private static final String PROPERTY_WEBSOCKET_EXECUTOR_MAX_QUEUE_SIZE = "ponton.messenger.websocket.executor.max_queue_size";
    private static final String DEFAULT_WEBSOCKET_EXECUTOR_MAX_QUEUE_SIZE = "100";
    private static final String PROPERTY_OUTBOUND_QUEUE_EXECUTOR_CORE_POOL_SIZE = "ponton.messenger.outbound_queue.executor.core_pool_size";
    private static final String DEFAULT_OUTBOUND_QUEUE_EXECUTOR_CORE_POOL_SIZE = "1";
    private static final String PROPERTY_OUTBOUND_QUEUE_EXECUTOR_MAX_POOL_SIZE = "ponton.messenger.outbound_queue.executor.max_pool_size";
    private static final String DEFAULT_OUTBOUND_QUEUE_EXECUTOR_MAX_POOL_SIZE = "100";
    public static final String PROPERTY_MESSENGER_REST_HSTS = "ponton.messenger.rest.hsts";
    private static final String PROPERTY_INBOUND_QUEUE_EXECUTOR_CORE_POOL_SIZE = "ponton.messenger.inbound_queue.executor.core_pool_size";
    private static final String DEFAULT_INBOUND_QUEUE_EXECUTOR_CORE_POOL_SIZE = "1";
    private static final String PROPERTY_INBOUND_QUEUE_EXECUTOR_MAX_POOL_SIZE = "ponton.messenger.inbound_queue.executor.max_pool_size";
    private static final String DEFAULT_INBOUND_QUEUE_EXECUTOR_MAX_POOL_SIZE = "100";
    private final Logger log = LogManager.getLogger((String)("Messenger." + this.getClass().getSimpleName()));
    private final ConfigResourceService configResourceService;
    private final Properties mergedProperties = new Properties();
    String DUMMY_CALLBAK_SERVER_NAME = "listener-machine";
    long DEFAULT_INBOUNDQUEUE_SCANTIME = 5000L;
    long DEFAULT_INBOUNDQUEUE_DELIVERYTIMEOUT = 300000L;
    long DEFAULT_INBOUNDQUEUE_RETRYDELAY = 60000L;
    public static final long DEFAULT_OUTBOUNDQUEUE_SCANTIME = 5000L;
    public static boolean DEFAULT_SSL_CERTCHECK = false;
    public static String DEFAULT_SUBJECT_ELEMENT_VARIABLE = "MessageTime";
    private static final String DEFAULT_PARTNER_REGISTRY_URI = "https://xpregistry.ponton.de/registry/files/";
    private static final String PROPERTY_PARTNER_REGISTRY_URI = "ponton.messenger.partnerregistry";
    private static final String DEFAULT_CSR_EMAIL = "xp-cert@ponton.de";
    private static final String PROPERTY_CSR_EMAIL = "ponton.messenger.csr.email";
    private static final String DEFAULT_TRANSMISSION_INSIDE_FULL_INTERVAL = "false";
    private static final String PROPERTY_TRANSMISSION_INSIDE_FULL_INTERVAL = "ponton.messenger.transmission_inside_full_interval";
    private static final String DEFAULT_IGNORE_MAINTENANCE_HTTP_HEADER = "false";
    private static final String PROPERTY_IGNORE_MAINTENANCE_HTTP_HEADER = "ponton.messenger.ignore_maintenance_http_header";
    private static final String DEFAULT_TTL_ON_FIRST_SEND = "true";
    private static final String PROPERTY_TTL_ON_FIRST_SEND = "ponton.messenger.ttl_on_first_send";
    private static final String PROPERTY_CLUSTER_MACHINEID = "ponton.messenger.cluster.machineid";
    private static final Logger _log = LogManager.getLogger((String)"Messenger.MessengerConfig");
    public static final String MESSENGER_CONFIG_CLASSES = "de.pontonconsulting.xmlpipe.config.messenger";
    public static final String BDEW_CSR_ORG = "ponton.messenger.bdew.csr.org";
    public static final String BDEW_CSR_CN_EXTENSION_SUFFIX = "ponton.messenger.bdew.csr.suffix";
    public static final String BDEW_LDAP_ROOT_CA_URL = "ldap.rootCA.url";
    public static final String BDEW_LDAP_ROOT_CA_BASE_DN = "ldap.rootCA.baseDN";
    public static final String CERTIFICATE_SWITCH_DAYS_BEFORE_EXPIRY = "ponton.messenger.certificate.switch.days_before_expiry";
    public static final String BDEW_CSR_SIGNATURE_ALGORITHM = "ponton.messenger.bdew.csr.signature.algorithm";
    public static final String HTTP_CLIENT_USE_HTTP_1_1_ONLY = "ponton.messenger.http_client.use_http_1_1_only";
    public static final String MESSENGER_DOCUMENTATION_URL = "ponton.messenger.help.url.messenger_documentation";
    public static final String RELEASE_NOTES_URL = "ponton.messenger.help.url.release_notes";
    public static final String SYSTEM_REQUIREMENTS_URL = "ponton.messenger.help.url.system_requirements";
    public static final String BACKEND_INTEGRATION_GUIDE_URL = "ponton.messenger.help.url.backend_integration_guide";
    public static final String ADAPTER_PROGRAMMING_GUIDE_URL = "ponton.messenger.help.url.adapter_programming_guide";
    public static final String SUPPORT_URL = "ponton.messenger.help.url.support";
    public static final String PRODUCT_PAGE_URL = "ponton.messenger.help.url.product_page";
    private static final byte[] CRYPTED_PW_IDENTIFIER = new byte[]{0, -1, 0};
    private final File _configFile;
    private Messenger _messenger;
    private final IPasswordCrypt _passwordCrypt;
    private Integer _messengerId;
    private boolean _clusterEnabled;
    private boolean _setTtlOnFirstSend;
    private boolean _ignoreMaintenanceHttpHeader;
    private boolean _transmissionInsideFullInterval;
    private String defaultCertificateRequestEmail;
    private String defaultRegistryURL;
    private final ObjectFactory _factory = new ObjectFactory();
    private final JAXBContext jc;
    private final MessengerConfigDAO messengerConfigDAO;

    public MessengerConfig(ConfigResourceService configResourceService, IServerConfigBean serverConfig, IPasswordCrypt passwordCrypt, MessengerConfigDAO messengerConfigDAO) throws JAXBException {
        this.configResourceService = configResourceService;
        this._configFile = new File(serverConfig.getConfigFolder(), "messenger.xml");
        this.messengerConfigDAO = messengerConfigDAO;
        this.jc = JAXBContext.newInstance((String)MESSENGER_CONFIG_CLASSES);
        this._passwordCrypt = passwordCrypt;
        this.loadConfigToMemory();
        this.checkForNtpServers();
    }

    @PostConstruct
    public void init() throws JAXBException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        this.reloadProperties();
        this.logMessengerProperties(this.mergedProperties);
        this._clusterEnabled = false;
        String clusterMachineId = this.getProperty(PROPERTY_CLUSTER_MACHINEID);
        if (Objects.nonNull(clusterMachineId)) {
            this._messengerId = Integer.parseInt(clusterMachineId);
        }
        this._setTtlOnFirstSend = Boolean.parseBoolean(this.getProperty(PROPERTY_TTL_ON_FIRST_SEND, DEFAULT_TTL_ON_FIRST_SEND));
        this._ignoreMaintenanceHttpHeader = Boolean.parseBoolean(this.getProperty(PROPERTY_IGNORE_MAINTENANCE_HTTP_HEADER, "false"));
        this._transmissionInsideFullInterval = Boolean.parseBoolean(this.getProperty(PROPERTY_TRANSMISSION_INSIDE_FULL_INTERVAL, "false"));
        this.defaultCertificateRequestEmail = this.getProperty(PROPERTY_CSR_EMAIL, DEFAULT_CSR_EMAIL);
        this.defaultRegistryURL = this.getProperty(PROPERTY_PARTNER_REGISTRY_URI, DEFAULT_PARTNER_REGISTRY_URI);
        this.getProxyPassword();
        this.getFtpProxyPassword();
        this.getSmtpPassword();
        this.getMailServerPassword();
        this.getRegistryPassword();
        this.getJwtSecret();
    }

    public void loadConfigToMemory() throws JAXBException {
        if (this._configFile.exists() && !this.messengerConfigDAO.doesMessengerConfigExist("messenger.xml")) {
            try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(this._configFile.toPath(), new OpenOption[0]));){
                this.messengerConfigDAO.storeMessengerConfig(inputStream.readAllBytes(), "messenger.xml", "SYSTEM");
            }
            catch (IOException e) {
                throw new JAXBException("Configuration file '" + String.valueOf(this._configFile) + "' could not be read: " + e.getMessage());
            }
            try {
                Files.delete(this._configFile.toPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Unmarshaller u = this.jc.createUnmarshaller();
        XpValidationEventHandler validation = new XpValidationEventHandler();
        de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerConfig messengerConfig = this.messengerConfigDAO.loadMessengerConfig("messenger.xml");
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(messengerConfig.getData());){
            u.setEventHandler((ValidationEventHandler)validation);
            this._messenger = (Messenger)u.unmarshal((InputStream)inputStream);
        }
        catch (JAXBException jaxb) {
            if (validation.getMessage() != null) {
                throw new JAXBException("Xml Error (Line:" + validation.getLine() + " / Column:" + validation.getColumn() + ") " + validation.getMessage());
            }
            throw jaxb;
        }
        catch (IOException e) {
            throw new JAXBException(e.getMessage(), (Throwable)e);
        }
    }

    private void checkForNtpServers() {
        try {
            ArrayList<de.pontonconsulting.xmlpipe.config.NtpServer> ntpServers = this.getNtpServers();
            if (ntpServers == null) {
                if (this.getNtpServerSynchronizeIntervalHours() <= 0) {
                    this.setNtpServerSynchronizeIntervalHours(24);
                }
                ntpServers = new ArrayList();
                ntpServers.add(new de.pontonconsulting.xmlpipe.config.NtpServer("clock.isc.org"));
                ntpServers.add(new de.pontonconsulting.xmlpipe.config.NtpServer("tick.usno.navy.mil"));
                ntpServers.add(new de.pontonconsulting.xmlpipe.config.NtpServer("bonehed.lcs.mit.edu"));
                ntpServers.add(new de.pontonconsulting.xmlpipe.config.NtpServer("ptbtime1.ptb.de"));
                ntpServers.add(new de.pontonconsulting.xmlpipe.config.NtpServer("ntps1-0.cs.tu-berlin.de"));
                ntpServers.add(new de.pontonconsulting.xmlpipe.config.NtpServer("ntp0.fau.de"));
                this.setNtpServers(ntpServers);
                this.saveConfigFromMemory();
            }
        }
        catch (Exception e) {
            _log.warn(e.getMessage());
        }
    }

    public void update() throws JAXBException {
        this.saveConfigFromMemory("SYSTEM");
    }

    public void update(String username) throws JAXBException {
        this.saveConfigFromMemory(username);
    }

    private void saveConfigFromMemory() throws JAXBException {
        this.saveConfigFromMemory("SYSTEM");
    }

    private void saveConfigFromMemory(String username) throws JAXBException {
        Marshaller m = this.jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.setProperty("jaxb.encoding", (Object)"UTF-8");
        XpValidationEventHandler validationEventHandler = new XpValidationEventHandler();
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            m.setEventHandler((ValidationEventHandler)validationEventHandler);
            m.marshal((Object)this._messenger, (OutputStream)bos);
            this.messengerConfigDAO.storeMessengerConfig(bos.toByteArray(), "messenger.xml", username);
        }
        catch (JAXBException e) {
            if (validationEventHandler.getMessage() != null) {
                JAXBException je = new JAXBException("Xml Error (" + validationEventHandler.getLine() + ", " + validationEventHandler.getColumn() + "): " + validationEventHandler.getMessage());
                je.setStackTrace(e.getStackTrace());
                throw je;
            }
            throw e;
        }
        catch (IOException e1) {
            throw new JAXBException("Configuration could not be written: " + e1.getMessage());
        }
    }

    private void logMessengerProperties(Properties properties) {
        new TreeMap<Object, Object>(properties).forEach((key, value) -> this.log.trace("MessengerProperty: {} = {}", key, value));
    }

    @Override
    public void storeMergedProperties(File file) throws IOException {
        try (BufferedOutputStream fileOutputStream = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
            this.mergedProperties.store(fileOutputStream, "Generated by Ponton XP");
        }
    }

    private void reloadProperties() {
        block18: {
            this.mergedProperties.clear();
            try {
                AtomicReference<String> environment = new AtomicReference<String>(this.getEnvironment().value());
                ArrayList allURLs = new ArrayList(this.configResourceService.getResources(FILE_NAME).entrySet().stream().toList());
                ArrayList envResourceURLs = new ArrayList(this.configResourceService.getResources("ponton-messenger.properties_" + environment.get()).entrySet().stream().toList());
                if (EnvironmentType.TEST.equals((Object)this.getEnvironment()) && envResourceURLs.isEmpty()) {
                    envResourceURLs.addAll(this.configResourceService.getResources("ponton-messenger.properties_" + EnvironmentType.PRODUCTION.value()).entrySet().stream().toList());
                    environment.set(EnvironmentType.PRODUCTION.value());
                }
                envResourceURLs.forEach(envURL -> {
                    for (int i = 0; i < allURLs.size(); ++i) {
                        Map.Entry url = (Map.Entry)allURLs.get(i);
                        if (!(String.valueOf(url.getKey()) + "_" + (String)environment.get()).equals(((URI)envURL.getKey()).toString())) continue;
                        allURLs.add(i, envURL);
                        break;
                    }
                });
                for (int i = allURLs.size() - 1; i >= 0; --i) {
                    try (InputStream inputStream = (InputStream)((Map.Entry)allURLs.get(i)).getValue();){
                        this.addedProperties(inputStream);
                        continue;
                    }
                }
            }
            catch (IOException environment) {
                // empty catch block
            }
            try {
                Map.Entry<URI, InputStream> resourceAsStream = this.configResourceService.getResource(CUSTOM_FILE_NAME);
                if (resourceAsStream == null || resourceAsStream.getValue() == null) break block18;
                try (InputStream inputStream = resourceAsStream.getValue();){
                    this.addedProperties(inputStream);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void addedProperties(InputStream resourceURL) throws IOException {
        Properties resourceProperties = new Properties();
        resourceProperties.load(resourceURL);
        this.mergedProperties.putAll((Map<?, ?>)resourceProperties);
        this.log.info("Added messenger properties from {}", (Object)resourceURL);
    }

    @Override
    public boolean isDeveloperMode() {
        return Boolean.parseBoolean(this.getProperty(PROPERTY_DEVELOPER_MODE, "false"));
    }

    @Override
    public int getWebsocketExecutorCorePoolSize() {
        return Integer.parseInt(this.getProperty(PROPERTY_WEBSOCKET_EXECUTOR_CORE_POOL_SIZE, DEFAULT_WEBSOCKET_EXECUTOR_CORE_POOL_SIZE));
    }

    @Override
    public int getWebsocketExecutorMaxPoolSize() {
        return Integer.parseInt(this.getProperty(PROPERTY_WEBSOCKET_EXECUTOR_MAX_POOL_SIZE, "100"));
    }

    @Override
    public int getWebsocketExecutorMaxQueueSize() {
        return Integer.parseInt(this.getProperty(PROPERTY_WEBSOCKET_EXECUTOR_MAX_QUEUE_SIZE, "100"));
    }

    @Override
    public int getOutboundQueueExecutorCorePoolSize() {
        return Integer.parseInt(this.getProperty(PROPERTY_OUTBOUND_QUEUE_EXECUTOR_CORE_POOL_SIZE, "1"));
    }

    @Override
    public int getOutboundQueueExecutorMaxPoolSize() {
        return Integer.parseInt(this.getProperty(PROPERTY_OUTBOUND_QUEUE_EXECUTOR_MAX_POOL_SIZE, "100"));
    }

    @Override
    public int getInboundQueueExecutorCorePoolSize() {
        return Integer.parseInt(this.getProperty(PROPERTY_INBOUND_QUEUE_EXECUTOR_CORE_POOL_SIZE, "1"));
    }

    @Override
    public int getInboundQueueExecutorMaxPoolSize() {
        return Integer.parseInt(this.getProperty(PROPERTY_INBOUND_QUEUE_EXECUTOR_MAX_POOL_SIZE, "100"));
    }

    @Override
    public String getProperty(String key) {
        return this.mergedProperties.getProperty(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.mergedProperties.getProperty(key, defaultValue);
    }

    public boolean isTtlOnFirstSend() {
        return this._setTtlOnFirstSend;
    }

    public boolean isIgnoreMaintenanceHttpHeader() {
        return this._ignoreMaintenanceHttpHeader;
    }

    public boolean isTransmissionInsideFullInterval() {
        return this._transmissionInsideFullInterval;
    }

    public boolean isDetailLogOnlyErrors() throws JAXBException {
        Messenger.LogSettings.DetailLog detail = this._messenger.getLogSettings().getDetailLog();
        if (detail == null) {
            return false;
        }
        return detail.isOnlyErrors();
    }

    public String getMessageIdDomain() throws JAXBException {
        return this._messenger.getMessageIdDomain();
    }

    public void setMessageIdDomain(String domain) {
        this._messenger.setMessageIdDomain(domain);
    }

    public boolean isSSLCertificateCheck() throws JAXBException {
        Boolean bool = this._messenger.isSSLCertificateCheck();
        if (bool == null) {
            return DEFAULT_SSL_CERTCHECK;
        }
        return bool;
    }

    public void setSSLCertificateCheck(boolean certCheck) {
        this._messenger.setSSLCertificateCheck(Boolean.valueOf(certCheck));
    }

    public int getDatabaseMaxAge() {
        return this._messenger.getLogSettings().getMaximumAge().getValue();
    }

    public XMLGregorianCalendar getDatabaseCleanupTime() throws JAXBException {
        XMLGregorianCalendar cleanupTime = this._messenger.getLogSettings().getCleanupTime();
        if (Objects.isNull(cleanupTime)) {
            try {
                return DatatypeFactory.newInstance().newXMLGregorianCalendarTime(3, 0, 0, Integer.MIN_VALUE);
            }
            catch (DatatypeConfigurationException e) {
                return null;
            }
        }
        return cleanupTime;
    }

    public String getDatabaseCleanupTimeAsString() {
        XMLGregorianCalendar cleanupTime;
        XMLGregorianCalendar xMLGregorianCalendar = cleanupTime = Objects.isNull(this._messenger.getLogSettings()) ? null : this._messenger.getLogSettings().getCleanupTime();
        if (Objects.isNull(cleanupTime)) {
            return "03:00:00";
        }
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
        return format.format(cleanupTime.toGregorianCalendar().getTime());
    }

    public void setDatabaseCleanUpTime(String deleteTime) {
        if (StringUtils.isBlank((CharSequence)deleteTime)) {
            return;
        }
        if (Objects.isNull(this._messenger.getLogSettings())) {
            this._messenger.setLogSettings(this._factory.createMessengerLogSettings());
        }
        try {
            XMLGregorianCalendar cleanupTime = XMLGregorianCalendarConverter.asXMLGregorianCalendar(deleteTime);
            this._messenger.getLogSettings().setCleanupTime(cleanupTime);
        }
        catch (DatatypeConfigurationException ex) {
            _log.error(ex.getMessage());
        }
    }

    public int getDatabaseCleanupMaxRuntime() {
        Integer maxRuntime = Objects.isNull(this._messenger.getLogSettings()) ? null : this._messenger.getLogSettings().getCleanupMaxRuntime();
        return Objects.isNull(maxRuntime) ? 0 : maxRuntime;
    }

    public void setDatabaseCleanupMaxRuntime(int databaseCleanupMaxRuntime) {
        if (Objects.isNull(this._messenger.getLogSettings())) {
            this._messenger.setLogSettings(this._factory.createMessengerLogSettings());
        }
        this._messenger.getLogSettings().setCleanupMaxRuntime(Integer.valueOf(databaseCleanupMaxRuntime));
    }

    public void setDatabaseMaxAge(int days) {
        if (Objects.isNull(this._messenger.getLogSettings())) {
            this._messenger.setLogSettings(this._factory.createMessengerLogSettings());
        }
        if (Objects.isNull(this._messenger.getLogSettings().getMaximumAge())) {
            this._messenger.getLogSettings().setMaximumAge(this._factory.createMessengerLogSettingsMaximumAge());
        }
        this._messenger.getLogSettings().getMaximumAge().setValue(days);
    }

    public boolean isDeleteArchive() throws JAXBException {
        Messenger.Archiving.MaximumAge maximumAge = this._messenger.getArchiving().getMaximumAge();
        if (maximumAge == null) {
            return false;
        }
        return maximumAge.isEnabled();
    }

    public boolean isArchiveCleanupConfigured() {
        return Objects.nonNull(this._messenger.getArchiving().getMaximumAge());
    }

    public boolean isDeleteDatabase() throws JAXBException {
        if (Objects.isNull(this._messenger.getLogSettings()) || Objects.isNull(this._messenger.getLogSettings().getMaximumAge())) {
            return false;
        }
        return this._messenger.getLogSettings().getMaximumAge().isEnabled();
    }

    public boolean isDeleteDatabaseConfigured() {
        return Objects.nonNull(this._messenger.getLogSettings()) && Objects.nonNull(this._messenger.getLogSettings().getMaximumAge());
    }

    public void setDeleteDatabase(boolean deleteDatabase) {
        if (Objects.isNull(this._messenger.getLogSettings())) {
            this._messenger.setLogSettings(this._factory.createMessengerLogSettings());
        }
        if (Objects.isNull(this._messenger.getLogSettings().getMaximumAge())) {
            this._messenger.getLogSettings().setMaximumAge(this._factory.createMessengerLogSettingsMaximumAge());
        }
        this._messenger.getLogSettings().getMaximumAge().setEnabled(Boolean.valueOf(deleteDatabase));
    }

    public int getArchiveMaxAge() {
        Messenger.Archiving.MaximumAge maximumAge = this._messenger.getArchiving().getMaximumAge();
        if (Objects.isNull(maximumAge)) {
            return this.getDatabaseMaxAge();
        }
        return maximumAge.getValue();
    }

    public List<EMailSendSetting> getEMailSendSettings() throws JAXBException {
        List sendSettings = this._messenger.getLogSettings().getEmailNotification().getSendSetting();
        ArrayList<EMailSendSetting> emailSendSettings = new ArrayList<EMailSendSetting>(sendSettings.size());
        for (Messenger.LogSettings.EmailNotification.SendSetting sendSetting : sendSettings) {
            EMailSendSetting emailSendSetting = new EMailSendSetting(sendSetting.getCronExpression(), sendSetting.getEmailMaxCount());
            emailSendSettings.add(emailSendSetting);
        }
        return emailSendSettings;
    }

    public void setEMailSendSettings(List<EMailSendSetting> emailSendSettings) {
        List sendSettings = this._messenger.getLogSettings().getEmailNotification().getSendSetting();
        sendSettings.clear();
        for (EMailSendSetting emailSendSetting : emailSendSettings) {
            Messenger.LogSettings.EmailNotification.SendSetting sendSetting = new Messenger.LogSettings.EmailNotification.SendSetting();
            sendSetting.setCronExpression(emailSendSetting.getCronExpression());
            sendSetting.setEmailMaxCount(Integer.valueOf(emailSendSetting.getEmailMaxCount()));
            sendSettings.add(sendSetting);
        }
    }

    public void setSystemEventReceivers(List<SystemEventReceiver> systemEventReceivers) {
        List jaxbEventReceivers = this._messenger.getLogSettings().getEmailNotification().getSystemEventReceiver();
        jaxbEventReceivers.clear();
        for (SystemEventReceiver systemEventReceiver : systemEventReceivers) {
            Messenger.LogSettings.EmailNotification.SystemEventReceiver jaxbEventReceiver = new Messenger.LogSettings.EmailNotification.SystemEventReceiver();
            jaxbEventReceiver.setEmail(systemEventReceiver.getEmail());
            jaxbEventReceiver.setSubject(systemEventReceiver.getSubject());
            for (SystemEvent systemEvent : systemEventReceiver.getEvents()) {
                jaxbEventReceiver.getEventCode().add(systemEvent.getCode());
            }
            jaxbEventReceivers.add(jaxbEventReceiver);
        }
    }

    public List<SystemEventReceiver> getSystemEventReceivers() throws JAXBException {
        List jaxbReceivers = this._messenger.getLogSettings().getEmailNotification().getSystemEventReceiver();
        ArrayList<SystemEventReceiver> systemEventReceivers = new ArrayList<SystemEventReceiver>(jaxbReceivers.size());
        for (Messenger.LogSettings.EmailNotification.SystemEventReceiver jaxbReceiver : jaxbReceivers) {
            List codes = jaxbReceiver.getEventCode();
            ArrayList<SystemEvent> systemEvents = new ArrayList<SystemEvent>(codes.size());
            for (Integer code : codes) {
                systemEvents.add(SystemEvent.getSystemEvent(code));
            }
            systemEventReceivers.add(new SystemEventReceiver(jaxbReceiver.getEmail(), jaxbReceiver.getSubject(), systemEvents));
        }
        Collections.sort(systemEventReceivers, new Comparator<SystemEventReceiver>(this){

            @Override
            public int compare(SystemEventReceiver r1, SystemEventReceiver r2) {
                return r1.getEmail().compareToIgnoreCase(r2.getEmail());
            }
        });
        return systemEventReceivers;
    }

    public List<NotificationReceiver> getNotificationReceivers() throws JAXBException {
        List receivers = this._messenger.getLogSettings().getEmailNotification().getReceiver();
        ArrayList<NotificationReceiver> notificationReceivers = new ArrayList<NotificationReceiver>(receivers.size());
        for (Messenger.LogSettings.EmailNotification.Receiver element : receivers) {
            int[] events = new int[element.getLogCode().size()];
            int j = 0;
            for (Integer eventIdObj : element.getLogCode()) {
                events[j] = eventIdObj;
                ++j;
            }
            ArrayList<SubjectElement> nse = new ArrayList<SubjectElement>();
            for (NotificationSubjectElementType nset : element.getSubjectElement()) {
                if (nset.getVariable() != null) {
                    nse.add(new SubjectElement(1, nset.getVariable()));
                    continue;
                }
                if (nset.getXPath() != null) {
                    nse.add(new SubjectElement(2, nset.getXPath()));
                    continue;
                }
                if (nset.getText() == null) continue;
                nse.add(new SubjectElement(3, nset.getText()));
            }
            notificationReceivers.add(new NotificationReceiver(element.getEmail(), element.isWithAttachment(), events, nse));
        }
        Collections.sort(notificationReceivers, new Comparator<NotificationReceiver>(this){

            @Override
            public int compare(NotificationReceiver r1, NotificationReceiver r2) {
                return r1.getEmail().compareToIgnoreCase(r2.getEmail());
            }
        });
        return notificationReceivers;
    }

    public NotificationReceiver getNotificationReceiverForEmail(String email) {
        NotificationReceiver receiver = null;
        List receivers = this._messenger.getLogSettings().getEmailNotification().getReceiver();
        for (Messenger.LogSettings.EmailNotification.Receiver element : receivers) {
            if (!email.equals(element.getEmail())) continue;
            int[] events = new int[element.getLogCode().size()];
            int j = 0;
            for (Integer eventIdObj : element.getLogCode()) {
                events[j] = eventIdObj;
                ++j;
            }
            ArrayList<SubjectElement> nse = new ArrayList<SubjectElement>();
            for (NotificationSubjectElementType nset : element.getSubjectElement()) {
                if (nset.getVariable() != null) {
                    nse.add(new SubjectElement(1, nset.getVariable()));
                    continue;
                }
                if (nset.getXPath() != null) {
                    nse.add(new SubjectElement(2, nset.getXPath()));
                    continue;
                }
                if (nset.getText() == null) continue;
                nse.add(new SubjectElement(3, nset.getText()));
            }
            receiver = new NotificationReceiver(element.getEmail(), element.isWithAttachment(), events, nse);
            break;
        }
        return receiver;
    }

    public void setNotificationCodesForReceiver(String email, List<Integer> codes, boolean withAttachment, List<SubjectElement> subjectElements) {
        boolean found = false;
        List receivers = this._messenger.getLogSettings().getEmailNotification().getReceiver();
        Messenger.LogSettings.EmailNotification.Receiver newReceiver = this._factory.createMessengerLogSettingsEmailNotificationReceiver();
        newReceiver.setEmail(email);
        newReceiver.getLogCode().addAll(codes);
        newReceiver.setWithAttachment(Boolean.valueOf(withAttachment));
        newReceiver.getSubjectElement().clear();
        if (subjectElements != null) {
            ArrayList<NotificationSubjectElementType> nse = new ArrayList<NotificationSubjectElementType>();
            for (SubjectElement se : subjectElements) {
                NotificationSubjectElementType nset = this._factory.createNotificationSubjectElementType();
                if (1 == se.getType()) {
                    if (se.getVariable() != null && !se.getVariable().isEmpty()) {
                        nset.setVariable(se.getVariable());
                    } else {
                        nset.setVariable(DEFAULT_SUBJECT_ELEMENT_VARIABLE);
                    }
                } else if (2 == se.getType()) {
                    if (se.getXpath() != null && !se.getXpath().isEmpty()) {
                        nset.setXPath(se.getXpath());
                    } else if (se.getText() != null && !se.getText().isEmpty()) {
                        nset.setXPath(se.getText());
                    } else {
                        nset.setXPath("");
                    }
                } else if (se.getText() != null && !se.getText().isEmpty()) {
                    nset.setText(se.getText());
                } else if (se.getXpath() != null && !se.getXpath().isEmpty()) {
                    nset.setText(se.getXpath());
                } else {
                    nset.setText("");
                }
                nse.add(nset);
            }
            newReceiver.getSubjectElement().addAll(nse);
        }
        receivers.add(newReceiver);
    }

    public void removeNotificationReceiver(String email) {
        Messenger.LogSettings.EmailNotification.Receiver value;
        List receivers = this._messenger.getLogSettings().getEmailNotification().getReceiver();
        Messenger.LogSettings.EmailNotification.Receiver receiver = null;
        Iterator iterator = receivers.iterator();
        while (iterator.hasNext() && !email.equals((receiver = (value = (Messenger.LogSettings.EmailNotification.Receiver)iterator.next())).getEmail())) {
            receiver = null;
        }
        if (receiver != null) {
            receivers.remove(receiver);
        }
    }

    public void setDetailLogOnlyErrors(boolean flag) {
        Messenger.LogSettings.DetailLog detailLog = this._messenger.getLogSettings().getDetailLog();
        if (detailLog == null) {
            detailLog = this._factory.createMessengerLogSettingsDetailLog();
            this._messenger.getLogSettings().setDetailLog(detailLog);
        }
        detailLog.setOnlyErrors(flag);
    }

    public XpArchiverType getArchiverType() throws JAXBException {
        if (Objects.nonNull(this._messenger.getArchiving()) && Objects.nonNull(this._messenger.getArchiving().getType())) {
            return XpArchiverType.valueOf(this._messenger.getArchiving().getType().value());
        }
        return XpArchiverType.FILE_SYSTEM;
    }

    public void setArchiverType(XpArchiverType archiverType) {
        Messenger.Archiving archiving = this._messenger.getArchiving();
        if (Objects.isNull(archiving)) {
            archiving = this._factory.createMessengerArchiving();
            this._messenger.setArchiving(archiving);
        }
        if (Objects.nonNull((Object)archiverType)) {
            archiving.setType(ArchiverType.fromValue((String)archiverType.name()));
        }
    }

    public boolean isArchivePayload() {
        return ArchiveSetting.INCLUDED.equals((Object)this._messenger.getArchiving().getPayload());
    }

    public boolean isArchiveBackendEnvelope() {
        return ArchiveSetting.INCLUDED.equals((Object)this._messenger.getArchiving().getBackendEnvelope());
    }

    public boolean isArchiveEbXml() {
        return ArchiveSetting.INCLUDED.equals((Object)this._messenger.getArchiving().getEbXML());
    }

    public boolean isArchiveCertificate() {
        return ArchiveSetting.INCLUDED.equals((Object)this._messenger.getArchiving().getCertificate());
    }

    public boolean isArchiveSignature() {
        return ArchiveSetting.INCLUDED.equals((Object)this._messenger.getArchiving().getSignature());
    }

    public boolean isArchiveAttachments() {
        return ArchiveSetting.INCLUDED.equals((Object)this._messenger.getArchiving().getAttachments());
    }

    public boolean isArchiveRenameAckFiles() {
        return this._messenger.getArchiving().isRenameAckFiles();
    }

    public boolean isArchiveCompression() {
        return this._messenger.getArchiving().isCompression();
    }

    public void setArchivePayload(boolean include) {
        if (include) {
            this._messenger.getArchiving().setPayload(ArchiveSetting.INCLUDED);
        } else {
            this._messenger.getArchiving().setPayload(ArchiveSetting.EXCLUDED);
        }
    }

    public void setArchiveBackendEnvelope(boolean include) {
        if (include) {
            this._messenger.getArchiving().setBackendEnvelope(ArchiveSetting.INCLUDED);
        } else {
            this._messenger.getArchiving().setBackendEnvelope(ArchiveSetting.EXCLUDED);
        }
    }

    public void setArchiveEbXml(boolean include) {
        if (include) {
            this._messenger.getArchiving().setEbXML(ArchiveSetting.INCLUDED);
        } else {
            this._messenger.getArchiving().setEbXML(ArchiveSetting.EXCLUDED);
        }
    }

    public void setArchiveCertificate(boolean include) {
        if (include) {
            this._messenger.getArchiving().setCertificate(ArchiveSetting.INCLUDED);
        } else {
            this._messenger.getArchiving().setCertificate(ArchiveSetting.EXCLUDED);
        }
    }

    public void setArchiveSignature(boolean include) {
        if (include) {
            this._messenger.getArchiving().setSignature(ArchiveSetting.INCLUDED);
        } else {
            this._messenger.getArchiving().setSignature(ArchiveSetting.EXCLUDED);
        }
    }

    public void setArchiveAttachments(boolean include) {
        if (include) {
            this._messenger.getArchiving().setAttachments(ArchiveSetting.INCLUDED);
        } else {
            this._messenger.getArchiving().setAttachments(ArchiveSetting.EXCLUDED);
        }
    }

    public void setArchiveRenameAckFiles(boolean value) {
        this._messenger.getArchiving().setRenameAckFiles(Boolean.valueOf(value));
    }

    public void setArchiveCompression(boolean value) {
        this._messenger.getArchiving().setCompression(Boolean.valueOf(value));
    }

    public String getArchiveFolder() throws JAXBException {
        return this._messenger.getArchiving().getFolder();
    }

    public void setArchiveFolder(String folder) {
        this._messenger.getArchiving().setFolder(folder);
    }

    public String getArchiveFailedFolder() throws JAXBException {
        String failedFolder = this._messenger.getArchiving().getFailedFolder();
        if (Objects.isNull(failedFolder) || failedFolder.isEmpty()) {
            failedFolder = this.getArchiveFolder();
            this._messenger.getArchiving().setFailedFolder(failedFolder);
            this.saveConfigFromMemory();
        }
        return failedFolder;
    }

    public void setArchiveFailedFolder(String failedFolder) {
        this._messenger.getArchiving().setFailedFolder(failedFolder);
    }

    public boolean isListenerEnabled() throws JAXBException {
        if (this._messenger.getXpListener() == null) {
            return true;
        }
        return this._messenger.getXpListener().stream().anyMatch(Messenger.XpListener::isEnabled);
    }

    public String getCertificateRequestEmail() {
        if (this._messenger.getPontonCA() != null && StringUtils.isNotBlank((CharSequence)this._messenger.getPontonCA().getCertificateRequestEmail())) {
            return this._messenger.getPontonCA().getCertificateRequestEmail();
        }
        return this.defaultCertificateRequestEmail;
    }

    public String getPasswordEncryption() {
        return this._messenger.getPasswordEncryption().value();
    }

    public static String getRealPassword(IPasswordCrypt passwordCrypt, String password) {
        String realPasssword = password;
        byte[] decodedPw = Base64Decoder.decode(realPasssword);
        boolean encryptedPwFound = true;
        if (decodedPw.length > CRYPTED_PW_IDENTIFIER.length) {
            for (int i = 0; i < CRYPTED_PW_IDENTIFIER.length && encryptedPwFound; ++i) {
                if (decodedPw[i] == CRYPTED_PW_IDENTIFIER[i]) continue;
                encryptedPwFound = false;
                break;
            }
        } else {
            encryptedPwFound = false;
        }
        if (encryptedPwFound) {
            byte[] encryptedPw = new byte[decodedPw.length - CRYPTED_PW_IDENTIFIER.length];
            System.arraycopy(decodedPw, CRYPTED_PW_IDENTIFIER.length, encryptedPw, 0, encryptedPw.length);
            try {
                realPasssword = passwordCrypt.decryptPassword(encryptedPw);
            }
            catch (GeneralSecurityException e) {
                _log.error("could not decrypt password", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return realPasssword;
    }

    public boolean isHttpMultiLineUse() throws JAXBException {
        return false;
    }

    public String getProxyHost() throws JAXBException {
        return this._messenger.getProxyConfig().getProxyHost();
    }

    public int getProxyPort() throws JAXBException {
        return this._messenger.getProxyConfig().getProxyPort();
    }

    public String getProxyPassword() throws JAXBException {
        AuthenticationType auth = this._messenger.getProxyConfig().getAuthentication();
        if (auth == null) {
            return null;
        }
        String password = auth.getPassword();
        if (password == null) {
            return null;
        }
        String realPassword = MessengerConfig.getRealPassword(this._passwordCrypt, password);
        if (password.equals(realPassword)) {
            this.setProxyPassword(password);
            this.saveConfigFromMemory();
        }
        return realPassword;
    }

    public String getProxyUser() throws JAXBException {
        AuthenticationType authentication = this._messenger.getProxyConfig().getAuthentication();
        if (authentication != null) {
            return authentication.getUsername();
        }
        return null;
    }

    public List<String> getProxyBypassList() throws JAXBException {
        Messenger.ProxyConfig.BypassList bypassProxyFor = this._messenger.getProxyConfig().getBypassList();
        if (bypassProxyFor != null) {
            return bypassProxyFor.getBypassHost();
        }
        return new ArrayList<String>();
    }

    public String getLdapProxyHost() {
        if (this._messenger.getLdapProxyConfig() != null) {
            return this._messenger.getLdapProxyConfig().getProxyHost();
        }
        return null;
    }

    public int getLdapProxyPort() {
        if (this._messenger.getLdapProxyConfig() != null) {
            return this._messenger.getLdapProxyConfig().getProxyPort();
        }
        return 0;
    }

    public String getFtpProxyHost() {
        if (this._messenger.getFtpProxyConfig() != null) {
            return this._messenger.getFtpProxyConfig().getProxyHost();
        }
        return null;
    }

    public int getFtpProxyPort() {
        if (this._messenger.getFtpProxyConfig() != null) {
            return this._messenger.getFtpProxyConfig().getProxyPort();
        }
        return 0;
    }

    public String getFtpProxyPassword() throws JAXBException {
        if (this._messenger.getFtpProxyConfig() != null) {
            AuthenticationType auth = this._messenger.getFtpProxyConfig().getAuthentication();
            if (auth == null) {
                return null;
            }
            String password = auth.getPassword();
            if (password == null) {
                return null;
            }
            String realPassword = MessengerConfig.getRealPassword(this._passwordCrypt, password);
            if (password.equals(realPassword)) {
                this.setFtpProxyPassword(password);
                this.saveConfigFromMemory();
            }
            return realPassword;
        }
        return null;
    }

    public String getFtpProxyUser() {
        AuthenticationType authentication;
        if (this._messenger.getFtpProxyConfig() != null && (authentication = this._messenger.getFtpProxyConfig().getAuthentication()) != null) {
            return authentication.getUsername();
        }
        return null;
    }

    public String getRegistryURL() throws JAXBException {
        Messenger.PontonRegistry reg = this.getPontonRegistry(false);
        if (reg != null && StringUtils.isNotBlank((CharSequence)reg.getRegistryURL())) {
            return reg.getRegistryURL();
        }
        return this.defaultRegistryURL;
    }

    public void setRegistryURL(String registryURL) {
        try {
            if (StringUtils.isNotBlank((CharSequence)registryURL)) {
                this.getPontonRegistry(true).setRegistryURL(registryURL);
            } else {
                this.getPontonRegistry(true).setRegistryURL(null);
            }
        }
        catch (JAXBException e) {
            _log.error(e.getMessage());
        }
    }

    private Messenger.PontonRegistry getPontonRegistry(boolean create) throws JAXBException {
        Messenger.PontonRegistry reg = this._messenger.getPontonRegistry();
        if (create && reg == null) {
            reg = this._factory.createMessengerPontonRegistry();
            this._messenger.setPontonRegistry(reg);
        }
        return reg;
    }

    public boolean isRegistryConfigured() {
        try {
            return this.getPontonRegistry(false) != null;
        }
        catch (JAXBException e) {
            _log.error(e.getMessage());
            return false;
        }
    }

    private DownloadIntervalType getPontonRegistryDownloadIntervalType(boolean create) throws JAXBException {
        DownloadIntervalType downloadInterval = null;
        Messenger.PontonRegistry reg = this.getPontonRegistry(create);
        if (reg != null) {
            downloadInterval = reg.getDownloadInterval();
            if (create && downloadInterval == null) {
                downloadInterval = this._factory.createDownloadIntervalType();
                reg.setDownloadInterval(downloadInterval);
            }
        }
        return downloadInterval;
    }

    public String getRegistryUsername() throws JAXBException {
        AuthenticationType auth = this.getPontonRegistryAuthenticationType(false);
        if (auth != null) {
            return auth.getUsername();
        }
        return null;
    }

    public void setRegistryUsername(String username) {
        Objects.requireNonNull(username, "user for partner registry can't be null");
        this.getPontonRegistryAuthenticationType(true).setUsername(username);
    }

    public String getRegistryPassword() throws JAXBException {
        AuthenticationType auth = this.getPontonRegistryAuthenticationType(false);
        if (auth == null) {
            return null;
        }
        String password = auth.getPassword();
        if (password == null) {
            return null;
        }
        String realPassword = MessengerConfig.getRealPassword(this._passwordCrypt, password);
        if (password.equals(realPassword)) {
            this.setRegistryPassword(password);
            this.saveConfigFromMemory();
        }
        return realPassword;
    }

    public void setRegistryPassword(String password) {
        Objects.requireNonNull(password, "password for partner registry can't be null");
        String registryPass = this.getEncryptedPassword(password);
        this.getPontonRegistryAuthenticationType(true).setPassword(registryPass);
    }

    public boolean isRegistryDownloadEnabled() throws JAXBException {
        DownloadIntervalType downloadInterval = this.getPontonRegistryDownloadIntervalType(false);
        if (downloadInterval != null) {
            Boolean enabled = downloadInterval.isEnabled();
            return enabled != null && enabled != false;
        }
        return false;
    }

    public boolean isRegistryCleanUpEnabled() throws JAXBException {
        Messenger.PontonRegistry pontonRegistry = this.getPontonRegistry(false);
        return pontonRegistry.isRegistryCleanUpEnabled();
    }

    public void setRegistryCleanUpEnabled(boolean enableCleanUp) throws JAXBException {
        Messenger.PontonRegistry pontonRegistry = this.getPontonRegistry(false);
        pontonRegistry.setRegistryCleanUpEnabled(Boolean.valueOf(enableCleanUp));
    }

    public boolean isAutomaticAgreementUpdateEnabled() throws JAXBException {
        DownloadIntervalType downloadInterval = this.getPontonRegistryDownloadIntervalType(false);
        if (downloadInterval != null) {
            return downloadInterval.isAutomaticAgreementUpdate();
        }
        return false;
    }

    public void setAutomaticAgreementUpdateEnabled(boolean enabled) {
        try {
            DownloadIntervalType downloadInterval = this.getPontonRegistryDownloadIntervalType(true);
            if (downloadInterval != null) {
                downloadInterval.setAutomaticAgreementUpdate(Boolean.valueOf(enabled));
            }
        }
        catch (JAXBException e) {
            _log.error(e.getMessage());
        }
    }

    public void setRegistryDownloadEnabled(boolean enabled) {
        try {
            DownloadIntervalType downloadInterval = this.getPontonRegistryDownloadIntervalType(true);
            if (downloadInterval != null) {
                downloadInterval.setEnabled(Boolean.valueOf(enabled));
            }
        }
        catch (JAXBException e) {
            _log.error(e.getMessage());
        }
    }

    public int getRegistryDownloadInterval() throws JAXBException {
        DownloadIntervalType downloadInterval = this.getPontonRegistryDownloadIntervalType(false);
        if (downloadInterval != null) {
            return downloadInterval.getValue();
        }
        return 24;
    }

    public void setRegistryDownloadInterval(int downloadInterval) {
        this.setRegistryDownloadInterval(downloadInterval, true);
    }

    public void setRegistryDownloadInterval(int downloadInterval, boolean create) {
        try {
            DownloadIntervalType dit = this.getPontonRegistryDownloadIntervalType(create);
            if (dit != null) {
                dit.setValue(downloadInterval);
            }
        }
        catch (JAXBException e) {
            _log.error(e.getMessage());
        }
    }

    private AuthenticationType getPontonRegistryAuthenticationType(boolean create) {
        AuthenticationType auth = null;
        try {
            Messenger.PontonRegistry reg = this.getPontonRegistry(create);
            if (reg != null) {
                auth = reg.getAuthentication();
                if (create && auth == null) {
                    auth = this._factory.createAuthenticationType();
                    reg.setAuthentication(auth);
                }
            }
        }
        catch (JAXBException e) {
            _log.error(e.getMessage());
        }
        return auth;
    }

    public boolean isRegistryPartnerCreationEnabled() {
        try {
            Messenger.PontonRegistry reg = this.getPontonRegistry(true);
            return reg.isRemotePartnerCreation();
        }
        catch (JAXBException ex) {
            _log.error(ex.getMessage());
            return false;
        }
    }

    public void setRegistryPartnerCreationEnabled(boolean enable) {
        try {
            Messenger.PontonRegistry reg = this.getPontonRegistry(true);
            reg.setRemotePartnerCreation(Boolean.valueOf(enable));
        }
        catch (JAXBException e) {
            _log.error(e.getMessage());
        }
    }

    public int getDefaultRetransmissionRetryInterval() {
        List temp = this._messenger.getDefaultRetransmissionHandling().getRetryInterval();
        if (temp.isEmpty()) {
            return 60;
        }
        return (Integer)temp.getFirst();
    }

    public List<Integer> getDefaultRetransmissionRetryIntervals() throws JAXBException {
        return Collections.unmodifiableList(this._messenger.getDefaultRetransmissionHandling().getRetryInterval());
    }

    public int getDefaultRetransmissionRetries() throws JAXBException {
        Integer temp = this._messenger.getDefaultRetransmissionHandling().getRetries();
        return Objects.requireNonNullElse(temp, 3);
    }

    public String getDefaultAdapterId() throws JAXBException {
        return this._messenger.getDefaultAdapterId();
    }

    public void setDefaultAdapterId(String adapterId) {
        this._messenger.setDefaultAdapterId(adapterId);
    }

    public String getMailServerPassword() throws JAXBException {
        AuthenticationType auth = this._messenger.getInboundMailService().getAuthentication();
        if (auth == null) {
            return null;
        }
        String password = auth.getPassword();
        if (password == null) {
            return null;
        }
        String realPassword = MessengerConfig.getRealPassword(this._passwordCrypt, password);
        if (password.equals(realPassword)) {
            this.setMailServerPassword(password);
            this.saveConfigFromMemory();
        }
        return realPassword;
    }

    public String getMailServerHost() {
        return this._messenger.getInboundMailService().getMailServer().getValue();
    }

    public String getMailServerProtocol() {
        return this._messenger.getInboundMailService().getMailServer().getProtocol().value();
    }

    public String getMailServerProtocolName() {
        return this._messenger.getInboundMailService().getMailServer().getProtocol().value();
    }

    public String getMailServerUser() {
        if (this._messenger.getInboundMailService().getAuthentication() != null) {
            return this._messenger.getInboundMailService().getAuthentication().getUsername();
        }
        return null;
    }

    public int getMailPollInterval() throws JAXBException {
        return this._messenger.getInboundMailService().getPollInterval();
    }

    public String getMailInboxFolder() {
        return this._messenger.getInboundMailService().getMailServer().getInboxFolder();
    }

    public byte[] getSmimePassword() {
        return this._messenger.getInboundMailService().getSMIMEPassword();
    }

    public String getSmtpFromAddress() throws JAXBException {
        return this._messenger.getOutboundMailService().getFromAddress();
    }

    public String getSmtpPassword() throws JAXBException {
        AuthenticationType auth = this._messenger.getOutboundMailService().getAuthentication();
        if (auth == null) {
            return null;
        }
        String password = auth.getPassword();
        if (password == null) {
            return null;
        }
        String realPassword = MessengerConfig.getRealPassword(this._passwordCrypt, password);
        if (password.equals(realPassword)) {
            this.setSmtpPassword(password);
            this.saveConfigFromMemory();
        }
        return realPassword;
    }

    public String getSmtpServerHost() {
        return this._messenger.getOutboundMailService().getSMTPServer().getValue();
    }

    public String getSmtpServerProtocol() {
        return this._messenger.getOutboundMailService().getSMTPServer().getProtocol().value();
    }

    public String getSmtpServerProtocolName() {
        return this._messenger.getOutboundMailService().getSMTPServer().getProtocol().value();
    }

    public String getSmtpUser() {
        AuthenticationType authentication = this._messenger.getOutboundMailService().getAuthentication();
        if (authentication != null) {
            return authentication.getUsername();
        }
        return null;
    }

    public void setCertificateRequestEmail(String certificateRequestEmail) {
        Messenger.PontonCA pontonCA = this._messenger.getPontonCA();
        if (pontonCA == null) {
            pontonCA = this._factory.createMessengerPontonCA();
            this._messenger.setPontonCA(pontonCA);
        }
        pontonCA.setCertificateRequestEmail(certificateRequestEmail);
    }

    public void setPasswordEncryption(String encryptionType) {
        this._messenger.setPasswordEncryption(PasswordEncryptionType.fromValue((String)encryptionType));
    }

    private String getEncryptedPassword(String password) {
        return MessengerConfig.getEncryptedPassword(this._passwordCrypt, password);
    }

    public static String getEncryptedPassword(IPasswordCrypt _passwordCrypt, String password) {
        if (password == null) {
            return null;
        }
        try {
            byte[] cryptedPW = _passwordCrypt.encryptPassword(password);
            byte[] storedCryptedPw = new byte[CRYPTED_PW_IDENTIFIER.length + cryptedPW.length];
            System.arraycopy(CRYPTED_PW_IDENTIFIER, 0, storedCryptedPw, 0, CRYPTED_PW_IDENTIFIER.length);
            System.arraycopy(cryptedPW, 0, storedCryptedPw, CRYPTED_PW_IDENTIFIER.length, cryptedPW.length);
            return Base64Encoder.encode(storedCryptedPw);
        }
        catch (GeneralSecurityException e) {
            _log.error("could not encrypt password", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void setDatabasePassword(String databasePassword) {
        Objects.requireNonNull(databasePassword, "password for database can't be null");
        String dbPassword = this.getEncryptedPassword(databasePassword);
        AuthenticationType auth = this._messenger.getDatabase().getAuthentication();
        if (auth == null) {
            auth = this._factory.createAuthenticationType();
            this._messenger.getDatabase().setAuthentication(auth);
        }
        auth.setPassword(dbPassword);
    }

    public void setProxyHost(String proxyHost) {
        this._messenger.getProxyConfig().setProxyHost(proxyHost);
    }

    public void setProxyPort(int proxyPort) {
        this._messenger.getProxyConfig().setProxyPort(proxyPort);
    }

    private void createProxyAuthentication() {
        if (this._messenger.getProxyConfig().getAuthentication() == null) {
            AuthenticationType newAuthentication = this._factory.createAuthenticationType();
            this._messenger.getProxyConfig().setAuthentication(newAuthentication);
        }
    }

    private Messenger.LdapProxyConfig createLdapProxyConfig() {
        Messenger.LdapProxyConfig ldapProxyConfig = this._messenger.getLdapProxyConfig();
        if (ldapProxyConfig == null) {
            ldapProxyConfig = this._factory.createMessengerLdapProxyConfig();
            this._messenger.setLdapProxyConfig(ldapProxyConfig);
        }
        return ldapProxyConfig;
    }

    public void removeLdapProxyConfig() {
        this._messenger.setLdapProxyConfig(null);
    }

    public void setLdapProxyHost(String proxyHost) {
        this.createLdapProxyConfig().setProxyHost(proxyHost);
    }

    public void setLdapProxyPort(int proxyPort) {
        this.createLdapProxyConfig().setProxyPort(proxyPort);
    }

    private Messenger.FtpProxyConfig createFtpProxyConfig() {
        Messenger.FtpProxyConfig ftpProxyConfig = this._messenger.getFtpProxyConfig();
        if (ftpProxyConfig == null) {
            ftpProxyConfig = this._factory.createMessengerFtpProxyConfig();
            this._messenger.setFtpProxyConfig(ftpProxyConfig);
        }
        return ftpProxyConfig;
    }

    public void removeFtpProxyAuthentication() {
        if (this._messenger.getFtpProxyConfig() != null) {
            this._messenger.getFtpProxyConfig().setAuthentication(null);
        }
    }

    public void removeFtpProxyConfig() {
        this._messenger.setFtpProxyConfig(null);
    }

    public void setFtpProxyHost(String proxyHost) {
        this.createFtpProxyConfig().setProxyHost(proxyHost);
    }

    public void setFtpProxyPort(int proxyPort) {
        this.createFtpProxyConfig().setProxyPort(proxyPort);
    }

    private AuthenticationType createFtpProxyAuthentication() {
        AuthenticationType authentication = this.createFtpProxyConfig().getAuthentication();
        if (authentication == null) {
            authentication = this._factory.createAuthenticationType();
            this.createFtpProxyConfig().setAuthentication(authentication);
        }
        return authentication;
    }

    public void setFtpProxyPassword(String proxyPassword) {
        Objects.requireNonNull(proxyPassword, "password for ftp proxy can't be null");
        String proxyPass = this.getEncryptedPassword(proxyPassword);
        this.createFtpProxyAuthentication().setPassword(proxyPass);
    }

    public void setFtpProxyUser(String proxyUser) {
        Objects.requireNonNull(proxyUser, "user for ftp proxy can't be null");
        this.createFtpProxyAuthentication().setUsername(proxyUser);
    }

    private void createMessageQueueSettings() {
        if (this._messenger.getMessageQueues() == null) {
            Messenger.MessageQueues newMessageQueue = this._factory.createMessengerMessageQueues();
            this._messenger.setMessageQueues(newMessageQueue);
            if (this._messenger.getMessageQueues().getInbound() == null) {
                Messenger.MessageQueues.Inbound inqueue = this._factory.createMessengerMessageQueuesInbound();
                inqueue.setScanTime(this.DEFAULT_INBOUNDQUEUE_SCANTIME);
                inqueue.setDeliveryTimeout(Long.valueOf(this.DEFAULT_INBOUNDQUEUE_DELIVERYTIMEOUT));
                inqueue.setRetryDelay(Long.valueOf(this.DEFAULT_INBOUNDQUEUE_RETRYDELAY));
                this._messenger.getMessageQueues().setInbound(inqueue);
            }
            if (this._messenger.getMessageQueues().getOutbound() == null) {
                Messenger.MessageQueues.Outbound outqueue = this._factory.createMessengerMessageQueuesOutbound();
                outqueue.setScanTime(5000L);
                this._messenger.getMessageQueues().setOutbound(outqueue);
            }
        }
    }

    public void removeHttpProxyAuthentication() {
        this._messenger.getProxyConfig().setAuthentication(null);
    }

    public void setProxyPassword(String proxyPassword) {
        Objects.requireNonNull(proxyPassword, "password for http proxy can't be null");
        String proxyPass = this.getEncryptedPassword(proxyPassword);
        this.createProxyAuthentication();
        this._messenger.getProxyConfig().getAuthentication().setPassword(proxyPass);
    }

    public void setProxyUser(String proxyUser) {
        Objects.requireNonNull(proxyUser, "user for http proxy can't be null");
        this.createProxyAuthentication();
        this._messenger.getProxyConfig().getAuthentication().setUsername(proxyUser);
    }

    public void setProxyBypassList(List<String> bypassList) {
        this.createProxyAuthentication();
        Messenger.ProxyConfig.BypassList bypassProxyList = this._messenger.getProxyConfig().getBypassList();
        if (bypassProxyList == null) {
            bypassProxyList = new Messenger.ProxyConfig.BypassList();
            this._messenger.getProxyConfig().setBypassList(bypassProxyList);
        } else {
            bypassProxyList.getBypassHost().clear();
        }
        bypassProxyList.getBypassHost().addAll(bypassList);
    }

    public void setDefaultRetransmissionRetryInterval(int retransmissionInterval) {
        List intervals = this._messenger.getDefaultRetransmissionHandling().getRetryInterval();
        intervals.clear();
        intervals.add(retransmissionInterval);
    }

    public void setDefaultRetransmissionRetries(int retransmissionTrials) {
        this._messenger.getDefaultRetransmissionHandling().setRetries(Integer.valueOf(retransmissionTrials));
    }

    public void setSmtpFromAddress(String smtpFromAddress) {
        this._messenger.getOutboundMailService().setFromAddress(smtpFromAddress);
    }

    public void setSmtpPassword(String smtpPassword) {
        Objects.requireNonNull(smtpPassword, "password for smtp server can't be null");
        String smtpPass = this.getEncryptedPassword(smtpPassword);
        this.createSmtpAuthentication();
        this._messenger.getOutboundMailService().getAuthentication().setPassword(smtpPass);
    }

    private void createSmtpAuthentication() {
        if (this._messenger.getOutboundMailService().getAuthentication() == null) {
            AuthenticationType newAuthentication = this._factory.createAuthenticationType();
            this._messenger.getOutboundMailService().setAuthentication(newAuthentication);
        }
    }

    public void setSmtpServerHost(String smtpServerHost) {
        this._messenger.getOutboundMailService().getSMTPServer().setValue(smtpServerHost);
    }

    public void setSmtpServerProtocol(String smtpServerProtocol) {
        this._messenger.getOutboundMailService().getSMTPServer().setProtocol(SmtpServerType.fromValue((String)smtpServerProtocol));
    }

    public void setSmtpUser(String smtpUser) {
        Objects.requireNonNull(smtpUser, "user for smtp server can't be null");
        this.createSmtpAuthentication();
        this._messenger.getOutboundMailService().getAuthentication().setUsername(smtpUser);
    }

    public void setMailServerPassword(String mailPassword) {
        Objects.requireNonNull(mailPassword, "password for mail server can't be null");
        String mailPass = this.getEncryptedPassword(mailPassword);
        this.createMailServerAuthentication();
        this._messenger.getInboundMailService().getAuthentication().setPassword(mailPass);
    }

    private void createMailServerAuthentication() {
        if (this._messenger.getInboundMailService().getAuthentication() == null) {
            AuthenticationType newAuthentication = this._factory.createAuthenticationType();
            this._messenger.getInboundMailService().setAuthentication(newAuthentication);
        }
    }

    public void setMailServerHost(String mailServerHost) {
        this._messenger.getInboundMailService().getMailServer().setValue(mailServerHost);
    }

    public void setMailServerProtocol(String protocol) {
        this._messenger.getInboundMailService().getMailServer().setProtocol(MailServerType.fromValue((String)protocol));
    }

    public void setMailServerUser(String mailUser) {
        Objects.requireNonNull(mailUser, "user for mail server can't be null");
        this.createMailServerAuthentication();
        this._messenger.getInboundMailService().getAuthentication().setUsername(mailUser);
    }

    public void setMailPollInterval(int interval) {
        this._messenger.getInboundMailService().setPollInterval(interval);
    }

    public void setMailInboxFolder(String folder) {
        this._messenger.getInboundMailService().getMailServer().setInboxFolder(folder);
    }

    public void setSmimePassword(byte[] password) {
        this._messenger.getInboundMailService().setSMIMEPassword(password);
    }

    public long getInboundQueueScanTime() {
        long result = -1L;
        try {
            if (this._messenger.getMessageQueues() != null && this._messenger.getMessageQueues().getInbound() != null) {
                result = this._messenger.getMessageQueues().getInbound().getScanTime();
            }
        }
        catch (Exception e) {
            _log.error("Could not get InboundQueueScanTime.", (Throwable)e);
        }
        if (result <= 0L) {
            result = this.DEFAULT_INBOUNDQUEUE_SCANTIME;
        }
        return result;
    }

    public void setInboundQueueScanTime(long time) {
        this.createMessageQueueSettings();
        this._messenger.getMessageQueues().getInbound().setScanTime(time);
    }

    public long getInboundQueueDeliveryTimeout() {
        Long result = null;
        if (this._messenger.getMessageQueues() != null && this._messenger.getMessageQueues().getInbound() != null) {
            result = this._messenger.getMessageQueues().getInbound().getDeliveryTimeout();
        }
        if (result == null || result < 1L) {
            result = this.DEFAULT_INBOUNDQUEUE_DELIVERYTIMEOUT;
        }
        return result;
    }

    public void setInboundQueueDeliveryTimeout(long timeout) {
        this.createMessageQueueSettings();
        this._messenger.getMessageQueues().getInbound().setDeliveryTimeout(Long.valueOf(timeout));
    }

    public long getInboundQueueRetryDelay() {
        Long result = null;
        if (this._messenger.getMessageQueues() != null && this._messenger.getMessageQueues().getInbound() != null) {
            result = this._messenger.getMessageQueues().getInbound().getRetryDelay();
        }
        if (result == null || result <= 0L) {
            result = this.DEFAULT_INBOUNDQUEUE_RETRYDELAY;
        }
        return result;
    }

    public void setInboundQueueRetryDelay(long delay) {
        this.createMessageQueueSettings();
        this._messenger.getMessageQueues().getInbound().setRetryDelay(Long.valueOf(delay));
    }

    public long getOutboundQueueScanTime() {
        long result = -1L;
        if (this._messenger.getMessageQueues() != null && this._messenger.getMessageQueues().getOutbound() != null) {
            result = this._messenger.getMessageQueues().getOutbound().getScanTime();
        }
        if (result <= 0L) {
            result = 5000L;
        }
        return result;
    }

    public void setOutboundQueueScanTime(long time) {
        this.createMessageQueueSettings();
        this._messenger.getMessageQueues().getOutbound().setScanTime(time);
    }

    public boolean isNtpEnabled() {
        Messenger.NtpServers cfgNtpServers = this._messenger.getNtpServers();
        if (cfgNtpServers != null) {
            return cfgNtpServers.isEnabled();
        }
        return false;
    }

    public void setNtpEnabled(boolean enabled) {
        Messenger.NtpServers cfgNtpServers = this._messenger.getNtpServers();
        if (cfgNtpServers == null) {
            cfgNtpServers = this._factory.createMessengerNtpServers();
            this._messenger.setNtpServers(cfgNtpServers);
        }
        cfgNtpServers.setEnabled(Boolean.valueOf(enabled));
    }

    public int getNtpServerSynchronizeIntervalHours() {
        Messenger.NtpServers cfgNtpServers = this._messenger.getNtpServers();
        if (cfgNtpServers != null) {
            return cfgNtpServers.getSynchronizeIntervalHours();
        }
        return 0;
    }

    public void setNtpServerSynchronizeIntervalHours(int interval) {
        Messenger.NtpServers cfgNtpServers = this._messenger.getNtpServers();
        if (cfgNtpServers == null) {
            cfgNtpServers = this._factory.createMessengerNtpServers();
            this._messenger.setNtpServers(cfgNtpServers);
        }
        cfgNtpServers.setSynchronizeIntervalHours(Integer.valueOf(interval));
    }

    public ArrayList<de.pontonconsulting.xmlpipe.config.NtpServer> getNtpServers() throws JAXBException {
        ArrayList<de.pontonconsulting.xmlpipe.config.NtpServer> ntpServers = new ArrayList<de.pontonconsulting.xmlpipe.config.NtpServer>();
        Messenger.NtpServers cfgNtpServers = this._messenger.getNtpServers();
        if (cfgNtpServers != null) {
            List cfgNtpServerList = cfgNtpServers.getNtpServer();
            if (cfgNtpServerList != null) {
                for (NtpServer ntp : cfgNtpServerList) {
                    de.pontonconsulting.xmlpipe.config.NtpServer ntpServer = new de.pontonconsulting.xmlpipe.config.NtpServer(ntp.getHostname());
                    Integer port = ntp.getPort();
                    if (port != null) {
                        ntpServer.setPort(port);
                    }
                    ntpServers.add(ntpServer);
                }
            }
        } else {
            return null;
        }
        return ntpServers;
    }

    public void setNtpServers(List<de.pontonconsulting.xmlpipe.config.NtpServer> ntpServers) {
        ArrayList<NtpServer> cfgNtpServerList = new ArrayList<NtpServer>();
        for (de.pontonconsulting.xmlpipe.config.NtpServer ntpServer : ntpServers) {
            NtpServer ntp = this._factory.createNtpServer();
            ntp.setHostname(ntpServer.getHostname());
            if (123 != ntpServer.getPort()) {
                ntp.setPort(Integer.valueOf(ntpServer.getPort()));
            }
            cfgNtpServerList.add(ntp);
        }
        Messenger.NtpServers cfgNtpServers = this._messenger.getNtpServers();
        if (cfgNtpServers == null) {
            cfgNtpServers = this._factory.createMessengerNtpServers();
            this._messenger.setNtpServers(cfgNtpServers);
        }
        cfgNtpServers.getNtpServer().clear();
        cfgNtpServers.getNtpServer().addAll(cfgNtpServerList);
    }

    public int getOkEventAge() {
        Integer ok = this._messenger.getLogSettings().getOkEventAge();
        return Objects.requireNonNullElse(ok, 0);
    }

    public void setOkEventAge(int okEventAge) {
        this._messenger.getLogSettings().setOkEventAge(Integer.valueOf(okEventAge));
    }

    public void setProxyDomain(String string) {
        this._messenger.getProxyConfig().setNTDomain(string);
    }

    public String getProxyDomain() throws JAXBException {
        return this._messenger.getProxyConfig().getNTDomain();
    }

    public String getWorkFolder() throws JAXBException {
        return this._messenger.getFolders().getWorkFolder();
    }

    public void setWorkFolder(String workFolder) {
        this._messenger.getFolders().setWorkFolder(workFolder);
    }

    public boolean isLoopback() {
        return this._messenger.getCommunicationSettings().isLoopback();
    }

    public void setLoopback(boolean allowLoopback) {
        this._messenger.getCommunicationSettings().setLoopback(allowLoopback);
    }

    public boolean isRequeueFailedMessagesEnabled() {
        return this._messenger.getCommunicationSettings().isRequeueFailedMessages();
    }

    public void setRequeueFailedMessages(boolean requeueFailedMessages) {
        this._messenger.getCommunicationSettings().setRequeueFailedMessages(requeueFailedMessages);
    }

    public boolean isPartnerCertificateRevocationCheckEnabled() {
        return Objects.requireNonNullElse(this._messenger.getCommunicationSettings().isPartnerCertificateRevocationCheck(), false);
    }

    public void setPartnerCertificateRevocationCheck(boolean enabled) {
        this._messenger.getCommunicationSettings().setPartnerCertificateRevocationCheck(Boolean.valueOf(enabled));
    }

    public boolean isPingAllEnabled() {
        Messenger.CommunicationSettings.PingAll pingAllElement = this._messenger.getCommunicationSettings().getPingAll();
        if (pingAllElement == null) {
            return false;
        }
        return pingAllElement.isEnabled();
    }

    public void setPingAllEnabled(boolean enabled) {
        Messenger.CommunicationSettings.PingAll pingAllElement = this._messenger.getCommunicationSettings().getPingAll();
        if (pingAllElement == null) {
            pingAllElement = this._factory.createMessengerCommunicationSettingsPingAll();
            this._messenger.getCommunicationSettings().setPingAll(pingAllElement);
        }
        pingAllElement.setEnabled(enabled);
    }

    public int getPingAllInterval() throws JAXBException {
        Messenger.CommunicationSettings.PingAll pingAllElement = this._messenger.getCommunicationSettings().getPingAll();
        if (pingAllElement == null) {
            return 30;
        }
        return pingAllElement.getInterval();
    }

    public void setPingAllInterval(int interval) {
        Messenger.CommunicationSettings.PingAll pingAllElement = this._messenger.getCommunicationSettings().getPingAll();
        if (pingAllElement == null) {
            pingAllElement = this._factory.createMessengerCommunicationSettingsPingAll();
            this._messenger.getCommunicationSettings().setPingAll(pingAllElement);
        }
        pingAllElement.setInterval(interval);
    }

    public List<MaintenanceService> getMaintenanceServices() {
        ArrayList<MaintenanceService> result = new ArrayList<MaintenanceService>();
        List maintenancePeriods = this._messenger.getCommunicationSettings().getMaintenancePeriod();
        if (maintenancePeriods != null) {
            for (Messenger.CommunicationSettings.MaintenancePeriod maintenancePeriod : maintenancePeriods) {
                result.add(new MaintenanceService(maintenancePeriod.getStart(), maintenancePeriod.getEnd(), maintenancePeriod.isTurnOffToAdapters(), maintenancePeriod.isTurnOffToPartners(), maintenancePeriod.isRejectInboundMSGs(), maintenancePeriod.isRejectOutboundMSGs()));
            }
        }
        return result;
    }

    public void removeOldMaintenanceServices(long now) {
        List maintenancePeriods = this._messenger.getCommunicationSettings().getMaintenancePeriod();
        boolean changed = false;
        if (maintenancePeriods != null) {
            Iterator iterator = maintenancePeriods.iterator();
            while (iterator.hasNext()) {
                Messenger.CommunicationSettings.MaintenancePeriod maintenancePeriod = (Messenger.CommunicationSettings.MaintenancePeriod)iterator.next();
                if (now < maintenancePeriod.getEnd() && maintenancePeriod.getStart() <= maintenancePeriod.getEnd()) continue;
                iterator.remove();
                changed = true;
            }
            if (changed) {
                try {
                    this.saveConfigFromMemory();
                }
                catch (JAXBException e) {
                    _log.error("Could not save config. {}", (Object)String.valueOf((Object)e));
                }
            }
        }
    }

    public void setMaintenanceServices(List<MaintenanceService> maintenanceServices) {
        ArrayList<Messenger.CommunicationSettings.MaintenancePeriod> maintenancePeriods = this._messenger.getCommunicationSettings().getMaintenancePeriod();
        if (maintenancePeriods == null) {
            maintenancePeriods = new ArrayList<Messenger.CommunicationSettings.MaintenancePeriod>();
        } else {
            maintenancePeriods.clear();
        }
        for (MaintenanceService maintenanceService : maintenanceServices) {
            Messenger.CommunicationSettings.MaintenancePeriod period = this._factory.createMessengerCommunicationSettingsMaintenancePeriod();
            period.setStart(maintenanceService.getStartTime());
            period.setEnd(maintenanceService.getEndTime());
            period.setTurnOffToAdapters(Boolean.valueOf(maintenanceService.isTurnOffToAdapters()));
            period.setTurnOffToPartners(Boolean.valueOf(maintenanceService.isTurnOffToPartners()));
            period.setRejectInboundMSGs(Boolean.valueOf(maintenanceService.isRejectInboundMSGs()));
            period.setRejectOutboundMSGs(Boolean.valueOf(maintenanceService.isRejectOutboundMSGs()));
            maintenancePeriods.add(period);
        }
    }

    public boolean isClusterEnabled() {
        return this._clusterEnabled;
    }

    public void setClusterEnabled(boolean enabled) {
        this._clusterEnabled = enabled;
    }

    public int getMessengerId() {
        if (Objects.isNull(this._messengerId)) {
            _log.error("RacingCondition! MessengerId isn't injected by MessengerActivation, yet. ");
            return -1;
        }
        return this._messengerId;
    }

    public void setMessengerId(int messengerId) {
        this._messengerId = messengerId;
    }

    public int getReconnectDelay() {
        return Integer.parseInt(this.getProperty("pontonxp.websocket.reconnectdelay", "30"));
    }

    public void removeSmtpAuthentication() {
        if (this._messenger.getOutboundMailService() != null) {
            this._messenger.getOutboundMailService().setAuthentication(null);
        }
    }

    public void removeMailAuthentication() {
        this._messenger.getInboundMailService().setAuthentication(null);
    }

    public String getJwtSecret() {
        if (this._messenger.getAuthenticationToken() == null || this._messenger.getAuthenticationToken().getSecret() == null || this._messenger.getAuthenticationToken().getSecret().isBlank() || this.isRandomSecret()) {
            String secret = String.valueOf(UUID.randomUUID()) + "-" + String.valueOf(UUID.randomUUID());
            this.setJwtSecret(secret);
            return secret;
        }
        String secret = this._messenger.getAuthenticationToken().getSecret();
        String realSecret = MessengerConfig.getRealPassword(this._passwordCrypt, secret);
        if (realSecret.length() < 73) {
            String newSecret = String.valueOf(UUID.randomUUID()) + "-" + String.valueOf(UUID.randomUUID());
            this.setJwtSecret(newSecret);
            return newSecret;
        }
        if (secret.equals(realSecret)) {
            this.setJwtSecret(secret);
        }
        return realSecret;
    }

    public void setJwtSecret(String secret) {
        if (this._messenger.getAuthenticationToken() == null) {
            this._messenger.setAuthenticationToken(new Messenger.AuthenticationToken());
        }
        this._messenger.getAuthenticationToken().setSecret(this.getEncryptedPassword(secret));
        try {
            this.saveConfigFromMemory();
        }
        catch (JAXBException jAXBException) {
            // empty catch block
        }
    }

    public boolean isRandomSecret() {
        if (this._messenger.getAuthenticationToken() == null || this._messenger.getAuthenticationToken().isRandomSecretAtRestart() == null) {
            return false;
        }
        return this._messenger.getAuthenticationToken().isRandomSecretAtRestart();
    }

    public void setRandomSecret(boolean randomSecret) {
        if (this._messenger.getAuthenticationToken() == null) {
            this._messenger.setAuthenticationToken(new Messenger.AuthenticationToken());
        }
        this._messenger.getAuthenticationToken().setRandomSecretAtRestart(Boolean.valueOf(randomSecret));
    }

    public long getJwtExpiration() {
        if (this._messenger.getAuthenticationToken() == null || this._messenger.getAuthenticationToken().getExpiration() == null) {
            return 300L;
        }
        return this._messenger.getAuthenticationToken().getExpiration();
    }

    public void setJwtExpiration(long expiration) {
        if (this._messenger.getAuthenticationToken() == null) {
            this._messenger.setAuthenticationToken(new Messenger.AuthenticationToken());
        }
        this._messenger.getAuthenticationToken().setExpiration(Long.valueOf(expiration));
    }

    public void setJwtIgnoreIpAddress(boolean ignoreIpAddress) {
        if (this._messenger.getAuthenticationToken() == null) {
            this._messenger.setAuthenticationToken(new Messenger.AuthenticationToken());
        }
        this._messenger.getAuthenticationToken().setIgnoreIpAddress(Boolean.valueOf(ignoreIpAddress));
    }

    public boolean isJwtIgnoreIpAddress() {
        if (this._messenger.getAuthenticationToken() == null || this._messenger.getAuthenticationToken().isIgnoreIpAddress() == null) {
            return false;
        }
        return this._messenger.getAuthenticationToken().isIgnoreIpAddress();
    }

    public void setMessengerName(String messengerName) {
        if (this._messenger.getDisplay() == null) {
            this._messenger.setDisplay(new Messenger.Display());
        }
        this._messenger.getDisplay().setMessengerName(messengerName);
    }

    public void setEnvironment(EnvironmentType environment) {
        if (this._messenger.getDisplay() == null) {
            this._messenger.setDisplay(new Messenger.Display());
        }
        this._messenger.getDisplay().setEnvironment(environment);
    }

    public String getMessengerName() {
        if (this._messenger.getDisplay() == null || this._messenger.getDisplay().getMessengerName() == null) {
            String messengerName = System.getProperty("messenger.name");
            if (messengerName == null || messengerName.equals("set value in wrapper.conf")) {
                messengerName = "";
            }
            return messengerName;
        }
        return this._messenger.getDisplay().getMessengerName();
    }

    public EnvironmentType getEnvironment() {
        if (this._messenger.getDisplay() == null || this._messenger.getDisplay().getEnvironment() == null) {
            return EnvironmentType.PRODUCTION;
        }
        return this._messenger.getDisplay().getEnvironment();
    }

    public void setColorAdjustment(int colorAdjustment) {
        if (this._messenger.getDisplay() == null) {
            this._messenger.setDisplay(new Messenger.Display());
        }
        this._messenger.getDisplay().setColorAdjustment(Integer.valueOf(colorAdjustment));
    }

    public int getColorAdjustment() {
        if (this._messenger.getDisplay() == null || this._messenger.getDisplay().getColorAdjustment() == null) {
            return 0;
        }
        return this._messenger.getDisplay().getColorAdjustment();
    }

    public int getArchiveCleanupMaxRuntime() {
        Integer maxRuntime = Objects.isNull(this._messenger.getArchiving()) ? null : this._messenger.getArchiving().getCleanupMaxRuntime();
        return maxRuntime == null ? 0 : maxRuntime;
    }

    public void setArchiveCleanupMaxRuntime(int archiveCleanupMaxRuntime) {
        if (Objects.isNull(this._messenger.getArchiving())) {
            this._messenger.setArchiving(this._factory.createMessengerArchiving());
        }
        this._messenger.getArchiving().setCleanupMaxRuntime(Integer.valueOf(archiveCleanupMaxRuntime));
    }

    public void setDeleteArchive(boolean deleteArchive) {
        if (Objects.isNull(this._messenger.getArchiving())) {
            this._messenger.setArchiving(this._factory.createMessengerArchiving());
        }
        if (Objects.isNull(this._messenger.getArchiving().getMaximumAge())) {
            this._messenger.getArchiving().setMaximumAge(this._factory.createMessengerArchivingMaximumAge());
        }
        this._messenger.getArchiving().getMaximumAge().setEnabled(Boolean.valueOf(deleteArchive));
    }

    public XMLGregorianCalendar getArchiveCleanupTime() throws JAXBException {
        XMLGregorianCalendar cleanupTime = this._messenger.getArchiving().getCleanupTime();
        if (Objects.isNull(cleanupTime)) {
            try {
                return DatatypeFactory.newInstance().newXMLGregorianCalendarTime(3, 0, 0, Integer.MIN_VALUE);
            }
            catch (DatatypeConfigurationException e) {
                return null;
            }
        }
        return cleanupTime;
    }

    public String getArchiveCleanupTimeAsString() {
        XMLGregorianCalendar cleanupTime = this._messenger.getArchiving().getCleanupTime();
        if (Objects.isNull(cleanupTime)) {
            return "03:00:00";
        }
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
        return format.format(cleanupTime.toGregorianCalendar().getTime());
    }

    public void setArchiveCleanUpTime(String deleteTime) {
        if (StringUtils.isBlank((CharSequence)deleteTime)) {
            return;
        }
        if (Objects.isNull(this._messenger.getArchiving())) {
            this._messenger.setArchiving(this._factory.createMessengerArchiving());
        }
        try {
            this._messenger.getArchiving().setCleanupTime(XMLGregorianCalendarConverter.asXMLGregorianCalendar(deleteTime));
        }
        catch (DatatypeConfigurationException ex) {
            _log.error(ex.getMessage());
        }
    }

    public void setArchiveMaxAge(int days) {
        if (Objects.isNull(this._messenger.getArchiving())) {
            this._messenger.setArchiving(this._factory.createMessengerArchiving());
        }
        if (Objects.isNull(this._messenger.getArchiving().getMaximumAge())) {
            this._messenger.getArchiving().setMaximumAge(this._factory.createMessengerArchivingMaximumAge());
        }
        this._messenger.getArchiving().getMaximumAge().setValue(days);
    }

    public void setArchiveAdapterId(String adapterId) {
        if (Objects.isNull(this._messenger.getArchiving())) {
            this._messenger.setArchiving(this._factory.createMessengerArchiving());
        }
        this._messenger.getArchiving().setAdapterId(adapterId);
    }

    public String getArchiveAdapterId() {
        if (Objects.isNull(this._messenger.getArchiving())) {
            this._messenger.setArchiving(this._factory.createMessengerArchiving());
        }
        return this._messenger.getArchiving().getAdapterId();
    }

    public List<Messenger.XpListener> getXpListeners() {
        if (this._messenger.getXpListener() == null) {
            return Collections.emptyList();
        }
        return this._messenger.getXpListener();
    }

    public List<Messenger.XpListener> setXpListeners(List<Messenger.XpListener> xpListeners) {
        List<Messenger.XpListener> xpListeners1 = this.getXpListeners();
        xpListeners1.clear();
        xpListeners1.addAll(xpListeners);
        return xpListeners1;
    }
}

