/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.as;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;

public class MDNParameters {
    public static final String MDN_OPTION_IMPORTANCE_REQUIRED = "required";
    public static final String MDN_OPTION_IMPORTANCE_OPTIONAL = "optional";
    public static final String MDN_OPTION_SIGNED_PROTOCOL = "signed-receipt-protocol";
    public static final String MDN_OPTION_SIGNED_MICALG = "signed-receipt-micalg";
    private static final Map<String, String> MICALG_TO_DIGEST_ALGORITHM;
    public static final String MICALG_SHA1 = "sha1";
    public static final String MICALG_SHA_224 = "sha-224";
    public static final String MICALG_SHA224 = "sha224";
    public static final String MICALG_SHA_256 = "sha-256";
    public static final String MICALG_SHA256 = "sha256";
    public static final String MICALG_SHA_384 = "sha-384";
    public static final String MICALG_SHA384 = "sha384";
    public static final String MICALG_SHA_512 = "sha-512";
    public static final String MICALG_SHA512 = "sha512";
    public static final String MICALG_MD5 = "md5";
    public static final String SIGNED_RECEIPT_PROTOCOL_PKCS7_SIGNATURE = "pkcs7-signature";
    private boolean _syncReplyRequested;
    private String _asyncMDNRecipent;
    private String _dispositionNotificationTo;
    private boolean _signedReceiptProtocolRequired;
    private String[] _signedReceiptProtocolValues;
    private boolean _signedReceiptMicAlgRequired;
    private String[] _signedReceiptMicAlgValues;

    public static String getDigestAlgorithm(String micAlgorithm) {
        return MICALG_TO_DIGEST_ALGORITHM.get(micAlgorithm);
    }

    public MDNParameters(String dispositionNotificationTo) {
        this._dispositionNotificationTo = dispositionNotificationTo;
        if (this._dispositionNotificationTo != null && this._dispositionNotificationTo.length() > 0) {
            this._signedReceiptProtocolRequired = true;
            this._signedReceiptMicAlgRequired = true;
        }
    }

    public MDNParameters(String dispositionNotificationTo, String dispositionNotificationOptions) {
        this._dispositionNotificationTo = dispositionNotificationTo;
        if (dispositionNotificationOptions != null) {
            StringTokenizer optionsTokens = new StringTokenizer(dispositionNotificationOptions, ";");
            while (optionsTokens.hasMoreTokens()) {
                StringTokenizer optionTokens = new StringTokenizer(optionsTokens.nextToken(), "=,");
                while (optionTokens.hasMoreTokens()) {
                    String name = optionTokens.nextToken().trim();
                    String importance = optionTokens.nextToken().trim();
                    String[] values = new String[optionTokens.countTokens()];
                    int i = 0;
                    while (optionTokens.hasMoreTokens()) {
                        values[i] = optionTokens.nextToken().trim();
                        ++i;
                    }
                    if (MDN_OPTION_SIGNED_PROTOCOL.equalsIgnoreCase(name)) {
                        this._signedReceiptProtocolRequired = MDN_OPTION_IMPORTANCE_OPTIONAL.equals(importance) || MDN_OPTION_IMPORTANCE_REQUIRED.equals(importance);
                        this._signedReceiptProtocolValues = values;
                        continue;
                    }
                    if (!MDN_OPTION_SIGNED_MICALG.equalsIgnoreCase(name)) continue;
                    this._signedReceiptMicAlgRequired = MDN_OPTION_IMPORTANCE_OPTIONAL.equals(importance) || MDN_OPTION_IMPORTANCE_REQUIRED.equals(importance);
                    this._signedReceiptMicAlgValues = values;
                }
            }
        }
    }

    public String getDispositionNotificationTo() {
        return this._dispositionNotificationTo;
    }

    public void setDispositionNotificationTo(String dispositionNotificationTo) {
        this._dispositionNotificationTo = dispositionNotificationTo;
    }

    public boolean isSignedReceiptProtocolRequired() {
        return this._signedReceiptProtocolRequired;
    }

    public void setSignedReceiptProtocolRequired(boolean signedReceiptProtocolRequired) {
        this._signedReceiptProtocolRequired = signedReceiptProtocolRequired;
    }

    public String[] getSignedReceiptProtocolValues() {
        return this._signedReceiptProtocolValues;
    }

    public void setSignedReceiptProtocolValues(String[] signedReceiptProtocolValues) {
        this._signedReceiptProtocolValues = signedReceiptProtocolValues;
    }

    public boolean isSignedReceiptMicAlgRequired() {
        return this._signedReceiptMicAlgRequired;
    }

    public void setSignedReceiptMicAlgRequired(boolean signedReceiptMicAlgRequired) {
        this._signedReceiptMicAlgRequired = signedReceiptMicAlgRequired;
    }

    public String[] getSignedReceiptMicAlgValues() {
        return this._signedReceiptMicAlgValues;
    }

    public void setSignedReceiptMicAlgValues(String[] signedReceiptMicAlgValues) {
        this._signedReceiptMicAlgValues = signedReceiptMicAlgValues;
    }

    public boolean isSyncReplyRequested() {
        return this._syncReplyRequested;
    }

    public void setSyncReplyRequested(boolean syncReplyRequested) {
        this._syncReplyRequested = syncReplyRequested;
    }

    public String getAsyncMDNRecipient() {
        return this._asyncMDNRecipent;
    }

    public void setAsyncMDNRecipient(String asyncMDNRecipient) {
        this._asyncMDNRecipent = asyncMDNRecipient;
    }

    static {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        tempMap.put(MICALG_MD5, SMIMESignedGenerator.DIGEST_MD5);
        tempMap.put(MICALG_SHA1, SMIMESignedGenerator.DIGEST_SHA1);
        tempMap.put(MICALG_SHA_224, SMIMESignedGenerator.DIGEST_SHA224);
        tempMap.put(MICALG_SHA224, SMIMESignedGenerator.DIGEST_SHA224);
        tempMap.put(MICALG_SHA_256, SMIMESignedGenerator.DIGEST_SHA256);
        tempMap.put(MICALG_SHA256, SMIMESignedGenerator.DIGEST_SHA256);
        tempMap.put(MICALG_SHA_384, SMIMESignedGenerator.DIGEST_SHA384);
        tempMap.put(MICALG_SHA384, SMIMESignedGenerator.DIGEST_SHA384);
        tempMap.put(MICALG_SHA_512, SMIMESignedGenerator.DIGEST_SHA512);
        tempMap.put(MICALG_SHA512, SMIMESignedGenerator.DIGEST_SHA512);
        MICALG_TO_DIGEST_ALGORITHM = Collections.unmodifiableMap(tempMap);
    }
}

