/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.as;

import de.pontonconsulting.common.activation.SimpleFileDataSource;
import de.pontonconsulting.xmlpipe.as.ASObject;
import de.pontonconsulting.xmlpipe.as.MDNParameters;
import jakarta.mail.MessagingException;
import java.util.ArrayList;
import java.util.List;

public abstract class ASMessage
extends ASObject {
    protected boolean _mdnRequested;
    protected boolean _isMDN;
    protected boolean _handleResponse;
    protected MDNParameters _mdnParameters;
    protected String _micDigest;
    protected String _micAlgorithm;
    private final List<SimpleFileDataSource> _attachmentDataSources = new ArrayList<SimpleFileDataSource>();

    protected ASMessage() {
    }

    public boolean isMDNRequested() {
        return this._mdnRequested;
    }

    public void setMDNRequested(boolean mdnRequested) {
        this._mdnRequested = mdnRequested;
    }

    public MDNParameters getMDNParameters() {
        return this._mdnParameters;
    }

    public void setMDNParameters(MDNParameters mdnParameters) {
        this._mdnParameters = mdnParameters;
    }

    public boolean isHandleResponse() {
        return this._handleResponse;
    }

    public void setHandleResponse(boolean handleResponse) {
        this._handleResponse = handleResponse;
    }

    @Override
    protected void createHeaders() throws MessagingException {
        super.createHeaders();
        if (this.isMDNRequested()) {
            this._headers.setHeader("Disposition-Notification-To", this._mdnParameters.getDispositionNotificationTo());
            if (this._mdnParameters.getSignedReceiptProtocolValues() != null && this._mdnParameters.getSignedReceiptProtocolValues().length > 0) {
                int i;
                StringBuilder dispositionOpts = new StringBuilder();
                dispositionOpts.append("signed-receipt-protocol");
                dispositionOpts.append("=");
                if (this._mdnParameters.isSignedReceiptProtocolRequired()) {
                    dispositionOpts.append("required");
                } else {
                    dispositionOpts.append("optional");
                }
                for (i = 0; i < this._mdnParameters.getSignedReceiptProtocolValues().length; ++i) {
                    dispositionOpts.append(",");
                    dispositionOpts.append(this._mdnParameters.getSignedReceiptProtocolValues()[i]);
                }
                dispositionOpts.append(";");
                dispositionOpts.append("signed-receipt-micalg");
                dispositionOpts.append("=");
                if (this._mdnParameters.isSignedReceiptMicAlgRequired()) {
                    dispositionOpts.append("required");
                } else {
                    dispositionOpts.append("optional");
                }
                for (i = 0; i < this._mdnParameters.getSignedReceiptMicAlgValues().length; ++i) {
                    dispositionOpts.append(",");
                    dispositionOpts.append(this._mdnParameters.getSignedReceiptMicAlgValues()[i]);
                }
                this._headers.setHeader("Disposition-Notification-Options", dispositionOpts.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttahmentDataSource(SimpleFileDataSource dataSource) {
        List<SimpleFileDataSource> list = this._attachmentDataSources;
        synchronized (list) {
            this._attachmentDataSources.add(dataSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllAttachmentDataSources() {
        List<SimpleFileDataSource> list = this._attachmentDataSources;
        synchronized (list) {
            for (SimpleFileDataSource simpleFileDataSource : this._attachmentDataSources) {
                simpleFileDataSource.close();
            }
            this._attachmentDataSources.clear();
        }
    }

    public void setMICValue(String micDigest, String micAlgorithm) {
        this._micDigest = micDigest;
        this._micAlgorithm = micAlgorithm;
    }

    public String getMICDigest() {
        return this._micDigest;
    }

    public String getMICAlgorithm() {
        return this._micAlgorithm;
    }
}

