/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.as;

import de.pontonconsulting.xmlpipe.as.AS3Message;
import de.pontonconsulting.xmlpipe.as.AS3Report;
import de.pontonconsulting.xmlpipe.as.ASException;
import de.pontonconsulting.xmlpipe.as.ASMessage;
import de.pontonconsulting.xmlpipe.as.ASObject;
import de.pontonconsulting.xmlpipe.as.ASObjectFactory;
import de.pontonconsulting.xmlpipe.as.ASReport;
import de.pontonconsulting.xmlpipe.as.IAS3Object;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.smime.SMIMESigner;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.InternetHeaders;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import java.util.List;

public class AS3ObjectFactory
extends ASObjectFactory {
    private static final String USER_AGENT = "PontonXP AS3-Processor";
    public static final String HEADER_SUBJECT_VALUE = "AS3 Business Message";
    public static final String PARTYID_TYPE = "AS3-Name";
    public static final String HEADER_AS3_VERSION = "AS3-Version";
    public static final String HEADER_AS3_VERSION_1_0 = "1.0";
    public static final String HEADER_AS3_VERSION_1_1 = "1.1";
    public static final String HEADER_AS3_FROM = "AS3-From";
    public static final String HEADER_AS3_TO = "AS3-To";

    public AS3ObjectFactory(IdGenerator idGenerator, ReferenceDateTask referenceDateTask, CertificateUtility certificateUtility, SMIMESigner smimeSigner, Profiles profiles) {
        super(idGenerator, referenceDateTask, certificateUtility, smimeSigner, profiles);
    }

    @Override
    public AS3Message createASMessage(InternetHeaders headers, ContentType contentType, MimeBodyPart mimePart) throws ASException, MessagingException {
        AS3Message as3Message = new AS3Message();
        this.initASMessage(as3Message, headers, mimePart);
        return as3Message;
    }

    @Override
    public AS3Report createASReport(InternetHeaders headers, ContentType contentType, MimeBodyPart mimePart) throws ASException, MessagingException {
        AS3Report as3Report = new AS3Report(this._certificateUtility, this._smimeSigner, this.referenceDateTask);
        this.initASReport(as3Report, headers, mimePart);
        return as3Report;
    }

    public IAS3Object createAS3Object(MimeMessage mimeMessage) throws ASException, MessagingException, IOException {
        return (IAS3Object)((Object)super.createASObject(mimeMessage));
    }

    public AS3Message createAS3Message(XpMessage message) throws ASException {
        AS3Message as3Message = new AS3Message();
        this.initASMessage(as3Message, message);
        as3Message.setAS3Version(HEADER_AS3_VERSION_1_1);
        try {
            CppPartner ownPartner = this._profiles.getProfileForLocalId(message.getAgreement().getOwnPartner().getId(), true);
            as3Message.setFrom(ownPartner.getPartyIdValue(PARTYID_TYPE));
            if (as3Message.getFrom() == null || as3Message.getFrom().length() == 0) {
                throw new ASException(43010, "Sender AS3 name is not set.");
            }
        }
        catch (ProfileException e) {
            throw new ASException(43010, "Sender is not set.");
        }
        try {
            CppPartner communicationPartner = this._profiles.getProfileForLocalId(message.getAgreement().getCommunicationPartner().getId(), true);
            as3Message.setTo(communicationPartner.getPartyIdValue(PARTYID_TYPE));
            if (as3Message.getTo() == null || as3Message.getTo().length() == 0) {
                throw new ASException(43011, "Receiver AS3 name is not set.");
            }
        }
        catch (ProfileException e) {
            throw new ASException(43011, "Receiver is not set.");
        }
        return as3Message;
    }

    public AS3Report createOKReport(ASMessage asMessage, String statusDescription) {
        AS3Report as3Report = new AS3Report(this._certificateUtility, this._smimeSigner, this.referenceDateTask);
        this.initOKASReport(as3Report, asMessage, statusDescription);
        return as3Report;
    }

    public AS3Report createErrorReport(ASMessage asMessage, ASReport.DispositionModifier dispositionModifier, ASReport.DispositionModifierExtension dispositionModifierExtension, String statusDescription, List<String> details) {
        AS3Report as3Report = new AS3Report(this._certificateUtility, this._smimeSigner, this.referenceDateTask);
        this.initErrorASReport(as3Report, asMessage, dispositionModifier, dispositionModifierExtension, statusDescription, details);
        return as3Report;
    }

    @Override
    protected void parseASMessageHeaders(ASMessage asMessage) throws MessagingException {
        AS3Message as3Message = (AS3Message)asMessage;
        InternetHeaders headers = as3Message.getInternetHeaders();
        if (headers.getHeader("Receipt-Delivery-Option") != null && headers.getHeader("Receipt-Delivery-Option").length > 0) {
            as3Message.getMDNParameters().setSyncReplyRequested(false);
            as3Message.getMDNParameters().setAsyncMDNRecipient(headers.getHeader("Receipt-Delivery-Option")[0]);
        } else {
            as3Message.getMDNParameters().setSyncReplyRequested(true);
        }
    }

    @Override
    protected void parseASObjectHeaders(ASObject asObject) throws MessagingException {
        InternetHeaders headers = asObject.getInternetHeaders();
        if (headers.getHeader(HEADER_AS3_FROM) != null && headers.getHeader(HEADER_AS3_FROM).length > 0) {
            asObject.setFrom(headers.getHeader(HEADER_AS3_FROM)[0]);
        }
        if (headers.getHeader(HEADER_AS3_TO) != null && headers.getHeader(HEADER_AS3_TO).length > 0) {
            asObject.setTo(headers.getHeader(HEADER_AS3_TO)[0]);
        }
        if (headers.getHeader(HEADER_AS3_VERSION) != null && headers.getHeader(HEADER_AS3_VERSION).length > 0) {
            ((IAS3Object)((Object)asObject)).setAS3Version(headers.getHeader(HEADER_AS3_VERSION)[0]);
        }
    }

    @Override
    protected String getUserAgent() {
        return USER_AGENT;
    }
}

