/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.as;

import de.pontonconsulting.xmlpipe.as.AS1Message;
import de.pontonconsulting.xmlpipe.as.AS1Report;
import de.pontonconsulting.xmlpipe.as.ASException;
import de.pontonconsulting.xmlpipe.as.ASMessage;
import de.pontonconsulting.xmlpipe.as.ASObject;
import de.pontonconsulting.xmlpipe.as.ASObjectFactory;
import de.pontonconsulting.xmlpipe.as.ASReport;
import de.pontonconsulting.xmlpipe.as.IAS1Object;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.smime.SMIMESigner;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.InternetHeaders;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AS1ObjectFactory
extends ASObjectFactory {
    private static final String USER_AGENT = "PontonXP AS1-Processor";
    public static final String HEADER_SUBJECT_VALUE = "AS1 Business Message";
    public static final String PARTYID_TYPE = "E-Mail";

    public AS1ObjectFactory(IdGenerator idGenerator, ReferenceDateTask referenceDateTask, CertificateUtility certificateUtility, SMIMESigner smimeSigner, Profiles profiles) {
        super(idGenerator, referenceDateTask, certificateUtility, smimeSigner, profiles);
    }

    @Override
    public AS1Message createASMessage(InternetHeaders headers, ContentType contentType, MimeBodyPart mimePart) throws ASException, MessagingException {
        AS1Message as1Message = new AS1Message();
        this.initASMessage(as1Message, headers, mimePart);
        return as1Message;
    }

    @Override
    public AS1Report createASReport(InternetHeaders headers, ContentType contentType, MimeBodyPart mimePart) throws ASException, MessagingException {
        AS1Report as1Report = new AS1Report(this._certificateUtility, this._smimeSigner, this.referenceDateTask);
        this.initASReport(as1Report, headers, mimePart);
        return as1Report;
    }

    public IAS1Object createAS1Object(MimeMessage mimeMessage) throws ASException, MessagingException, IOException {
        return (IAS1Object)((Object)super.createASObject(mimeMessage));
    }

    public AS1Message createAS1Message(XpMessage message) throws ASException {
        AS1Message as1Message = new AS1Message();
        this.initASMessage(as1Message, message);
        String to = message.getCommunication().getTransportURL();
        if (!to.toLowerCase().startsWith("mailto:") && !to.toLowerCase().startsWith("smime:")) {
            throw new ASException(43008, "Selected tranport url is not allowed: '" + to + "'. AS1Messages can only be send via smtp.");
        }
        if (to.indexOf(":") > 0) {
            to = to.substring(to.indexOf(":") + 1);
        }
        as1Message.setTo(to);
        return as1Message;
    }

    public AS1Report createOKReport(ASMessage asMessage, String statusDescription) {
        AS1Report as1Report = new AS1Report(this._certificateUtility, this._smimeSigner, this.referenceDateTask);
        this.initOKASReport(as1Report, asMessage, statusDescription);
        return as1Report;
    }

    public AS1Report createErrorReport(ASMessage asMessage, ASReport.DispositionModifier dispositionModifier, ASReport.DispositionModifierExtension dispositionModifierExtension, String statusDescription, List<String> details) {
        AS1Report as1Report = new AS1Report(this._certificateUtility, this._smimeSigner, this.referenceDateTask);
        this.initErrorASReport(as1Report, asMessage, dispositionModifier, dispositionModifierExtension, statusDescription, details);
        return as1Report;
    }

    @Override
    protected void parseASMessageHeaders(ASMessage asMessage) throws MessagingException {
    }

    @Override
    protected void parseASObjectHeaders(ASObject asObject) throws MessagingException {
        int i;
        String[] emails;
        IAS1Object as1Object = (IAS1Object)((Object)asObject);
        InternetHeaders headers = asObject.getInternetHeaders();
        if (headers.getHeader("From") != null && headers.getHeader("From").length > 0) {
            emails = headers.getHeader("From");
            ArrayList<InternetAddress> fromEMailAddresses = new ArrayList<InternetAddress>();
            for (i = 0; i < emails.length; ++i) {
                try {
                    fromEMailAddresses.add(new InternetAddress(emails[i]));
                    continue;
                }
                catch (AddressException addressException) {
                    // empty catch block
                }
            }
            as1Object.setFromEMailAddresses(fromEMailAddresses.toArray(new InternetAddress[0]));
            if (as1Object.getFromEMailAddresses().length > 0) {
                asObject.setFrom(as1Object.getFromEMailAddresses()[0].getAddress());
            } else {
                asObject.setFrom(emails[0]);
            }
        }
        if (headers.getHeader("To") != null && headers.getHeader("To").length > 0) {
            emails = headers.getHeader("To");
            ArrayList<InternetAddress> toEMailAddresses = new ArrayList<InternetAddress>();
            for (i = 0; i < emails.length; ++i) {
                try {
                    toEMailAddresses.add(new InternetAddress(emails[i]));
                    continue;
                }
                catch (AddressException addressException) {
                    // empty catch block
                }
            }
            as1Object.setToEMailAddresses(toEMailAddresses.toArray(new InternetAddress[0]));
            if (as1Object.getToEMailAddresses().length > 0) {
                asObject.setTo(as1Object.getToEMailAddresses()[0].getAddress());
            } else {
                asObject.setTo(emails[0]);
            }
        }
    }

    @Override
    protected String getUserAgent() {
        return USER_AGENT;
    }

    @Override
    public void afterPropertiesSet() {
    }
}

