/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.admintool.registry.index;

import de.pontonconsulting.xmlpipe.adapter.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.csv.CSVRecord;

public class IndexRecord {
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
    private String path;
    private String filename;
    private String filepath;
    private String suffix;
    private String displayName;
    private Date lastModified;
    private String partnerId;

    public IndexRecord(CSVRecord record) {
        if (record.size() >= 1) {
            this.readFilePath(record.get(0));
        }
        if (record.size() >= 2) {
            this.readDisplayName(record.get(1));
        }
        if (record.size() >= 3) {
            this.readLastModified(record.get(2));
        }
        if (record.size() >= 4) {
            this.readParnerId(record.get(3));
        }
    }

    private void readFilePath(String field) {
        this.filepath = field.substring(1);
        String[] filepathArray = this.filepath.split("/");
        this.path = filepathArray[0];
        String fullFilename = filepathArray[1];
        String[] spiltFilename = fullFilename.split("\\.");
        this.filename = spiltFilename[0];
        if (spiltFilename.length > 1) {
            this.suffix = spiltFilename[1];
        }
    }

    private void readDisplayName(String field) {
        this.displayName = field;
    }

    private void readLastModified(String field) {
        if (field != null) {
            long l = Long.valueOf(field) / 1000L * 1000L;
            this.lastModified = new Date(l);
        }
    }

    private void readParnerId(String field) {
        this.partnerId = field;
    }

    public String getFullFilename() {
        return this.filename + "." + this.suffix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getPath() {
        return this.path;
    }

    public String getFilePath() {
        return this.filepath;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public long getLastModifiedLong() {
        return this.lastModified.getTime();
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public boolean isValid() {
        return StringUtils.isNotBlank((CharSequence)this.filepath) && this.lastModified != null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("IndexRecord [");
        buffer.append("path=").append(this.filepath);
        buffer.append(" , displayName=").append(this.displayName);
        if (this.lastModified != null) {
            buffer.append(" , lastModified=").append(this.sdf.format(this.lastModified));
        }
        if (this.partnerId != null) {
            buffer.append(" , partnerId=").append(this.partnerId);
        }
        buffer.append("]");
        return buffer.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = 31 * result + (this.lastModified == null ? 0 : this.lastModified.hashCode());
        result = 31 * result + (this.filepath == null ? 0 : this.filepath.hashCode());
        result = 31 * result + (this.partnerId == null ? 0 : this.partnerId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexRecord other = (IndexRecord)obj;
        if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
            return false;
        }
        if (this.lastModified == null ? other.lastModified != null : !this.lastModified.equals(other.lastModified)) {
            return false;
        }
        if (this.filepath == null ? other.filepath != null : !this.filepath.equals(other.filepath)) {
            return false;
        }
        return !(this.partnerId == null ? other.partnerId != null : !this.partnerId.equals(other.partnerId));
    }
}

