/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.admintool.partner.update;

import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.messenger.database.tables.EventLog;

public class ProfileUpdate {
    private static final String EVENT_ID = "profileUpdate";
    private static final String PACKAGING = "packaging";
    private static final String PROCESSING = "processing";
    private static final String SUB_EVENT_ID_DELETE = "delete";
    private static final String SUB_EVENT_ID_ADD = "add";
    private final EventLog eventLog;

    public ProfileUpdate(EventLog EventLog2) {
        this.eventLog = EventLog2;
    }

    public boolean update(CppPartner partner) {
        return this.updatePackaging(partner) | this.updateProcessing(partner);
    }

    private boolean updateProcessing(CppPartner partner) {
        boolean changed = false;
        String link = this.getLink(PROCESSING, partner);
        if (partner.deleteUnknownPipelines()) {
            changed = true;
            try {
                this.eventLog.writeOK(this.getEventId(PROCESSING, SUB_EVENT_ID_DELETE, partner), "profileUpdate.processing.deletePipeline.component", "profileUpdate.processing.deletePipeline.descriptionKey", "", new String[]{partner.getDisplayName()}, link);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (partner.addPipelines()) {
            changed = true;
            try {
                this.eventLog.writeOK(this.getEventId(PROCESSING, SUB_EVENT_ID_ADD, partner), "profileUpdate.processing.addPipeline.component", "profileUpdate.processing.addPipeline.descriptionKey", "", new String[]{partner.getDisplayName()}, link);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return changed;
    }

    private boolean updatePackaging(CppPartner partner) {
        boolean changed = false;
        String link = this.getLink(PACKAGING, partner);
        if (partner.deleteUnknownPackages()) {
            changed = true;
            try {
                this.eventLog.writeOK(this.getEventId(PACKAGING, SUB_EVENT_ID_DELETE, partner), "profileUpdate.packaging.deletePackage.component", "profileUpdate.packaging.deletePackage.descriptionKey", "", new String[]{partner.getDisplayName()}, link);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (partner.addPackages()) {
            changed = true;
            try {
                this.eventLog.writeOK(this.getEventId(PACKAGING, SUB_EVENT_ID_ADD, partner), "profileUpdate.packaging.addPackage.component", "profileUpdate.packaging.addPackage.descriptionKey", "", new String[]{partner.getDisplayName()}, link);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return changed;
    }

    private String getEventId(String objectOfChange, String kindOfChange, CppPartner partner) {
        return "profileUpdate." + partner.getLocalId() + "." + objectOfChange + "." + kindOfChange + "." + System.currentTimeMillis();
    }

    private String getLink(String objectOfChange, CppPartner partner) {
        String link = partner.isRemote() ? "/private/partners/ShowNonLocalPartners.do" : "/private/partners/ShowLocalPartners.do";
        return link + "?localID=" + partner.getLocalId() + "&tabName=" + objectOfChange;
    }
}

