/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter.pingall;

import de.pontonconsulting.xmlpipe.adapter.AdapterException;
import de.pontonconsulting.xmlpipe.adapter.AgreementPartners;
import de.pontonconsulting.xmlpipe.adapter.GenericAdapter;
import de.pontonconsulting.xmlpipe.adapter.ISpecificAdapter;
import de.pontonconsulting.xmlpipe.adapter.MessageResult;
import de.pontonconsulting.xmlpipe.adapter.pingall.PingResult;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.message.BackEndMessage;
import de.pontonconsulting.xmlpipe.message.BackEndMessageException;
import de.pontonconsulting.xmlpipe.message.XpAcknowledgment;
import de.pontonconsulting.xmlpipe.message.ack.XpAcknowledgment;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.AgreementListItem;
import jakarta.xml.bind.JAXBException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PingAllThread
implements ISpecificAdapter {
    public static final String PINGALL_ADAPTER_ID = "PingAll";
    private static final List<String> SUPPORTED_PACKAGES = List.of("EbXml20", "AS4");
    private static final String MESSENGER_ADDRESS = "localhost";
    private static final int MESSENGER_PORT = 8080;
    private static final String MESSENGER_PATH = "/pontonxp/AdapterService";
    private static final String SEPARATOR = "_#$%&_";
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.PingAllThread");
    private final MessengerConfig messengerConfig;
    private final ReferenceDateTask referenceDateTask;
    private final Agreements agreements;
    private GenericAdapter genericAdapter;
    private final Object syncObject = new Object();
    private final Map<String, PingResult> pingResults = new ConcurrentHashMap<String, PingResult>();
    private final Map<String, PingResult> workMap = new ConcurrentHashMap<String, PingResult>();
    private final AtomicInteger pingCounter = new AtomicInteger();

    public PingAllThread(MessengerConfig messengerConfig, ReferenceDateTask referenceDateTask, Agreements agreements) {
        this.messengerConfig = messengerConfig;
        this.referenceDateTask = referenceDateTask;
        this.agreements = agreements;
    }

    private XpAcknowledgment readAckXml(BackEndMessage beMessage) throws BackEndMessageException, JAXBException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        beMessage.writeMessageDocumentTo((OutputStream)out);
        return new XpAcknowledgment(out.toByteArray());
    }

    public int getInterval() {
        try {
            return this.messengerConfig.getPingAllInterval();
        }
        catch (JAXBException e) {
            LOG.error("Cannot parse PingAll interval", (Throwable)e);
            return 30;
        }
    }

    public boolean isEnabled() {
        return this.messengerConfig.isPingAllEnabled();
    }

    public int getPendingPings() {
        return this.pingCounter.get();
    }

    public Map<String, PingResult> getPingResults() {
        return Map.copyOf(this.pingResults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResult receiveAcknowledgement(BackEndMessage message) {
        String senderId = message.getSenderOrganisationText();
        LOG.info("Receiving acknowledgment from: '" + senderId + "' for message: '" + message.getReferenceId() + "'");
        PingResult pingResult = this.workMap.get(message.getReferenceId());
        if (pingResult != null) {
            try {
                XpAcknowledgment ack = this.readAckXml(message);
                Date replyTime = this.referenceDateTask.getReferenceDate();
                pingResult.setReplyTime(replyTime);
                Date pingTime = pingResult.getPingTime();
                if (pingTime != null) {
                    pingResult.setDuration((int)(replyTime.getTime() - pingTime.getTime()));
                }
                pingResult.setReplyMessageId(ack.getMessageId());
                List<XpAcknowledgment.Results> resultList = ack.getResults();
                StringBuilder results = new StringBuilder();
                for (int i = 0; i < resultList.size(); ++i) {
                    XpAcknowledgment.Results result = resultList.get(i);
                    String resultDescription = result.getDescription();
                    results.append(resultDescription);
                    if (i >= resultList.size() - 1) continue;
                    results.append("\n");
                }
                pingResult.setDescription(results.toString());
                String overallResult = ack.getOverallResult();
                pingResult.setError("Error".equals(overallResult));
            }
            catch (Exception e) {
                LOG.fatal("Could not reconstruct Acknowledgement:", (Throwable)e);
                pingResult.setDescription("Could not reconstruct result.");
                pingResult.setError(true);
                return new MessageResult(MessageResult.BACKENDMSG_COULD_NOT_BE_RECONSTRUCTED);
            }
            Object object = this.syncObject;
            synchronized (object) {
                this.workMap.remove(message.getReferenceId());
                this.pingCounter.decrementAndGet();
                this.pingResults.put(pingResult.getSenderId() + SEPARATOR + pingResult.getReceiverId() + SEPARATOR + pingResult.getUrlType(), pingResult);
            }
        }
        return new MessageResult(MessageResult.MSG_SUCCESSFULLY_RECEIVED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pingAllPartners() throws AdapterException {
        List<AgreementPartners> agreementPartnersList = this.agreements.getAgreementList().stream().filter(AgreementListItem::isPingAllEnabled).filter(a -> SUPPORTED_PACKAGES.contains(a.getPackagingId())).map(a -> new AgreementPartners(a.getOwnPartnerBackendId(), a.getCommunicationPartnerBackendId())).toList();
        Object object = this.syncObject;
        synchronized (object) {
            this.workMap.clear();
            this.pingCounter.set(0);
        }
        ArrayList newKeys = new ArrayList();
        for (AgreementPartners agreementPartners : agreementPartnersList) {
            String senderId = agreementPartners.getLocalPartnerId();
            String receiverId = agreementPartners.getRemotePartnerId();
            AtomicInteger index = new AtomicInteger();
            this.sendPing(senderId, receiverId).forEach(msgResult -> {
                Date pingTime = new Date(Long.parseLong(msgResult.getMessageTime()));
                String urlType = index.getAndIncrement() == 0 ? "primary" : "fallback";
                String key = senderId + SEPARATOR + receiverId + SEPARATOR + urlType;
                newKeys.add(key);
                PingResult pingResult = new PingResult();
                pingResult.setPingMessageId(msgResult.getMessageId());
                pingResult.setSenderId(senderId);
                pingResult.setReceiverId(receiverId);
                pingResult.setPingTime(pingTime);
                pingResult.setUrlType(urlType);
                if (!msgResult.equals((Object)MessageResult.MSG_SUCCESSFULLY_SEND)) {
                    pingResult.setError(true);
                    pingResult.setDescription(msgResult.getDescription());
                    Date replyTime = this.referenceDateTask.getReferenceDate();
                    pingResult.setReplyTime(replyTime);
                    pingResult.setDuration((int)(replyTime.getTime() - pingTime.getTime()));
                    Object object = this.syncObject;
                    synchronized (object) {
                        this.pingCounter.decrementAndGet();
                        this.pingResults.put(key, pingResult);
                    }
                }
                Object object = this.syncObject;
                synchronized (object) {
                    this.workMap.put(pingResult.getPingMessageId(), pingResult);
                }
            });
        }
        Object object2 = this.syncObject;
        synchronized (object2) {
            this.pingResults.keySet().removeIf(key -> !newKeys.contains(key));
        }
    }

    private List<MessageResult> sendPing(String senderId, String receiverId) throws AdapterException {
        LOG.debug("Sending PING from '{}' to '{}'", (Object)senderId, (Object)receiverId);
        List results = this.genericAdapter.sendPings(senderId, receiverId);
        results.forEach(result -> {
            Object object = this.syncObject;
            synchronized (object) {
                this.pingCounter.getAndIncrement();
            }
            LOG.debug("Sent PING from '{}' to '{}' : '{}'", (Object)senderId, (Object)receiverId, (Object)result.getMessageId());
        });
        return results;
    }

    public void startAdapter() {
        if (Objects.isNull(this.genericAdapter)) {
            try {
                this.genericAdapter = new GenericAdapter(this.getID());
                this.genericAdapter.setEndAdapter((ISpecificAdapter)this);
                this.genericAdapter.addMessengerConnection(MESSENGER_ADDRESS, 8080, MESSENGER_PATH);
            }
            catch (Exception e) {
                LOG.error("Could not register ping all adapter.", (Throwable)e);
            }
        }
    }

    void setGenericAdapter(GenericAdapter genericAdapter) {
        this.genericAdapter = genericAdapter;
    }

    public String getID() {
        return PINGALL_ADAPTER_ID;
    }

    public String getStatus() {
        return "PingAll Enabled: " + this.isEnabled() + "<BR/>PingAll Interval: " + this.getInterval() + " minute(s)";
    }

    public File getWorkFolder() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    public boolean doSelfCheck() {
        return true;
    }

    public String shutdown() {
        LOG.debug("PingAllThread shutting down");
        if (this.genericAdapter != null) {
            this.genericAdapter.shutdown();
        }
        return "PingAllThread is shutdown";
    }

    public boolean supportsAcknowledgements() {
        return true;
    }

    public boolean supportsAttachments() {
        return false;
    }

    public int getNumberOfParallelThreads() {
        return 5;
    }

    public MessageResult receiveMessage(BackEndMessage message) {
        throw new RuntimeException("Not Implemented.");
    }

    public MessageResult receiveTestMessage(BackEndMessage message) {
        throw new RuntimeException("Not Implemented.");
    }
}

