/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter.hotfolder.support;

import de.pontonconsulting.xmlpipe.adapter.activation.MimeTypeMapper;
import de.pontonconsulting.xmlpipe.message.BackEndMessage;
import de.pontonconsulting.xmlpipe.message.BackEndMessageException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.Assert;

public class CustomNameBuilder {
    public static final Logger LOG = LogManager.getLogger((String)"HotFolder");
    public static final char BORDER_CHAR = '%';
    public static final String ORIGINAL_FILENAME = "original_filename";
    public static final String TIMESTAMP = "timestamp";
    public static final String TEST_FLAG = "test_flag";
    public static final String SCHEMA_SET = "schema_set";
    public static final String MESSAGE_TYPE = "message_type";
    public static final String MESSAGE_VERSION = "message_version";
    public static final String RECEIVER = "receiver";
    public static final String SENDER = "sender";
    public static final String CONVERSATION_ID = "conversation_id";
    public static final String MESSAGE_ID = "message_id";
    public static final String DATABASE_ID = "database_id";
    public static final String DEFAULT_EXTENSION = "default_extension";
    public static final String ORIGINAL_EXTENSION = "original_extension";
    public static final String PROCESSING_DIRECTIVE_PREFIX = "processing_directive_";
    public static final String CREATION_TIME_PREFIX = "creation_time_";
    public static final String PATTERN_VARIABLES;
    private static final SortedSet<String> SUPPORTED_PARAMETERS;
    private static final Pattern FILE_NAME_PATTERN;
    private final String patternValue;
    private final List<String> variables;

    public CustomNameBuilder(String patternValue) {
        this(patternValue, true);
    }

    public CustomNameBuilder(String patternValue, boolean forFilename) {
        this.patternValue = patternValue;
        this.variables = this.parseVariables(this.patternValue);
        if (forFilename) {
            Assert.notNull(this.variables, (String)"Variables should not be null.");
        }
    }

    private List<String> parseVariables(String filenamePattern) {
        ArrayList<String> vars = new ArrayList<String>();
        Matcher matcher = FILE_NAME_PATTERN.matcher(filenamePattern);
        while (matcher.find()) {
            String variable = StringUtils.substring((String)filenamePattern, (int)(matcher.start() + 1), (int)(matcher.end() - 1));
            if ((vars.contains(variable) || !SUPPORTED_PARAMETERS.contains(variable)) && !variable.startsWith(PROCESSING_DIRECTIVE_PREFIX) && !variable.startsWith(CREATION_TIME_PREFIX)) continue;
            vars.add(variable);
        }
        return vars;
    }

    public String build(BackEndMessage message) throws BackEndMessageException {
        String filename = message.getProcessingDirectiveAsString("OriginalFilename");
        String name = this.patternValue;
        if (this.variables != null) {
            for (String variable : this.variables) {
                if (variable.equals(DATABASE_ID)) {
                    if (message.getDatabaseId() == null) {
                        throw new BackEndMessageException("Database Id is not set.");
                    }
                    name = name.replaceAll(CustomNameBuilder.createBorderedVariable(variable), message.getDatabaseId());
                    continue;
                }
                if (variable.equals(MESSAGE_ID)) {
                    if (message.getTransferIDText() == null) {
                        throw new BackEndMessageException("Message Id is not set.");
                    }
                    name = name.replaceAll(CustomNameBuilder.createBorderedVariable(variable), message.getTransferIDText());
                    continue;
                }
                if (variable.equals(CONVERSATION_ID)) {
                    if (message.getConversationIDText() == null) {
                        throw new BackEndMessageException("Conversation Id is not set.");
                    }
                    name = name.replaceAll(CustomNameBuilder.createBorderedVariable(variable), message.getConversationIDText());
                    continue;
                }
                if (variable.equals(SENDER)) {
                    if (message.getSenderOrganisationText() == null) {
                        throw new BackEndMessageException("Sender Id is not set.");
                    }
                    name = name.replaceAll(CustomNameBuilder.createBorderedVariable(variable), message.getSenderOrganisationText());
                    continue;
                }
                if (variable.equals(RECEIVER)) {
                    if (message.getReceiverOrganisationText() == null) {
                        throw new BackEndMessageException("Receiver Id is not set.");
                    }
                    name = name.replaceAll(CustomNameBuilder.createBorderedVariable(variable), message.getReceiverOrganisationText());
                    continue;
                }
                if (variable.equals(MESSAGE_TYPE)) {
                    if (message.getMessageName() == null) {
                        throw new BackEndMessageException("Message type is not set.");
                    }
                    name = name.replaceAll(CustomNameBuilder.createBorderedVariable(variable), message.getMessageName());
                    continue;
                }
                if (variable.equals(SCHEMA_SET)) {
                    if (message.getDTDSetText() == null) {
                        throw new BackEndMessageException("Schema set is not set.");
                    }
                    name = name.replaceAll(CustomNameBuilder.createBorderedVariable(variable), message.getDTDSetText());
                    continue;
                }
                if (variable.equals(MESSAGE_VERSION)) {
                    if (message.getDTDVersionNumberText() == null) {
                        throw new BackEndMessageException("Message version is not set.");
                    }
                    name = name.replaceAll(CustomNameBuilder.createBorderedVariable(variable), message.getDTDVersionNumberText());
                    continue;
                }
                if (variable.equals(TIMESTAMP)) {
                    name = name.replaceAll(CustomNameBuilder.createBorderedVariable(variable), String.valueOf(new Date().getTime()));
                    continue;
                }
                if (variable.equals(TEST_FLAG)) {
                    if (message.getTestFlag() == null) {
                        throw new BackEndMessageException("Test flag Id is not set.");
                    }
                    name = name.replaceAll(CustomNameBuilder.createBorderedVariable(variable), message.getTestFlag());
                    continue;
                }
                if (variable.equals(ORIGINAL_FILENAME)) {
                    if (filename == null) {
                        throw new BackEndMessageException("Original filename is not set.");
                    }
                    name = name.replaceAll(CustomNameBuilder.createBorderedVariable(variable), FilenameUtils.getBaseName((String)filename));
                    continue;
                }
                if (variable.equals(ORIGINAL_EXTENSION)) {
                    if (filename == null) {
                        throw new BackEndMessageException("Original filename is not set.");
                    }
                    name = name.replaceAll(CustomNameBuilder.createBorderedVariable(variable), FilenameUtils.getExtension((String)filename));
                    continue;
                }
                if (variable.equals(DEFAULT_EXTENSION)) {
                    name = name.replaceAll(CustomNameBuilder.createBorderedVariable(variable), FilenameUtils.getExtension((String)MimeTypeMapper.getExtension((String)message.getMimeType())));
                    continue;
                }
                if (variable.startsWith(PROCESSING_DIRECTIVE_PREFIX) && variable.length() > PROCESSING_DIRECTIVE_PREFIX.length()) {
                    String processingDirectiveKey = message.getProcessingDirectiveAsString(variable.substring(PROCESSING_DIRECTIVE_PREFIX.length()));
                    Optional<String> processingDirectiveValue = Optional.ofNullable(processingDirectiveKey);
                    if (processingDirectiveValue.isEmpty()) {
                        LOG.warn(message.getDatabaseId(), (Object)("No processing directive found with the key '" + processingDirectiveKey + "'."));
                    }
                    name = name.replaceAll(CustomNameBuilder.createBorderedVariable(variable), processingDirectiveValue.orElse(""));
                    continue;
                }
                if (!variable.startsWith(CREATION_TIME_PREFIX) || variable.length() <= CREATION_TIME_PREFIX.length()) continue;
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(variable.substring(CREATION_TIME_PREFIX.length()));
                name = name.replaceAll(CustomNameBuilder.createBorderedVariable(variable), simpleDateFormat.format(new Date(message.getCreationTimestamp())));
            }
        }
        return name;
    }

    public static String createBorderedVariable(String variable) {
        if (StringUtils.isBlank((CharSequence)variable)) {
            return null;
        }
        return "%" + variable.trim() + "%";
    }

    static {
        SUPPORTED_PARAMETERS = new TreeSet<String>();
        FILE_NAME_PATTERN = Pattern.compile("%[a-zA-Z]+[a-zA-Z0-9_':\\-\\.]*%");
        SUPPORTED_PARAMETERS.add(DATABASE_ID);
        SUPPORTED_PARAMETERS.add(MESSAGE_ID);
        SUPPORTED_PARAMETERS.add(CONVERSATION_ID);
        SUPPORTED_PARAMETERS.add(SENDER);
        SUPPORTED_PARAMETERS.add(RECEIVER);
        SUPPORTED_PARAMETERS.add(MESSAGE_TYPE);
        SUPPORTED_PARAMETERS.add(SCHEMA_SET);
        SUPPORTED_PARAMETERS.add(MESSAGE_VERSION);
        SUPPORTED_PARAMETERS.add(TIMESTAMP);
        SUPPORTED_PARAMETERS.add(TEST_FLAG);
        SUPPORTED_PARAMETERS.add(DEFAULT_EXTENSION);
        SUPPORTED_PARAMETERS.add(ORIGINAL_FILENAME);
        SUPPORTED_PARAMETERS.add(ORIGINAL_EXTENSION);
        StringBuilder builder = new StringBuilder();
        for (String param : SUPPORTED_PARAMETERS) {
            builder.append(CustomNameBuilder.createBorderedVariable(param)).append(", ");
        }
        String trimedString = builder.toString().trim();
        PATTERN_VARIABLES = trimedString.substring(0, trimedString.length() - 1);
    }
}

