/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter.hotfolder.config;

import de.pontonconsulting.common.file.DBConfigChangeWatcher;
import de.pontonconsulting.common.file.IFileChangeListener;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.config.HotFolderCfg;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.config.IHotFolderConfigurationListener;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.support.CustomNameBuilder;
import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.config.XpValidationEventHandler;
import de.pontonconsulting.xmlpipe.config.hotfolder.FilenameFormatType;
import de.pontonconsulting.xmlpipe.config.hotfolder.HotFolderConfig;
import de.pontonconsulting.xmlpipe.config.hotfolder.ObjectFactory;
import de.pontonconsulting.xmlpipe.config.hotfolder.OutboxType;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerConfig;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerConfigDAO;
import jakarta.annotation.PostConstruct;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEventHandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HotFolderConfiguration
implements IFileChangeListener {
    private static final Logger LOG = LogManager.getLogger((String)"Hotfolder.HotfolderConfiguration");
    public static final String BEAN_NAME = "hotFolderConfiguration";
    public static final String CONFIGURATION_FILE = "hotfolder.xml";
    private static final String HOTFOLDER_CONFIG_PACKAGE = "de.pontonconsulting.xmlpipe.config.hotfolder";
    private final File _configFile;
    private final IServerConfigBean _serverConfig;
    private final List<IHotFolderConfigurationListener> _listeners;
    private long _timestampOflastChange;
    private final DBConfigChangeWatcher hotfolderConfigWatcher;
    private final MessengerConfigDAO messengerConfigDAO;
    private final AtomicBoolean isOnNotifyingListeners = new AtomicBoolean(false);
    private static final int DEFAULT_THREADS = 1;
    private static final String DEFAULT_INBOX = "";
    private static final String DEFAULT_OUTBOX = "";
    private static final String DEFAULT_FAILED = "";
    private static final String DEFAULT_WORK = "";
    private static final boolean DEFAULT_SUPPORTS_ATTACHMENTS = false;
    private static final boolean DEFAULT_SAVE_WITH_BACKEND_ENV = false;
    private static final long DEFAULT_SCANINTERVAL = 360L;
    private static final ObjectFactory _factory = new ObjectFactory();
    private static JAXBContext _context;
    private HotFolderConfig _config;

    public HotFolderConfiguration(IServerConfigBean serverConfig, DBConfigChangeWatcher hotfolderConfigWatcher, MessengerConfigDAO messengerConfigDAO) throws JAXBException {
        this.hotfolderConfigWatcher = hotfolderConfigWatcher;
        this.messengerConfigDAO = messengerConfigDAO;
        this._listeners = new ArrayList<IHotFolderConfigurationListener>();
        this._configFile = new File(serverConfig.getConfigFolder(), CONFIGURATION_FILE);
        this._serverConfig = serverConfig;
    }

    private void convertOldFilenameFormatConfig() throws JAXBException {
        boolean needsSave = false;
        FilenameFormatType defaultFormat = this._config.getDefaultReceiveFilenameFormat();
        if (defaultFormat == null) {
            defaultFormat = FilenameFormatType.DATABASE_ID;
        }
        if (defaultFormat != FilenameFormatType.CUSTOM_FILENAME) {
            String pattern = this.convertFilenamePattern(defaultFormat);
            this._config.setDefaultReceiveFilenamePattern(pattern);
            this._config.setDefaultReceiveFilenameFormat(FilenameFormatType.CUSTOM_FILENAME);
            needsSave = true;
        }
        for (HotFolderConfig.HotFolder hotFolder : this._config.getHotFolder()) {
            FilenameFormatType instanceFormat = hotFolder.getReceiveFilenameFormat();
            String pattern = hotFolder.getReceiveFilenamePattern();
            if (instanceFormat == null) {
                pattern = this.getDefaultReceiveFilenamePattern();
                needsSave = true;
            } else if (instanceFormat != FilenameFormatType.CUSTOM_FILENAME) {
                pattern = this.convertFilenamePattern(instanceFormat);
                needsSave = true;
            }
            hotFolder.setReceiveFilenamePattern(pattern);
            hotFolder.setReceiveFilenameFormat(FilenameFormatType.CUSTOM_FILENAME);
        }
        if (needsSave) {
            this.save();
        }
    }

    @Override
    public void fileChangedEvent() {
        try {
            if (this.loadConfigToMemory()) {
                this.notifyListeners();
            }
        }
        catch (JAXBException e) {
            LOG.error("could not reload hotfolder.xml", (Throwable)e);
        }
    }

    private void notifyListeners() {
        if (this.isOnNotifyingListeners.compareAndSet(false, true)) {
            try {
                for (IHotFolderConfigurationListener listener : this._listeners) {
                    listener.onHotFolderConfigurationChange();
                }
            }
            finally {
                this.isOnNotifyingListeners.set(false);
            }
        }
    }

    protected boolean loadConfigToMemory() throws JAXBException {
        if (this._configFile.exists() && !this.messengerConfigDAO.doesMessengerConfigExist(CONFIGURATION_FILE)) {
            try (BufferedInputStream fileInputStream = new BufferedInputStream(Files.newInputStream(this._configFile.toPath(), new OpenOption[0]));){
                this.messengerConfigDAO.storeMessengerConfig(fileInputStream.readAllBytes(), CONFIGURATION_FILE, "SYSTEM");
            }
            catch (IOException e) {
                throw new JAXBException(e.getMessage(), (Throwable)e);
            }
            try {
                Files.delete(this._configFile.toPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this._timestampOflastChange != this.messengerConfigDAO.getTimestampAsLongByConfigType(CONFIGURATION_FILE)) {
            MessengerConfig messengerConfig = this.messengerConfigDAO.loadMessengerConfig(CONFIGURATION_FILE);
            Unmarshaller unmarshaller = _context.createUnmarshaller();
            this._config = (HotFolderConfig)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(messengerConfig.getData()));
            this._timestampOflastChange = messengerConfig.getTimestamp().toInstant().toEpochMilli();
            this.notifyListeners();
            return true;
        }
        return false;
    }

    public void save() throws JAXBException {
        this.save("SYSTEM");
    }

    public void save(String username) throws JAXBException {
        XpValidationEventHandler validationEventHandler = new XpValidationEventHandler();
        Marshaller marshaller = _context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setEventHandler((ValidationEventHandler)validationEventHandler);
        try (ByteArrayOutputStream bOut = new ByteArrayOutputStream();){
            marshaller.marshal((Object)this._config, (OutputStream)bOut);
            this._timestampOflastChange = this.messengerConfigDAO.storeMessengerConfig(bOut.toByteArray(), CONFIGURATION_FILE, username);
        }
        catch (JAXBException e) {
            if (validationEventHandler.getMessage() != null) {
                throw new JAXBException("Xml Error in (" + validationEventHandler.getLine() + ", " + validationEventHandler.getColumn() + "): " + validationEventHandler.getMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (IOException e) {
            throw new JAXBException("Configuration file could not be stored: " + e.getMessage(), (Throwable)e);
        }
        this.notifyListeners();
    }

    public String getConsoleLogLevel() throws JAXBException {
        this.loadConfigToMemory();
        return this._config.getLogging().getConsole().value();
    }

    public String getDefaultReceiveFilenamePattern() throws JAXBException {
        this.loadConfigToMemory();
        return this._config.getDefaultReceiveFilenamePattern();
    }

    public int getNumberOfHotFolders() throws JAXBException {
        this.loadConfigToMemory();
        return this._config.getHotFolder().size();
    }

    public HotFolderCfg getHotFolder(int folderNumber) throws JAXBException {
        this.loadConfigToMemory();
        HotFolderCfg hotfolderCfg = new HotFolderCfg(this, folderNumber);
        return hotfolderCfg;
    }

    public HotFolderCfg getHotFolder(String adapterID) throws JAXBException {
        for (int i = 0; i < this.getNumberOfHotFolders(); ++i) {
            HotFolderCfg hotfolder = this.getHotFolder(i);
            if (!hotfolder.getAdapterID().equals(adapterID)) continue;
            return hotfolder;
        }
        return null;
    }

    public List<String> getAdapterIdsForOutbox(File outboxFolder) throws JAXBException {
        ArrayList<String> adapterIds = new ArrayList<String>();
        for (int i = 0; i < this.getNumberOfHotFolders(); ++i) {
            HotFolderCfg hotfolder = this.getHotFolder(i);
            File folder = hotfolder.getOutboxFolder();
            if (folder == null || !outboxFolder.getAbsoluteFile().equals(folder.getAbsoluteFile())) continue;
            adapterIds.add(hotfolder.getAdapterID());
        }
        return adapterIds;
    }

    public int getHotFolderNumber(String adapterID) throws JAXBException {
        for (int i = 0; i < this.getNumberOfHotFolders(); ++i) {
            if (!this.getHotFolder(i).getAdapterID().equals(adapterID)) continue;
            return i;
        }
        return -1;
    }

    public void removeHotFolder(String adapterID) throws JAXBException {
        int folderNumber;
        if (!this.loadConfigToMemory()) {
            folderNumber = this.getHotFolderNumber(adapterID);
            if (folderNumber == -1) {
                throw new JAXBException("HotFolder with given id not found.");
            }
        } else {
            throw new JAXBException("HotFolder Configuration has been changed outside.");
        }
        this._config.getHotFolder().remove(folderNumber);
    }

    public HotFolderCfg addHotFolder(String adapterID) throws JAXBException {
        HotFolderConfig.HotFolder hotfolder = _factory.createHotFolderConfigHotFolder();
        hotfolder.setAdapterID(adapterID);
        hotfolder.setFolders(_factory.createHotFolderConfigHotFolderFolders());
        OutboxType outbox = _factory.createOutboxType();
        hotfolder.getFolders().setOutbox(outbox);
        this._config.getHotFolder().add(hotfolder);
        HotFolderCfg newAdapter = this.getHotFolder(adapterID);
        newAdapter.setNumberOfReceivingThreads(1);
        newAdapter.setInbox("");
        newAdapter.setOutbox("");
        newAdapter.setFailed("");
        newAdapter.setWork("");
        newAdapter.setSupportsAttachments(false);
        newAdapter.setSaveWithBackEndEnvelope(false);
        newAdapter.setScanInterval(360L);
        return new HotFolderCfg(this, this.getHotFolderNumber(adapterID));
    }

    protected void setHotFolderType(int number, HotFolderConfig.HotFolder hotfolderType) {
        this._config.getHotFolder().set(number, hotfolderType);
    }

    public List<String> getHotFolderIDs() throws JAXBException {
        this.loadConfigToMemory();
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < this.getNumberOfHotFolders(); ++i) {
            ids.add(((HotFolderConfig.HotFolder)this._config.getHotFolder().get(i)).getAdapterID());
        }
        return ids;
    }

    protected HotFolderConfig.HotFolder getHotFolderConfigHotFolder(int number) throws JAXBException {
        this.loadConfigToMemory();
        return (HotFolderConfig.HotFolder)this._config.getHotFolder().get(number);
    }

    protected File getFolder(String foldername) {
        File folder = null;
        try {
            folder = new File(this.getRealPath(foldername)).getCanonicalFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (folder == null) {
            folder = new File(foldername);
        }
        return folder;
    }

    protected String getRealPath(String folderString) throws IOException {
        if (folderString == null || folderString.length() == 0) {
            throw new IOException("Missing folder name");
        }
        String pathString = folderString;
        try {
            pathString = this._serverConfig.getRealPath(pathString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pathString;
    }

    public int getProcessingTimeout() throws JAXBException {
        this.loadConfigToMemory();
        Integer timeout = this._config.getCommunicationTimeout();
        if (timeout == null) {
            return 0;
        }
        return timeout;
    }

    public void setDefaultFilenamePattern(String filenamePattern) {
        this._config.setDefaultReceiveFilenamePattern(filenamePattern);
    }

    private String convertFilenamePattern(FilenameFormatType fileNameFormat) {
        return switch (fileNameFormat) {
            case FilenameFormatType.DATABASE_ID -> "payload-id-" + CustomNameBuilder.createBorderedVariable("database_id") + "." + CustomNameBuilder.createBorderedVariable("default_extension");
            case FilenameFormatType.MESSAGE_ID -> CustomNameBuilder.createBorderedVariable("message_id") + "." + CustomNameBuilder.createBorderedVariable("default_extension");
            case FilenameFormatType.ORIGINAL_FILENAME -> CustomNameBuilder.createBorderedVariable("original_filename") + "." + CustomNameBuilder.createBorderedVariable("original_extension");
            default -> "payload-id-" + CustomNameBuilder.createBorderedVariable("database_id") + "." + CustomNameBuilder.createBorderedVariable("default_extension");
        };
    }

    public void addListener(IHotFolderConfigurationListener listener) {
        this._listeners.add(listener);
    }

    @PostConstruct
    public void init() throws Exception {
        this.loadConfigToMemory();
        this.convertOldFilenameFormatConfig();
        this.hotfolderConfigWatcher.addFileChangeListener(this);
    }

    static {
        try {
            _context = JAXBContext.newInstance((String)HOTFOLDER_CONFIG_PACKAGE);
        }
        catch (JAXBException ex) {
            LOG.error("could not initialize JAXB", (Throwable)ex);
        }
    }
}

