/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter.hotfolder;

import de.pontonconsulting.xmlpipe.adapter.hotfolder.HotFolderAdapter;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.HotFolderMessageType;
import de.pontonconsulting.xmlpipe.message.BackEndMessage;
import de.pontonconsulting.xmlpipe.message.EdifactMessage;
import de.pontonconsulting.xmlpipe.message.EdifactMessageException;
import de.pontonconsulting.xmlpipe.message.X12Message;
import de.pontonconsulting.xmlpipe.message.X12MessageException;
import java.io.File;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public class HotFolderAdapterIntegration {
    public static final String BEAN_NAME = "HotFolderAdapterIntegration";

    public BackEndMessage createMessage(HotFolderMessageType type, File file, Collection<File> attachments) {
        try {
            BackEndMessage backEndMessage = type == HotFolderMessageType.XML ? new BackEndMessage(file, true) : new BackEndMessage(file);
            String fileName = file.getName();
            backEndMessage.addProcessingDirective("OriginalFilename", fileName);
            String fileNameConcat = "OriginalFilename: " + fileName;
            String oldLogInfo = backEndMessage.getLogInfoText();
            if (!StringUtils.isNotBlank((CharSequence)oldLogInfo) || !fileNameConcat.equals(oldLogInfo)) {
                if (StringUtils.isBlank((CharSequence)oldLogInfo)) {
                    backEndMessage.setLogInfoText(fileNameConcat);
                } else {
                    String newLogInfo = oldLogInfo + " " + fileNameConcat;
                    backEndMessage.setLogInfoText(newLogInfo);
                }
            }
            switch (type) {
                case BIN: {
                    this.populateMessage(backEndMessage);
                    break;
                }
                case EDI: {
                    EdifactMessage edifactMessage = new EdifactMessage(file);
                    this.populateMessage(backEndMessage, edifactMessage);
                    break;
                }
                case X12: {
                    X12Message x12Message = new X12Message(file);
                    this.populateMessage(backEndMessage, x12Message);
                    break;
                }
                case XML: {
                    break;
                }
            }
            if (attachments != null && !attachments.isEmpty()) {
                this.populateMessage(backEndMessage, attachments);
            }
            return backEndMessage;
        }
        catch (EdifactMessageException ex) {
            HotFolderAdapter.LOG.error("Edifact message creation failed: {}", (Object)ex.getMessage());
            return null;
        }
        catch (X12MessageException ex) {
            HotFolderAdapter.LOG.error("X12 message creation failed: {}", (Object)ex.getMessage());
            return null;
        }
        catch (Exception ex) {
            HotFolderAdapter.LOG.error("Message creation failed: {}", (Object)ex.getMessage());
            return null;
        }
    }

    private void populateMessage(BackEndMessage backEndMessage, Collection<File> attachments) {
        for (File file : attachments) {
            try {
                backEndMessage.addAttachment(file);
            }
            catch (Exception ex) {
                HotFolderAdapter.LOG.error(ex.getMessage());
            }
        }
    }

    private void populateMessage(BackEndMessage backEndMessage) {
        backEndMessage.setDTDSet("BINARY");
        backEndMessage.setDTDVersionNumber("1");
        backEndMessage.setMessageName("BINARY");
    }

    private void populateMessage(BackEndMessage backEndMessage, X12Message x12Message) {
        backEndMessage.setSenderOrganisation(x12Message.getSenderId());
        backEndMessage.setReceiverOrganisation(x12Message.getReceiverId());
        backEndMessage.setTransferID(x12Message.getMessageId());
        backEndMessage.setDTDVersionNumber(x12Message.getMessageVersion());
        backEndMessage.setMessageName(x12Message.getMessageType());
    }

    private void populateMessage(BackEndMessage backEndMessage, EdifactMessage edifactMessage) {
        backEndMessage.setSenderOrganisation(edifactMessage.getSenderId());
        backEndMessage.setReceiverOrganisation(edifactMessage.getReceiverId());
        backEndMessage.setTransferID(edifactMessage.getMessageId());
        backEndMessage.setDTDVersionNumber(edifactMessage.getMessageVersion());
        backEndMessage.setMessageName(edifactMessage.getMessageType());
    }
}

