/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter.hotfolder;

import de.pontonconsulting.xmlpipe.adapter.hotfolder.HotFolderAdapter;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.HotFolderAdapterService;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.HotFolderMessageType;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.HotFolderUtil;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.config.HotFolderCfg;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.camel.Exchange;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextStartedEvent;
import org.springframework.util.Assert;

public class HotFolder
implements ApplicationContextAware,
ApplicationListener {
    public static final String RECEIVER_LOCAL_ID = "ReceiverLocalId";
    public static final String HOTFOLDER_CFG = "HotfolderConfig";
    public static final String ATTACHMENTS = "Attachments";
    public static final String HANDLE_XML = "handleXmlMessage";
    public static final String HANDLE_EDI = "handleEdiMessage";
    public static final String HANDLE_X12 = "handleX12Message";
    public static final String HANDLE_BIN = "handleBinMessage";
    public static final String HOTFOLDER = "hotfolder";
    public static final String BEAN_NAME = "HotFolder";
    private HotFolderAdapter HotFolderAdapter;
    private HotFolderAdapterService hotFolderAdapterService;
    private ApplicationContext context;

    public void handleXmlMessage(Exchange message) {
        this.sendMessage(HotFolderMessageType.XML, message);
    }

    public void handleEdiMessage(Exchange message) {
        this.sendMessage(HotFolderMessageType.EDI, message);
    }

    public void handleX12Message(Exchange message) {
        this.sendMessage(HotFolderMessageType.X12, message);
    }

    public void handleBinMessage(Exchange message) {
        this.sendMessage(HotFolderMessageType.BIN, message);
    }

    public HotFolderAdapter getHotFolderAdapter() {
        return this.HotFolderAdapter;
    }

    public void setHotFolderAdapter(HotFolderAdapter HotFolderAdapter2) {
        this.HotFolderAdapter = HotFolderAdapter2;
    }

    public HotFolderAdapterService getHotFolderAdapterService() {
        return this.hotFolderAdapterService;
    }

    public void setHotFolderAdapterService(HotFolderAdapterService hotFolderAdapterService) {
        this.hotFolderAdapterService = hotFolderAdapterService;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextStartedEvent) {
            this.HotFolderAdapter = (HotFolderAdapter)this.context.getBean("HotFolderAdapter", HotFolderAdapter.class);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendMessage(HotFolderMessageType type, Exchange message) {
        Assert.notNull((Object)message, (String)"Message should not be null.");
        String attachmentFolderName = null;
        Collection<File> attachments = null;
        File attachmentFolder = null;
        File failedFolder = null;
        try {
            HotFolderCfg configuration = this.extractConfiguration(message);
            String receiverId = null;
            boolean isReceiverSub = false;
            if (configuration.getUsePartnerSubfolders()) {
                receiverId = this.extractReceiverId(message);
                isReceiverSub = true;
                de.pontonconsulting.xmlpipe.adapter.hotfolder.HotFolderAdapter.LOG.info("Use partner subfolder for {} to {}", (Object)configuration.getSenderLocalID(), (Object)receiverId);
            }
            if (configuration.getSupportsAttachments() && (attachmentFolder = this.extractAttachmentFolder(message)).exists() && attachmentFolder.isDirectory() && (attachments = this.extractAttachments(attachmentFolder)) != null) {
                de.pontonconsulting.xmlpipe.adapter.hotfolder.HotFolderAdapter.LOG.info("Found {} attachment(s) for message", (Object)attachments.size());
                attachmentFolderName = StringUtils.isNotBlank((CharSequence)receiverId) && isReceiverSub ? FilenameUtils.concat((String)receiverId, (String)attachmentFolder.getName()) : attachmentFolder.getName();
                failedFolder = configuration.getFailedFolder();
                for (File attachment : attachments) {
                    this.checkPayload(attachment);
                }
            }
            File body = (File)message.getIn().getBody(File.class);
            this.checkPayload(body);
            de.pontonconsulting.xmlpipe.adapter.hotfolder.HotFolderAdapter.LOG.info("Try to send file: {}", (Object)this.extractFilePath(message));
            if (StringUtils.isNotBlank((CharSequence)receiverId) && isReceiverSub ? !this.hotFolderAdapterService.sendMessage(this.HotFolderAdapter, type, configuration, receiverId, body, attachments) : !this.hotFolderAdapterService.sendMessage(this.HotFolderAdapter, type, configuration, body, attachments)) {
                throw new IllegalArgumentException("Message could not be sent.");
            }
        }
        catch (IllegalArgumentException ex) {
            try {
                de.pontonconsulting.xmlpipe.adapter.hotfolder.HotFolderAdapter.LOG.error(ex.getMessage());
                this.moveToFailedFolder(failedFolder, attachmentFolderName, attachmentFolder);
                throw ex;
                catch (Exception ex2) {
                    de.pontonconsulting.xmlpipe.adapter.hotfolder.HotFolderAdapter.LOG.error(ex2.getMessage());
                    throw new IllegalArgumentException("Processing stopped. Reason: " + ex2.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.delete(attachmentFolder, attachments);
                throw throwable;
            }
        }
        this.delete(attachmentFolder, attachments);
        de.pontonconsulting.xmlpipe.adapter.hotfolder.HotFolderAdapter.LOG.info("Message was successfully sent. {}", (Object)this.extractFilePath(message));
    }

    private void checkPayload(File fileToCheck) {
        if (fileToCheck == null) {
            throw new IllegalArgumentException("Payload should not be null.");
        }
        if (!fileToCheck.exists()) {
            throw new IllegalArgumentException(String.format("Payload does not exist.", HotFolder.normalize(fileToCheck.getAbsolutePath())));
        }
        long sizeOfPayload = FileUtils.sizeOf((File)fileToCheck);
        if (sizeOfPayload < 1L) {
            throw new IllegalArgumentException(String.format("Payload %s size was too small to process.", HotFolder.normalize(fileToCheck.getAbsolutePath())));
        }
    }

    private void delete(File attachmentFolder, Collection<File> attachments) {
        if (attachments == null) {
            return;
        }
        if (attachmentFolder == null) {
            return;
        }
        for (File attachment : attachments) {
            FileUtils.deleteQuietly((File)attachment);
        }
        try {
            FileUtils.deleteDirectory((File)attachmentFolder);
        }
        catch (IOException ex) {
            de.pontonconsulting.xmlpipe.adapter.hotfolder.HotFolderAdapter.LOG.error(ex.getMessage());
        }
    }

    private void moveToFailedFolder(File failedFolder, String folderName, File attachmentFolder) {
        if (failedFolder == null) {
            return;
        }
        if (folderName == null) {
            return;
        }
        if (attachmentFolder == null) {
            return;
        }
        try {
            File baseInDir = HotFolderUtil.mkDir(true, failedFolder, folderName);
            FileUtils.copyDirectory((File)attachmentFolder, (File)baseInDir);
            FileUtils.deleteDirectory((File)attachmentFolder);
        }
        catch (Exception ex) {
            de.pontonconsulting.xmlpipe.adapter.hotfolder.HotFolderAdapter.LOG.error(ex.getMessage());
        }
    }

    private HotFolderCfg extractConfiguration(Exchange message) {
        return (HotFolderCfg)message.getIn().getHeader(HOTFOLDER_CFG, HotFolderCfg.class);
    }

    private String extractReceiverId(Exchange message) {
        return (String)message.getIn().getHeader(RECEIVER_LOCAL_ID, String.class);
    }

    private String extractFilePath(Exchange message) {
        return (String)message.getIn().getHeader("CamelFilePath", String.class);
    }

    private File extractAttachmentFolder(Exchange message) {
        String fileParent = (String)message.getIn().getHeader("CamelFileParent", String.class);
        String fileName = (String)message.getIn().getHeader("CamelFileNameOnly", String.class);
        return HotFolderUtil.getAttachmentFolder(fileParent, fileName);
    }

    private Collection<File> extractAttachments(File attachmentFolder) {
        Collection attachments = FileUtils.listFiles((File)attachmentFolder, null, (boolean)false);
        if (attachments != null && !attachments.isEmpty()) {
            return attachments;
        }
        return null;
    }

    private static String normalize(String path) {
        if (ObjectHelper.isEmpty((String)path)) {
            return path;
        }
        path = path.replace('/', File.separatorChar);
        path = path.replace('\\', File.separatorChar);
        return path;
    }
}

