/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter.as4certificateupdate;

import de.pontonconsulting.xmlpipe.adapter.as4certificateupdate.AS4CertificateUpdateAdapter;
import de.pontonconsulting.xmlpipe.cpa.Agreement;
import de.pontonconsulting.xmlpipe.cpa.AgreementException;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpa.CommunicationNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.messenger.packaging.AS4CertificateUpdateUtility;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AS4TestWorker
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger((String)("Messenger." + AS4TestWorker.class.getName()));
    private final Agreements agreements;
    private final AS4CertificateUpdateAdapter as4CertificateUpdateAdapter;
    private final AS4CertificateUpdateUtility as4CertificateUpdateUtility;
    private final Profiles profiles;

    public AS4TestWorker(Agreements agreements, AS4CertificateUpdateAdapter as4CertificateUpdateAdapter, AS4CertificateUpdateUtility as4CertificateUpdateUtility, Profiles profiles) {
        this.agreements = agreements;
        this.as4CertificateUpdateAdapter = as4CertificateUpdateAdapter;
        this.as4CertificateUpdateUtility = as4CertificateUpdateUtility;
        this.profiles = profiles;
    }

    @Override
    public void run() {
        LOGGER.debug("Running AS4TestWorker ...");
        this.agreements.getAllAgreementIds().forEach(this::verifyCertificateUpdateStateForAgreement);
    }

    private void verifyCertificateUpdateStateForAgreement(String agreementId) {
        try {
            Agreement agreement = this.agreements.getAgreement(agreementId, false);
            CppPartner sender = this.profiles.getProfileForLocalId(agreement.getOwnPartner().getId(), false);
            CppPartner receiver = this.profiles.getProfileForLocalId(agreement.getCommunicationPartner().getId(), false);
            Communication communication = agreement.getCommunication(sender.getLocalId(), receiver.getLocalId());
            boolean certificateUpdateEnabledForCommunication = this.as4CertificateUpdateUtility.isCertificateUpdateEnabledForCommunication(communication);
            if (certificateUpdateEnabledForCommunication) {
                this.processCertificateUpdate(agreement, sender, receiver);
            }
        }
        catch (CommunicationNotFoundException | ProfileException e) {
            LOGGER.error("Cannot identify communication.", (Throwable)e);
        }
        catch (AgreementException e) {
            LOGGER.error("Cannot save agreement.");
        }
    }

    private void processCertificateUpdate(Agreement agreement, CppPartner sender, CppPartner receiver) throws AgreementException, ProfileException {
        String as4UpdatedAgreementRef = agreement.getAS4UpdatedAgreementRef();
        String activateByString = agreement.getAS4CertUpdateActivateBy();
        if (as4UpdatedAgreementRef != null && activateByString != null) {
            OffsetDateTime activateBy;
            OffsetDateTime now = OffsetDateTime.now(ZoneOffset.UTC);
            if (now.isBefore(activateBy = OffsetDateTime.parse(activateByString))) {
                LOGGER.trace("activate by {} not yet reached", (Object)activateBy);
                boolean isAgreementSwitched = this.as4CertificateUpdateAdapter.verifyTestResultsAndSwitchAgreement(agreement, sender, receiver, as4UpdatedAgreementRef);
                if (!isAgreementSwitched && agreement.isAS4CertificateUpdateTestServiceEnabled() && !agreement.isAS4UpdatedAgreementOutboundTestSuccessful()) {
                    this.as4CertificateUpdateAdapter.sendAS4TestMessage(sender, receiver, agreement);
                }
            } else {
                this.as4CertificateUpdateAdapter.cleanUpAgreement(agreement);
            }
        }
    }
}

