/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter;

import de.pontonconsulting.xmlpipe.adapter.AdapterInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class AdapterRegistry {
    private boolean _initialized;
    private final Map<String, AdapterInfo> _adapters;
    private final Set<AdapterInfo> _partnerEventListener;
    private final Set<AdapterInfo> partnerCertificateEventListener;
    private final Set<AdapterInfo> _agreementEventListener;
    private final List<Consumer<String>> adapterDeleteEventListeners = new ArrayList<Consumer<String>>();

    public AdapterRegistry() {
        this._adapters = Collections.synchronizedMap(new HashMap());
        this._partnerEventListener = new HashSet<AdapterInfo>();
        this.partnerCertificateEventListener = new HashSet<AdapterInfo>();
        this._agreementEventListener = new HashSet<AdapterInfo>();
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public void setInitialized(boolean b) {
        this._initialized = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAdapter(AdapterInfo info) {
        Map<String, AdapterInfo> map = this._adapters;
        synchronized (map) {
            info.setIsDown(false);
            AdapterInfo old = this._adapters.put(info.getId(), info);
            if (old != null) {
                this._partnerEventListener.remove(old);
                this._agreementEventListener.remove(old);
            }
            if (info.acceptsPartnerChangeEvents() && !"ReceptionDisabled".equals(info.getAddress())) {
                this._partnerEventListener.add(info);
            }
            if (info.acceptsPartnerCertificateChangeEvents() && !"ReceptionDisabled".equals(info.getAddress())) {
                this.partnerCertificateEventListener.add(info);
            }
            if (info.acceptsAgreementChangeEvents() && !"ReceptionDisabled".equals(info.getAddress())) {
                this._agreementEventListener.add(info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAdapter(String id) {
        Map<String, AdapterInfo> map = this._adapters;
        synchronized (map) {
            AdapterInfo info = this._adapters.remove(id);
            this.adapterDeleteEventListeners.forEach(listener -> listener.accept(id));
            if (info != null) {
                this._partnerEventListener.remove(info);
                this._agreementEventListener.remove(info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdapterInfo[] getAllAdapters() {
        AdapterInfo[] result;
        Map<String, AdapterInfo> map = this._adapters;
        synchronized (map) {
            result = this._adapters.values().toArray(new AdapterInfo[this._adapters.size()]);
        }
        return result;
    }

    public List<String> getAdapters() {
        ArrayList<String> result = new ArrayList<String>();
        for (AdapterInfo adapter : this._adapters.values()) {
            result.add(adapter.getId());
        }
        Collections.sort(result, String::compareToIgnoreCase);
        return result;
    }

    public AdapterInfo getAdapter(String id) {
        return this._adapters.get(id);
    }

    public AdapterInfo[] getAgreementEventListeners() {
        return this._agreementEventListener.toArray(new AdapterInfo[this._agreementEventListener.size()]);
    }

    public AdapterInfo[] getPartnerEventListeners() {
        return this._partnerEventListener.toArray(new AdapterInfo[this._partnerEventListener.size()]);
    }

    public AdapterInfo[] getPartnerCertificateEventListeners() {
        return this.partnerCertificateEventListener.toArray(new AdapterInfo[this.partnerCertificateEventListener.size()]);
    }

    public void addAdapterDeleteEventListener(Consumer<String> consumer) {
        this.adapterDeleteEventListeners.add(consumer);
    }

    public void removeAdapterDeleteEventListener(Consumer<String> consumer) {
        this.adapterDeleteEventListeners.remove(consumer);
    }
}

