/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter;

import de.pontonconsulting.xmlpipe.adapter.IAgreementEventListener;
import de.pontonconsulting.xmlpipe.adapter.IErrorNotificationHandler;
import de.pontonconsulting.xmlpipe.adapter.IMessageStatusHandler;
import de.pontonconsulting.xmlpipe.adapter.IPartnerCertificateEventListener;
import de.pontonconsulting.xmlpipe.adapter.IPartnerEventListener;
import de.pontonconsulting.xmlpipe.adapter.ISpecificAdapter;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class AdapterInfo {
    public static final String INTERNAL = "INTERNAL";
    private String _id;
    private String _address;
    private int _maximumThreads = 1;
    private final AtomicInteger _currentThreads = new AtomicInteger(0);
    private boolean _supportsAcknowledgements;
    private boolean _supportsAttachments;
    private boolean _acceptsPartnerChangeEvents;
    private boolean acceptsPartnerCertificateChangeEvents;
    private boolean _acceptsAgreementChangeEvents;
    private boolean _supportsStatusResponses;
    private boolean _supportsErrorNotifications;
    private boolean _supportsArchive;
    private boolean supportsMessages;
    private int _processingTimeout;
    private ISpecificAdapter _instance;
    private boolean _isDown = false;
    private final HashSet<String> _services = new HashSet();

    public AdapterInfo(String id, String url, int processingTimeout) {
        this.setId(id);
        this.setAddress(url);
        this.setProcessingTimeout(processingTimeout);
    }

    public AdapterInfo(ISpecificAdapter instance) {
        this._instance = instance;
        this._id = instance.getID();
        this._maximumThreads = instance.getNumberOfParallelThreads();
        this._supportsAcknowledgements = instance.supportsAcknowledgements();
        this._supportsAttachments = instance.supportsAttachments();
        this._address = INTERNAL;
        if (instance instanceof IPartnerEventListener) {
            this._acceptsPartnerChangeEvents = true;
        }
        if (instance instanceof IPartnerCertificateEventListener) {
            this.acceptsPartnerCertificateChangeEvents = true;
        }
        if (instance instanceof IAgreementEventListener) {
            this._acceptsAgreementChangeEvents = true;
        }
        if (instance instanceof IMessageStatusHandler) {
            this._supportsStatusResponses = true;
        }
        if (instance instanceof IErrorNotificationHandler) {
            this._supportsErrorNotifications = true;
        }
    }

    public ISpecificAdapter getAdapterInstance() {
        return this._instance;
    }

    public boolean isUsingDirectCommunication() {
        return this._instance != null && !this.isWebSocketAdapter();
    }

    public String getAddress() {
        return this._address;
    }

    public int getMaximumThreads() {
        return this._maximumThreads;
    }

    public int getCurrentThreads() {
        return this._currentThreads.get();
    }

    public String getId() {
        return this._id;
    }

    public boolean supportsAcknowledgements() {
        return this._supportsAcknowledgements;
    }

    public void setAddress(String address) {
        this._address = address;
    }

    public void setMaximumThreads(int newMaxThreads) {
        this._maximumThreads = newMaxThreads;
    }

    public void setId(String id) {
        this._id = id;
    }

    public void setSupportsAcknowledgements(boolean supportsAcknowledgements) {
        this._supportsAcknowledgements = supportsAcknowledgements;
    }

    public boolean acceptsPartnerChangeEvents() {
        return this._acceptsPartnerChangeEvents;
    }

    public void setAcceptsPartnerChangeEvents(boolean acceptsPartnerChangeEvents) {
        this._acceptsPartnerChangeEvents = acceptsPartnerChangeEvents;
    }

    public void setAcceptsPartnerCertificateChangeEvents(boolean acceptsPartnerCertificateChangeEvents) {
        this.acceptsPartnerCertificateChangeEvents = acceptsPartnerCertificateChangeEvents;
    }

    public boolean acceptsPartnerCertificateChangeEvents() {
        return this.acceptsPartnerCertificateChangeEvents;
    }

    public boolean acceptsAgreementChangeEvents() {
        return this._acceptsAgreementChangeEvents;
    }

    public void setAcceptsAgreementChangeEvents(boolean acceptsAgreementChangeEvents) {
        this._acceptsAgreementChangeEvents = acceptsAgreementChangeEvents;
    }

    public void setSupportsArchive(boolean supportsArchive) {
        this._supportsArchive = supportsArchive;
    }

    public boolean supportsArchive() {
        return this._supportsArchive;
    }

    public boolean canHandleAnotherThread() {
        return this._currentThreads.get() < this.getMaximumThreads();
    }

    public int decreaseCurrentThreads() {
        return this._currentThreads.decrementAndGet();
    }

    public int increaseCurrentThreads() {
        return this._currentThreads.incrementAndGet();
    }

    public boolean supportsAttachments() {
        return this._supportsAttachments;
    }

    public void setSupportsAttachments(boolean supportsAttachments) {
        this._supportsAttachments = supportsAttachments;
    }

    public boolean supportsStatusResponses() {
        return this._supportsStatusResponses;
    }

    public void setSupportsStatusResponses(boolean supportsStatusResponses) {
        this._supportsStatusResponses = supportsStatusResponses;
    }

    public boolean supportsErrorNotifications() {
        return this._supportsErrorNotifications;
    }

    public void setSupportsErrorNotification(boolean supportsErrorNotifications) {
        this._supportsErrorNotifications = supportsErrorNotifications;
    }

    public void setProcessingTimeout(int processingTimeout) {
        this._processingTimeout = processingTimeout;
    }

    public int getProcessingTimeout() {
        return this._processingTimeout;
    }

    public void addService(String serviceId) {
        this._services.add(serviceId);
    }

    public void removeService(String serviceId) {
        this._services.remove(serviceId);
    }

    public Set<String> getServices() {
        return this._services;
    }

    public boolean isDown() {
        return this._isDown;
    }

    public void setIsDown(boolean isDown) {
        this._isDown = isDown;
    }

    public boolean isWebSocketAdapter() {
        return this._address.startsWith("wss://");
    }
}

