/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.activation.capability;

import de.pontonconsulting.xmlpipe.activation.MessengerActivation;
import de.pontonconsulting.xmlpipe.activation.capability.ICapability;
import de.pontonconsulting.xmlpipe.events.activation.ActivationEvent;
import jakarta.annotation.PostConstruct;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public abstract class AbstractCapability
implements ICapability,
ApplicationListener<ApplicationEvent> {
    protected final MessengerActivation activationProvider;
    private final AtomicBoolean trialVersion = new AtomicBoolean(false);

    protected AbstractCapability(MessengerActivation activationProvider) {
        this.activationProvider = activationProvider;
    }

    @Override
    public boolean isCapable() {
        return this.trialVersion.get() || this.isEnabled();
    }

    @PostConstruct
    public void reinit() {
        this.checkTrialVersion();
        this.doCapabilityCheck();
    }

    private void checkTrialVersion() {
        this.trialVersion.set(this.activationProvider.isTrialVersion());
    }

    protected abstract void doCapabilityCheck();

    protected abstract boolean isEnabled();

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ActivationEvent) {
            this.reinit();
        }
    }
}

