/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.activation;

import de.pontonconsulting.activation.IRequestExtensionBuilder;
import de.pontonconsulting.security.Extension;
import de.pontonconsulting.xmlpipe.activation.MessengerActivation;
import de.pontonconsulting.xmlpipe.activation.NetworkCards;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;

public class RequestExtensionBuilder
implements IRequestExtensionBuilder {
    private final Profiles profiles;
    private final MessengerActivation activationProvider;
    private final NetworkCards networkCards;

    public RequestExtensionBuilder(Profiles profiles, MessengerActivation activationProvider, NetworkCards networkCards) {
        this.profiles = profiles;
        this.activationProvider = activationProvider;
        this.networkCards = networkCards;
    }

    public Extension[] buildRequestExtensions() {
        ArrayList<Extension> allExtensions = new ArrayList<Extension>();
        Map<String, String[]> partnerWithPartyIDs = this.profiles.getLocalPartnerWithPartyIDs();
        ArrayList<CallSite> oids = new ArrayList<CallSite>();
        int counter = 1;
        Set<String> partnerKeySet = partnerWithPartyIDs.keySet();
        int partnerAmount = partnerKeySet.size();
        for (String partnerName : partnerKeySet) {
            String[] partyIDs = partnerWithPartyIDs.get(partnerName);
            ArrayList<String> partnerAndPartyIds = new ArrayList<String>();
            partnerAndPartyIds.add(partnerName);
            partnerAndPartyIds.addAll(Arrays.asList(partyIDs));
            String oid = "1.3.6.1.4.1.14136.1.4." + counter;
            String[] oidValues = partnerAndPartyIds.toArray(new String[0]);
            Extension extension = new Extension(oid, oidValues);
            oids.add((CallSite)((Object)oid));
            allExtensions.add(extension);
            if (++counter <= 10) continue;
            String oidPartnerCount = "1.3.6.1.4.1.14136.1.4." + counter;
            String[] oidPartnerCountValues = new String[]{"TotalPartnerCount:" + partnerAmount};
            Extension extensionPartnerCount = new Extension(oidPartnerCount, oidPartnerCountValues);
            oids.add((CallSite)((Object)oidPartnerCount));
            allExtensions.add(extensionPartnerCount);
            break;
        }
        String[] oidsSet = oids.toArray(new String[0]);
        allExtensions.addFirst(new Extension("1.3.6.1.4.1.14136.1.4", oidsSet));
        String localIP = this.networkCards.getDefaultInetAddress().getHostAddress();
        try {
            if (this.activationProvider.isTrialVersion() || !this.activationProvider.isClusterModeEnabled()) {
                allExtensions.add(new Extension("1.3.6.1.4.1.14136.1.5", new String[]{localIP}));
            }
        }
        catch (Exception e) {
            allExtensions.add(new Extension("1.3.6.1.4.1.14136.1.5", new String[]{localIP}));
        }
        return allExtensions.toArray(new Extension[0]);
    }
}

