/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe;

import de.pontonconsulting.xmlpipe.messenger.IMessageResources;
import java.util.Locale;

public class LocalizedException
extends Exception {
    private static final long serialVersionUID = -5801512872473570771L;
    protected int _errorNumber = -1;
    protected String[] _arguments = null;

    private LocalizedException() {
    }

    public LocalizedException(int errorNumber) {
        this();
        this._errorNumber = errorNumber;
    }

    public LocalizedException(int errorNumber, String[] arguments) {
        this();
        this._errorNumber = errorNumber;
        this._arguments = arguments;
    }

    public LocalizedException(int errorNumber, String message) {
        this(errorNumber, null, message);
    }

    public LocalizedException(int errorNumber, String[] arguments, String message) {
        super(message);
        this._errorNumber = errorNumber;
        this._arguments = arguments;
    }

    public LocalizedException(int errorNumber, String message, Throwable cause) {
        this(errorNumber, null, message, cause);
    }

    public LocalizedException(int errorNumber, String[] arguments, String message, Throwable cause) {
        super(message, cause);
        this._errorNumber = errorNumber;
        this._arguments = arguments;
    }

    public LocalizedException(int errorNumber, Throwable cause) {
        super(cause);
        this._errorNumber = errorNumber;
    }

    public int getErrorNumber() {
        return this._errorNumber;
    }

    public String getUserMessage(IMessageResources mr, Locale locale) {
        String userMessage = null;
        String key = "" + this.getErrorNumber();
        try {
            userMessage = mr.getMessage(locale, key, this.getArguments());
        }
        catch (Exception e) {
            userMessage = null;
        }
        return userMessage == null ? this.getMessage() : userMessage;
    }

    public static long getErrorNumber(Exception e) {
        if (e instanceof LocalizedException) {
            return ((LocalizedException)e).getErrorNumber();
        }
        return -1L;
    }

    public static String[] getArguments(Exception e) {
        if (e instanceof LocalizedException) {
            return ((LocalizedException)e).getArguments();
        }
        return null;
    }

    public String[] getArguments() {
        return this._arguments;
    }
}

