/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.common.net.ntp;

import de.pontonconsulting.common.net.ntp.NtpHeader;
import de.pontonconsulting.common.net.ntp.NtpInfo;
import de.pontonconsulting.common.net.ntp.TimeStamp;
import java.net.DatagramPacket;
import java.net.InetAddress;

public class NtpDatagramPacket {
    private static final int headerOffset = 0;
    private static final int referenceTimeStampOffset = 16;
    private static final int originateTimeStampOffset = 24;
    private static final int receiveTimeStampOffset = 32;
    private static final int transmitTimeStampOffset = 40;
    private static final int ntpDatagramLength = 48;
    private DatagramPacket dp;
    private TimeStamp receptionTimeStamp;

    public NtpDatagramPacket(NtpHeader header, TimeStamp referenceTimeStamp, TimeStamp originateTimeStamp, TimeStamp receiveTimeStamp, TimeStamp transmitTimeStamp, InetAddress iaddr, int iport) {
        byte[] temp;
        int i;
        byte[] buffer = new byte[48];
        for (i = 0; i < 16; ++i) {
            buffer[i] = header.getData()[i - 0];
        }
        for (i = 16; i < 24; ++i) {
            temp = referenceTimeStamp.getData();
            buffer[i] = temp[i - 16];
        }
        for (i = 24; i < 32; ++i) {
            temp = originateTimeStamp.getData();
            buffer[i] = temp[i - 24];
        }
        for (i = 32; i < 40; ++i) {
            temp = receiveTimeStamp.getData();
            buffer[i] = temp[i - 32];
        }
        for (i = 40; i < 48; ++i) {
            temp = transmitTimeStamp.getData();
            buffer[i] = temp[i - 40];
        }
        this.dp = new DatagramPacket(buffer, 48, iaddr, iport);
    }

    public NtpDatagramPacket(InetAddress iaddr, int iport) {
        this(NtpHeader.defaultHeader, TimeStamp.zero, TimeStamp.zero, TimeStamp.zero, new TimeStamp(), iaddr, iport);
    }

    public NtpDatagramPacket() {
        byte[] buffer = new byte[48];
        this.dp = new DatagramPacket(buffer, 48);
    }

    public NtpDatagramPacket(DatagramPacket dp) {
        this.dp = dp;
    }

    DatagramPacket getDatagramPacket() {
        return this.dp;
    }

    public NtpHeader getHeader() {
        byte[] buffer = this.dp.getData();
        byte[] temp = new byte[16];
        for (int i = 0; i < 16; ++i) {
            temp[i - 0] = buffer[i];
        }
        return new NtpHeader(temp);
    }

    public TimeStamp getReferenceTimeStamp() {
        byte[] buffer = this.dp.getData();
        byte[] temp = new byte[8];
        for (int i = 16; i < 24; ++i) {
            temp[i - 16] = buffer[i];
        }
        return new TimeStamp(temp);
    }

    public TimeStamp getOriginateTimeStamp() {
        byte[] buffer = this.dp.getData();
        byte[] temp = new byte[8];
        for (int i = 24; i < 32; ++i) {
            temp[i - 24] = buffer[i];
        }
        return new TimeStamp(temp);
    }

    public TimeStamp getReceiveTimeStamp() {
        byte[] buffer = this.dp.getData();
        byte[] temp = new byte[8];
        for (int i = 32; i < 40; ++i) {
            temp[i - 32] = buffer[i];
        }
        return new TimeStamp(temp);
    }

    public TimeStamp getTransmitTimeStamp() {
        byte[] buffer = this.dp.getData();
        byte[] temp = new byte[8];
        for (int i = 40; i < 48; ++i) {
            temp[i - 40] = buffer[i];
        }
        return new TimeStamp(temp);
    }

    public TimeStamp getReceptionTimeStamp() {
        return this.receptionTimeStamp;
    }

    void setReceptionTimeStamp(TimeStamp receptionTimeStamp) {
        this.receptionTimeStamp = receptionTimeStamp;
    }

    public NtpInfo getInfo() {
        NtpInfo info = new NtpInfo();
        NtpHeader h = this.getHeader();
        info.serverAddress = this.dp.getAddress();
        info.leapYearIndicator = h.getLeapYearIndicator();
        info.versionNumber = h.getVersionNumber();
        info.stratum = h.getStratum();
        info.mode = h.getMode();
        info.pollInterval = h.getPollInterval();
        info.precision = h.getPrecision();
        info.rootDelay = h.getRootDelay();
        info.rootDispersion = h.getRootDispersion();
        info.referenceIdentifier = h.getReferenceIdentifier();
        info.referenceTimeStamp = this.getReferenceTimeStamp();
        long originate = this.getOriginateTimeStamp().getTime().getTime();
        long receive = this.getReceiveTimeStamp().getTime().getTime();
        long transmit = this.getTransmitTimeStamp().getTime().getTime();
        long reception = this.getReceptionTimeStamp().getTime().getTime();
        info.roundTripDelay = receive - originate + reception - transmit;
        info.offset = (receive - originate - reception + transmit) / 2L;
        return info;
    }

    public String toString() {
        Object s = "Header : ";
        s = (String)s + String.valueOf(this.getHeader());
        s = (String)s + "\n";
        s = (String)s + "ReferenceTimeStamp : ";
        s = (String)s + String.valueOf(this.getReferenceTimeStamp());
        s = (String)s + "\n";
        s = (String)s + "OriginateTimeStamp : ";
        s = (String)s + String.valueOf(this.getOriginateTimeStamp());
        s = (String)s + "\n";
        s = (String)s + "ReceiveTimeStamp : ";
        s = (String)s + String.valueOf(this.getReceiveTimeStamp());
        s = (String)s + "\n";
        s = (String)s + "TransmitTimeStamp : ";
        s = (String)s + String.valueOf(this.getTransmitTimeStamp());
        return s;
    }
}

