/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.common.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CRLFOutputStream
extends FilterOutputStream {
    private static final byte[] CRLF = new byte[]{13, 10};
    private int _lastByte = -1;

    public CRLFOutputStream(OutputStream outputstream) {
        super(outputstream);
    }

    @Override
    public void write(int i) throws IOException {
        if (this._lastByte == -1) {
            if (i == 10) {
                this.out.write(CRLF);
            } else if (i == 13) {
                this._lastByte = 13;
            } else {
                this.out.write(i);
            }
        } else if (this._lastByte == 13 && i == 10) {
            this.out.write(CRLF);
            this._lastByte = -1;
        } else {
            this.out.write(CRLF);
            this.out.write(i);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        for (int i = 0; i < b.length; ++i) {
            this.write(b[i]);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        for (int i = off; i < len; ++i) {
            this.write(b[i]);
        }
    }

    public void writeln() throws IOException {
        this.out.write(CRLF);
    }
}

