/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.common.file;

import de.pontonconsulting.common.file.LockException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

public class FileLocker {
    private static final String LOCK_EXTENSION = ".lock";
    private File _lockFile;

    public FileLocker(File file) {
        this._lockFile = new File(file.getAbsolutePath() + LOCK_EXTENSION);
    }

    public void lockFile() throws LockException {
        if (this.isLocked()) {
            throw new LockException("File is already locked:", this._lockFile);
        }
        try {
            if (!this._lockFile.createNewFile()) {
                throw new LockException(this._lockFile);
            }
        }
        catch (IOException ioe) {
            throw new LockException(this._lockFile, (Exception)ioe);
        }
    }

    public void unlockFile() {
        if (this._lockFile.exists()) {
            this._lockFile.delete();
        }
    }

    public boolean isLocked() {
        return this._lockFile.exists();
    }

    public static void cleanLocksInFolder(File folder) {
        File[] oldLocks = folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(FileLocker.LOCK_EXTENSION);
            }
        });
        for (int i = 0; i < oldLocks.length; ++i) {
            oldLocks[i].delete();
        }
    }
}

