/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.common.activation;

import jakarta.mail.util.SharedFileInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.activation.DataSource;

public class SimpleFileDataSource
implements jakarta.activation.DataSource,
DataSource,
AutoCloseable {
    private String _contentType;
    private String _name;
    private File _file;
    private final List<SharedFileInputStream> _mainInputStreams;

    public SimpleFileDataSource(String contentType, String filename) throws FileNotFoundException {
        this(contentType, new File(filename));
    }

    public SimpleFileDataSource(String contentType, File file) throws FileNotFoundException {
        this._contentType = contentType;
        this._file = file;
        this._name = this._file.getName();
        if (!this._file.exists()) {
            throw new FileNotFoundException("File not found: " + this._file.getAbsolutePath());
        }
        this._mainInputStreams = new ArrayList<SharedFileInputStream>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        SharedFileInputStream sharedFileInputStream = new SharedFileInputStream(this._file);
        List<SharedFileInputStream> list = this._mainInputStreams;
        synchronized (list) {
            this._mainInputStreams.add(sharedFileInputStream);
        }
        return sharedFileInputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    public String getContentType() {
        return this._contentType;
    }

    public String getName() {
        return this._name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        List<SharedFileInputStream> list = this._mainInputStreams;
        synchronized (list) {
            for (SharedFileInputStream sharedFileInputStream : this._mainInputStreams) {
                try {
                    sharedFileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

