/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.websocket;

import de.ponton.xmlpipe.websocket.ConfigEndpoint;
import de.ponton.xmlpipe.websocket.DataEndpoint;
import de.pontonconsulting.xmlpipe.activation.MessengerActivation;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.config.messenger.Messenger;
import de.pontonconsulting.xmlpipe.events.ServiceLevel;
import de.pontonconsulting.xmlpipe.events.ShutdownCompleted;
import de.pontonconsulting.xmlpipe.events.ShutdownService;
import de.pontonconsulting.xmlpipe.events.StartupCompleted;
import de.pontonconsulting.xmlpipe.events.StartupFailed;
import de.pontonconsulting.xmlpipe.events.StartupService;
import de.pontonconsulting.xmlpipe.listener.ListenerManager;
import de.pontonconsulting.xmlpipe.messenger.IServiceProvider;
import jakarta.websocket.WebSocketContainer;
import jakarta.xml.bind.JAXBException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.transport.HttpClientTransportDynamic;
import org.eclipse.jetty.ee10.websocket.jakarta.client.JakartaWebSocketClientContainer;
import org.eclipse.jetty.ee10.websocket.jakarta.common.JakartaWebSocketContainer;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component(value="WebsocketClient")
public class WebsocketClient
implements IServiceProvider {
    private static final int ONE_DAY = 86400000;
    private static final int SIZE64KB = 65536;
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.WebsocketClient");
    private final MessengerConfig messengerConfig;
    private final IFolders folders;
    private final ListenerManager listenerManager;
    private JakartaWebSocketContainer jettyContainer;
    private final PrivateKey identKey;
    private final X509Certificate identCert;
    private final String clusterId;
    private final List<DataEndpoint> dataConnections;
    private final List<ConfigEndpoint> configEndpoints;
    private final ApplicationEventPublisher applicationEventPublisher;

    public WebsocketClient(MessengerActivation activation, MessengerConfig messengerConfig, IFolders folders, ListenerManager listenerManager, ApplicationEventPublisher applicationEventPublisher) throws Exception {
        this.messengerConfig = messengerConfig;
        this.folders = folders;
        this.listenerManager = listenerManager;
        this.applicationEventPublisher = applicationEventPublisher;
        this.identKey = activation.getClusterProductIdentificationPK();
        this.identCert = activation.getClusterProductIdentificationCert();
        this.clusterId = activation.getClusterId();
        this.dataConnections = new ArrayList<DataEndpoint>(3);
        this.configEndpoints = Collections.synchronizedList(new ArrayList());
    }

    private void init() throws Exception {
        ClientConnector clientConnector = new ClientConnector();
        clientConnector.setSslContextFactory(new SslContextFactory.Client());
        clientConnector.getSslContextFactory().setTrustAll(true);
        HttpClient httpClient = new HttpClient((HttpClientTransport)new HttpClientTransportDynamic(clientConnector, new ClientConnectionFactory.Info[0]));
        httpClient.setConnectBlocking(false);
        httpClient.setIdleTimeout(10000L);
        httpClient.setConnectTimeout(10000L);
        this.jettyContainer = new JakartaWebSocketClientContainer(httpClient);
        this.jettyContainer.setDefaultMaxBinaryMessageBufferSize(65536);
        this.jettyContainer.setDefaultMaxTextMessageBufferSize(65536);
        this.jettyContainer.setDefaultMaxSessionIdleTimeout(86400000L);
        this.jettyContainer.start();
    }

    private String buildURL(String path, Messenger.XpListener listenerConfig) throws JAXBException {
        String websocketHost = listenerConfig.getHost();
        int websocketPort = listenerConfig.getPort();
        String urlPrefix = listenerConfig.isSsl() ? "wss://" : "ws://";
        return urlPrefix + websocketHost + ":" + websocketPort + path;
    }

    private int getReconnectDelay() {
        return this.messengerConfig.getReconnectDelay();
    }

    private List<Future<Boolean>> reinitDataConnections(Messenger.XpListener xpListener) throws JAXBException {
        ArrayList<Future<Boolean>> connectFutures = new ArrayList<Future<Boolean>>();
        String dataURL = this.buildURL("/data", xpListener);
        int reconnectDelay = this.getReconnectDelay();
        int count = xpListener.getDataConnectionCount();
        for (int i = 0; i < count; ++i) {
            DataEndpoint data = new DataEndpoint(this.folders, this.listenerManager, (WebSocketContainer)this.jettyContainer, dataURL, reconnectDelay, this.identKey, this.identCert, this.clusterId);
            connectFutures.add(data.reconnect());
            this.dataConnections.add(data);
        }
        return connectFutures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<Future<Boolean>> reconnect() throws JAXBException {
        ArrayList<Future<Boolean>> connectFutures = new ArrayList<Future<Boolean>>();
        List<ConfigEndpoint> list = this.configEndpoints;
        synchronized (list) {
            this.shutdown();
            for (Messenger.XpListener xpListener : this.messengerConfig.getXpListeners()) {
                if (!xpListener.isEnabled()) continue;
                String configURL = this.buildURL("/config", xpListener);
                int reconnectDelay = this.getReconnectDelay();
                ConfigEndpoint configEndpoint = new ConfigEndpoint((WebSocketContainer)this.jettyContainer, configURL, reconnectDelay, this.identKey, this.identCert, this.applicationEventPublisher, this.clusterId);
                this.configEndpoints.add(configEndpoint);
                Future<Boolean> connectFuture = configEndpoint.reconnect();
                connectFutures.add(connectFuture);
                connectFutures.addAll(this.reinitDataConnections(xpListener));
            }
        }
        return connectFutures;
    }

    public synchronized void shutdown() {
        try {
            for (ConfigEndpoint configEndpoint : this.configEndpoints) {
                configEndpoint.shutdown();
            }
            for (DataEndpoint dataConnection : this.dataConnections) {
                dataConnection.shutdown();
            }
        }
        finally {
            this.configEndpoints.clear();
            this.dataConnections.clear();
        }
    }

    public List<ConfigEndpoint> getConfigEndpoints() {
        return this.configEndpoints;
    }

    @Override
    public String getServiceName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public ServiceLevel getServiceLevel() {
        return ServiceLevel.getServiceLevel(WebsocketClient.class);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof StartupService) {
            StartupService startupEvent = (StartupService)event;
            if (this.getServiceLevel() == startupEvent.getServiceLevel()) {
                try {
                    this.init();
                    List<Future<Boolean>> reconnect = this.reconnect();
                    for (Future<Boolean> future : reconnect) {
                        try {
                            if (future.get(5000L, TimeUnit.MILLISECONDS).booleanValue()) continue;
                            LOG.warn("Failed to establish WebSocket connection.");
                        }
                        catch (Exception e) {
                            LOG.warn("Error while waiting for WebSocket connection establishment.", (Throwable)e);
                        }
                    }
                    this.applicationEventPublisher.publishEvent((ApplicationEvent)new StartupCompleted(this));
                }
                catch (Exception e) {
                    LOG.error("Unable to initialize the WebSocketClient service.", (Throwable)e);
                    this.applicationEventPublisher.publishEvent((ApplicationEvent)new StartupFailed(this, "Unable to initialize the WebSocketClient service", e));
                }
            }
        } else if (event instanceof ShutdownService) {
            ShutdownService shutdownEvent = (ShutdownService)event;
            if (this.getServiceLevel() == shutdownEvent.getServiceLevel()) {
                try {
                    this.shutdown();
                    if (this.jettyContainer != null) {
                        this.jettyContainer.stop();
                    }
                }
                catch (Exception e) {
                    LOG.error("Unable to stop WebSocketClient service.", (Throwable)e);
                }
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new ShutdownCompleted(this));
            }
        }
    }
}

