/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.validation;

import de.ponton.xmlpipe.rest.validation.X509CertificateConstraint;
import de.pontonconsulting.xmlpipe.admintool.InstallCertException;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;

public class X509CertificateValidator
implements ConstraintValidator<X509CertificateConstraint, String> {
    private final CertificateUtility certificateUtility;
    private final ReferenceDateTask referenceDateTask;

    public X509CertificateValidator(CertificateUtility certificateUtility, ReferenceDateTask referenceDateTask) {
        this.certificateUtility = certificateUtility;
        this.referenceDateTask = referenceDateTask;
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        try {
            this.certificateUtility.getX509Certificate(value).checkValidity(this.referenceDateTask.getReferenceDate());
        }
        catch (CertificateExpiredException | CertificateNotYetValidException e) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(String.format("{%s.message}", e.getClass().getName())).addConstraintViolation();
            return false;
        }
        catch (InstallCertException | NoSuchProviderException | CertificateException e) {
            return false;
        }
        return true;
    }
}

