/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.status;

import de.ponton.xmlpipe.rest.certificate.CertificateDto;
import de.ponton.xmlpipe.rest.certificate.CertificateDtoFactory;
import de.ponton.xmlpipe.rest.status.KnownServerCertificateDto;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.KnownServerCertificate;
import de.pontonconsulting.xmlpipe.messenger.database.tables.KnownServerCertificateDAO;
import io.swagger.v3.oas.annotations.Operation;
import java.security.cert.X509Certificate;
import java.time.OffsetDateTime;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/status/remoteServer"})
@Validated
public class RemoteServerController {
    private static final String DOCUMENTATION_TAG_REMOTE_SERVER = "RemoteServer";
    private final KnownServerCertificateDAO knownServerCertificateDAO;
    private final CertificateDtoFactory certificateDtoFactory;

    public RemoteServerController(KnownServerCertificateDAO knownServerCertificateDAO, CertificateDtoFactory certificateDtoFactory) {
        this.knownServerCertificateDAO = knownServerCertificateDAO;
        this.certificateDtoFactory = certificateDtoFactory;
    }

    @GetMapping(value={"/knownServerCertificates"})
    @Operation(summary="Get a list of known server certificates", description="permission:KNOWN_SERVER_CERTIFICATES_GET", tags={"RemoteServer"})
    @Secured(value={"KNOWN_SERVER_CERTIFICATES_GET"})
    public ResponseEntity<List<KnownServerCertificateDto>> getAllKnownServerCertificates(boolean onlyInvalid) {
        try {
            List<KnownServerCertificateDto> knownCertificates = this.knownServerCertificateDAO.loadAllKnownServerCertificates().stream().map(this::mapToKnownServerCertificateDto).toList();
            if (onlyInvalid) {
                OffsetDateTime buffer = OffsetDateTime.now().plusMonths(1L);
                knownCertificates = knownCertificates.stream().filter(cert -> !cert.getValidTo().isAfter(buffer)).toList();
            }
            return ResponseEntity.ok(knownCertificates);
        }
        catch (KnownServerCertificateException e) {
            return ResponseEntity.notFound().build();
        }
    }

    @DeleteMapping(value={"/knownServerCertificates/{id}"})
    @Operation(summary="Removes a known server certificates", description="permission:KNOWN_SERVER_CERTIFICATES_DELETE", tags={"RemoteServer"})
    @Secured(value={"KNOWN_SERVER_CERTIFICATES_DELETE"})
    public ResponseEntity<Void> deleteKnownServerCertificate(String id) {
        boolean deleteSuccess = this.knownServerCertificateDAO.delete(id);
        if (deleteSuccess) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }

    private KnownServerCertificateDto mapToKnownServerCertificateDto(KnownServerCertificate knownServerCertificate) throws KnownServerCertificateException {
        X509Certificate certificate = this.certificateDtoFactory.parse(knownServerCertificate.getCertificate());
        CertificateDto certificateDto = this.certificateDtoFactory.create(certificate);
        String crlReason = knownServerCertificate.getCrlReason() != null ? knownServerCertificate.getCrlReason().toString() : null;
        return new KnownServerCertificateDto(certificateDto).setStatus(this.mapStatus(knownServerCertificate.getStatus())).setCrlReason(crlReason).setLastSuccessfulCheck(knownServerCertificate.getLastSuccessfulCheck().toString()).setLastCheck(knownServerCertificate.getLastCheck().toString());
    }

    String mapStatus(int status) {
        return switch (status) {
            case 1 -> "trusted";
            case 2 -> "temporarily_disabled";
            case 99 -> "revoked";
            default -> "unknown";
        };
    }

    private static class KnownServerCertificateException
    extends RuntimeException {
        private static final long serialVersionUID = -553382789121697862L;

        public KnownServerCertificateException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

