/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.status;

import de.ponton.xmlpipe.queue.InboundQueue;
import de.ponton.xmlpipe.queue.OutboundQueue;
import de.ponton.xmlpipe.queue.OutboundQueueConsumer;
import de.ponton.xmlpipe.queue.QueueMessageConsumer;
import de.ponton.xmlpipe.rest.status.ConfigurationExporter;
import de.ponton.xmlpipe.rest.status.ConfigurationImporter;
import de.ponton.xmlpipe.rest.status.MessengerStatusDto;
import de.pontonconsulting.common.xml.DtdFilterStream;
import de.pontonconsulting.xmlpipe.Constants;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.messenger.Messenger;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.ConnectionPool;
import de.pontonconsulting.xmlpipe.messenger.database.tables.ArchiveQueueDAO;
import de.pontonconsulting.xmlpipe.server.ILoggingSystem;
import de.pontonconsulting.xmlpipe.server.Server;
import de.schlichtherle.truezip.file.TFileInputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.concurrent.ExecutorService;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class MessengerStatusService {
    private static final String FILE_PREFIX = "PontonXP-";
    private static final String FILE_MIDDLE_LOGS = "-Logs";
    private static final String FILE_SUFFIX = ".zip";
    private static final Logger AUDIT = LogManager.getLogger((String)"Audit.DownloadConfiguration");
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CONTENT_TYPE_APP_ZIP = "application/zip";
    private final InboundQueue inboundQueue;
    private final QueueMessageConsumer inboundQueueMessageConsumer;
    private final OutboundQueue outboundQueue;
    private final ArchiveQueueDAO archiveQueueDao;
    private final ExecutorService restExecutorService;
    private final Server server;
    private final IFolders folders;
    private final ReferenceDateTask referenceDateTask;
    private final SimpleDateFormat dateFormatter;
    private final ILoggingSystem loggingSystem;
    private final OutboundQueueConsumer outboundQueueConsumer;
    private final ConfigurationExporter configurationExporter;
    private final ConfigurationImporter configurationImporter;

    public MessengerStatusService(InboundQueue inboundQueue, @Qualifier(value="inboundQueueMessageConsumer") QueueMessageConsumer inboundQueueMessageConsumer, OutboundQueue outboundQueue, ArchiveQueueDAO archiveQueueDao, @Qualifier(value="restExecutorService") ExecutorService restExecutorService, Server server, IFolders folders, ReferenceDateTask referenceDateTask, ILoggingSystem loggingSystem, OutboundQueueConsumer outboundQueueConsumer, ConfigurationExporter configurationExporter, ConfigurationImporter configurationImporter) {
        this.inboundQueue = inboundQueue;
        this.inboundQueueMessageConsumer = inboundQueueMessageConsumer;
        this.outboundQueue = outboundQueue;
        this.archiveQueueDao = archiveQueueDao;
        this.restExecutorService = restExecutorService;
        this.server = server;
        this.folders = folders;
        this.referenceDateTask = referenceDateTask;
        this.loggingSystem = loggingSystem;
        this.outboundQueueConsumer = outboundQueueConsumer;
        this.configurationExporter = configurationExporter;
        this.configurationImporter = configurationImporter;
        this.dateFormatter = new SimpleDateFormat("yyyyMMdd_HHmm");
    }

    public void restartMessenger() {
        this.restExecutorService.submit(this.server::restartMessenger);
    }

    public void getMessengerConfigFiles(HttpServletRequest request, HttpServletResponse response) throws IOException {
        File configZipFile = this.configurationExporter.export(this.getMessengerStatus());
        AUDIT.info("{} [{}] (user '{}') downloaded the configuration files.", (Object)request.getRemoteHost(), (Object)request.getRemoteAddr(), (Object)request.getRemoteUser());
        response.setHeader("Access-Control-Expose-Headers", CONTENT_DISPOSITION);
        response.setHeader(CONTENT_TYPE, CONTENT_TYPE_APP_ZIP);
        response.setHeader(CONTENT_DISPOSITION, String.format("attachment; filename=\"%s\"", configZipFile.getName()));
        ServletOutputStream out = response.getOutputStream();
        try (TFileInputStream xmlIn = new TFileInputStream(configZipFile);
             DtdFilterStream dfs = new DtdFilterStream((InputStream)xmlIn);){
            int length;
            byte[] buffer = new byte[16384];
            while ((length = dfs.read(buffer)) != -1) {
                out.write(buffer, 0, length);
            }
        }
    }

    public void getMessengerLogs(HttpServletRequest request, HttpServletResponse response) throws IOException {
        File[] files;
        for (File file : files = this.folders.getPackedLogsFolder().listFiles((dir, name) -> name.startsWith(FILE_PREFIX) && name.endsWith(FILE_SUFFIX) && name.indexOf(FILE_MIDDLE_LOGS) > 0)) {
            FileUtils.deleteQuietly((File)file);
        }
        String filename = FILE_PREFIX + Constants.getXP_VERSION().replaceAll("[() ]", "") + "-" + this.dateFormatter.format(this.referenceDateTask.getReferenceDate()) + "-Logs.zip";
        File logs = new File(this.folders.getPackedLogsFolder(), filename);
        logs.deleteOnExit();
        this.zipLogs(logs);
        AUDIT.info("{} [{}] (user '{}') downloaded the log files.", (Object)request.getRemoteHost(), (Object)request.getRemoteAddr(), (Object)request.getRemoteUser());
        response.setHeader("Access-Control-Expose-Headers", CONTENT_DISPOSITION);
        response.setHeader(CONTENT_TYPE, CONTENT_TYPE_APP_ZIP);
        response.setHeader(CONTENT_DISPOSITION, String.format("attachment; filename=\"%s\"", filename));
        ServletOutputStream out = response.getOutputStream();
        try (TFileInputStream xmlIn = new TFileInputStream(logs);
             DtdFilterStream dfs = new DtdFilterStream((InputStream)xmlIn);){
            int length;
            byte[] buffer = new byte[16384];
            while ((length = dfs.read(buffer)) != -1) {
                out.write(buffer, 0, length);
            }
        }
    }

    private void zipLogs(File logs) throws IOException {
        try (ZipOutputStream zip = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(logs.toPath(), new OpenOption[0])));){
            long sevenDaysBefore = this.referenceDateTask.getReferenceCurrentTimeMillis() - 604800000L;
            for (File file : this.loggingSystem.getLogFolder().listFiles()) {
                String fileName = file.getName();
                if (!fileName.toLowerCase().endsWith(".log") && !fileName.toLowerCase().endsWith(FILE_SUFFIX) || file.lastModified() <= sevenDaysBefore) continue;
                this.addToZip(zip, file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToZip(ZipOutputStream zip, File file) throws IOException {
        if (file.exists()) {
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
                int length;
                zip.putNextEntry(new ZipEntry(file.getCanonicalPath().substring(this.loggingSystem.getLogFolder().getCanonicalPath().length() + 1)));
                byte[] buffer = new byte[8192];
                while ((length = in.read(buffer)) > 0) {
                    zip.write(buffer, 0, length);
                }
            }
            finally {
                try {
                    zip.flush();
                }
                catch (Exception exception) {}
            }
        }
    }

    public MessengerStatusDto getMessengerStatus() {
        MessengerStatusDto messengerStatus = new MessengerStatusDto().setUptime(Messenger.getUptime() / 1000L).setUsedMemory((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L);
        try {
            messengerStatus.setDatabaseConnectionCount(ConnectionPool.getNumConnections()).setDatabaseIdleConnections(ConnectionPool.getNumIdleConnections()).setDatabaseBusyConnections(ConnectionPool.getNumBusyConnections()).setDatabaseOrphanedConnections(ConnectionPool.getNumUnclosedOrphanedConnections()).setDatabaseConnectionStatus(true);
        }
        catch (Exception e) {
            messengerStatus.setDatabaseConnectionCount(-1).setDatabaseIdleConnections(-1).setDatabaseBusyConnections(-1).setDatabaseOrphanedConnections(-1).setDatabaseConnectionStatus(false);
        }
        messengerStatus.setInboundThreadCount(this.inboundQueueMessageConsumer.getActiveThreadCount()).setInboundMessageCount(this.inboundQueue.getTotalMessageCount());
        messengerStatus.setOutboundThreadCount(this.outboundQueueConsumer.getRunningThreads()).setOutboundMessageCount(this.outboundQueue.getTotalMessageCount());
        messengerStatus.setArchiveMessageCount(this.archiveQueueDao.getArchiveQueueSize().intValue());
        return messengerStatus;
    }

    public void installConfigFileZip(MultipartFile configFileZip) throws IOException {
        this.configurationImporter.importConfigFile(configFileZip);
    }
}

