/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.status;

import de.ponton.xmlpipe.rest.status.ClusterInfoDto;
import de.ponton.xmlpipe.rest.status.MessengerInfoDto;
import de.pontonconsulting.xmlpipe.Constants;
import de.pontonconsulting.xmlpipe.activation.ActivationControl;
import de.pontonconsulting.xmlpipe.activation.MessengerActivation;
import de.pontonconsulting.xmlpipe.cluster.GlobalTaskManager;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Objects;
import org.springframework.stereotype.Component;

@Component
public class MessengerInfoService {
    private final ActivationControl activationControl;
    private final MessengerActivation messengerActivation;
    private final ReferenceDateTask referenceDateTask;
    private final GlobalTaskManager globalTaskManager;

    public MessengerInfoService(ActivationControl activationControl, MessengerActivation messengerActivation, ReferenceDateTask referenceDateTask, GlobalTaskManager globalTaskManager) {
        this.activationControl = activationControl;
        this.messengerActivation = messengerActivation;
        this.referenceDateTask = referenceDateTask;
        this.globalTaskManager = globalTaskManager;
    }

    public MessengerInfoDto getMessengerInfo() {
        return new MessengerInfoDto().setId(this.messengerActivation.getInstanceId()).setVersion(Constants.getXP_VERSION()).setBuildDate(Constants.getBuildDate()).setValidActivation(this.activationControl.isActive()).setActivationDaysLeft(this.activationControl.isActive() ? this.messengerActivation.getDaysLeft() : -1L).setJavaVirtualMachine(System.getProperty("java.vm.name")).setJavaVendor(System.getProperty("java.vm.vendor")).setJavaVersion(System.getProperty("java.runtime.version")).setOperationSystem(System.getProperty("os.name")).setOperationSystemVersion(System.getProperty("os.version")).setReferenceNTPServer(this.referenceDateTask.getUsedNtpServer()).setReferenceDate(OffsetDateTime.ofInstant(this.referenceDateTask.getReferenceDate().toInstant(), ZoneOffset.UTC)).setLocalSystemTimeOffset(this.referenceDateTask.getOffset());
    }

    public List<ClusterInfoDto> getClusterInfos() {
        String clusterId = this.messengerActivation.getClusterId();
        Integer globalTaskMessenger = this.globalTaskManager.getCurrentResponsibleMessengerId();
        return this.messengerActivation.loadAllMessengerActivations().stream().map(ma -> new ClusterInfoDto().setId(ma.getInstanceId()).setClusterId(clusterId).setAlias(ma.getInstanceAlias()).setIpAddress(ma.getIpAddress()).setLastStartup(ma.getLastStartup()).setLastHeartBeat(ma.getLastHeartBeat()).setMessengerId(ma.getMessengerId()).setStatus(this.getClusterNodeStatus(ma.getLastHeartBeat())).setHandlingGlobalTasks(ma.getMessengerId().equals(globalTaskMessenger)).setThisNode(ma.getMessengerId().equals(this.messengerActivation.getMessengerId()))).toList();
    }

    private String getClusterNodeStatus(OffsetDateTime lastHeartBeat) {
        OffsetDateTime now = this.referenceDateTask.getReferenceOffsetDateTime();
        if (Objects.isNull(lastHeartBeat)) {
            return "DOWN";
        }
        if (lastHeartBeat.isAfter(now.minusMinutes(1L))) {
            return "OK";
        }
        if (lastHeartBeat.isAfter(now.minusMinutes(3L))) {
            return "DELAYED";
        }
        return "DOWN";
    }
}

