/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.settings.timeserver;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Holds the time server configuration of the messenger.")
public class TimeServerDto {
    @NotNull
    @Size(min=1, max=10)
    @Schema(description="A list of hostnames or ip addresses of ntp servers. It is recommended to configure at least one ntp server to avoid problems caused by an imprecise system time.")
    private @NotNull @Size(min=1, max=10) List<@NotNull @Pattern(regexp="^(.*?)(:(\\d+))?$") String> ntpServers;
    @Schema(description="Set to true to enable time synchronization with ntp servers, set to false to disable it.")
    private boolean enabled;
    @NotNull
    @Min(value=1L)
    @Schema(description="The time interval in hours at which the time will be synced if synchronization is enabled.")
    private @NotNull @Min(value=1L) Integer syncInterval;

    public List<String> getNtpServers() {
        return this.ntpServers;
    }

    public TimeServerDto setNtpServers(List<String> ntpServers) {
        this.ntpServers = new ArrayList<String>(ntpServers);
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public TimeServerDto setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Integer getSyncInterval() {
        return this.syncInterval;
    }

    public TimeServerDto setSyncInterval(Integer syncInterval) {
        this.syncInterval = syncInterval;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimeServerDto)) {
            return false;
        }
        TimeServerDto that = (TimeServerDto)o;
        return this.enabled == that.enabled && Objects.equals(this.ntpServers, that.ntpServers) && Objects.equals(this.syncInterval, that.syncInterval);
    }

    public int hashCode() {
        return Objects.hash(this.ntpServers, this.enabled, this.syncInterval);
    }

    public String toString() {
        return "TimeServerDto{ntpServers=" + String.valueOf(this.ntpServers) + ", enabled=" + this.enabled + ", syncInterval=" + this.syncInterval + "}";
    }
}

