/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.settings.partnerregistry;

import de.ponton.xmlpipe.rest.settings.common.authentication.AuthenticationDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Holds the partner registry update configuration of the messenger.")
public class PartnerRegistryUpdateDto {
    @NotNull
    @Valid
    @Schema(description="The authentication information for the partner registry.")
    private AuthenticationDto authentication;
    @Schema(description="If a partner is automatically updated from the registry server and this option is enabled, all agreements with the partner will be updated automatically.")
    private boolean automaticAgreementUpdates;
    @Schema(description="If enabeld, the messenger creates unknown partners from partner registry to process incoming and outgoing messages.")
    private boolean automaticPartnerCreation;
    @Schema(description="If enabled, the messenger deletes all non-existing remote profiles from local space.")
    private boolean automaticPartnerCleanup;
    @NotNull
    @Min(value=1L)
    @Max(value=24L)
    @Schema(description="The profile download interval time in hours for profile sync.")
    private @NotNull @Min(value=1L) @Max(value=24L) Integer downloadInterval;

    public AuthenticationDto getAuthentication() {
        return this.authentication;
    }

    public PartnerRegistryUpdateDto setAuthentication(AuthenticationDto authentication) {
        this.authentication = authentication;
        return this;
    }

    public boolean isAutomaticAgreementUpdates() {
        return this.automaticAgreementUpdates;
    }

    public PartnerRegistryUpdateDto setAutomaticAgreementUpdates(boolean automaticAgreementUpdates) {
        this.automaticAgreementUpdates = automaticAgreementUpdates;
        return this;
    }

    public boolean isAutomaticPartnerCreation() {
        return this.automaticPartnerCreation;
    }

    public PartnerRegistryUpdateDto setAutomaticPartnerCreation(boolean automaticPartnerCreation) {
        this.automaticPartnerCreation = automaticPartnerCreation;
        return this;
    }

    public boolean isAutomaticPartnerCleanup() {
        return this.automaticPartnerCleanup;
    }

    public PartnerRegistryUpdateDto setAutomaticPartnerCleanup(boolean automaticPartnerCleanup) {
        this.automaticPartnerCleanup = automaticPartnerCleanup;
        return this;
    }

    public Integer getDownloadInterval() {
        return this.downloadInterval;
    }

    public PartnerRegistryUpdateDto setDownloadInterval(Integer downloadInterval) {
        this.downloadInterval = downloadInterval;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PartnerRegistryUpdateDto)) {
            return false;
        }
        PartnerRegistryUpdateDto that = (PartnerRegistryUpdateDto)o;
        return this.automaticAgreementUpdates == that.automaticAgreementUpdates && this.automaticPartnerCreation == that.automaticPartnerCreation && this.automaticPartnerCleanup == that.automaticPartnerCleanup && Objects.equals(this.authentication, that.authentication) && Objects.equals(this.downloadInterval, that.downloadInterval);
    }

    public int hashCode() {
        return Objects.hash(this.authentication, this.automaticAgreementUpdates, this.automaticPartnerCreation, this.automaticPartnerCleanup, this.downloadInterval);
    }

    public String toString() {
        return "PartnerRegistryUpdateDto{authentication=" + String.valueOf(this.authentication) + ", automaticAgreementUpdates=" + this.automaticAgreementUpdates + ", automaticPartnerCreation=" + this.automaticPartnerCreation + ", automaticPartnerCleanup=" + this.automaticPartnerCleanup + ", downloadInterval=" + this.downloadInterval + "}";
    }
}

