/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.settings.email.notification.message;

import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import de.ponton.xmlpipe.rest.message.MessageLogEvent;
import de.ponton.xmlpipe.rest.settings.email.notification.message.ISubjectElement;
import de.ponton.xmlpipe.rest.settings.email.notification.message.SubjectElementTextDto;
import de.ponton.xmlpipe.rest.settings.email.notification.message.SubjectElementVariableDto;
import de.ponton.xmlpipe.rest.settings.email.notification.message.SubjectElementXPathDto;
import de.ponton.xmlpipe.rest.settings.validation.EmailsFormatConstraint;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Holds the information about a message event receiver for the E-Mail notification configuration of the messenger.")
public class MessageEventReceiverDto {
    @NotNull
    @Size(max=256)
    @EmailsFormatConstraint
    @Schema(description="The email address to which the notification email will be sent.")
    @TrimmedField
    private @NotNull @Size(max=256) String email;
    @Schema(description="Set to 'true' if an HTML attachment should be sent with the email, otherwise set to 'false'.")
    private boolean withHtmlAttachment;
    @NotNull
    @Size(min=1, max=1000)
    @Schema(description="A list of eventId's for which notification emails should be sent.")
    private @NotNull @Size(min=1, max=1000) List<@NotNull MessageLogEvent> messageEventIds;
    @NotNull
    @Valid
    @Size(max=100)
    @Schema(description="The subject of the email notification can be customized. If no subject elements are defined, the subject with the text 'Notification for message' followed by the message id is used. Each subject element will be separated with a blank. You can choose between predefined variables, a xpath value in the payload message or some text. Please notice that using xpath values may decrease the performance because the whole payload message is parsed.", oneOf={SubjectElementTextDto.class, SubjectElementVariableDto.class, SubjectElementXPathDto.class})
    private @NotNull @Valid @Size(max=100) List<@NotNull @Valid ISubjectElement> subjectElements;

    public String getEmail() {
        return this.email;
    }

    public MessageEventReceiverDto setEmail(String email) {
        this.email = email;
        return this;
    }

    public boolean isWithHtmlAttachment() {
        return this.withHtmlAttachment;
    }

    public MessageEventReceiverDto setWithHtmlAttachment(boolean withHtmlAttachment) {
        this.withHtmlAttachment = withHtmlAttachment;
        return this;
    }

    public List<MessageLogEvent> getMessageEventIds() {
        return this.messageEventIds;
    }

    public MessageEventReceiverDto setMessageEventIds(List<MessageLogEvent> messageEventIds) {
        this.messageEventIds = new ArrayList<MessageLogEvent>(messageEventIds);
        return this;
    }

    public List<ISubjectElement> getSubjectElements() {
        return this.subjectElements;
    }

    public MessageEventReceiverDto setSubjectElements(List<ISubjectElement> subjectElements) {
        this.subjectElements = new ArrayList<ISubjectElement>(subjectElements);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MessageEventReceiverDto)) {
            return false;
        }
        MessageEventReceiverDto that = (MessageEventReceiverDto)o;
        return this.withHtmlAttachment == that.withHtmlAttachment && Objects.equals(this.email, that.email) && Objects.equals(this.messageEventIds, that.messageEventIds) && Objects.equals(this.subjectElements, that.subjectElements);
    }

    public int hashCode() {
        return Objects.hash(this.email, this.withHtmlAttachment, this.messageEventIds, this.subjectElements);
    }

    public String toString() {
        return "MessageEventReceiverDto{email='" + this.email + "', withHtmlAttachment=" + this.withHtmlAttachment + ", messageEventIds=" + String.valueOf(this.messageEventIds) + ", subjectElements=" + String.valueOf(this.subjectElements) + "}";
    }
}

